

<?php $__env->startSection('title', 'Quản lý đăng ký - ' . $tournament->name); ?>

<?php $__env->startPush('layout_css'); ?>
<style>
    /* Dark theme styles for tournament registrations */
    .page-title-box {
        background: transparent;
        color: var(--text-primary);
    }

    .page-title {
        color: var(--text-primary) !important;
    }

    .breadcrumb {
        background: transparent;
    }

    .breadcrumb-item a {
        color: var(--accent-primary) !important;
        text-decoration: none;
    }

    .breadcrumb-item.active {
        color: var(--text-muted) !important;
    }

    .card {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .card-header {
        background: var(--secondary-bg) !important;
        border-bottom: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .card-title {
        color: var(--text-primary) !important;
    }

    .table {
        background: var(--card-bg) !important;
        color: var(--text-primary) !important;
    }

    .table th,
    .table td {
        background: transparent !important;
        border-color: var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .table-striped>tbody>tr:nth-of-type(odd)>td {
        background: rgba(255, 255, 255, 0.02) !important;
    }

    .table-bordered {
        border-color: var(--border-color) !important;
    }

    .text-muted {
        color: var(--text-muted) !important;
    }

    .text-success {
        color: var(--success) !important;
    }

    .text-warning {
        color: var(--warning) !important;
    }

    .text-danger {
        color: var(--danger) !important;
    }

    .text-primary {
        color: var(--accent-primary) !important;
    }

    .badge {
        color: var(--text-primary) !important;
    }

    .bg-success {
        background: var(--success) !important;
    }

    .bg-warning {
        background: var(--warning) !important;
    }

    .bg-danger {
        background: var(--danger) !important;
    }

    .bg-secondary {
        background: var(--text-muted) !important;
    }

    .btn-success {
        background: var(--success) !important;
        border-color: var(--success) !important;
        color: var(--text-primary) !important;
    }

    .btn-warning {
        background: var(--warning) !important;
        border-color: var(--warning) !important;
        color: var(--primary-bg) !important;
    }

    .btn-danger {
        background: var(--danger) !important;
        border-color: var(--danger) !important;
        color: var(--text-primary) !important;
    }

    .btn-secondary {
        background: var(--secondary-bg) !important;
        border-color: var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .modal-content {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .modal-header {
        background: var(--secondary-bg) !important;
        border-bottom: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .modal-footer {
        background: var(--secondary-bg) !important;
        border-top: 1px solid var(--border-color) !important;
    }

    .modal-title {
        color: var(--text-primary) !important;
    }

    .form-control,
    .form-select {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .form-control:focus,
    .form-select:focus {
        background: var(--card-bg) !important;
        border-color: var(--accent-primary) !important;
        color: var(--text-primary) !important;
        box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.25) !important;
    }

    .form-control::placeholder {
        color: var(--text-muted) !important;
    }

    .form-label {
        color: var(--text-primary) !important;
    }

    .btn-close-white {
        filter: invert(1) grayscale(100%) brightness(200%);
    }

    .empty-state {
        color: var(--text-muted);
    }

    .empty-state i {
        color: var(--text-muted) !important;
    }

    .pagination {
        --bs-pagination-bg: #1a1a1a;
        --bs-pagination-border-color: #333333;
        --bs-pagination-hover-bg: rgba(59, 130, 246, 0.2);
        --bs-pagination-hover-border-color: var(--accent-primary);
        --bs-pagination-focus-bg: rgba(59, 130, 246, 0.25);
        --bs-pagination-focus-border-color: var(--accent-primary);
        --bs-pagination-active-bg: var(--accent-primary);
        --bs-pagination-active-border-color: var(--accent-primary);
        --bs-pagination-disabled-bg: #0f0f0f;
        --bs-pagination-disabled-border-color: #333333;
        --bs-pagination-color: var(--accent-primary);
        --bs-pagination-hover-color: #ffffff;
        --bs-pagination-focus-color: #ffffff;
        --bs-pagination-active-color: #ffffff;
        --bs-pagination-disabled-color: #666666;
        margin: 1.5rem 0;
    }

    .pagination .page-link {
        font-weight: 500;
        border-radius: 8px !important;
        margin: 0 2px;
        transition: all 0.3s ease;
        backdrop-filter: blur(10px);
        border: 1px solid #333333 !important;
        background: #1a1a1a !important;
        color: var(--accent-primary) !important;
    }

    .pagination .page-link:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        background: rgba(59, 130, 246, 0.2) !important;
        color: #ffffff !important;
        border-color: var(--accent-primary) !important;
    }

    .pagination .page-item.active .page-link {
        background: linear-gradient(135deg, var(--accent-primary), #1d4ed8) !important;
        border-color: var(--accent-primary) !important;
        box-shadow: 0 4px 15px rgba(59, 130, 246, 0.4);
        transform: translateY(-1px);
        color: #ffffff !important;
    }

    .pagination .page-item.disabled .page-link {
        opacity: 0.5;
        transform: none !important;
        box-shadow: none !important;
        background: #0f0f0f !important;
        color: #666666 !important;
        border-color: #333333 !important;
    }

    .pagination-wrapper {
        background: rgba(0, 0, 0, 0.3);
        border-radius: 12px;
        padding: 1rem 1.5rem;
        border: 1px solid #333333;
        backdrop-filter: blur(10px);
    }

    .pagination-wrapper .pagination {
        margin: 0;
    }

    .toast {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .toast.bg-success {
        background: var(--success) !important;
        color: var(--text-primary) !important;
    }

    .toast.bg-danger {
        background: var(--danger) !important;
        color: var(--text-primary) !important;
    }

    .toast-header.bg-success {
        background: var(--success) !important;
        color: var(--text-primary) !important;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1) !important;
    }

    .toast-header.bg-danger {
        background: var(--danger) !important;
        color: var(--text-primary) !important;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1) !important;
    }

    /* Avatar styling */
    .rounded-circle {
        border: 2px solid var(--border-color) !important;
    }

    .export-print-actions .btn {
        border-radius: 8px;
        transition: all 0.2s ease;
    }

    .export-print-actions .btn:hover {
        transform: translateY(-1px);
        box-shadow: 0 6px 18px rgba(59, 130, 246, 0.25);
    }

    @media print {
        body {
            background: #ffffff !important;
        }

        .page-title-box,
        .breadcrumb,
        .no-print,
        .pagination-wrapper,
        .toast,
        .modal,
        header,
        footer,
        nav,
        aside {
            display: none !important;
        }

        .container-fluid {
            padding: 0 !important;
        }

        .card {
            box-shadow: none !important;
            border: none !important;
            background: #ffffff !important;
            color: #000000 !important;
        }

        .printable-area .table {
            color: #000000 !important;
            border-color: #000000 !important;
        }

        .printable-area .table th,
        .printable-area .table td {
            color: #000000 !important;
            border-color: #000000 !important;
        }

        .printable-area .table-striped>tbody>tr:nth-of-type(odd)>td {
            background: #f0f0f0 !important;
        }

        @page {
            margin: 15mm;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php
$role = session('tournament_role_'.$tournament->id, 'guest');
$isOrganizer = $role === 'organizer' && session('tournament_pw_'.$tournament->id);
$user = auth()->user();
$isAdminOrMod = $user && ($user->hasRole('admin') || $user->hasRole('mod'));
$exportRoute = $isOrganizer
? route('tournament.setting.registrations.export', $tournament)
: route('admin.tournaments.registrations.export', $tournament);
$hasRegistrations = $registrations->count() > 0;
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <?php if($isOrganizer): ?>
                        <li class="breadcrumb-item"><a
                                href="<?php echo e(route('tournament.setting.index', $tournament)); ?>">Tournament Setting</a></li>
                        <?php else: ?>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.tournaments.index')); ?>">Tournaments</a>
                        </li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.tournaments.show', $tournament)); ?>"><?php echo e($tournament->name); ?></a></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active">Đăng ký</li>
                    </ol>
                </div>
                <h4 class="page-title">Quản lý đăng ký</h4>
            </div>
        </div>
    </div>

    <!-- Tournament Info & Stats -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title" style="color: var(--text-primary);"><?php echo e($tournament->name); ?></h5>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="text-center">
                                <h2 style="color: var(--success);"><?php echo e($stats['approved']); ?></h2>
                                <p style="color: var(--text-muted);">Đã duyệt</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h2 style="color: var(--warning);"><?php echo e($stats['pending']); ?></h2>
                                <p style="color: var(--text-muted);">Chờ duyệt</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h2 style="color: var(--danger);"><?php echo e($stats['rejected']); ?></h2>
                                <p style="color: var(--text-muted);">Từ chối</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h2 style="color: var(--accent-primary);"><?php echo e($stats['total']); ?></h2>
                                <p style="color: var(--text-muted);">Tổng cộng</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Registration List -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex flex-wrap justify-content-between align-items-center gap-2">
                    <h4 class="card-title mb-0">Danh sách đăng ký</h4>
                    <div class="export-print-actions d-flex flex-wrap gap-2 no-print">
                        <button type="button" class="btn btn-secondary btn-sm" id="printRegistrations"
                            <?php if(!$hasRegistrations): ?> disabled <?php endif; ?>>
                            <i class="fas fa-print me-1"></i> In danh sách
                        </button>
                        <a href="<?php echo e($exportRoute); ?>" class="btn btn-success btn-sm">
                            <i class="fas fa-file-excel me-1"></i> Xuất Excel
                        </a>
                    </div>
                </div>
                <div class="card-body printable-area">
                    <?php if($registrations->count() > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Player 1</th>
                                    <th>Player 2</th>
                                    <th>Tổng điểm trình</th>
                                    <th>Ngày đăng ký</th>
                                    <th>Trạng thái</th>
                                    <th>Ghi chú</th>
                                    <th class="no-print">Thao tác</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $registrations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $registration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($registration->id); ?></td>
                                    <td class="no-print">
                                        <div class="d-flex align-items-center">
                                            <?php if($registration->player1->avatar_path): ?>
                                            <img src="<?php echo e(asset('assets/avatars/' . $registration->player1->avatar_path)); ?>"
                                                alt="<?php echo e($registration->player1->name); ?>" class="rounded-circle me-2"
                                                style="width: 32px; height: 32px;">
                                            <?php endif; ?>
                                            <div>
                                                <strong style="color: var(--text-primary);"><?php echo e($registration->player1->name); ?></strong><br>
                                                <small style="color: var(--text-muted);"><?php echo e($registration->player1->phone); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <?php if($registration->player2->avatar_path): ?>
                                            <img src="<?php echo e(asset('assets/avatars/' . $registration->player2->avatar_path)); ?>"
                                                alt="<?php echo e($registration->player2->name); ?>" class="rounded-circle me-2"
                                                style="width: 32px; height: 32px;">
                                            <?php endif; ?>
                                            <div>
                                                <strong style="color: var(--text-primary);"><?php echo e($registration->player2->name); ?></strong><br>
                                                <small style="color: var(--text-muted);"><?php echo e($registration->player2->phone); ?></small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text-center">
                                            <strong style="color: var(--accent-primary);">
                                                <?php echo e(number_format($registration->player1->doubles_score +
                                                $registration->player2->doubles_score, 1)); ?>

                                            </strong>
                                            <br>
                                            <small style="color: var(--text-muted);">
                                                (<?php echo e(number_format($registration->player1->doubles_score, 1)); ?> + <?php echo e(number_format($registration->player2->doubles_score, 1)); ?>)
                                            </small>
                                        </div>
                                    </td>
                                    <td><?php echo e($registration->created_at->format('d/m/Y H:i')); ?></td>
                                    <td>
                                        <?php switch($registration->status):
                                        case ('approved'): ?>
                                        <span class="badge"
                                            style="background: var(--success); color: var(--text-primary);">Đã
                                            duyệt</span>
                                        <?php break; ?>
                                        <?php case ('pending'): ?>
                                        <span class="badge"
                                            style="background: var(--warning); color: var(--primary-bg);">Chờ
                                            duyệt</span>
                                        <?php break; ?>
                                        <?php case ('rejected'): ?>
                                        <span class="badge"
                                            style="background: var(--danger); color: var(--text-primary);">Từ
                                            chối</span>
                                        <?php break; ?>
                                        <?php default: ?>
                                        <span class="badge"
                                            style="background: var(--text-muted); color: var(--text-primary);"><?php echo e($registration->status); ?></span>
                                        <?php endswitch; ?>
                                    </td>
                                    <td>
                                        <?php if($registration->reason): ?>
                                        <small><?php echo e($registration->reason); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <?php if($registration->status !== 'approved'): ?>
                                            <form method="POST"
                                                action="<?php echo e($isOrganizer ? route('tournament.setting.registrations.updateStatus', $registration) : route('admin.tournaments.registrations.update-status', [$tournament, $registration])); ?>"
                                                class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php if(!$isOrganizer): ?>
                                                <?php echo method_field('PUT'); ?>
                                                <?php endif; ?>
                                                <input type="hidden" name="status" value="approved">
                                                <button type="submit" class="btn btn-success btn-sm">
                                                    <i class="fas fa-check"></i> Duyệt
                                                </button>
                                            </form>
                                            <?php endif; ?>

                                            <?php if($registration->status !== 'rejected'): ?>
                                            <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal"
                                                data-bs-target="#rejectModal<?php echo e($registration->id); ?>">
                                                <i class="fas fa-times"></i> Từ chối
                                            </button>
                                            <?php endif; ?>

                                            <?php if($registration->status !== 'pending'): ?>
                                            <form method="POST"
                                                action="<?php echo e($isOrganizer ? route('tournament.setting.registrations.updateStatus', $registration) : route('admin.tournaments.registrations.update-status', [$tournament, $registration])); ?>"
                                                class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php if(!$isOrganizer): ?>
                                                <?php echo method_field('PUT'); ?>
                                                <?php endif; ?>
                                                <input type="hidden" name="status" value="pending">
                                                <button type="submit" class="btn btn-warning btn-sm">
                                                    <i class="fas fa-clock"></i> Chờ
                                                </button>
                                            </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        <div class="pagination-wrapper">
                            <?php echo e($registrations->links('vendor.pagination.no-arrow')); ?>

                        </div>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-4">
                        <div class="empty-state">
                            <i class="fas fa-inbox fa-3x mb-3" style="color: var(--text-muted);"></i>
                            <h5 style="color: var(--text-primary);">Chưa có đăng ký nào</h5>
                            <p style="color: var(--text-muted);">Giải đấu này chưa có đăng ký nào.</p>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Reject Modals -->
<?php if($registrations->count() > 0): ?>
<?php $__currentLoopData = $registrations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $registration): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="rejectModal<?php echo e($registration->id); ?>" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Từ chối đăng ký</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST"
                action="<?php echo e($isOrganizer ? route('tournament.setting.registrations.updateStatus', $registration) : route('admin.tournaments.registrations.update-status', [$tournament, $registration])); ?>">
                <?php echo csrf_field(); ?>
                <?php if(!$isOrganizer): ?>
                <?php echo method_field('PUT'); ?>
                <?php endif; ?>
                <div class="modal-body">
                    <input type="hidden" name="status" value="rejected">
                    <div class="mb-3">
                        <label for="reason<?php echo e($registration->id); ?>" class="form-label">Lý do từ chối</label>
                        <textarea class="form-control" id="reason<?php echo e($registration->id); ?>" name="reason" rows="3"
                            placeholder="Nhập lý do từ chối..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-danger">Từ chối</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>

<?php if(session('success')): ?>
<div class="position-fixed top-0 end-0 p-3" style="z-index: 11">
    <div class="toast show bg-success text-white" role="alert">
        <div class="toast-header bg-success text-white">
            <strong class="me-auto">Thành công</strong>
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
        </div>
        <div class="toast-body">
            <?php echo e(session('success')); ?>

        </div>
    </div>
</div>
<?php endif; ?>

<?php if(session('error')): ?>
<div class="position-fixed top-0 end-0 p-3" style="z-index: 11">
    <div class="toast show bg-danger text-white" role="alert">
        <div class="toast-header bg-danger text-white">
            <strong class="me-auto">Lỗi</strong>
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
        </div>
        <div class="toast-body">
            <?php echo e(session('error')); ?>

        </div>
    </div>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('layout_script'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const printButton = document.getElementById('printRegistrations');
        if (printButton) {
            printButton.addEventListener('click', function() {
                if (printButton.disabled) {
                    return;
                }
                window.print();
            });
        }

        // Auto-hide toasts after 5 seconds
        setTimeout(function() {
            const toasts = document.querySelectorAll('.toast');
            toasts.forEach(function(toast) {
                const bsToast = new bootstrap.Toast(toast);
                bsToast.hide();
            });
        }, 5000);
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/tournaments/registrations.blade.php ENDPATH**/ ?>