

<?php $__env->startSection('title', 'Danh sách cặp đấu - ' . $tournament->name); ?>

<?php $__env->startPush('layout_css'); ?>
<style>
    /* Dark theme styles for pairs index */
    .container {
        background: transparent;
        color: var(--text-primary);
    }

    h1 {
        color: var(--text-primary) !important;
    }

    .text-primary {
        color: var(--accent-primary) !important;
    }

    .text-muted {
        color: var(--text-muted) !important;
    }

    .card {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
        box-shadow: 0 4px 6px var(--shadow-dark);
    }

    .card-body {
        background: transparent;
        color: var(--text-primary);
    }

    .table {
        background: var(--card-bg) !important;
        color: var(--text-primary) !important;
    }

    .table th,
    .table td {
        background: transparent !important;
        border-color: var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .table-hover tbody tr:hover {
        background: rgba(255, 255, 255, 0.05) !important;
        color: var(--text-primary) !important;
    }

    .form-control {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .form-control:focus {
        background: var(--card-bg) !important;
        border-color: var(--accent-primary) !important;
        color: var(--text-primary) !important;
        box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.25) !important;
    }

    .form-control::placeholder {
        color: var(--text-muted) !important;
    }

    .btn-primary {
        background: var(--accent-primary) !important;
        border-color: var(--accent-primary) !important;
        color: #ffffff !important;
    }

    .btn-primary:hover {
        background: var(--accent-hover) !important;
        border-color: var(--accent-hover) !important;
        color: #ffffff !important;
    }

    .btn-outline-secondary {
        background: transparent !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .btn-outline-secondary:hover {
        background: var(--secondary-bg) !important;
        border-color: var(--accent-primary) !important;
        color: var(--accent-primary) !important;
    }

    .btn-outline-primary {
        background: transparent !important;
        border: 1px solid var(--accent-primary) !important;
        color: var(--accent-primary) !important;
    }

    .btn-outline-primary:hover {
        background: var(--accent-primary) !important;
        border-color: var(--accent-primary) !important;
        color: #ffffff !important;
    }

    .badge {
        color: var(--text-primary) !important;
    }

    .bg-info {
        background: var(--accent-secondary) !important;
    }

    .text-dark {
        color: var(--primary-bg) !important;
    }

    .text-center {
        color: var(--text-muted) !important;
    }

    .input-group .btn {
        border-left: none;
    }

    .fw-bold {
        font-weight: 600 !important;
    }

    /* Empty state styling */
    .table tbody tr td[colspan] {
        color: var(--text-muted) !important;
        font-style: italic;
        padding: 3rem 1rem;
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
        .d-flex.justify-content-between {
            flex-direction: column;
            gap: 1rem;
        }

        .btn {
            width: 100%;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="fw-bold" style="color: var(--text-primary);">
                <i class="bi bi-people-fill" style="color: var(--accent-primary);"></i>
                Danh sách tất cả cặp đấu
            </h1>
            <p style="color: var(--text-muted);">Giải đấu: <?php echo e($tournament->name); ?></p>
        </div>
        <a href="<?php echo e(route('admin.tournaments.show', $tournament)); ?>" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left"></i> Quay lại giải đấu
        </a>
    </div>

    <!-- Search Form -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.tournaments.pairs.index', $tournament)); ?>">
                <div class="input-group">
                    <input type="text" name="search" class="form-control"
                        placeholder="Tìm kiếm theo tên VĐV hoặc tên bảng..." value="<?php echo e($search ?? ''); ?>">
                    <button class="btn btn-primary" type="submit"><i class="bi bi-search"></i> Tìm kiếm</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Bảng</th>
                            <th>Cặp Đấu</th>
                            <th>Hành động</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $pairs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><strong style="color: var(--accent-primary);"><?php echo e($pair->id); ?></strong></td>
                            <td>
                                <span class="badge bg-info"
                                    style="background: var(--accent-secondary) !important; color: var(--primary-bg) !important;">
                                    <?php echo e($pair->group_name); ?>

                                </span>
                            </td>
                            <td style="color: var(--text-primary);">
                                <strong><?php echo e($pair->player1_name); ?></strong> & <strong><?php echo e($pair->player2_name); ?></strong>
                            </td>
                            <td>
                                
                                <a href="<?php echo e(route('admin.groups.pairs.edit', ['group' => $pair->group_id, 'pair' => $pair->id])); ?>"
                                    class="btn btn-sm btn-outline-primary">
                                    <i class="bi bi-pencil"></i> Sửa
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center"
                                style="color: var(--text-muted) !important; padding: 3rem 1rem;">
                                <div>
                                    <i class="bi bi-inbox" style="font-size: 3rem; opacity: 0.5;"></i>
                                    <div class="mt-2">Không tìm thấy cặp đấu nào.</div>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="d-flex justify-content-center mt-4">
                <?php echo e($pairs->appends(['search' => $search])->links('vendor.pagination.no-arrow')); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/pairs/index.blade.php ENDPATH**/ ?>