

<?php $__env->startSection('title', 'Quản Lý Giải Đấu'); ?>

<?php $__env->startSection('content'); ?>
<div class="admin-tournaments-page container py-4">
    <style>
        .admin-tournaments-page {
            color: var(--text-primary);
        }

        .admin-tournaments-page .card {
            background-color: var(--card-bg);
            border: 1px solid var(--border-color);
            box-shadow: 0 20px 45px rgba(0, 0, 0, 0.35);
        }

        .admin-tournaments-page .card-header {
            background: linear-gradient(135deg, rgba(59, 130, 246, 0.8) 0%, rgba(34, 211, 238, 0.5) 100%);
            border-bottom: 1px solid rgba(255, 255, 255, 0.08);
            box-shadow: inset 0 -1px 0 rgba(255, 255, 255, 0.12);
        }

        .admin-tournaments-page .card-header .btn {
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.25);
        }

        .admin-tournaments-page .table {
            color: var(--text-secondary);
            border-color: var(--border-color);
            background-color: rgba(12, 15, 22, 0.88);
        }

        .admin-tournaments-page .table thead th {
            background: rgba(25, 35, 50, 0.95) !important;
            color: var(--text-primary) !important;
            border-bottom: 1px solid rgba(255, 255, 255, 0.08) !important;
        }

        .admin-tournaments-page .table tbody tr {
            background: rgba(17, 24, 39, 0.7) !important;
            transition: background 0.2s ease, transform 0.2s ease, box-shadow 0.2s ease;
        }

        .admin-tournaments-page .table tbody tr:nth-of-type(even) {
            background: rgba(31, 41, 55, 0.75) !important;
        }

        .admin-tournaments-page .table tbody tr:hover {
            background: rgba(59, 130, 246, 0.25) !important;
            color: var(--text-primary) !important;
            transform: translateY(-2px);
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.32);
        }

        .admin-tournaments-page .table td,
        .admin-tournaments-page .table th {
            border-color: rgba(255, 255, 255, 0.08) !important;
            background-color: transparent !important;
        }

        .admin-tournaments-page .table tbody td {
            color: var(--text-primary);
        }

        .admin-tournaments-page .table td a {
            color: var(--accent-secondary);
        }

        .admin-tournaments-page .table td a:hover {
            color: var(--accent-primary);
        }

        .admin-tournaments-page .badge {
            border: 1px solid rgba(255, 255, 255, 0.12);
            box-shadow: 0 8px 18px rgba(0, 0, 0, 0.25);
        }

        .admin-tournaments-page .input-group .form-control,
        .admin-tournaments-page .input-group .input-group-text {
            background-color: rgba(17, 24, 39, 0.7);
            color: var(--text-primary);
            border: 1px solid rgba(255, 255, 255, 0.08);
        }

        .admin-tournaments-page .input-group .form-control:focus {
            border-color: var(--accent-primary);
            box-shadow: 0 0 0 0.2rem rgba(37, 99, 235, 0.25);
        }

        .admin-tournaments-page .btn-outline-primary,
        .admin-tournaments-page .btn-outline-danger,
        .admin-tournaments-page .btn-outline-success {
            border-color: rgba(255, 255, 255, 0.18);
            color: var(--text-primary);
            background-color: rgba(17, 24, 39, 0.55);
        }

        .admin-tournaments-page .btn-outline-primary:hover {
            background: rgba(59, 130, 246, 0.2);
            color: var(--text-primary);
        }

        .admin-tournaments-page .btn-outline-danger:hover {
            background: rgba(239, 68, 68, 0.2);
            color: var(--danger);
        }

        .admin-tournaments-page .btn-outline-success:hover {
            background: rgba(16, 185, 129, 0.2);
            color: var(--success);
        }

        .admin-tournaments-page .alert-info {
            background: rgba(34, 211, 238, 0.12);
            border: 1px solid rgba(34, 211, 238, 0.35);
            color: var(--accent-secondary);
        }

        .admin-tournaments-page .text-muted {
            color: rgba(255, 255, 255, 0.55) !important;
        }

        .admin-tournaments-page #copy-toast {
            position: fixed;
            bottom: 30px;
            right: 30px;
            z-index: 9999;
            background: rgba(16, 185, 129, 0.85);
            color: var(--text-primary);
            padding: 12px 24px;
            border-radius: 10px;
            box-shadow: 0 12px 28px rgba(0, 0, 0, 0.35);
            font-weight: 600;
            border: 1px solid rgba(255, 255, 255, 0.12);
            display: none;
        }

        @media (max-width: 991.98px) {
            .admin-tournaments-page .btn-group {
                flex-wrap: wrap;
                gap: 0.25rem;
                justify-content: center;
            }

            .admin-tournaments-page .input-group {
                width: 100% !important;
            }
        }

        @media (max-width: 575.98px) {
            .admin-tournaments-page .card-header {
                flex-direction: column;
                align-items: flex-start !important;
                gap: 0.75rem;
            }

            .admin-tournaments-page .card-header .btn {
                width: 100%;
            }
        }

        /* Loading overlay styles */
        #loading-overlay {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1000;
            background: rgba(255, 255, 255, 0.9);
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }

        #tournaments-table-container {
            position: relative;
        }

        .table-responsive {
            transition: opacity 0.2s ease;
        }

        /* Smooth transitions for loading states */
        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }
    </style>
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h1 class="h5 mb-0 fw-bold"><i class="bi bi-trophy-fill me-2"></i> Quản Lý Giải Đấu</h1>
            <a href="<?php echo e(route('admin.tournaments.create')); ?>" class="btn btn-light btn-sm">
                <i class="bi bi-plus-circle me-1"></i> Tạo Giải Đấu Mới
            </a>
        </div>
        <div class="card-body">
            <!-- Search & Filter Form -->
            <form method="GET" class="mb-4" id="tournamentFilterForm">
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Tìm kiếm</label>
                        <input type="text" name="search" class="form-control" placeholder="Tên giải, địa điểm, mô tả..."
                            value="<?php echo e(request('search')); ?>">
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">Loại giải</label>
                        <select name="type" class="form-select">
                            <option value="">Tất cả</option>
                            <option value="singles" <?php echo e(request('type')=='singles' ? 'selected' : ''); ?>>Đơn</option>
                            <option value="doubles" <?php echo e(request('type')=='doubles' ? 'selected' : ''); ?>>Đôi</option>
                        </select>
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">Từ ngày</label>
                        <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>">
                    </div>

                    <div class="col-md-2">
                        <label class="form-label">Đến ngày</label>
                        <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>">
                    </div>

                    <div class="col-md-2 d-flex align-items-end">
                        <div class="btn-group w-100">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-funnel"></i>
                            </button>
                            <a href="<?php echo e(route('admin.tournaments.index')); ?>" class="btn btn-outline-light">
                                <i class="bi bi-x"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </form>

            <?php if($tournaments->isEmpty()): ?>
            <div class="alert alert-info text-center">
                Chưa có giải đấu nào được tạo.
            </div>
            <?php else: ?>
            <div class="table-responsive" id="tournaments-table-container">
                <div id="loading-overlay" class="d-none">
                    <div class="text-center p-4">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Đang tải...</span>
                        </div>
                        <div class="mt-2 text-muted">Đang tìm kiếm...</div>
                    </div>
                </div>
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th scope="col">Hình ảnh</th>
                            <th scope="col">Tên Giải</th>
                            <th scope="col">Loại</th>
                            <th scope="col">Ngày</th>
                            <th scope="col">Địa Điểm</th>
                            <th scope="col" class="text-center">Mật khẩu</th>
                            <th scope="col" class="text-center">Mật khẩu trọng tài</th>
                            <th scope="col" class="text-center">Hành Động</th>
                        </tr>
                    </thead>
                    <tbody id="tournaments-table-body">
                        <?php echo $__env->make('admin.tournaments.partials.table', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('layout_script'); ?>
<script>
    // Tournament search functionality
document.addEventListener('DOMContentLoaded', function() {
    let searchTimeout;
    let isLoading = false;
    
    // Debounce function
    function debounce(func, wait) {
        let timeout;
        return function executedFunction(...args) {
            const later = () => {
                clearTimeout(timeout);
                func(...args);
            };
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
        };
    }
    
    // Show loading state
    function showLoading() {
        if (isLoading) return;
        isLoading = true;
        const loadingOverlay = document.getElementById('loading-overlay');
        const tableBody = document.getElementById('tournaments-table-body');
        if (loadingOverlay) loadingOverlay.classList.remove('d-none');
        if (tableBody) tableBody.style.opacity = '0.5';
    }
    
    // Hide loading state
    function hideLoading() {
        isLoading = false;
        const loadingOverlay = document.getElementById('loading-overlay');
        const tableBody = document.getElementById('tournaments-table-body');
        if (loadingOverlay) loadingOverlay.classList.add('d-none');
        if (tableBody) tableBody.style.opacity = '1';
    }
    
    // Perform AJAX search
    function performSearch() {
        if (isLoading) return;
        
        showLoading();
        
        const formData = new FormData(document.getElementById('tournamentFilterForm'));
        const searchParams = new URLSearchParams(formData);
        
        fetch(`<?php echo e(route('admin.tournaments.search')); ?>?${searchParams.toString()}`, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update table content
                document.getElementById('tournaments-table-body').innerHTML = data.html;
                
                // Update URL without refreshing page
                const newUrl = `${window.location.pathname}?${searchParams.toString()}`;
                window.history.replaceState({}, '', newUrl);
            }
        })
        .catch(error => {
            console.error('Search error:', error);
        })
        .finally(() => {
            hideLoading();
        });
    }
    
    // Debounced search function
    const debouncedSearch = debounce(performSearch, 500);
    
    // Auto submit form when filter selects change
    const filterSelects = document.querySelectorAll('#tournamentFilterForm select, #tournamentFilterForm input[type="date"]');
    filterSelects.forEach(element => {
        element.addEventListener('change', function() {
            debouncedSearch();
        });
    });
    
    // Real-time search on input
    const searchInput = document.querySelector('input[name="search"]');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            debouncedSearch();
        });
        
        // Still allow Enter key for immediate search
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                clearTimeout(searchTimeout);
                performSearch();
            }
        });
    }
});

// Original copy functions - keep them intact
function copyTournamentInfo(link, btcPassword, refereePassword) {
    const info = `Link giải đấu: ${link}\n[Mật khẩu BTC: ${btcPassword}]\n[Mật khẩu trọng tài: ${refereePassword}]`;
    if (navigator.clipboard) {
        navigator.clipboard.writeText(info).then(function() {
            showCopyToast('Đã copy thông tin giải đấu!');
        }, function(err) {
            alert('Không thể copy: ' + err);
        });
    } else {
        // Fallback cho trình duyệt cũ
        const textarea = document.createElement('textarea');
        textarea.value = info;
        document.body.appendChild(textarea);
        textarea.select();
        try {
            document.execCommand('copy');
            showCopyToast('Đã copy thông tin giải đấu!');
        } catch (err) {
            alert('Không thể copy: ' + err);
        }
        document.body.removeChild(textarea);
    }
}

function showCopyToast(message) {
    let toast = document.getElementById('copy-toast');
    if (!toast) {
        toast = document.createElement('div');
        toast.id = 'copy-toast';
        toast.style.position = 'fixed';
        toast.style.bottom = '30px';
        toast.style.right = '30px';
        toast.style.zIndex = '9999';
        toast.style.background = 'rgba(16, 185, 129, 0.85)';
        toast.style.color = '#fff';
        toast.style.padding = '10px 20px';
        toast.style.borderRadius = '6px';
        toast.style.boxShadow = '0 2px 8px rgba(0,0,0,0.15)';
        toast.style.fontWeight = 'bold';
        document.body.appendChild(toast);
    }
    toast.textContent = message;
    toast.style.display = 'block';
    setTimeout(function() {
        toast.style.display = 'none';
    }, 1800);
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/tournaments/index.blade.php ENDPATH**/ ?>