

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">
                        <i class="bi bi-person-plus me-2"></i>Thêm Player Mới
                    </h3>
                    <a href="<?php echo e(route('admin.players.index')); ?>" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left me-1"></i>Quay lại
                    </a>
                </div>

                <div class="card-body">
                    <!-- Success Message -->
                    <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>

                    <!-- Error Message -->
                    <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>

                    <!-- Validation Errors -->
                    <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <h6><i class="bi bi-exclamation-triangle me-2"></i>Vui lòng kiểm tra lại thông tin:</h6>
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('admin.players.store')); ?>" enctype="multipart/form-data"
                        id="createPlayerForm">
                        <?php echo csrf_field(); ?>

                        <div class="row">
                            <!-- Basic Information -->
                            <div class="col-md-6">
                                <h5 class="mb-3 text-primary">
                                    <i class="bi bi-person me-2"></i>Thông tin cơ bản
                                </h5>

                                <div class="mb-3">
                                    <label for="name" class="form-label">
                                        Tên <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="name" id="name" value="<?php echo e(old('name')); ?>"
                                        class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                                        placeholder="Nhập họ tên đầy đủ">
                                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="email" class="form-label">
                                        Email <span class="text-danger">*</span>
                                    </label>
                                    <input type="email" name="email" id="email" value="<?php echo e(old('email')); ?>"
                                        class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                                        maxlength="255" placeholder="example@gmail.com">
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="phone" class="form-label">
                                        Số điện thoại <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="phone" id="phone" value="<?php echo e(old('phone')); ?>"
                                        class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                                        placeholder="0901234567">
                                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="gender" class="form-label">
                                        Giới tính <span class="text-danger">*</span>
                                    </label>
                                    <select name="gender" id="gender"
                                        class="form-select <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                        <option value="">-- Chọn giới tính --</option>
                                        <option value="Nam" <?php if(old('gender')=='Nam' ): ?> selected <?php endif; ?>>
                                            <i class="bi bi-gender-male"></i>Nam
                                        </option>
                                        <option value="Nữ" <?php if(old('gender')=='Nữ' ): ?> selected <?php endif; ?>>
                                            <i class="bi bi-gender-female"></i>Nữ
                                        </option>
                                        <option value="Khác" <?php if(old('gender')=='Khác' ): ?> selected <?php endif; ?>>Khác</option>
                                    </select>
                                    <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>

                            <!-- Game Information -->
                            <div class="col-md-6">
                                <h5 class="mb-3 text-success">
                                    <i class="bi bi-trophy me-2"></i>Thông tin game
                                </h5>

                                <div class="mb-3">
                                    <label for="initial_level" class="form-label">
                                        Trình độ ban đầu <span class="text-danger">*</span>
                                    </label>
                                    <select name="initial_level" id="initial_level"
                                        class="form-select <?php $__errorArgs = ['initial_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                        <option value="">-- Chọn trình độ --</option>
                                        <option value="2.0" <?php if(old('initial_level')=='2.0' ): ?> selected <?php endif; ?>>2.0 - Mới
                                            bắt đầu</option>
                                        <?php for($i = 2.1; $i <= 6.0; $i +=0.1): ?> <option value="<?php echo e(number_format($i,1)); ?>"
                                            <?php if(old('initial_level')==number_format($i,1)): ?> selected <?php endif; ?>>
                                            <?php echo e(number_format($i,1)); ?>

                                            <?php if($i <= 2.5): ?> - Người mới <?php elseif($i <=3.5): ?> - Trung bình <?php elseif($i <=4.5): ?>
                                                - Khá <?php else: ?> - Giỏi <?php endif; ?> </option>
                                                <?php endfor; ?>
                                    </select>
                                    <?php $__errorArgs = ['initial_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <div class="form-text">
                                        <i class="bi bi-info-circle me-1"></i>Điểm đôi và đơn sẽ được tự động thiết lập
                                        theo trình độ này
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="location" class="form-label">
                                        Khu vực <span class="text-danger">*</span>
                                    </label>
                                    <select name="location" id="location"
                                        class="form-select <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                        <option value="">-- Chọn khu vực --</option>
                                        <option value="Hà Nội" <?php if(old('location')=='Hà Nội' ): ?> selected <?php endif; ?>>Hà Nội
                                        </option>
                                        <option value="TP Hồ Chí Minh" <?php if(old('location')=='TP Hồ Chí Minh' ): ?> selected
                                            <?php endif; ?>>TP Hồ Chí Minh</option>
                                        <option value="Đà Nẵng" <?php if(old('location')=='Đà Nẵng' ): ?> selected <?php endif; ?>>Đà Nẵng
                                        </option>
                                        <option value="Cần Thơ" <?php if(old('location')=='Cần Thơ' ): ?> selected <?php endif; ?>>Cần Thơ
                                        </option>
                                        <option value="Hải Phòng" <?php if(old('location')=='Hải Phòng' ): ?> selected <?php endif; ?>>Hải
                                            Phòng</option>
                                        <option value="An Giang" <?php if(old('location')=='An Giang' ): ?> selected <?php endif; ?>>An
                                            Giang</option>
                                        <option value="Bà Rịa - Vũng Tàu" <?php if(old('location')=='Bà Rịa - Vũng Tàu' ): ?>
                                            selected <?php endif; ?>>Bà Rịa - Vũng Tàu</option>
                                        <option value="Bắc Giang" <?php if(old('location')=='Bắc Giang' ): ?> selected <?php endif; ?>>Bắc
                                            Giang</option>
                                        <option value="Bắc Kạn" <?php if(old('location')=='Bắc Kạn' ): ?> selected <?php endif; ?>>Bắc Kạn
                                        </option>
                                        <option value="Bạc Liêu" <?php if(old('location')=='Bạc Liêu' ): ?> selected <?php endif; ?>>Bạc
                                            Liêu</option>
                                        <option value="Bắc Ninh" <?php if(old('location')=='Bắc Ninh' ): ?> selected <?php endif; ?>>Bắc
                                            Ninh</option>
                                        <option value="Bến Tre" <?php if(old('location')=='Bến Tre' ): ?> selected <?php endif; ?>>Bến Tre
                                        </option>
                                        <option value="Bình Định" <?php if(old('location')=='Bình Định' ): ?> selected <?php endif; ?>>
                                            Bình Định</option>
                                        <option value="Bình Dương" <?php if(old('location')=='Bình Dương' ): ?> selected <?php endif; ?>>
                                            Bình Dương</option>
                                        <option value="Bình Phước" <?php if(old('location')=='Bình Phước' ): ?> selected <?php endif; ?>>
                                            Bình Phước</option>
                                        <option value="Bình Thuận" <?php if(old('location')=='Bình Thuận' ): ?> selected <?php endif; ?>>
                                            Bình Thuận</option>
                                        <option value="Cà Mau" <?php if(old('location')=='Cà Mau' ): ?> selected <?php endif; ?>>Cà Mau
                                        </option>
                                        <option value="Cao Bằng" <?php if(old('location')=='Cao Bằng' ): ?> selected <?php endif; ?>>Cao
                                            Bằng</option>
                                        <option value="Đắk Lắk" <?php if(old('location')=='Đắk Lắk' ): ?> selected <?php endif; ?>>Đắk Lắk
                                        </option>
                                        <option value="Đắk Nông" <?php if(old('location')=='Đắk Nông' ): ?> selected <?php endif; ?>>Đắk
                                            Nông</option>
                                        <option value="Điện Biên" <?php if(old('location')=='Điện Biên' ): ?> selected <?php endif; ?>>
                                            Điện Biên</option>
                                        <option value="Đồng Nai" <?php if(old('location')=='Đồng Nai' ): ?> selected <?php endif; ?>>Đồng
                                            Nai</option>
                                        <option value="Đồng Tháp" <?php if(old('location')=='Đồng Tháp' ): ?> selected <?php endif; ?>>
                                            Đồng Tháp</option>
                                        <option value="Gia Lai" <?php if(old('location')=='Gia Lai' ): ?> selected <?php endif; ?>>Gia Lai
                                        </option>
                                        <option value="Hà Giang" <?php if(old('location')=='Hà Giang' ): ?> selected <?php endif; ?>>Hà
                                            Giang</option>
                                        <option value="Hà Nam" <?php if(old('location')=='Hà Nam' ): ?> selected <?php endif; ?>>Hà Nam
                                        </option>
                                        <option value="Hà Tĩnh" <?php if(old('location')=='Hà Tĩnh' ): ?> selected <?php endif; ?>>Hà Tĩnh
                                        </option>
                                        <option value="Hải Dương" <?php if(old('location')=='Hải Dương' ): ?> selected <?php endif; ?>>Hải
                                            Dương</option>
                                        <option value="Hậu Giang" <?php if(old('location')=='Hậu Giang' ): ?> selected <?php endif; ?>>Hậu
                                            Giang</option>
                                        <option value="Hòa Bình" <?php if(old('location')=='Hòa Bình' ): ?> selected <?php endif; ?>>Hòa
                                            Bình</option>
                                        <option value="Hội An" <?php if(old('location')=='Hội An' ): ?> selected <?php endif; ?>>Hội An
                                        </option>
                                        <option value="Hưng Yên" <?php if(old('location')=='Hưng Yên' ): ?> selected <?php endif; ?>>Hưng
                                            Yên</option>
                                        <option value="Khánh Hòa" <?php if(old('location')=='Khánh Hòa' ): ?> selected <?php endif; ?>>
                                            Khánh Hòa</option>
                                        <option value="Kiên Giang" <?php if(old('location')=='Kiên Giang' ): ?> selected <?php endif; ?>>
                                            Kiên Giang</option>
                                        <option value="Kon Tum" <?php if(old('location')=='Kon Tum' ): ?> selected <?php endif; ?>>Kon Tum
                                        </option>
                                        <option value="Lai Châu" <?php if(old('location')=='Lai Châu' ): ?> selected <?php endif; ?>>Lai
                                            Châu</option>
                                        <option value="Lâm Đồng" <?php if(old('location')=='Lâm Đồng' ): ?> selected <?php endif; ?>>Lâm
                                            Đồng</option>
                                        <option value="Lạng Sơn" <?php if(old('location')=='Lạng Sơn' ): ?> selected <?php endif; ?>>Lạng
                                            Sơn</option>
                                        <option value="Lào Cai" <?php if(old('location')=='Lào Cai' ): ?> selected <?php endif; ?>>Lào Cai
                                        </option>
                                        <option value="Long An" <?php if(old('location')=='Long An' ): ?> selected <?php endif; ?>>Long An
                                        </option>
                                        <option value="Nam Định" <?php if(old('location')=='Nam Định' ): ?> selected <?php endif; ?>>Nam
                                            Định</option>
                                        <option value="Nghệ An" <?php if(old('location')=='Nghệ An' ): ?> selected <?php endif; ?>>Nghệ An
                                        </option>
                                        <option value="Ninh Bình" <?php if(old('location')=='Ninh Bình' ): ?> selected <?php endif; ?>>
                                            Ninh Bình</option>
                                        <option value="Ninh Thuận" <?php if(old('location')=='Ninh Thuận' ): ?> selected <?php endif; ?>>
                                            Ninh Thuận</option>
                                        <option value="Phú Thọ" <?php if(old('location')=='Phú Thọ' ): ?> selected <?php endif; ?>>Phú Thọ
                                        </option>
                                        <option value="Phú Yên" <?php if(old('location')=='Phú Yên' ): ?> selected <?php endif; ?>>Phú Yên
                                        </option>
                                        <option value="Quảng Bình" <?php if(old('location')=='Quảng Bình' ): ?> selected <?php endif; ?>>
                                            Quảng Bình</option>
                                        <option value="Quảng Nam" <?php if(old('location')=='Quảng Nam' ): ?> selected <?php endif; ?>>
                                            Quảng Nam</option>
                                        <option value="Quảng Ngãi" <?php if(old('location')=='Quảng Ngãi' ): ?> selected <?php endif; ?>>
                                            Quảng Ngãi</option>
                                        <option value="Quảng Ninh" <?php if(old('location')=='Quảng Ninh' ): ?> selected <?php endif; ?>>
                                            Quảng Ninh</option>
                                        <option value="Quảng Trị" <?php if(old('location')=='Quảng Trị' ): ?> selected <?php endif; ?>>
                                            Quảng Trị</option>
                                        <option value="Sóc Trăng" <?php if(old('location')=='Sóc Trăng' ): ?> selected <?php endif; ?>>Sóc
                                            Trăng</option>
                                        <option value="Sơn La" <?php if(old('location')=='Sơn La' ): ?> selected <?php endif; ?>>Sơn La
                                        </option>
                                        <option value="Tây Ninh" <?php if(old('location')=='Tây Ninh' ): ?> selected <?php endif; ?>>Tây
                                            Ninh</option>
                                        <option value="Thái Bình" <?php if(old('location')=='Thái Bình' ): ?> selected <?php endif; ?>>
                                            Thái Bình</option>
                                        <option value="Thái Nguyên" <?php if(old('location')=='Thái Nguyên' ): ?> selected
                                            <?php endif; ?>>Thái Nguyên</option>
                                        <option value="Thanh Hóa" <?php if(old('location')=='Thanh Hóa' ): ?> selected <?php endif; ?>>
                                            Thanh Hóa</option>
                                        <option value="Thừa Thiên Huế" <?php if(old('location')=='Thừa Thiên Huế' ): ?> selected
                                            <?php endif; ?>>Thừa Thiên Huế</option>
                                        <option value="Tiền Giang" <?php if(old('location')=='Tiền Giang' ): ?> selected <?php endif; ?>>
                                            Tiền Giang</option>
                                        <option value="Trà Vinh" <?php if(old('location')=='Trà Vinh' ): ?> selected <?php endif; ?>>Trà
                                            Vinh</option>
                                        <option value="Tuyên Quang" <?php if(old('location')=='Tuyên Quang' ): ?> selected
                                            <?php endif; ?>>Tuyên Quang</option>
                                        <option value="Vĩnh Long" <?php if(old('location')=='Vĩnh Long' ): ?> selected <?php endif; ?>>
                                            Vĩnh Long</option>
                                        <option value="Vĩnh Phúc" <?php if(old('location')=='Vĩnh Phúc' ): ?> selected <?php endif; ?>>
                                            Vĩnh Phúc</option>
                                        <option value="Yên Bái" <?php if(old('location')=='Yên Bái' ): ?> selected <?php endif; ?>>Yên Bái
                                        </option>
                                        <option value="Khác" <?php if(old('location')=='Khác' ): ?> selected <?php endif; ?>>Khác</option>
                                    </select>
                                    <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="status" class="form-label">
                                        Trạng thái
                                    </label>
                                    <select name="status" id="status"
                                        class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <option value="0" <?php if(old('status', 0)==0): ?> selected <?php endif; ?>>
                                            <i class="bi bi-clock"></i>Chưa duyệt
                                        </option>
                                        <option value="1" <?php if(old('status')==1): ?> selected <?php endif; ?>>
                                            <i class="bi bi-check-circle"></i>Đã duyệt
                                        </option>
                                        <option value="2" <?php if(old('status')==2): ?> selected <?php endif; ?>>
                                            <i class="bi bi-shield-check"></i>Được bảo lãnh
                                        </option>
                                    </select>
                                    <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <label for="avatar" class="form-label">
                                        Avatar
                                    </label>
                                    <input type="file" name="avatar" id="avatar"
                                        class="form-control <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" accept="image/*">
                                    <?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i><?php echo e($message); ?>

                                    </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <div class="form-text">
                                        <i class="bi bi-info-circle me-1"></i>Chọn file ảnh (JPG, PNG, GIF). Tối đa 2MB.
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e(route('admin.players.index')); ?>" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-1"></i>Hủy bỏ
                            </a>
                            <button type="submit" class="btn btn-success" id="submitBtn">
                                <i class="bi bi-person-plus me-1"></i>Thêm Player
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .card {
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }

    .form-label {
        font-weight: 500;
    }

    .is-invalid {
        border-color: #dc3545;
        box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
    }

    .invalid-feedback {
        display: block;
    }

    .alert {
        border: none;
        border-radius: 0.5rem;
    }

    #submitBtn:hover {
        transform: translateY(-1px);
        transition: all 0.2s;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    // Form validation feedback
    const form = document.getElementById('createPlayerForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Đang xử lý...';
        submitBtn.disabled = true;
    });

    // Auto-hide alerts after 5 seconds
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => {
            if (alert.classList.contains('show')) {
                alert.classList.remove('show');
                setTimeout(() => alert.remove(), 150);
            }
        }, 5000);
    });

    // Phone number formatting
    const phoneInput = document.getElementById('phone');
    phoneInput.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 10) value = value.slice(0, 10);
        e.target.value = value;
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/players/create.blade.php ENDPATH**/ ?>