<?php $__empty_1 = true; $__currentLoopData = $players; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $player): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
<tr>
    <td><strong><?php echo e($player->id); ?></strong></td>
    <td>
        <span class="badge bg-info"><?php echo e($player->player_id); ?></span>
    </td>
    <td>
        <div class="d-flex align-items-center">
            <a href="<?php echo e(route('admin.players.edit', $player)); ?>" class="fw-semibold"><?php echo e($player->name); ?></a>
        </div>
    </td>
    <td>
        <span class="badge bg-primary"><?php echo e(number_format($player->doubles_score, 1)); ?></span>
    </td>
    <td>
        <span class="badge bg-success"><?php echo e(number_format($player->singles_score, 1)); ?></span>
    </td>
    <td>
        <i class="bi bi-geo-alt text-muted me-1"></i>
        <?php echo e($player->location); ?>

    </td>
    <td>
        <?php if($player->gender == 'Nam'): ?>
        <span class="badge bg-info">
            <i class="bi bi-gender-male me-1"></i><?php echo e($player->gender); ?>

        </span>
        <?php else: ?>
        <span class="badge bg-pink">
            <i class="bi bi-gender-female me-1"></i><?php echo e($player->gender); ?>

        </span>
        <?php endif; ?>
    </td>
    <td>
        <?php echo e($player->phone); ?>

    </td>
    <td>
        <?php if($player->avatar): ?>
        <img src="<?php echo e(asset($player->avatar)); ?>" width="50" height="50" class="rounded border" style="object-fit:cover;">
        <?php else: ?>
        <div class="bg-light border rounded d-flex align-items-center justify-content-center"
            style="width: 50px; height: 50px;">
            <i class="bi bi-person text-muted"></i>
        </div>
        <?php endif; ?>
    </td>
    <td>
        <?php if($player->status==0): ?>
        <span class="badge bg-secondary">
            <i class="bi bi-clock me-1"></i>Chưa duyệt
        </span>
        <?php elseif($player->status==1): ?>
        <span class="badge bg-success">
            <i class="bi bi-check me-1"></i>Đã duyệt
        </span>
        <?php elseif($player->status==2): ?>
        <span class="badge bg-warning">
            <i class="bi bi-shield-check me-1"></i>Bảo lãnh
        </span>
        <?php endif; ?>
    </td>
    <td>
        <?php if($player->avatar_pending): ?>
        <div class="rounded d-flex align-items-center justify-content-center">
            <img src="<?php echo e(asset($player->avatar_pending)); ?>" width="50" height="50" class="rounded border"
                style="object-fit:cover;" alt="Avatar pending">
        </div>
        <div class="d-flex gap-1">
            <form action="<?php echo e(route('admin.players.approveAvatar', $player)); ?>" method="POST"
                style="display:inline-block;">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-sm btn-success fw-semibold text-white shadow-sm"
                    onclick="return confirm('Duyệt avatar này?')">
                    <i class="bi bi-check me-1"></i>
                </button>
            </form>
            <form action="<?php echo e(route('admin.players.rejectAvatar', $player)); ?>" method="POST"
                style="display:inline-block;">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-sm btn-danger fw-semibold text-white shadow-sm"
                    onclick="return confirm('Từ chối avatar này? Avatar sẽ bị xóa khỏi trạng thái chờ duyệt.')">
                    <i class="bi bi-x me-1"></i>
                </button>
            </form>
        </div>
        <?php else: ?>
        <span class="badge bg-success">
            <i class="bi bi-check me-1"></i>Đã duyệt
        </span>
        <?php endif; ?>
    </td>
    <td>
        <div class="btn-group" role="group">
            <a href="<?php echo e(route('admin.players.edit', $player)); ?>" class="btn btn-outline-primary" title="Chỉnh sửa">
                <i class="bi bi-pencil"></i>
            </a>
            <form action="<?php echo e(route('admin.players.destroy', $player)); ?>" method="POST" style="display:inline-block;">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-outline-danger" onclick="return confirm('Bạn có chắc muốn xóa?')">
                    <i class="bi bi-trash"></i>
                </button>
            </form>
        </div>
    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
<tr>
    <td colspan="12" class="text-center text-light py-4">
        <i class="bi bi-people text-muted mb-3" style="font-size: 3rem;"></i>
        <h5 class="text-muted">Không có dữ liệu player</h5>
        <p class="text-muted">Hãy thêm player mới hoặc thay đổi bộ lọc</p>
        <a href="<?php echo e(route('admin.players.create')); ?>" class="btn btn-success fw-semibold shadow-sm">
            <i class="bi bi-plus me-1"></i>Thêm Player Đầu Tiên
        </a>
    </td>
</tr>
<?php endif; ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/players/partials/table.blade.php ENDPATH**/ ?>