
<?php $__env->startSection('title', 'Thêm cặp đấu vào Bảng ' . $group->name); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="card">
        <div class="card-header">
            <h1 class="card-title fw-bold text-primary">
                <i class="bi bi-people-fill"></i> Thêm cặp đấu vào Bảng <?php echo e($group->name); ?>

            </h1>
            <p class="text-muted">Giải đấu: <?php echo e($group->tournament->name); ?></p>
        </div>
        <div class="card-body">
            <form action="<?php echo e(isset($formAction) ? $formAction : route('admin.groups.pairs.store', $group)); ?>"
                method="POST">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-12 mb-3">
                        <label for="registration_pair" class="form-label">Chọn cặp đăng ký đã được duyệt</label>
                        <select id="registration_pair" class="form-select" required>
                            <option value="">-- Chọn cặp đăng ký --</option>
                            <?php $__currentLoopData = $pairs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            $p1 = $pair['player1'];
                            $p2 = $pair['player2'];
                            $label = ($p1 ? $p1->name : 'VĐV không xác định') . ' & ' . ($p2 ? $p2->name : 'VĐV không
                            xác định');
                            ?>
                            <option value="<?php echo e($pair['player1_id']); ?>|<?php echo e($pair['player2_id']); ?>"><?php echo e($label); ?> (Reg#<?php echo e($pair['registration_id']); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                        
                        <input type="hidden" name="player1_id" id="player1_id" />
                        <input type="hidden" name="player2_id" id="player2_id" />
                    </div>
                </div>

                <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p><?php echo e($error); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endif; ?>

                <button type="submit" class="btn btn-primary">Thêm cặp đấu</button>
                <a href="<?php echo e(isset($cancelUrl) ? $cancelUrl : route('admin.tournaments.show', $group->tournament_id)); ?>"
                    class="btn btn-secondary">Hủy</a>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('layout_script'); ?>
<script>
    // Đợi tài liệu được tải xong
    $(document).ready(function() {
        // Kích hoạt Select2 cho các ô lựa chọn VĐV
        $('.form-select').select2({
            theme: 'bootstrap-5'
        });

        // Khi chọn cặp đăng ký, điền giá trị vào hidden inputs player1_id và player2_id
        $('#registration_pair').on('change', function() {
            var val = $(this).val();
            if (!val) {
                $('#player1_id').val('');
                $('#player2_id').val('');
                return;
            }
            var parts = val.split('|');
            $('#player1_id').val(parts[0]);
            $('#player2_id').val(parts[1]);
        });

        // Ensure form submission has hidden inputs populated. If hidden inputs
        // are empty (e.g. select2 didn't populate them or JS was slow), try
        // to parse the currently selected option value and fill them as a
        // fallback before validation.
        $('form').on('submit', function(e) {
            var p1 = $('#player1_id').val();
            var p2 = $('#player2_id').val();

            // Fallback: try to derive from the select value if hidden inputs are empty
            if ((!p1 || !p2) && $('#registration_pair').length) {
                var selVal = $('#registration_pair').val();
                if (selVal) {
                    var parts = selVal.split('|');
                    if (parts.length === 2) {
                        $('#player1_id').val(parts[0]);
                        $('#player2_id').val(parts[1]);
                        p1 = parts[0];
                        p2 = parts[1];
                    }
                }
            }

            if (!p1 || !p2) {
                e.preventDefault();
                var msg = 'Vui lòng chọn một cặp đăng ký hợp lệ.';
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'warning',
                        title: 'Lưu ý',
                        text: msg,
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        timer: 3000
                    });
                } else {
                    alert(msg);
                }
            }
        });

        // Show server-side flash messages (if any)
        var flashInfo = <?php echo json_encode(session('info')); ?>;
        var flashSuccess = <?php echo json_encode(session('success')); ?>;
        var flashError = <?php echo json_encode(session('error')); ?>;
        if (flashInfo) {
            if (typeof Swal !== 'undefined') {
                Swal.fire({ icon: 'info', title: flashInfo, toast: true, position: 'top-end', showConfirmButton: false, timer: 3500 });
            } else { alert(flashInfo); }
        }
        if (flashSuccess) {
            if (typeof Swal !== 'undefined') {
                Swal.fire({ icon: 'success', title: flashSuccess, toast: true, position: 'top-end', showConfirmButton: false, timer: 3500 });
            } else { alert(flashSuccess); }
        }
        if (flashError) {
            if (typeof Swal !== 'undefined') {
                Swal.fire({ icon: 'error', title: flashError, toast: true, position: 'top-end', showConfirmButton: false, timer: 4000 });
            } else { alert(flashError); }
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/pairs/create.blade.php ENDPATH**/ ?>