<style>
    /* Dark theme styles for bracket view */
    .bracket {
        display: flex;
        justify-content: center;
        background: var(--secondary-bg) !important;
        padding: 20px;
        border-radius: 8px;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .bracket-round {
        display: flex;
        flex-direction: column;
        justify-content: space-around;
        flex: 1;
    }

    .bracket-round h4 {
        color: var(--accent-primary) !important;
    }

    .bracket-match {
        display: flex;
        flex-direction: column;
        justify-content: center;
        margin: 20px 10px;
        position: relative;
    }

    .bracket-pair {
        background: var(--card-bg) !important;
        color: var(--text-primary) !important;
        padding: 10px;
        margin: 5px 0;
        border-radius: 5px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border: 1px solid var(--border-color) !important;
        border-left: 5px solid var(--text-muted);
        min-width: 220px;
    }

    .bracket-pair.winner {
        border-left-color: var(--success) !important;
        font-weight: bold;
        background: rgba(16, 185, 129, 0.1) !important;
    }

    .bracket-pair .score {
        font-weight: bold;
        color: var(--warning) !important;
    }

    .final-rounds-container {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 2rem;
        margin-top: 2rem;
    }

    .final-match {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        padding: 20px;
        border-radius: 8px;
        min-width: 300px;
        display: flex;
        flex-direction: column;
        align-items: center;
        box-shadow: 0 4px 8px var(--shadow-dark);
    }

    .final-match h4 {
        color: var(--accent-primary) !important;
    }

    .final-match .bracket-pair {
        width: 100%;
    }

    .player-number-tag {
        background: var(--accent-primary);
        color: #ffffff;
        padding: 2px 6px;
        border-radius: 50%;
        font-size: 0.7rem;
        font-weight: bold;
        margin: 0 2px;
    }

    @media (max-width: 767.98px) {
        .bracket {
            flex-direction: column;
            align-items: stretch;
        }

        .bracket-round {
            margin-bottom: 2rem;
        }
    }
</style>

<div id="printable-bracket">
    <div class="bracket">
        <!-- Round of 64 -->
        <?php if(!empty($roundOf64)): ?>
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Vòng 1/64</h4>
            <?php $__currentLoopData = $roundOf64->matches->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matchGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bracket-match-group">
                <?php $__currentLoopData = $matchGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bracket-match">
                    <?php $scores = $match->score ? explode('-', $match->score) : [null, null]; ?>
                    <?php if($match->status === 'Bye'): ?>
                    <div class="bracket-pair winner" title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''); ?></span>
                        <span class="score">BYE</span>
                    </div>
                    <?php else: ?>
                    <div class="bracket-pair <?php echo e(($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : ''); ?>"
                        title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''); ?></span>
                        <span class="score"><?php echo e($scores[0] ?? '-'); ?></span>
                    </div>
                    <div class="bracket-pair <?php echo e(($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : ''); ?>"
                        title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair2->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''); ?></span>
                        <span class="score"><?php echo e($scores[1] ?? '-'); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php endif; ?>

        <!-- Round of 32 -->
        <?php if(!empty($roundOf32)): ?>
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Vòng 1/32</h4>
            <?php $__currentLoopData = $roundOf32->matches->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matchGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bracket-match-group">
                <?php $__currentLoopData = $matchGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bracket-match">
                    <?php $scores = $match->score ? explode('-', $match->score) : [null, null]; ?>
                    <?php if($match->status === 'Bye'): ?>
                    <div class="bracket-pair winner" title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''); ?></span>
                        <span class="score">BYE</span>
                    </div>
                    <?php else: ?>
                    <div class="bracket-pair <?php echo e(($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : ''); ?>"
                        title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''); ?></span>
                        <span class="score"><?php echo e($scores[0] ?? '-'); ?></span>
                    </div>
                    <div class="bracket-pair <?php echo e(($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : ''); ?>"
                        title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair2->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''); ?></span>
                        <span class="score"><?php echo e($scores[1] ?? '-'); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php endif; ?>

        <!-- Round of 16 -->
        <?php if(!empty($roundOf16)): ?>
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Vòng 1/16</h4>
            <?php $__currentLoopData = $roundOf16->matches->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matchGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bracket-match-group">
                <?php $__currentLoopData = $matchGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bracket-match">
                    <?php $scores = $match->score ? explode('-', $match->score) : [null, null]; ?>
                    <?php if($match->status === 'Bye'): ?>
                    <div class="bracket-pair winner" title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''); ?></span>
                        <span class="score">BYE</span>
                    </div>
                    <?php else: ?>
                    <div class="bracket-pair <?php echo e(($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : ''); ?>"
                        title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''); ?></span>
                        <span class="score"><?php echo e($scores[0] ?? '-'); ?></span>
                    </div>
                    <div class="bracket-pair <?php echo e(($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : ''); ?>"
                        title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair2->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''); ?></span>
                        <span class="score"><?php echo e($scores[1] ?? '-'); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php endif; ?>

        <!-- Quarter-finals -->
        <?php if(!empty($quarterFinals)): ?>
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Tứ kết</h4>
            <?php $__currentLoopData = $quarterFinals->matches->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $matchGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bracket-match-group">
                <?php $__currentLoopData = $matchGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bracket-match">
                    <?php $scores = $match->score ? explode('-', $match->score) : [null, null]; ?>
                    <div class="bracket-pair <?php echo e(($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : ''); ?>"
                        title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''); ?></span>
                        <span class="score"><?php echo e($scores[0] ?? '-'); ?></span>
                    </div>
                    <div class="bracket-pair <?php echo e(($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : ''); ?>"
                        title="ID Trận: <?php echo e($match->id); ?>">
                        <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair2->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''); ?></span>
                        <span class="score"><?php echo e($scores[1] ?? '-'); ?></span>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php endif; ?>

        <!-- Semi-finals -->
        <?php if(!empty($semiFinals)): ?>
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Bán kết</h4>
            <?php $__currentLoopData = $semiFinals->matches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bracket-match">
                <?php $scores = $match->score ? explode('-', $match->score) : [null, null]; ?>
                <div class="bracket-pair <?php echo e(($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : ''); ?>"
                    title="ID Trận: <?php echo e($match->id); ?>">
                    <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span
                            class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''); ?></span>
                    <span class="score"><?php echo e($scores[0] ?? '-'); ?></span>
                </div>
                <div class="bracket-pair <?php echo e(($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : ''); ?>"
                    title="ID Trận: <?php echo e($match->id); ?>">
                    <span class="pair-name"><span class="player-number-tag p1">1</span><?php echo e($match->pair2->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles' ? ' & ' : ''); ?><span
                            class="player-number-tag p2"><?php echo e($tournament->type == 'doubles' ? '2' : ''); ?></span><?php echo e($tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''); ?></span>
                    <span class="score"><?php echo e($scores[1] ?? '-'); ?></span>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php endif; ?>
    </div>

    <!-- Final & 3rd Place -->
    <?php if(!empty($final) || !empty($thirdPlace)): ?>
    <div class="final-rounds-container">
        <!-- Tranh Hạng Ba -->
        <?php if(!empty($thirdPlace) && $thirdPlace->matches->first()): ?>
        <?php $match = $thirdPlace->matches->first(); ?>
        <div class="bracket-round final-match">
            <h4 class="text-primary text-center mb-3 fw-bold"><?php echo e($thirdPlace->name); ?></h4>
            <div class="bracket-match">
                <?php $scores = $match->score ? explode('-', $match->score) : [null, null]; ?>
                <div class="bracket-pair <?php echo e(($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : ''); ?>">
                    <span class="pair-name"><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles'
                        ? ' & ' . ($match->pair1->player2->name ?? '') : ''); ?></span>
                    <span class="score"><?php echo e($scores[0] ?? '-'); ?></span>
                </div>
                <div class="bracket-pair <?php echo e(($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : ''); ?>">
                    <span class="pair-name"><?php echo e($match->pair2->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles'
                        ? ' & ' . ($match->pair2->player2->name ?? '') : ''); ?></span>
                    <span class="score"><?php echo e($scores[1] ?? '-'); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Chung kết -->
        <?php if(!empty($final) && $final->matches->first()): ?>
        <?php $match = $final->matches->first(); ?>
        <div class="bracket-round final-match" style="border-color: #f1c40f;">
            <h4 class="text-primary text-center mb-3 fw-bold"><?php echo e($final->name); ?></h4>
            <div class="bracket-match">
                <?php $scores = $match->score ? explode('-', $match->score) : [null, null]; ?>
                <div class="bracket-pair <?php echo e(($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : ''); ?>">
                    <span class="pair-name"><?php echo e($match->pair1->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles'
                        ? ' & ' . ($match->pair1->player2->name ?? '') : ''); ?></span>
                    <span class="score"><?php echo e($scores[0] ?? '-'); ?></span>
                </div>
                <div class="bracket-pair <?php echo e(($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : ''); ?>">
                    <span class="pair-name"><?php echo e($match->pair2->player1->name ?? 'TBD'); ?><?php echo e($tournament->type == 'doubles'
                        ? ' & ' . ($match->pair2->player2->name ?? '') : ''); ?></span>
                    <span class="score"><?php echo e($scores[1] ?? '-'); ?></span>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/tournaments/partials/bracket_view.blade.php ENDPATH**/ ?>