

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <h2><?php echo e(__('admin.user_management.user_list')); ?></h2>
            <p class="text-muted mb-0">Tổng cộng: <strong><?php echo e($users->total()); ?></strong> người dùng</p>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
        <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-primary fw-semibold shadow-sm">
            <i class="bi bi-plus-circle me-1"></i>
            <?php echo e(__('admin.action.add_item', ['attribute' => 'User'])); ?>

        </a>
        <?php endif; ?>
    </div>
    <!-- Advanced Filter Form -->
    <div class="card mb-4 filter-card">
        <div class="card-header">
            <h5 class="mb-0">
                <i class="bi bi-funnel me-2"></i>
                Bộ lọc tìm kiếm
            </h5>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('admin.users.index')); ?>" method="GET" class="row g-3" id="userFilterForm">
                <div class="col-md-4">
                    <label for="search" class="form-label">Tìm kiếm</label>
                    <input type="text" id="search" name="search" class="form-control"
                        placeholder="Tìm theo tên, email hoặc SĐT..." value="<?php echo e(request('search')); ?>">
                </div>
                <div class="col-md-2">
                    <label for="role" class="form-label">Vai trò</label>
                    <select name="role" id="role" class="form-select">
                        <option value="">-- Tất cả --</option>
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($role->name); ?>" <?php echo e(request('role')==$role->name ? 'selected' : ''); ?>>
                            <?php echo e(ucfirst($role->name)); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="gender" class="form-label">Giới tính</label>
                    <select name="gender" id="gender" class="form-select">
                        <option value="">-- Tất cả --</option>
                        <?php $__currentLoopData = $genders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gender): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($gender); ?>" <?php echo e(request('gender')==$gender ? 'selected' : ''); ?>>
                            <?php echo e($gender); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="location" class="form-label">Khu vực</label>
                    <select name="location" id="location" class="form-select">
                        <option value="">-- Tất cả --</option>
                        <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($location); ?>" <?php echo e(request('location')==$location ? 'selected' : ''); ?>>
                            <?php echo e($location); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="sort_by" class="form-label">Sắp xếp theo</label>
                    <select name="sort_by" id="sort_by" class="form-select">
                        <option value="created_at" <?php echo e(request('sort_by')=='created_at' ? 'selected' : ''); ?>>Ngày tạo
                        </option>
                        <option value="name" <?php echo e(request('sort_by')=='name' ? 'selected' : ''); ?>>Tên</option>
                        <option value="email" <?php echo e(request('sort_by')=='email' ? 'selected' : ''); ?>>Email</option>
                        <option value="location" <?php echo e(request('sort_by')=='location' ? 'selected' : ''); ?>>Khu vực</option>
                    </select>
                </div>
                <div class="col-12">
                    <button type="submit" class="btn btn-primary fw-semibold shadow-sm me-2">
                        <i class="bi bi-search me-1"></i>Tìm kiếm
                    </button>
                    <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-outline-light fw-semibold shadow-sm">
                        <i class="bi bi-x-circle me-1"></i>Xóa bộ lọc
                    </a>
                    <input type="hidden" name="sort_direction" value="<?php echo e(request('sort_direction', 'desc')); ?>">
                </div>
            </form>
        </div>
    </div>
    <div class="table-responsive dark-table-wrapper" id="users-table-container">
        <div id="loading-overlay" class="d-none">
            <div class="text-center p-4">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Đang tải...</span>
                </div>
                <div class="mt-2 text-muted">Đang tìm kiếm...</div>
            </div>
        </div>
        <table class="table table-hover table-striped table-dark-mode align-middle">
            <thead class="table-dark-mode-head">
                <tr>
                    <th>ID</th>
                    <th>
                        <a href="?<?php echo e(http_build_query(array_merge(request()->query(), ['sort_by' => 'name', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>"
                            class="text-decoration-none">
                            <?php echo e(__('validation.attributes.name')); ?>

                            <?php if(request('sort_by') === 'name'): ?>
                            <i class="bi bi-chevron-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>
                        <a href="?<?php echo e(http_build_query(array_merge(request()->query(), ['sort_by' => 'email', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>"
                            class="text-decoration-none">
                            <?php echo e(__('validation.attributes.email')); ?>

                            <?php if(request('sort_by') === 'email'): ?>
                            <i class="bi bi-chevron-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th><?php echo e(__('validation.attributes.phone')); ?></th>
                    <th>
                        <a href="?<?php echo e(http_build_query(array_merge(request()->query(), ['sort_by' => 'location', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>"
                            class="text-decoration-none">
                            Địa điểm
                            <?php if(request('sort_by') === 'location'): ?>
                            <i class="bi bi-chevron-<?php echo e(request('sort_direction') === 'asc' ? 'up' : 'down'); ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th><?php echo e(__('validation.attributes.gender')); ?></th>
                    <th>Avatar</th>
                    <th>Role</th>
                    <th>
                        <a href="?<?php echo e(http_build_query(array_merge(request()->query(), ['sort_by' => 'created_at', 'sort_direction' => request('sort_direction') === 'asc' ? 'desc' : 'asc']))); ?>"
                            class="text-decoration-none">
                            Ngày tạo
                            <?php if(request('sort_by') === 'created_at' || !request('sort_by')): ?>
                            <i
                                class="bi bi-chevron-<?php echo e(request('sort_direction', 'desc') === 'asc' ? 'up' : 'down'); ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th style="min-width: 120px;"><?php echo e(__('admin.products.actions') ?? 'Hành động'); ?></th>
                </tr>
            </thead>
            <tbody id="users-table-body">
                <?php echo $__env->make('admin.users.partials.table', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </tbody>
        </table>
    </div>

    <div id="pagination-container">
        <?php echo $__env->make('admin.users.partials.pagination', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
</div>

<style>
    /* Loading overlay styles */
    #loading-overlay {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        z-index: 1000;
        background: rgba(255, 255, 255, 0.9);
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    #users-table-container {
        position: relative;
    }

    .table-responsive {
        transition: opacity 0.2s ease;
    }

    /* Smooth transitions for loading states */
    .fade-in {
        animation: fadeIn 0.3s ease-in-out;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
        }

        to {
            opacity: 1;
        }
    }
</style>

<script>
    // User search functionality
document.addEventListener('DOMContentLoaded', function() {
    let searchTimeout;
    let isLoading = false;
    
    // Debounce function
    function debounce(func, wait) {
        let timeout;
        return function executedFunction(...args) {
            const later = () => {
                clearTimeout(timeout);
                func(...args);
            };
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
        };
    }
    
    // Show loading state
    function showLoading() {
        if (isLoading) return;
        isLoading = true;
        const loadingOverlay = document.getElementById('loading-overlay');
        const tableBody = document.getElementById('users-table-body');
        if (loadingOverlay) loadingOverlay.classList.remove('d-none');
        if (tableBody) tableBody.style.opacity = '0.5';
    }
    
    // Hide loading state
    function hideLoading() {
        isLoading = false;
        const loadingOverlay = document.getElementById('loading-overlay');
        const tableBody = document.getElementById('users-table-body');
        if (loadingOverlay) loadingOverlay.classList.add('d-none');
        if (tableBody) tableBody.style.opacity = '1';
    }
    
    // Perform AJAX search
    function performSearch() {
        if (isLoading) return;
        
        showLoading();
        
        const formData = new FormData(document.getElementById('userFilterForm'));
        const searchParams = new URLSearchParams(formData);
        
        // Add current URL query parameters to maintain sorting
        const currentParams = new URLSearchParams(window.location.search);
        for (const [key, value] of currentParams.entries()) {
            if (!searchParams.has(key)) {
                searchParams.set(key, value);
            }
        }
        
        fetch(`<?php echo e(route('admin.users.search')); ?>?${searchParams.toString()}`, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update table content
                document.getElementById('users-table-body').innerHTML = data.html;
                
                // Update pagination
                document.getElementById('pagination-container').innerHTML = data.pagination;
                
                // Update URL without refreshing page
                const newUrl = `${window.location.pathname}?${searchParams.toString()}`;
                window.history.replaceState({}, '', newUrl);
                
                // Re-attach pagination event listeners
                attachPaginationListeners();
            }
        })
        .catch(error => {
            console.error('Search error:', error);
        })
        .finally(() => {
            hideLoading();
        });
    }
    
    // Attach event listeners to pagination links
    function attachPaginationListeners() {
        const paginationLinks = document.querySelectorAll('#pagination-container a');
        paginationLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                const url = new URL(this.href);
                const page = url.searchParams.get('page');
                
                if (page) {
                    // Add page parameter to form and search
                    const hiddenPageInput = document.querySelector('input[name="page"]') || 
                                           document.createElement('input');
                    hiddenPageInput.type = 'hidden';
                    hiddenPageInput.name = 'page';
                    hiddenPageInput.value = page;
                    
                    if (!document.querySelector('input[name="page"]')) {
                        document.getElementById('userFilterForm').appendChild(hiddenPageInput);
                    }
                    
                    performSearch();
                }
            });
        });
    }
    
    // Debounced search function
    const debouncedSearch = debounce(performSearch, 500);
    
    // Auto submit form when filter selects change
    const filterSelects = document.querySelectorAll('#userFilterForm select');
    filterSelects.forEach(select => {
        select.addEventListener('change', function() {
            // Clear page parameter when filter changes
            const pageInput = document.querySelector('input[name="page"]');
            if (pageInput) {
                pageInput.remove();
            }
            debouncedSearch();
        });
    });
    
    // Real-time search on input
    const searchInput = document.querySelector('input[name="search"]');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            // Clear page parameter when search changes
            const pageInput = document.querySelector('input[name="page"]');
            if (pageInput) {
                pageInput.remove();
            }
            debouncedSearch();
        });
        
        // Still allow Enter key for immediate search
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                clearTimeout(searchTimeout);
                performSearch();
            }
        });
    }
    
    // Initial pagination listeners
    attachPaginationListeners();
    
    // Handle sorting links
    document.addEventListener('click', function(e) {
        if (e.target.closest('th a')) {
            e.preventDefault();
            const link = e.target.closest('a');
            const url = new URL(link.href);
            
            // Update sort parameters in form
            const sortBy = url.searchParams.get('sort_by');
            const sortDirection = url.searchParams.get('sort_direction');
            
            // Add/update hidden inputs for sorting
            let sortByInput = document.querySelector('input[name="sort_by"]') || 
                             document.createElement('input');
            let sortDirectionInput = document.querySelector('input[name="sort_direction"]') || 
                                document.createElement('input');
            
            sortByInput.type = 'hidden';
            sortByInput.name = 'sort_by';
            sortByInput.value = sortBy;
            
            sortDirectionInput.type = 'hidden';
            sortDirectionInput.name = 'sort_direction';
            sortDirectionInput.value = sortDirection;
            
            if (!document.querySelector('input[name="sort_by"]')) {
                document.getElementById('userFilterForm').appendChild(sortByInput);
            }
            if (!document.querySelector('input[name="sort_direction"]')) {
                document.getElementById('userFilterForm').appendChild(sortDirectionInput);
            }
            
            // Clear page parameter when sorting
            const pageInput = document.querySelector('input[name="page"]');
            if (pageInput) {
                pageInput.remove();
            }
            
            performSearch();
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/users/index.blade.php ENDPATH**/ ?>