

<?php $__env->startSection('title', __('admin.user_management.edit_user_title', ['name' => $user->name])); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    
    <?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <?php endif; ?>

    
    <?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if(session('error')): ?>
    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <div class="card shadow-sm">
        <div class="card-header bg-light">
            <h2 class="h5 mb-0 fw-bold">
                <i class="bi bi-pencil-square me-2"></i>
                <?php echo e(__('admin.user_management.edit_user_title', ['name' => $user->name])); ?>

            </h2>
        </div>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('admin.users.update', $user->id)); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="row g-4">
                    
                    <div class="col-lg-8">
                        <div class="card border-0">
                            <div class="card-body p-0">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="name" class="form-label fw-semibold"><?php echo e(__('validation.attributes.name')); ?> <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="name" name="name" class="form-control"
                                            value="<?php echo e(old('name', $user->name)); ?>" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="email" class="form-label fw-semibold"><?php echo e(__('validation.attributes.email')); ?> <span
                                                class="text-danger">*</span></label>
                                        <input type="email" id="email" name="email" class="form-control"
                                            value="<?php echo e(old('email', $user->email)); ?>" required>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label fw-semibold"><?php echo e(__('model.user.role')); ?> <span
                                                class="text-danger">*</span></label>
                                        <div class="d-flex flex-wrap gap-3">
                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="role"
                                                    id="role_<?php echo e($role->id); ?>" value="<?php echo e($role->name); ?>"
                                                    <?php if(old('role', $user->getRoleNames()->first()) ==
                                                $role->name): echo 'checked'; endif; ?>>
                                                <label class="form-check-label" for="role_<?php echo e($role->id); ?>">
                                                    <?php echo e(ucfirst($role->name)); ?>

                                                </label>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="password" class="form-label fw-semibold"><?php echo e(__('validation.attributes.password')); ?></label>
                                        <input type="password" id="password" name="password" class="form-control"
                                            autocomplete="new-password">
                                        <div class="form-text"><?php echo e(__('common.stay_unchanged')); ?></div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="password_confirmation" class="form-label fw-semibold">Xác nhận mật
                                            khẩu</label>
                                        <input type="password" id="password_confirmation" name="password_confirmation"
                                            class="form-control" autocomplete="new-password">
                                        <div class="form-text">Chỉ cần nhập nếu thay đổi mật khẩu</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-lg-4">
                        <div class="card bg-light border-0">
                            <div class="card-body">
                                <h5 class="fw-semibold mb-3">Thông tin bổ sung</h5>
                                <div class="mb-3">
                                    <label for="phone" class="form-label"><?php echo e(__('validation.attributes.phone')); ?></label>
                                    <input type="text" id="phone" name="phone" class="form-control"
                                        value="<?php echo e(old('phone', $user->phone)); ?>">
                                </div>
                                <div class="mb-3">
                                    <label for="location" class="form-label">Khu vực</label>
                                    <select name="location" id="location" class="form-select">
                                        <option value="Hội An" <?php if($user->location=='Hội An'): ?> selected <?php endif; ?>>Hội An
                                        </option>
                                        <option value="An Giang" <?php if($user->location=='An Giang'): ?> selected <?php endif; ?>>An
                                            Giang</option>
                                        <option value="Bà Rịa - Vũng Tàu" <?php if($user->location=='Bà Rịa - Vũng Tàu'): ?>
                                            selected <?php endif; ?>>Bà Rịa -
                                            Vũng Tàu</option>
                                        <option value="Bắc Giang" <?php if($user->location=='Bắc Giang'): ?> selected <?php endif; ?>>Bắc
                                            Giang</option>
                                        <option value="Bắc Kạn" <?php if($user->location=='Bắc Kạn'): ?> selected <?php endif; ?>>Bắc Kạn
                                        </option>
                                        <option value="Bạc Liêu" <?php if($user->location=='Bạc Liêu'): ?> selected <?php endif; ?>>Bạc
                                            Liêu</option>
                                        <option value="Bắc Ninh" <?php if($user->location=='Bắc Ninh'): ?> selected <?php endif; ?>>Bắc
                                            Ninh</option>
                                        <option value="Bến Tre" <?php if($user->location=='Bến Tre'): ?> selected <?php endif; ?>>Bến Tre
                                        </option>
                                        <option value="Bình Định" <?php if($user->location=='Bình Định'): ?> selected <?php endif; ?>>Bình
                                            Định</option>
                                        <option value="Bình Dương" <?php if($user->location=='Bình Dương'): ?> selected
                                            <?php endif; ?>>Bình Dương</option>
                                        <option value="Bình Phước" <?php if($user->location=='Bình Phước'): ?> selected
                                            <?php endif; ?>>Bình Phước</option>
                                        <option value="Bình Thuận" <?php if($user->location=='Bình Thuận'): ?> selected
                                            <?php endif; ?>>Bình Thuận</option>
                                        <option value="Cà Mau" <?php if($user->location=='Cà Mau'): ?> selected <?php endif; ?>>Cà Mau
                                        </option>
                                        <option value="Cần Thơ" <?php if($user->location=='Cần Thơ'): ?> selected <?php endif; ?>>Cần Thơ
                                        </option>
                                        <option value="Cao Bằng" <?php if($user->location=='Cao Bằng'): ?> selected <?php endif; ?>>Cao
                                            Bằng</option>
                                        <option value="Đà Nẵng" <?php if($user->location=='Đà Nẵng'): ?> selected <?php endif; ?>>Đà Nẵng
                                        </option>
                                        <option value="Đắk Lắk" <?php if($user->location=='Đắk Lắk'): ?> selected <?php endif; ?>>Đắk Lắk
                                        </option>
                                        <option value="Đắk Nông" <?php if($user->location=='Đắk Nông'): ?> selected <?php endif; ?>>Đắk
                                            Nông</option>
                                        <option value="Điện Biên" <?php if($user->location=='Điện Biên'): ?> selected <?php endif; ?>>Điện
                                            Biên</option>
                                        <option value="Đồng Nai" <?php if($user->location=='Đồng Nai'): ?> selected <?php endif; ?>>Đồng
                                            Nai</option>
                                        <option value="Đồng Tháp" <?php if($user->location=='Đồng Tháp'): ?> selected <?php endif; ?>>Đồng
                                            Tháp</option>
                                        <option value="Gia Lai" <?php if($user->location=='Gia Lai'): ?> selected <?php endif; ?>>Gia Lai
                                        </option>
                                        <option value="Hà Giang" <?php if($user->location=='Hà Giang'): ?> selected <?php endif; ?>>Hà
                                            Giang</option>
                                        <option value="Hà Nam" <?php if($user->location=='Hà Nam'): ?> selected <?php endif; ?>>Hà Nam
                                        </option>
                                        <option value="Hà Nội" <?php if($user->location=='Hà Nội'): ?> selected <?php endif; ?>>Hà Nội
                                        </option>
                                        <option value="Hà Tĩnh" <?php if($user->location=='Hà Tĩnh'): ?> selected <?php endif; ?>>Hà Tĩnh
                                        </option>
                                        <option value="Hải Dương" <?php if($user->location=='Hải Dương'): ?> selected <?php endif; ?>>Hải
                                            Dương</option>
                                        <option value="Hải Phòng" <?php if($user->location=='Hải Phòng'): ?> selected <?php endif; ?>>Hải
                                            Phòng</option>
                                        <option value="Hậu Giang" <?php if($user->location=='Hậu Giang'): ?> selected <?php endif; ?>>Hậu
                                            Giang</option>
                                        <option value="Hòa Bình" <?php if($user->location=='Hòa Bình'): ?> selected <?php endif; ?>>Hòa
                                            Bình</option>
                                        <option value="Hưng Yên" <?php if($user->location=='Hưng Yên'): ?> selected <?php endif; ?>>Hưng
                                            Yên</option>
                                        <option value="Khánh Hòa" <?php if($user->location=='Khánh Hòa'): ?> selected
                                            <?php endif; ?>>Khánh Hòa</option>
                                        <option value="Kiên Giang" <?php if($user->location=='Kiên Giang'): ?> selected
                                            <?php endif; ?>>Kiên Giang</option>
                                        <option value="Kon Tum" <?php if($user->location=='Kon Tum'): ?> selected <?php endif; ?>>Kon Tum
                                        </option>
                                        <option value="Lai Châu" <?php if($user->location=='Lai Châu'): ?> selected <?php endif; ?>>Lai
                                            Châu</option>
                                        <option value="Lâm Đồng" <?php if($user->location=='Lâm Đồng'): ?> selected <?php endif; ?>>Lâm
                                            Đồng</option>
                                        <option value="Lạng Sơn" <?php if($user->location=='Lạng Sơn'): ?> selected <?php endif; ?>>Lạng
                                            Sơn</option>
                                        <option value="Lào Cai" <?php if($user->location=='Lào Cai'): ?> selected <?php endif; ?>>Lào Cai
                                        </option>
                                        <option value="Long An" <?php if($user->location=='Long An'): ?> selected <?php endif; ?>>Long An
                                        </option>
                                        <option value="Nam Định" <?php if($user->location=='Nam Định'): ?> selected <?php endif; ?>>Nam
                                            Định</option>
                                        <option value="Nghệ An" <?php if($user->location=='Nghệ An'): ?> selected <?php endif; ?>>Nghệ An
                                        </option>
                                        <option value="Ninh Bình" <?php if($user->location=='Ninh Bình'): ?> selected <?php endif; ?>>Ninh
                                            Bình</option>
                                        <option value="Ninh Thuận" <?php if($user->location=='Ninh Thuận'): ?> selected
                                            <?php endif; ?>>Ninh Thuận</option>
                                        <option value="Phú Thọ" <?php if($user->location=='Phú Thọ'): ?> selected <?php endif; ?>>Phú Thọ
                                        </option>
                                        <option value="Phú Yên" <?php if($user->location=='Phú Yên'): ?> selected <?php endif; ?>>Phú Yên
                                        </option>
                                        <option value="Quảng Bình" <?php if($user->location=='Quảng Bình'): ?> selected
                                            <?php endif; ?>>Quảng Bình</option>
                                        <option value="Quảng Nam" <?php if($user->location=='Quảng Nam'): ?> selected
                                            <?php endif; ?>>Quảng Nam</option>
                                        <option value="Quảng Ngãi" <?php if($user->location=='Quảng Ngãi'): ?> selected
                                            <?php endif; ?>>Quảng Ngãi</option>
                                        <option value="Quảng Ninh" <?php if($user->location=='Quảng Ninh'): ?> selected
                                            <?php endif; ?>>Quảng Ninh</option>
                                        <option value="Quảng Trị" <?php if($user->location=='Quảng Trị'): ?> selected
                                            <?php endif; ?>>Quảng Trị</option>
                                        <option value="Sóc Trăng" <?php if($user->location=='Sóc Trăng'): ?> selected <?php endif; ?>>Sóc
                                            Trăng</option>
                                        <option value="Sơn La" <?php if($user->location=='Sơn La'): ?> selected <?php endif; ?>>Sơn La
                                        </option>
                                        <option value="Tây Ninh" <?php if($user->location=='Tây Ninh'): ?> selected <?php endif; ?>>Tây
                                            Ninh</option>
                                        <option value="Thái Bình" <?php if($user->location=='Thái Bình'): ?> selected <?php endif; ?>>Thái
                                            Bình</option>
                                        <option value="Thái Nguyên" <?php if($user->location=='Thái Nguyên'): ?> selected
                                            <?php endif; ?>>Thái Nguyên</option>
                                        <option value="Thanh Hóa" <?php if($user->location=='Thanh Hóa'): ?> selected
                                            <?php endif; ?>>Thanh Hóa</option>
                                        <option value="Thừa Thiên Huế" <?php if($user->location=='Thừa Thiên Huế'): ?> selected
                                            <?php endif; ?>>Thừa Thiên Huế
                                        </option>
                                        <option value="Tiền Giang" <?php if($user->location=='Tiền Giang'): ?> selected
                                            <?php endif; ?>>Tiền Giang</option>
                                        <option value="TP Hồ Chí Minh" <?php if($user->location=='TP Hồ Chí Minh'): ?> selected
                                            <?php endif; ?>>TP Hồ Chí Minh
                                        </option>
                                        <option value="Trà Vinh" <?php if($user->location=='Trà Vinh'): ?> selected <?php endif; ?>>Trà
                                            Vinh</option>
                                        <option value="Tuyên Quang" <?php if($user->location=='Tuyên Quang'): ?> selected
                                            <?php endif; ?>>Tuyên Quang</option>
                                        <option value="Vĩnh Long" <?php if($user->location=='Vĩnh Long'): ?> selected <?php endif; ?>>Vĩnh
                                            Long</option>
                                        <option value="Vĩnh Phúc" <?php if($user->location=='Vĩnh Phúc'): ?> selected <?php endif; ?>>Vĩnh
                                            Phúc</option>
                                        <option value="Yên Bái" <?php if($user->location=='Yên Bái'): ?> selected <?php endif; ?>>Yên Bái
                                        </option>
                                        <option value="Khác" <?php if($user->location=='Khác'): ?> selected <?php endif; ?>>Khác</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="gender" class="form-label"><?php echo e(__('validation.attributes.gender')); ?></label>
                                    <select name="gender" id="gender" class="form-select" aria-label="Chọn giới tính">
                                        <option value="" <?php if(old('gender', $user->gender) == ''): echo 'selected'; endif; ?>>-- Chọn giới tính
                                            --</option>
                                        <option value="Nam" <?php if(old('gender', $user->gender) == 'Nam'): echo 'selected'; endif; ?>>Nam
                                        </option>
                                        <option value="Nữ" <?php if(old('gender', $user->gender) == 'Nữ'): echo 'selected'; endif; ?>>Nữ</option>
                                        <option value="Khác" <?php if(old('gender', $user->gender) == 'Khác'): echo 'selected'; endif; ?>>Khác
                                        </option>
                                    </select>
                                </div>
                                <div>
                                    <label for="avatar" class="form-label"><?php echo e(__('common.avatar')); ?></label>
                                    <input type="file" id="avatar" name="avatar" class="form-control"
                                        accept="image/png, image/jpeg, image/gif">
                                    <?php if($user->avatar): ?>
                                    <div class="mt-2">
                                        <img src="<?php echo e($user->avatar ? (str_starts_with($user->avatar, 'http') ? $user->avatar : asset($user->avatar)) : ''); ?>"
                                            alt="Avatar" width="60" height="60" class="rounded-circle"
                                            style="object-fit:cover;">
                                        <small class="d-block mt-1">Ảnh đại diện hiện tại.</small>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-end gap-2">
                    <a href="<?php echo e(route('admin.users.index')); ?>" class="btn btn-secondary">
                        <i class="bi bi-x-circle me-1"></i>
                        <?php echo e(__('common.back')); ?>

                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-1"></i>
                        <?php echo e(__('common.update')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>