<?php $__env->startSection('title', 'Chỉnh Sửa Giải Đấu'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h1 class="h5 mb-0 fw-bold"><i class="bi bi-pencil-square me-2"></i> Chỉnh Sửa Giải Đấu: <?php echo e($tournament->name); ?></h1>
        </div>
        <div class="card-body">
            <!-- Success Message -->
            <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i><?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>

            <!-- Error Message -->
            <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="bi bi-exclamation-circle me-2"></i><?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php endif; ?>
            <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <?php endif; ?>
            <form method="POST" action="<?php echo e(route('admin.tournaments.update', $tournament)); ?>"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="name" class="form-label fw-bold">Tên giải đấu</label>
                        <input type="text" name="name" id="name"
                            class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('name', $tournament->name)); ?>" required>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="location" class="form-label fw-bold">Địa điểm</label>
                        <select name="location" id="location"
                            class="form-select <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                            <option value="Hội An" <?php echo e($tournament->location == 'Hội An' ? 'selected' : ''); ?>>Hội An
                            </option>
                            <option value="An Giang" <?php echo e($tournament->location == 'An Giang' ? 'selected' : ''); ?>>An
                                Giang</option>
                            <option value="Bà Rịa - Vũng Tàu" <?php echo e($tournament->location == 'Bà Rịa - Vũng Tàu' ?
                                'selected' : ''); ?>>Bà Rịa - Vũng Tàu</option>
                            <option value="Bắc Giang" <?php echo e($tournament->location == 'Bắc Giang' ? 'selected' : ''); ?>>Bắc
                                Giang</option>
                            <option value="Bắc Kạn" <?php echo e($tournament->location == 'Bắc Kạn' ? 'selected' : ''); ?>>Bắc Kạn
                            </option>
                            <option value="Bạc Liêu" <?php echo e($tournament->location == 'Bạc Liêu' ? 'selected' : ''); ?>>Bạc
                                Liêu</option>
                            <option value="Bắc Ninh" <?php echo e($tournament->location == 'Bắc Ninh' ? 'selected' : ''); ?>>Bắc
                                Ninh</option>
                            <option value="Bến Tre" <?php echo e($tournament->location == 'Bến Tre' ? 'selected' : ''); ?>>Bến Tre
                            </option>
                            <option value="Bình Định" <?php echo e($tournament->location == 'Bình Định' ? 'selected' : ''); ?>>Bình
                                Định</option>
                            <option value="Bình Dương" <?php echo e($tournament->location == 'Bình Dương' ? 'selected' : ''); ?>>Bình Dương</option>
                            <option value="Bình Phước" <?php echo e($tournament->location == 'Bình Phước' ? 'selected' : ''); ?>>Bình Phước</option>
                            <option value="Bình Thuận" <?php echo e($tournament->location == 'Bình Thuận' ? 'selected' : ''); ?>>Bình Thuận</option>
                            <option value="Cà Mau" <?php echo e($tournament->location == 'Cà Mau' ? 'selected' : ''); ?>>Cà Mau
                            </option>
                            <option value="Cần Thơ" <?php echo e($tournament->location == 'Cần Thơ' ? 'selected' : ''); ?>>Cần Thơ
                            </option>
                            <option value="Cao Bằng" <?php echo e($tournament->location == 'Cao Bằng' ? 'selected' : ''); ?>>Cao
                                Bằng</option>
                            <option value="Đà Nẵng" <?php echo e($tournament->location == 'Đà Nẵng' ? 'selected' : ''); ?>>Đà Nẵng
                            </option>
                            <option value="Đắk Lắk" <?php echo e($tournament->location == 'Đắk Lắk' ? 'selected' : ''); ?>>Đắk Lắk
                            </option>
                            <option value="Đắk Nông" <?php echo e($tournament->location == 'Đắk Nông' ? 'selected' : ''); ?>>Đắk
                                Nông</option>
                            <option value="Điện Biên" <?php echo e($tournament->location == 'Điện Biên' ? 'selected' : ''); ?>>Điện
                                Biên</option>
                            <option value="Đồng Nai" <?php echo e($tournament->location == 'Đồng Nai' ? 'selected' : ''); ?>>Đồng
                                Nai</option>
                            <option value="Đồng Tháp" <?php echo e($tournament->location == 'Đồng Tháp' ? 'selected' : ''); ?>>Đồng
                                Tháp</option>
                            <option value="Gia Lai" <?php echo e($tournament->location == 'Gia Lai' ? 'selected' : ''); ?>>Gia Lai
                            </option>
                            <option value="Hà Giang" <?php echo e($tournament->location == 'Hà Giang' ? 'selected' : ''); ?>>Hà
                                Giang</option>
                            <option value="Hà Nam" <?php echo e($tournament->location == 'Hà Nam' ? 'selected' : ''); ?>>Hà Nam
                            </option>
                            <option value="Hà Nội" <?php echo e($tournament->location == 'Hà Nội' ? 'selected' : ''); ?>>Hà Nội
                            </option>
                            <option value="Hà Tĩnh" <?php echo e($tournament->location == 'Hà Tĩnh' ? 'selected' : ''); ?>>Hà Tĩnh
                            </option>
                            <option value="Hải Dương" <?php echo e($tournament->location == 'Hải Dương' ? 'selected' : ''); ?>>Hải
                                Dương</option>
                            <option value="Hải Phòng" <?php echo e($tournament->location == 'Hải Phòng' ? 'selected' : ''); ?>>Hải
                                Phòng</option>
                            <option value="Hậu Giang" <?php echo e($tournament->location == 'Hậu Giang' ? 'selected' : ''); ?>>Hậu
                                Giang</option>
                            <option value="Hòa Bình" <?php echo e($tournament->location == 'Hòa Bình' ? 'selected' : ''); ?>>Hòa
                                Bình</option>
                            <option value="Hưng Yên" <?php echo e($tournament->location == 'Hưng Yên' ? 'selected' : ''); ?>>Hưng
                                Yên</option>
                            <option value="Khánh Hòa" <?php echo e($tournament->location == 'Khánh Hòa' ? 'selected' : ''); ?>>Khánh
                                Hòa</option>
                            <option value="Kiên Giang" <?php echo e($tournament->location == 'Kiên Giang' ? 'selected' : ''); ?>>Kiên Giang</option>
                            <option value="Kon Tum" <?php echo e($tournament->location == 'Kon Tum' ? 'selected' : ''); ?>>Kon Tum
                            </option>
                            <option value="Lai Châu" <?php echo e($tournament->location == 'Lai Châu' ? 'selected' : ''); ?>>Lai
                                Châu</option>
                            <option value="Lâm Đồng" <?php echo e($tournament->location == 'Lâm Đồng' ? 'selected' : ''); ?>>Lâm
                                Đồng</option>
                            <option value="Lạng Sơn" <?php echo e($tournament->location == 'Lạng Sơn' ? 'selected' : ''); ?>>Lạng
                                Sơn</option>
                            <option value="Lào Cai" <?php echo e($tournament->location == 'Lào Cai' ? 'selected' : ''); ?>>Lào Cai
                            </option>
                            <option value="Long An" <?php echo e($tournament->location == 'Long An' ? 'selected' : ''); ?>>Long An
                            </option>
                            <option value="Nam Định" <?php echo e($tournament->location == 'Nam Định' ? 'selected' : ''); ?>>Nam
                                Định</option>
                            <option value="Nghệ An" <?php echo e($tournament->location == 'Nghệ An' ? 'selected' : ''); ?>>Nghệ An
                            </option>
                            <option value="Ninh Bình" <?php echo e($tournament->location == 'Ninh Bình' ? 'selected' : ''); ?>>Ninh
                                Bình</option>
                            <option value="Ninh Thuận" <?php echo e($tournament->location == 'Ninh Thuận' ? 'selected' : ''); ?>>Ninh Thuận</option>
                            <option value="Phú Thọ" <?php echo e($tournament->location == 'Phú Thọ' ? 'selected' : ''); ?>>Phú Thọ
                            </option>
                            <option value="Phú Yên" <?php echo e($tournament->location == 'Phú Yên' ? 'selected' : ''); ?>>Phú Yên
                            </option>
                            <option value="Quảng Bình" <?php echo e($tournament->location == 'Quảng Bình' ? 'selected' : ''); ?>>Quảng Bình</option>
                            <option value="Quảng Nam" <?php echo e($tournament->location == 'Quảng Nam' ? 'selected' : ''); ?>>Quảng
                                Nam</option>
                            <option value="Quảng Ngãi" <?php echo e($tournament->location == 'Quảng Ngãi' ? 'selected' : ''); ?>>Quảng Ngãi</option>
                            <option value="Quảng Ninh" <?php echo e($tournament->location == 'Quảng Ninh' ? 'selected' : ''); ?>>Quảng Ninh</option>
                            <option value="Quảng Trị" <?php echo e($tournament->location == 'Quảng Trị' ? 'selected' : ''); ?>>Quảng
                                Trị</option>
                            <option value="Sóc Trăng" <?php echo e($tournament->location == 'Sóc Trăng' ? 'selected' : ''); ?>>Sóc
                                Trăng</option>
                            <option value="Sơn La" <?php echo e($tournament->location == 'Sơn La' ? 'selected' : ''); ?>>Sơn La
                            </option>
                            <option value="Tây Ninh" <?php echo e($tournament->location == 'Tây Ninh' ? 'selected' : ''); ?>>Tây
                                Ninh</option>
                            <option value="Thái Bình" <?php echo e($tournament->location == 'Thái Bình' ? 'selected' : ''); ?>>Thái
                                Bình</option>
                            <option value="Thái Nguyên" <?php echo e($tournament->location == 'Thái Nguyên' ? 'selected' : ''); ?>>Thái Nguyên</option>
                            <option value="Thanh Hóa" <?php echo e($tournament->location == 'Thanh Hóa' ? 'selected' : ''); ?>>Thanh
                                Hóa</option>
                            <option value="Thừa Thiên Huế" <?php echo e($tournament->location == 'Thừa Thiên Huế' ? 'selected' :
                                ''); ?>>Thừa Thiên Huế</option>
                            <option value="Tiền Giang" <?php echo e($tournament->location == 'Tiền Giang' ? 'selected' : ''); ?>>Tiền Giang</option>
                            <option value="TP Hồ Chí Minh" <?php echo e($tournament->location == 'TP Hồ Chí Minh' ? 'selected' :
                                ''); ?>>TP Hồ Chí Minh</option>
                            <option value="Trà Vinh" <?php echo e($tournament->location == 'Trà Vinh' ? 'selected' : ''); ?>>Trà
                                Vinh</option>
                            <option value="Tuyên Quang" <?php echo e($tournament->location == 'Tuyên Quang' ? 'selected' : ''); ?>>Tuyên Quang</option>
                            <option value="Vĩnh Long" <?php echo e($tournament->location == 'Vĩnh Long' ? 'selected' : ''); ?>>Vĩnh
                                Long</option>
                            <option value="Vĩnh Phúc" <?php echo e($tournament->location == 'Vĩnh Phúc' ? 'selected' : ''); ?>>Vĩnh
                                Phúc</option>
                            <option value="Yên Bái" <?php echo e($tournament->location == 'Yên Bái' ? 'selected' : ''); ?>>Yên Bái
                            </option>
                            <option value="Khác" <?php echo e($tournament->location == 'Khác' ? 'selected' : ''); ?>>Khác</option>
                        </select>
                        <?php $__errorArgs = ['location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-4">
                        <label for="type" class="form-label fw-bold">Loại giải đấu</label>
                        <select name="type" id="type" class="form-select <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <option value="doubles" <?php echo e(old('type', $tournament->type) == 'doubles' ? 'selected' : ''); ?>>Đôi</option>
                            <option value="singles" <?php echo e(old('type', $tournament->type) == 'singles' ? 'selected' : ''); ?>>Đơn</option>
                        </select>
                        <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-4">
                        <label for="start_date" class="form-label fw-bold">Ngày bắt đầu</label>
                        <input type="date" name="start_date" id="start_date"
                            class="form-control <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                            value="<?php echo e(old('start_date', $tournament->start_date ? \Carbon\Carbon::parse($tournament->start_date)->format('Y-m-d') : '')); ?>">
                        <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-4">
                        <label for="end_date" class="form-label fw-bold">Ngày kết thúc</label>
                        <input type="date" name="end_date" id="end_date"
                            class="form-control <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                            value="<?php echo e(old('end_date', $tournament->end_date ? \Carbon\Carbon::parse($tournament->end_date)->format('Y-m-d') : '')); ?>">
                        <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-4">
                        <label for="skill_point" class="form-label fw-bold">Điểm trình</label>
                        <input type="number" name="skill_point" id="skill_point"
                            class="form-control <?php $__errorArgs = ['skill_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" min="0" max="15" step="0.1"
                            value="<?php echo e(old('skill_point', $tournament->skill_point)); ?>" required>
                        <?php $__errorArgs = ['skill_point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-4">
                        <label for="skill_tolerance" class="form-label fw-bold">Dung sai điểm trình</label>
                        <input type="number" name="skill_tolerance" id="skill_tolerance"
                            class="form-control <?php $__errorArgs = ['skill_tolerance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" min="0" max="5"
                            step="0.01" value="<?php echo e(old('skill_tolerance', $tournament->skill_tolerance)); ?>" required>
                        <?php $__errorArgs = ['skill_tolerance'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-4">
                        <label for="max_pairs" class="form-label fw-bold">Số cặp/VĐV tối đa</label>
                        <input type="number" name="max_pairs" id="max_pairs"
                            class="form-control <?php $__errorArgs = ['max_pairs'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('max_pairs', $tournament->max_pairs)); ?>" min="4" max="128" required>
                        <?php $__errorArgs = ['max_pairs'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="fee" class="form-label fw-bold">Lệ phí (VNĐ)</label>
                        <input type="number" name="fee" id="fee" class="form-control <?php $__errorArgs = ['fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            step="10000" min="0" value="<?php echo e(old('fee', $tournament->fee)); ?>" required>
                        <?php $__errorArgs = ['fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="prizes" class="form-label fw-bold">Giải thưởng</label>
                        <input type="text" name="prizes" id="prizes"
                            class="form-control <?php $__errorArgs = ['prizes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('prizes', $tournament->prizes)); ?>" required>
                        <?php $__errorArgs = ['prizes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-12">
                        <label for="description" class="form-label fw-bold">
                            <i class="bi bi-card-text me-1"></i>Mô tả giải đấu
                        </label>
                        <div class="border rounded p-2 mb-2">
                            <div class="btn-toolbar mb-2" role="toolbar">
                                <div class="btn-group btn-group-sm me-2" role="group">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatText('description', 'bold')" title="Bold">
                                        <i class="bi bi-type-bold"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatText('description', 'italic')" title="Italic">
                                        <i class="bi bi-type-italic"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatText('description', 'underline')" title="Underline">
                                        <i class="bi bi-type-underline"></i>
                                    </button>
                                </div>
                                <div class="btn-group btn-group-sm me-2" role="group">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatList('description', 'ul')" title="Bullet List">
                                        <i class="bi bi-list-ul"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatList('description', 'ol')" title="Numbered List">
                                        <i class="bi bi-list-ol"></i>
                                    </button>
                                </div>
                                <div class="btn-group btn-group-sm" role="group">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="insertImage('description')" title="Insert Image">
                                        <i class="bi bi-image"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="insertLink('description')" title="Insert Link">
                                        <i class="bi bi-link-45deg"></i>
                                    </button>
                                </div>
                            </div>
                            <textarea name="description" id="description"
                                class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="6"
                                placeholder="Nhập mô tả chi tiết về giải đấu...&#10;&#10;Bạn có thể sử dụng:&#10;• HTML tags: &lt;b&gt;, &lt;i&gt;, &lt;u&gt;, &lt;br&gt;, &lt;p&gt;&#10;• Danh sách: &lt;ul&gt;, &lt;ol&gt;, &lt;li&gt;&#10;• Hình ảnh: &lt;img src='link'&gt;&#10;• Liên kết: &lt;a href='link'&gt;text&lt;/a&gt;"><?php echo e(old('description', $tournament->description)); ?></textarea>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted">
                                <i class="bi bi-info-circle me-1"></i>
                                Hỗ trợ HTML cơ bản và template mẫu cho thể lệ giải đấu
                            </small>
                            <button type="button" class="btn btn-sm btn-outline-info"
                                onclick="previewContent('description')">
                                <i class="bi bi-eye me-1"></i>Xem trước
                            </button>
                        </div>
                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-12">
                        <label for="rules" class="form-label fw-bold">
                            <i class="bi bi-journal-text me-1"></i>Thể lệ giải đấu
                        </label>
                        <div class="border rounded p-2 mb-2">
                            <div class="btn-toolbar mb-2" role="toolbar">
                                <div class="btn-group btn-group-sm me-2" role="group">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatText('rules', 'bold')" title="Bold">
                                        <i class="bi bi-type-bold"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatText('rules', 'italic')" title="Italic">
                                        <i class="bi bi-type-italic"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatText('rules', 'underline')" title="Underline">
                                        <i class="bi bi-type-underline"></i>
                                    </button>
                                </div>
                                <div class="btn-group btn-group-sm me-2" role="group">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatList('rules', 'ul')" title="Bullet List">
                                        <i class="bi bi-list-ul"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="formatList('rules', 'ol')" title="Numbered List">
                                        <i class="bi bi-list-ol"></i>
                                    </button>
                                </div>
                                <div class="btn-group btn-group-sm me-2" role="group">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="insertTemplate('rules')" title="Insert Template">
                                        <i class="bi bi-file-earmark-text"></i>
                                    </button>
                                </div>
                                <div class="btn-group btn-group-sm" role="group">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="insertImage('rules')" title="Insert Image">
                                        <i class="bi bi-image"></i>
                                    </button>
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="insertLink('rules')" title="Insert Link">
                                        <i class="bi bi-link-45deg"></i>
                                    </button>
                                </div>
                            </div>
                            <textarea name="rules" id="rules" class="form-control <?php $__errorArgs = ['rules'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                rows="8"
                                placeholder="Nhập thể lệ chi tiết của giải đấu...&#10;&#10;Gợi ý nội dung:&#10;• Điều kiện tham gia&#10;• Quy định về trang phục&#10;• Luật thi đấu&#10;• Quy định về thiết bị&#10;• Thời gian và lịch thi đấu&#10;• Quy định về trọng tài&#10;• Điều kiện thời tiết&#10;• Quy định khác"><?php echo e(old('rules', $tournament->rules)); ?></textarea>
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <small class="text-muted">
                                <i class="bi bi-info-circle me-1"></i>
                                Hỗ trợ HTML cơ bản và template mẫu cho thể lệ giải đấu
                            </small>
                            <button type="button" class="btn btn-sm btn-outline-info" onclick="previewContent('rules')">
                                <i class="bi bi-eye me-1"></i>Xem trước
                            </button>
                        </div>
                        <?php $__errorArgs = ['rules'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="image" class="form-label fw-bold">Hình ảnh giải đấu</label>
                        <input type="file" name="image" id="image"
                            class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" accept="image/*">
                        <?php if($tournament->image): ?>
                        <div class="mt-2">
                            <img src="/<?php echo e($tournament->image); ?>" alt="Hình ảnh giải đấu hiện tại"
                                style="max-width:200px;max-height:150px; border-radius: 6px;">
                        </div>
                        <?php endif; ?>
                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-6">
                        <label for="password" class="form-label fw-bold">Mật khẩu quản lý (6 số)</label>
                        <input type="text" id="password" class="form-control" value="<?php echo e($tournament->password); ?>"
                            readonly>
                        <small class="text-muted">Không thể thay đổi. Dùng cho BTC truy cập quản lý giải đấu.</small>
                    </div>
                    <div class="col-md-6">
                        <label for="referee_password" class="form-label fw-bold">Mật khẩu trọng tài (tùy chọn)</label>
                        <input type="text" id="referee_password" name="referee_password"
                            class="form-control <?php $__errorArgs = ['referee_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('referee_password', $tournament->referee_password)); ?>" maxlength="6"
                            inputmode="numeric" pattern="\d{6}"
                            placeholder="Nhập mật khẩu riêng cho trọng tài (nếu muốn cập nhật)">
                        <small class="text-muted">Chỉ trọng tài dùng mật khẩu này để truy cập và cập nhật tỷ số.</small>
                        <?php $__errorArgs = ['referee_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-end gap-2">
                    <a href="<?php echo e(route('admin.tournaments.index')); ?>" class="btn btn-secondary">
                        <i class="bi bi-x-circle me-1"></i> Hủy
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle-fill me-1"></i> Lưu Thay Đổi
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="previewModalLabel">
                    <i class="bi bi-eye me-2"></i>Xem trước nội dung
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="previewContent" class="border rounded p-3" style="min-height: 200px;"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
            </div>
        </div>
    </div>
</div>

<script>
    // Format text functions
function formatText(fieldId, format) {
    const textarea = document.getElementById(fieldId);
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText = textarea.value.substring(start, end);
    
    if (selectedText) {
        let formattedText;
        switch(format) {
            case 'bold':
                formattedText = `<b>${selectedText}</b>`;
                break;
            case 'italic':
                formattedText = `<i>${selectedText}</i>`;
                break;
            case 'underline':
                formattedText = `<u>${selectedText}</u>`;
                break;
        }
        
        textarea.value = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
        textarea.focus();
    } else {
        alert('Vui lòng chọn text để định dạng');
    }
}

function formatList(fieldId, listType) {
    const textarea = document.getElementById(fieldId);
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    const selectedText = textarea.value.substring(start, end);
    
    if (selectedText) {
        const lines = selectedText.split('\n');
        let formattedList;
        
        if (listType === 'ul') {
            formattedList = '<ul>\n' + lines.map(line => line.trim() ? `  <li>${line.trim()}</li>` : '').filter(line => line).join('\n') + '\n</ul>';
        } else {
            formattedList = '<ol>\n' + lines.map(line => line.trim() ? `  <li>${line.trim()}</li>` : '').filter(line => line).join('\n') + '\n</ol>';
        }
        
        textarea.value = textarea.value.substring(0, start) + formattedList + textarea.value.substring(end);
        textarea.focus();
    } else {
        const listTemplate = listType === 'ul' ? 
            '<ul>\n  <li>Mục 1</li>\n  <li>Mục 2</li>\n  <li>Mục 3</li>\n</ul>' :
            '<ol>\n  <li>Mục 1</li>\n  <li>Mục 2</li>\n  <li>Mục 3</li>\n</ol>';
        insertAtCursor(textarea, listTemplate);
    }
}

function insertImage(fieldId) {
    const imageUrl = prompt('Nhập URL hình ảnh:');
    if (imageUrl) {
        const altText = prompt('Nhập mô tả hình ảnh (tùy chọn):') || 'Hình ảnh';
        const imageHtml = `<img src="${imageUrl}" alt="${altText}" class="img-fluid rounded my-2" style="max-width: 100%;">`;
        const textarea = document.getElementById(fieldId);
        insertAtCursor(textarea, imageHtml);
    }
}

function insertLink(fieldId) {
    const linkUrl = prompt('Nhập URL liên kết:');
    if (linkUrl) {
        const linkText = prompt('Nhập text hiển thị:') || linkUrl;
        const linkHtml = `<a href="${linkUrl}" target="_blank">${linkText}</a>`;
        const textarea = document.getElementById(fieldId);
        insertAtCursor(textarea, linkHtml);
    }
}

function insertTemplate(fieldId) {
    const template = `<h4>📋 ĐIỀU KIỆN THAM GIA</h4>
<ul>
  <li>Độ tuổi: Từ 18 tuổi trở lên</li>
  <li>Trình độ: Phù hợp với điểm skill của giải đấu</li>
  <li>Sức khỏe: Đảm bảo sức khỏe tốt, có giấy khám sức khỏe (nếu cần)</li>
</ul>

<h4>👕 QUY ĐỊNH TRANG PHỤC</h4>
<ul>
  <li>Áo: Áo thể thao, có thể in logo đội/sponsor</li>
  <li>Quần: Quần short thể thao, quần dài thể thao</li>
  <li>Giày: Giày thể thao có đế không đen, chống trượt</li>
  <li>Phụ kiện: Mũ, băng đeo tay được phép</li>
</ul>

<h4>🏓 LUẬT THI ĐẤU</h4>
<ul>
  <li>Áp dụng luật Pickleball quốc tế mới nhất</li>
  <li>Hệ thống thi đấu: Vòng tròn + playoff</li>
  <li>Điểm số: 11 điểm/set, thắng cách biệt 2 điểm</li>
  <li>Số set: Bo3 (vòng bảng), Bo5 (chung kết)</li>
</ul>

<h4>🏆 GIẢI THƯỞNG & DANH HIỆU</h4>
<ul>
  <li>Huy chương cho 3 vị trí đầu</li>
  <li>Giải thưởng tiền mặt theo quy định</li>
  <li>Danh hiệu đặc biệt: Best Team Spirit, Fair Play</li>
</ul>

<h4>⚠️ LỰU Ý QUAN TRỌNG</h4>
<ul>
  <li>Đăng ký và đóng phí trước hạn chót</li>
  <li>Mang theo CMND/CCCD khi thi đấu</li>
  <li>Tuân thủ nghiêm túc quy định của BTC</li>
  <li>BTC có quyền thay đổi thể lệ nếu cần thiết</li>
</ul>`;

    const textarea = document.getElementById(fieldId);
    insertAtCursor(textarea, template);
}

function insertAtCursor(textarea, text) {
    const start = textarea.selectionStart;
    const end = textarea.selectionEnd;
    textarea.value = textarea.value.substring(0, start) + text + textarea.value.substring(end);
    textarea.focus();
    textarea.setSelectionRange(start + text.length, start + text.length);
}

function previewContent(fieldId) {
    const content = document.getElementById(fieldId).value;
    const previewDiv = document.getElementById('previewContent');
    
    // Convert basic HTML to display
    previewDiv.innerHTML = content || '<p class="text-muted">Không có nội dung để xem trước</p>';
    
    // Show modal
    const modal = new bootstrap.Modal(document.getElementById('previewModal'));
    modal.show();
}

// Auto-resize textareas
document.addEventListener('DOMContentLoaded', function() {
    const textareas = document.querySelectorAll('textarea[name="description"], textarea[name="rules"]');
    textareas.forEach(textarea => {
        textarea.addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
        
        // Initial resize for existing content
        textarea.style.height = 'auto';
        textarea.style.height = (textarea.scrollHeight) + 'px';
    });
    // Sync end_date >= start_date like create form
    const startInput = document.getElementById('start_date');
    const endInput = document.getElementById('end_date');
    function syncMinEnd() {
        if (startInput && endInput && startInput.value) {
            endInput.min = startInput.value;
            if (endInput.value && endInput.value < startInput.value) {
                endInput.value = startInput.value;
            }
        }
    }
    startInput?.addEventListener('change', syncMinEnd);
    syncMinEnd();
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/tournaments/edit.blade.php ENDPATH**/ ?>