

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">
                        <i class="bi bi-people me-2"></i>Quản lý Player
                    </h3>
                    <a href="<?php echo e(route('admin.players.create')); ?>" class="btn btn-success fw-semibold shadow-sm">
                        <i class="bi bi-plus me-1"></i>Thêm Player
                    </a>
                </div>

                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" class="mb-4" id="filterForm">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Tìm kiếm</label>
                                <input type="text" name="search" class="form-control"
                                    placeholder="Tên, SĐT, Mã Player..." value="<?php echo e(request('search')); ?>">
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">Trạng thái</label>
                                <select name="status" class="form-select">
                                    <option value="">Tất cả</option>
                                    <option value="0" <?php echo e(request('status')=='0' ? 'selected' : ''); ?>>Chưa duyệt</option>
                                    <option value="1" <?php echo e(request('status')=='1' ? 'selected' : ''); ?>>Đã duyệt</option>
                                    <option value="2" <?php echo e(request('status')=='2' ? 'selected' : ''); ?>>Được bảo lãnh
                                    </option>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">Giới tính</label>
                                <select name="gender" class="form-select">
                                    <option value="">Tất cả</option>
                                    <?php $__currentLoopData = $genders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gender): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($gender); ?>" <?php echo e(request('gender')==$gender ? 'selected' : ''); ?>>
                                        <?php echo e($gender); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">Khu vực</label>
                                <select name="location" class="form-select">
                                    <option value="">Tất cả</option>
                                    <?php $__currentLoopData = $locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($location); ?>" <?php echo e(request('location')==$location ? 'selected' : ''); ?>>
                                        <?php echo e($location); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label class="form-label">Avatar pending</label>
                                <select name="avatar_pending" class="form-select">
                                    <option value="">Tất cả</option>
                                    <option value="1" <?php echo e(request('avatar_pending')=='1' ? 'selected' : ''); ?>>Chờ duyệt
                                    </option>
                                    <option value="0" <?php echo e(request('avatar_pending')=='0' ? 'selected' : ''); ?>>Đã duyệt
                                    </option>
                                </select>
                            </div>

                            <div class="col-md-1 d-flex align-items-end">
                                <div class="btn-group w-100">
                                    <button type="submit" class="btn btn-primary fw-semibold shadow-sm">
                                        <i class="bi bi-funnel"></i>
                                    </button>
                                    <a href="<?php echo e(route('admin.players.index')); ?>"
                                        class="btn btn-outline-light fw-semibold shadow-sm">
                                        <i class="bi bi-x"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- Stats Cards -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card border-primary">
                                <div class="card-body text-center">
                                    <i class="bi bi-people text-primary" style="font-size: 2rem;"></i>
                                    <h5 class="card-title text-primary" id="total-count"><?php echo e($players->total()); ?></h5>
                                    <p class="card-text">Tổng Player</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-success">
                                <div class="card-body text-center">
                                    <i class="bi bi-check-circle text-success" style="font-size: 2rem;"></i>
                                    <h5 class="card-title text-success" id="approved-count"><?php echo e(\App\Models\Player::where('status',
                                        1)->count()); ?></h5>
                                    <p class="card-text">Đã duyệt</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-warning">
                                <div class="card-body text-center">
                                    <i class="bi bi-clock text-warning" style="font-size: 2rem;"></i>
                                    <h5 class="card-title text-warning" id="pending-count"><?php echo e(\App\Models\Player::where('status',
                                        0)->count()); ?></h5>
                                    <p class="card-text">Chưa duyệt</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-info">
                                <div class="card-body text-center">
                                    <i class="bi bi-image text-info" style="font-size: 2rem;"></i>
                                    <h5 class="card-title text-info" id="avatar-pending-count"><?php echo e(\App\Models\Player::whereNotNull('avatar_pending')->count()); ?></h5>
                                    <p class="card-text">Avatar chờ duyệt</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Table -->
                    <div class="table-responsive dark-table-wrapper" id="players-table-container">
                        <div id="loading-overlay" class="d-none">
                            <div class="text-center p-4">
                                <div class="spinner-border text-primary" role="status">
                                    <span class="visually-hidden">Đang tải...</span>
                                </div>
                                <div class="mt-2 text-muted">Đang tìm kiếm...</div>
                            </div>
                        </div>
                        <table class="table table-hover table-striped table-dark-mode align-middle mb-0">
                            <thead class="table-dark-mode-head">
                                <tr>
                                    <th>
                                        <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'id', 'sort_order' => request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                            class="text-white text-decoration-none">
                                            ID
                                            <?php if(request('sort_by') == 'id'): ?>
                                            <i
                                                class="bi bi-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?>"></i>
                                            <?php endif; ?>
                                        </a>
                                    </th>
                                    <th>Mã Player</th>
                                    <th>
                                        <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'name', 'sort_order' => request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                            class="text-white text-decoration-none">
                                            Tên
                                            <?php if(request('sort_by') == 'name'): ?>
                                            <i
                                                class="bi bi-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?>"></i>
                                            <?php endif; ?>
                                        </a>
                                    </th>
                                    <th>
                                        <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'doubles_score', 'sort_order' => request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                            class="text-white text-decoration-none">
                                            Score đôi
                                            <?php if(request('sort_by') == 'doubles_score'): ?>
                                            <i
                                                class="bi bi-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?>"></i>
                                            <?php endif; ?>
                                        </a>
                                    </th>
                                    <th>
                                        <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'singles_score', 'sort_order' => request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                            class="text-white text-decoration-none">
                                            Score đơn
                                            <?php if(request('sort_by') == 'singles_score'): ?>
                                            <i
                                                class="bi bi-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?>"></i>
                                            <?php endif; ?>
                                        </a>
                                    </th>
                                    <th>
                                        <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'location', 'sort_order' => request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                            class="text-white text-decoration-none">
                                            Khu vực
                                            <?php if(request('sort_by') == 'location'): ?>
                                            <i
                                                class="bi bi-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?>"></i>
                                            <?php endif; ?>
                                        </a>
                                    </th>
                                    <th>Giới tính</th>
                                    <th>SĐT</th>
                                    <th>Avatar</th>
                                    <th>
                                        <a href="<?php echo e(request()->fullUrlWithQuery(['sort_by' => 'status', 'sort_order' => request('sort_order') == 'asc' ? 'desc' : 'asc'])); ?>"
                                            class="text-white text-decoration-none">
                                            Trạng thái
                                            <?php if(request('sort_by') == 'status'): ?>
                                            <i
                                                class="bi bi-sort-<?php echo e(request('sort_order') == 'asc' ? 'up' : 'down'); ?>"></i>
                                            <?php endif; ?>
                                        </a>
                                    </th>
                                    <th>Duyệt Avatar</th>
                                    <th>Hành động</th>
                                </tr>
                            </thead>
                            <tbody id="players-table-body">
                                <?php echo $__env->make('admin.players.partials.table', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div id="pagination-container">
                        <?php echo $__env->make('admin.players.partials.pagination', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
    let searchTimeout;
    let isLoading = false;
    
    // Debounce function
    function debounce(func, wait) {
        let timeout;
        return function executedFunction(...args) {
            const later = () => {
                clearTimeout(timeout);
                func(...args);
            };
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
        };
    }
    
    // Show loading state
    function showLoading() {
        if (isLoading) return;
        isLoading = true;
        document.getElementById('loading-overlay').classList.remove('d-none');
        document.getElementById('players-table-body').style.opacity = '0.5';
    }
    
    // Hide loading state
    function hideLoading() {
        isLoading = false;
        document.getElementById('loading-overlay').classList.add('d-none');
        document.getElementById('players-table-body').style.opacity = '1';
    }
    
    // Perform AJAX search
    function performSearch() {
        if (isLoading) return;
        
        showLoading();
        
        const formData = new FormData(document.getElementById('filterForm'));
        const searchParams = new URLSearchParams(formData);
        
        // Add current URL query parameters to maintain sorting
        const currentParams = new URLSearchParams(window.location.search);
        for (const [key, value] of currentParams.entries()) {
            if (!searchParams.has(key)) {
                searchParams.set(key, value);
            }
        }
        
        fetch(`<?php echo e(route('admin.players.search')); ?>?${searchParams.toString()}`, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Update table content
                document.getElementById('players-table-body').innerHTML = data.html;
                
                // Update pagination
                document.getElementById('pagination-container').innerHTML = data.pagination;
                
                // Update statistics
                document.getElementById('total-count').textContent = data.total;
                document.getElementById('approved-count').textContent = data.approved_count;
                document.getElementById('pending-count').textContent = data.pending_count;
                document.getElementById('avatar-pending-count').textContent = data.avatar_pending_count;
                
                // Update URL without refreshing page
                const newUrl = `${window.location.pathname}?${searchParams.toString()}`;
                window.history.replaceState({}, '', newUrl);
                
                // Re-attach pagination event listeners
                attachPaginationListeners();
            }
        })
        .catch(error => {
            console.error('Search error:', error);
        })
        .finally(() => {
            hideLoading();
        });
    }
    
    // Attach event listeners to pagination links
    function attachPaginationListeners() {
        const paginationLinks = document.querySelectorAll('#pagination-container a');
        paginationLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                const url = new URL(this.href);
                const page = url.searchParams.get('page');
                
                if (page) {
                    // Add page parameter to form and search
                    const hiddenPageInput = document.querySelector('input[name="page"]') || 
                                           document.createElement('input');
                    hiddenPageInput.type = 'hidden';
                    hiddenPageInput.name = 'page';
                    hiddenPageInput.value = page;
                    
                    if (!document.querySelector('input[name="page"]')) {
                        document.getElementById('filterForm').appendChild(hiddenPageInput);
                    }
                    
                    performSearch();
                }
            });
        });
    }
    
    // Debounced search function
    const debouncedSearch = debounce(performSearch, 500);
    
    // Auto submit form when filter selects change
    const filterSelects = document.querySelectorAll('#filterForm select');
    filterSelects.forEach(select => {
        select.addEventListener('change', function() {
            // Clear page parameter when filter changes
            const pageInput = document.querySelector('input[name="page"]');
            if (pageInput) {
                pageInput.remove();
            }
            debouncedSearch();
        });
    });
    
    // Real-time search on input
    const searchInput = document.querySelector('input[name="search"]');
    if (searchInput) {
        searchInput.addEventListener('input', function() {
            // Clear page parameter when search changes
            const pageInput = document.querySelector('input[name="page"]');
            if (pageInput) {
                pageInput.remove();
            }
            debouncedSearch();
        });
        
        // Still allow Enter key for immediate search
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                clearTimeout(searchTimeout);
                performSearch();
            }
        });
    }
    
    // Initial pagination listeners
    attachPaginationListeners();
    
    // Handle sorting links
    document.addEventListener('click', function(e) {
        if (e.target.closest('th a')) {
            e.preventDefault();
            const link = e.target.closest('a');
            const url = new URL(link.href);
            
            // Update sort parameters in form
            const sortBy = url.searchParams.get('sort_by');
            const sortOrder = url.searchParams.get('sort_order');
            
            // Add/update hidden inputs for sorting
            let sortByInput = document.querySelector('input[name="sort_by"]') || 
                             document.createElement('input');
            let sortOrderInput = document.querySelector('input[name="sort_order"]') || 
                                document.createElement('input');
            
            sortByInput.type = 'hidden';
            sortByInput.name = 'sort_by';
            sortByInput.value = sortBy;
            
            sortOrderInput.type = 'hidden';
            sortOrderInput.name = 'sort_order';
            sortOrderInput.value = sortOrder;
            
            if (!document.querySelector('input[name="sort_by"]')) {
                document.getElementById('filterForm').appendChild(sortByInput);
            }
            if (!document.querySelector('input[name="sort_order"]')) {
                document.getElementById('filterForm').appendChild(sortOrderInput);
            }
            
            // Clear page parameter when sorting
            const pageInput = document.querySelector('input[name="page"]');
            if (pageInput) {
                pageInput.remove();
            }
            
            performSearch();
        }
    });
});
</script>

<style>
    #loading-overlay {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        z-index: 1000;
        background: rgba(255, 255, 255, 0.9);
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    #players-table-container {
        position: relative;
    }

    .table-responsive {
        transition: opacity 0.2s ease;
    }

    /* Smooth transitions for loading states */
    .fade-in {
        animation: fadeIn 0.3s ease-in-out;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
        }

        to {
            opacity: 1;
        }
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/players/index.blade.php ENDPATH**/ ?>