<!DOCTYPE html>
<html lang="vi">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <title><?php echo $__env->yieldContent('title', 'Pickleball Vietnam Association'); ?></title>
        <meta name="description"
            content="Pickleball Vietnam Association - Cộng đồng, giải đấu, sân chơi, đăng ký thành viên, cập nhật tin tức và kết nối người chơi Pickleball tại Việt Nam.">
        <meta name="keywords"
            content="pickleball, pickleball vietnam, giải đấu pickleball, sân pickleball, đăng ký thành viên, cộng đồng pickleball, pickleball tournament, pickleball court, pickleball player, pickleball guide, pickleball rules, pickleball prizes, pickleball fee, pickleball registration, pickleball association">
        <meta name="author" content="pickleballvna.com">
        <meta name="copyright" content="pickleballvna.com">
        <link href="<?php echo e(asset('favicon.ico')); ?>" rel="shortcut icon apple-touch-icon">
        <!-- Preload Critical Assets -->
        <link rel="preload" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" as="style"
            onload="this.onload=null;this.rel='stylesheet'">
        <noscript>
            <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
        </noscript>

        <!-- Critical Stylesheets (inline load) -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
        <!-- Bootstrap Icons -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

        <!-- Non-critical Stylesheets (deferred) -->
        <link href="https://cdn.jsdelivr.net/npm/flag-icons@7.2.3/css/flag-icons.min.css" rel="preload" as="style"
            onload="this.onload=null;this.rel='stylesheet'">
        <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="preload" as="style"
            onload="this.onload=null;this.rel='stylesheet'">
        <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css"
            rel="preload" as="style" onload="this.onload=null;this.rel='stylesheet'">

        <!-- Fallback for no-JS -->
        <noscript>
            <link href="https://cdn.jsdelivr.net/npm/flag-icons@7.2.3/css/flag-icons.min.css" rel="stylesheet">
            <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
            <link
                href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css"
                rel="stylesheet">
        </noscript>

        
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

        
        <link href="resources/css/image-optimization.css" rel="stylesheet">

        <?php echo $__env->yieldPushContent('layout_css'); ?>
        <!-- Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;300;400;500;700;900&display=swap"
            rel="stylesheet">
        <link href="/assets/global/fonts/web-icons/web-icons.min.css" rel="stylesheet">
        <!-- Critical Scripts (inline) -->
        <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

        <!-- Non-critical Scripts (deferred) -->
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.10.7/dist/sweetalert2.all.min.js" defer></script>
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js" defer></script>
        <script src="/assets/global/vendor/breakpoints/breakpoints.min.js" defer></script>

        <!-- Image Optimization Script -->
        <script src="<?php echo e(asset('assets/js/image-optimizer.js')); ?>" defer></script>

        <!-- Page Load Optimization -->
        <script>
            // Show loading indicator
            document.addEventListener('DOMContentLoaded', function() {
                // Initialize breakpoints when available
                if (typeof Breakpoints !== 'undefined') {
                    Breakpoints();
                }
                
                // Hide loading indicators if any exist
                const loadingElements = document.querySelectorAll('.loading-indicator');
                loadingElements.forEach(el => el.style.display = 'none');
            });
            
            // Performance optimization: preload next likely pages
            const preloadLinks = [
                '/admin/tournaments',
                '/admin/dashboard'
            ];
            
            preloadLinks.forEach(url => {
                if (window.location.pathname !== url) {
                    const link = document.createElement('link');
                    link.rel = 'prefetch';
                    link.href = url;
                    document.head.appendChild(link);
                }
            });
        </script>
        <!-- Bootstrap Icons -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
        <style>
            body {
                font-family: 'Roboto', Arial, sans-serif;
                background-color: var(--primary-bg) !important;
                color: var(--text-primary) !important;
            }

            .navbar {
                background: linear-gradient(135deg, #1a1a1a 0%, #2a2a2a 100%) !important;
                box-shadow: 0 4px 24px var(--shadow-dark);
                position: sticky;
                top: 0;
                z-index: 1050;
                isolation: isolate;
                border-bottom: 1px solid var(--border-color);
            }



            .navbar-brand img {
                background: #fff;
                border-radius: 50%;
                box-shadow: 0 2px 8px rgba(255, 255, 255, 0.1);
            }

            .navbar-brand span {
                color: var(--text-primary) !important;
            }

            .navbar-collapse {
                transition: all 0.3s cubic-bezier(.4, 2, .3, 1);
            }

            .navbar-nav .nav-link {
                color: var(--text-secondary) !important;
                font-weight: 500;
                letter-spacing: 0.5px;
                border-radius: 0.75rem;
                transition: all 0.3s ease;
                padding: 0.6rem 1.2rem;
                display: flex;
                align-items: center;
                gap: 0.6rem;
                font-size: 1.08rem;
                background: rgba(255, 255, 255, 0.05);
                margin: 0 0.2rem;
            }

            /* Stronger safeguard: force nav items visible and clickable */
            .navbar-nav .nav-item,
            .navbar-nav .nav-link {
                display: list-item !important;
                /* keep element layout for navs */
                visibility: visible !important;
                opacity: 1 !important;
                pointer-events: auto !important;
            }

            /* Make sure the navbar stays on top of most overlays */
            .navbar {
                z-index: 1030;
                /* keep original stacking */
            }

            /* Ensure logout form button looks like other nav links */
            .navbar .nav-link.btn.btn-link {
                color: inherit;
                text-decoration: none;
                padding: 0.6rem 1.2rem;
                display: flex;
                align-items: center;
                gap: 0.6rem;
            }

            .navbar-nav .nav-link.active,
            .navbar-nav .nav-link:hover {
                background: linear-gradient(135deg, var(--accent-primary) 0%, var(--accent-secondary) 100%);
                color: var(--text-primary) !important;
                box-shadow: 0 4px 12px var(--shadow-primary);
                transform: translateY(-2px) scale(1.02);
            }

            .navbar-toggler {
                border: 1px solid var(--border-color);
                background: var(--card-bg);
                border-radius: 0.75rem;
                box-shadow: 0 2px 8px var(--shadow-dark);
                padding: 0.4rem 0.7rem;
            }

            .navbar-toggler:focus {
                box-shadow: 0 0 0 2px var(--accent-primary);
            }

            .navbar-toggler-icon {
                background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba(255,255,255,0.8)' stroke-width='2.5' stroke-linecap='round' stroke-miterlimit='10' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
                filter: drop-shadow(0 2px 4px var(--shadow-dark));
                width: 2em;
                height: 2em;
            }

            /* Mobile Menu - Dark Theme */
            @media (max-width: 991.98px) {
                .navbar-collapse {
                    background: var(--secondary-bg) !important;
                    border-radius: 12px !important;
                    margin-top: 12px !important;
                    padding: 20px !important;
                    position: absolute !important;
                    left: 0 !important;
                    right: 0 !important;
                    top: 100% !important;
                    width: 100% !important;
                    z-index: 1050 !important;
                    box-shadow: 0 8px 32px var(--shadow-dark) !important;
                    border: 1px solid var(--border-color) !important;
                }

                .navbar-nav .nav-link {
                    color: var(--text-secondary) !important;
                    background: var(--card-bg) !important;
                    padding: 12px 16px !important;
                    margin: 6px 0 !important;
                    border-radius: 8px !important;
                    display: block !important;
                    text-decoration: none !important;
                    transition: all 0.3s !important;
                    border: 1px solid var(--border-color) !important;
                }

                .navbar-nav .nav-link:hover,
                .navbar-nav .nav-link:focus {
                    background: linear-gradient(135deg, var(--accent-primary) 0%, var(--accent-secondary) 100%) !important;
                    color: var(--text-primary) !important;
                    transform: translateX(8px) !important;
                    box-shadow: 0 4px 12px var(--shadow-primary) !important;
                }

                .navbar-nav .nav-item form .nav-link {
                    background: var(--card-bg) !important;
                    color: var(--text-secondary) !important;
                    border: 1px solid var(--border-color) !important;
                    text-align: left !important;
                    width: 100% !important;
                }
            }

            @media (min-width: 992px) {
                .navbar-collapse {
                    background: transparent !important;
                    box-shadow: none !important;
                    border-radius: 0;
                    margin-top: 0;
                    padding: 0;
                    position: static;
                    min-width: auto;
                    backdrop-filter: none;
                    -webkit-backdrop-filter: none;
                    border: none;
                }

                .navbar-nav .nav-link {
                    background: transparent !important;
                    border: none !important;
                    margin-bottom: 0;
                }
            }





            .nav-icon {
                font-size: 1.2em;
                margin-right: 0.3em;
                display: inline-block;
            }

            .swal2-popup {
                font-family: 'Roboto', Arial, sans-serif;
                background: var(--card-bg) !important;
                color: var(--text-primary) !important;
                border: 1px solid var(--border-color);
            }

            .swal2-title {
                color: var(--text-primary) !important;
            }

            .swal2-content {
                color: var(--text-secondary) !important;
            }

            footer {
                background: linear-gradient(135deg, var(--secondary-bg) 0%, var(--primary-bg) 100%);
                color: var(--text-primary);
                border-top: 1px solid var(--border-color);
            }

            /* Alert Styles for Dark Theme */
            .alert {
                border: 1px solid var(--border-color);
                border-radius: 8px;
            }

            .alert-success {
                background-color: rgba(16, 185, 129, 0.1);
                border-color: var(--success);
                color: var(--success);
            }

            .alert-danger {
                background-color: rgba(239, 68, 68, 0.1);
                border-color: var(--danger);
                color: var(--danger);
            }

            .alert-warning {
                background-color: rgba(245, 158, 11, 0.1);
                border-color: var(--warning);
                color: var(--warning);
            }

            /* Main Content Area */
            main {
                background-color: var(--primary-bg);
                color: var(--text-primary);
            }

            .container {
                color: var(--text-primary);
            }
        </style>

    </head>

    <body class="min-vh-100 d-flex flex-column" style="background-color: var(--primary-bg);" )>
        <!-- Header/Navbar -->
        <nav
            class="navbar navbar-expand-lg navbar-dark shadow-lg position-sticky top-0 z-3 animate__animated animate__fadeInDown">
            <div class="container">
                <a class="navbar-brand d-flex align-items-center gap-2" href="<?php echo e(route('home')); ?>">
                    <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Logo" width="40" height="40">
                    <span class="fw-bold">Pickleball Vietnam</span>
                </a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#mainNav"
                    aria-controls="mainNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse" id="mainNav">
                    <ul class="navbar-nav ms-auto mb-2 mb-lg-0 align-items-lg-center gap-2">
                        <li class="nav-item"><a class="nav-link <?php echo e(request()->routeIs('home') ? 'active' : ''); ?>"
                                href="<?php echo e(route('home')); ?>"><span class="nav-icon"><i
                                        class="bi bi-house-door-fill"></i></span>Trang
                                Chủ</a></li>
                        <li class="nav-item"><a
                                class="nav-link <?php echo e(request()->routeIs('tournaments.list') ? 'active' : ''); ?>"
                                href="<?php echo e(route('tournaments.list')); ?>"><span class="nav-icon"><i
                                        class="bi bi-trophy-fill"></i></span>Giải
                                Đấu</a></li>
                        <li class="nav-item"><a
                                class="nav-link <?php echo e(request()->routeIs('venues.index') ? 'active' : ''); ?>"
                                href="<?php echo e(route('venues.index')); ?>"><span class="nav-icon"><i
                                        class="bi bi-geo-alt-fill"></i></span>Sân
                                Pickleball</a></li>
                        <li class="nav-item"><a
                                class="nav-link <?php echo e(request()->routeIs('register-member.show') ? 'active' : ''); ?>"
                                href="<?php echo e(route('register-member.show')); ?>"><span class="nav-icon"><i
                                        class="bi bi-person-plus-fill"></i></span>Đăng
                                Ký Thành Viên</a></li>
                        <?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin|mod')): ?>
                        <li class="nav-item"><a
                                class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>"
                                href="<?php echo e(route('admin.dashboard')); ?>"><span class="nav-icon"><i
                                        class="bi bi-shield-lock-fill"></i></span>Admin</a>
                        </li>
                        <?php endif; ?>
                        <?php if(auth()->guard()->check()): ?>
                        <li class="nav-item">
                            <form action="<?php echo e(route('logout')); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="nav-link btn btn-link px-0"><span class="nav-icon"><i
                                            class="bi bi-box-arrow-right"></i></span>Đăng Xuất</button>
                            </form>
                        </li>
                        <?php else: ?>
                        <li class="nav-item"><a class="nav-link <?php echo e(request()->routeIs('login') ? 'active' : ''); ?>"
                                href="<?php echo e(route('login')); ?>"><span class="nav-icon"><i
                                        class="bi bi-box-arrow-in-right"></i></span>Đăng
                                Nhập</a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- Main Content -->
        <main class="flex-grow-1 py-4">
            <div class="container">
                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show mt-3" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
                <?php endif; ?>
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>
        <!-- Footer -->
        <footer class="py-3 text-center mt-auto">
            <div class="container">
                <p class="mb-0">&copy; <?php echo e(date('Y')); ?> Pickleball Vietnam Association. All rights reserved.</p>
            </div>
        </footer>
        <script>
            $(document).ready(function() {
                // Initialize Select2 for location dropdowns
                if ($('#location').length) {
                    $('#location').select2({
                        tags: true, // Allow creating new tags
                        theme: 'bootstrap-5'
                    });
                }

                // Mobile menu enhancement
                const navbarCollapse = document.getElementById('mainNav');
                const navbarToggler = document.querySelector('.navbar-toggler');
                
                // Close mobile menu when clicking outside
                document.addEventListener('click', function(event) {
                    const isClickInsideNav = navbarCollapse.contains(event.target);
                    const isClickOnToggler = navbarToggler.contains(event.target);
                    
                    if (!isClickInsideNav && !isClickOnToggler && navbarCollapse.classList.contains('show')) {
                        const bsCollapse = new bootstrap.Collapse(navbarCollapse, {
                            toggle: false
                        });
                        bsCollapse.hide();
                    }
                });

                // Close mobile menu when clicking on nav links
                document.querySelectorAll('.navbar-nav .nav-link').forEach(link => {
                    link.addEventListener('click', function() {
                        if (window.innerWidth < 992 && navbarCollapse.classList.contains('show')) {
                            const bsCollapse = new bootstrap.Collapse(navbarCollapse, {
                                toggle: false
                            });
                            bsCollapse.hide();
                        }
                    });
                });

                // Simple mobile menu handling - no complex animations
                // Just ensure menu closes when clicking nav links
                // Bootstrap handles the rest
            });
        </script>
        <?php echo $__env->yieldPushContent('layout_script'); ?>
    </body>

</html><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>