<?php if($venues->isEmpty()): ?>
<div class="text-center py-5">
    <i class="bi bi-exclamation-circle-fill fs-1" style="color: var(--warning);"></i>
    <p class="fs-5 mt-3" style="color: var(--text-muted);">Không tìm thấy sân nào phù hợp.</p>
</div>
<?php else: ?>
<div class="row g-4">
    <?php $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 shadow-sm rounded-4 overflow-hidden venue-card">
            <a href="<?php echo e(route('venues.show', $venue->slug)); ?>">
                <img class="card-img-top" src="<?php echo e($venue->main_image); ?>" alt="Hình ảnh của <?php echo e($venue->name); ?>"
                    loading="lazy">
            </a>
            <div class="card-body p-4">
                <h3 class="card-title h5 mb-2">
                    <a href="<?php echo e(route('venues.show', $venue->slug)); ?>" class="text-decoration-none"><?php echo e($venue->name); ?></a>
                </h3>
                <p class="card-text small mb-3" style="color: var(--text-muted);"><i
                        class="bi bi-geo-alt-fill me-1"></i> <?php echo e($venue->address ?? 'Chưa có địa chỉ'); ?></p>
                <div class="mt-auto">
                    <span class="badge" style="background: var(--accent-primary); color: var(--text-primary);"><?php echo e($venue->location ?? 'Khác'); ?></span>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<!-- Pagination -->
<div class="mt-5 d-flex justify-content-center">
    <?php echo e($venues->appends(request()->query())->links()); ?>

</div>
<?php endif; ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/venues/partials/_venues_grid.blade.php ENDPATH**/ ?>