<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<tr>
    <td><?php echo e($user->id); ?></td>
    <td>
        <div class="d-flex align-items-center">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view', $user)): ?>
            <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" class="fw-medium text-decoration-none">
                <?php echo e($user->name); ?>

            </a>
            <?php else: ?>
            <span class="fw-medium"><?php echo e($user->name); ?></span>
            <?php endif; ?>
            <?php if($user->hasRole('admin')): ?>
            <span class="badge bg-danger ms-2">Admin</span>
            <?php endif; ?>
        </div>
    </td>
    <td><?php echo e($user->email); ?></td>
    <td>
        <span class="text-muted"><?php echo e($user->phone ?: 'Chưa có'); ?></span>
    </td>
    <td>
        <span class="badge text-dark"><?php echo e($user->location ?: 'Chưa có'); ?></span>
    </td>
    <td>
        <?php if($user->gender): ?>
        <span
            class="badge <?php echo e($user->gender == 'Nam' ? 'bg-primary' : ($user->gender == 'Nữ' ? 'bg-warning' : 'bg-secondary')); ?>">
            <?php echo e($user->gender); ?>

        </span>
        <?php else: ?>
        <span class="text-muted">Chưa có</span>
        <?php endif; ?>
    </td>
    <td>
        <?php if($user->avatar): ?>
        <img src="<?php echo e(str_starts_with($user->avatar, 'http') ? $user->avatar : asset($user->avatar)); ?>" width="40"
            height="40" alt="Avatar" style="object-fit:cover; border-radius: 50%;" class="border"
            onerror="this.style.display='none'; this.nextElementSibling.style.display='inline-flex';">
        <?php else: ?>
        <div class="d-inline-flex align-items-center justify-content-center bg-secondary text-white rounded-circle"
            style="width: 40px; height: 40px; font-size: 14px;">
            <?php echo e(strtoupper(substr($user->name, 0, 1))); ?>

        </div>
        <?php endif; ?>
    </td>
    <td>
        <?php if($user->getRoleNames()->isNotEmpty()): ?>
        <?php $__currentLoopData = $user->getRoleNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <span class="badge bg-info text-dark me-1"><?php echo e(ucfirst($role)); ?></span>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
        <span class="text-muted">Chưa có vai trò</span>
        <?php endif; ?>
    </td>
    <td>
        <small class="text-muted"><?php echo e($user->created_at->format('d/m/Y H:i')); ?></small>
    </td>
    <td>
        <div class="btn-group btn-group-sm" role="group">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $user)): ?>
            <a href="<?php echo e(route('admin.users.edit', $user->id)); ?>" class="btn btn-outline-primary" title="Chỉnh sửa">
                <i class="bi bi-pencil"></i>
            </a>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $user)): ?>
            <form action="<?php echo e(route('admin.users.destroy', $user->id)); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-outline-danger" title="Xóa"
                    onclick="return confirm('Bạn có chắc muốn xóa người dùng này?')">
                    <i class="bi bi-trash"></i>
                </button>
            </form>
            <?php else: ?>
            <?php if($user->id === auth()->id()): ?>
            <button class="btn btn-sm btn-outline-light text-muted" disabled title="Không thể xóa chính mình">
                <i class="bi bi-shield-lock"></i>
            </button>
            <?php elseif($user->hasRole('admin')): ?>
            <button class="btn btn-sm btn-outline-light text-muted" disabled title="Không thể xóa admin">
                <i class="bi bi-shield-check"></i>
            </button>
            <?php endif; ?>
            <?php endif; ?>
        </div>
    </td>
</tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php if($users->isEmpty()): ?>
<tr>
    <td colspan="10" class="text-center text-light py-4">
        <i class="bi bi-people text-muted mb-3" style="font-size: 3rem;"></i>
        <h5 class="text-muted">Không có người dùng nào</h5>
        <p class="text-muted">Hãy thêm người dùng mới hoặc thay đổi bộ lọc</p>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\User::class)): ?>
        <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-primary fw-semibold shadow-sm">
            <i class="bi bi-plus-circle me-1"></i> Thêm User Đầu Tiên
        </a>
        <?php endif; ?>
    </td>
</tr>
<?php endif; ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/users/partials/table.blade.php ENDPATH**/ ?>