<?php $__env->startSection('title', 'Bảng Điều Khiển Admin'); ?>

<?php $__env->startPush('layout_css'); ?>
<style>
    .stat-card {
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
    }

    .stat-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.3) !important;
    }

    .stat-card .card-body {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    .stat-card .stat-icon {
        font-size: 3rem;
        opacity: 0.3;
    }

    .stat-card-primary {
        background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary)) !important;
        color: var(--text-primary) !important;
    }

    .stat-card-success {
        background: linear-gradient(135deg, var(--success), #059669) !important;
        color: var(--text-primary) !important;
    }

    .stat-card-info {
        background: linear-gradient(135deg, #0ea5e9, #0284c7) !important;
        color: var(--text-primary) !important;
    }

    .stat-card-secondary {
        background: linear-gradient(135deg, var(--text-muted), #64748b) !important;
        color: var(--text-primary) !important;
    }

    .stat-card .card-footer {
        background: rgba(0, 0, 0, 0.2) !important;
        border-top: 1px solid rgba(255, 255, 255, 0.1) !important;
        color: var(--text-primary) !important;
    }

    .stat-card .card-footer:hover {
        background: rgba(0, 0, 0, 0.3) !important;
    }

    .dashboard-title {
        color: var(--text-primary) !important;
    }

    .dashboard-title i {
        color: var(--accent-primary) !important;
    }

    .quick-list-card {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .quick-list-card .card-header {
        background: var(--secondary-bg) !important;
        border-bottom: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .quick-list-card .list-group-item {
        background: var(--card-bg) !important;
        border-color: var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .quick-list-card .list-group-item a {
        color: var(--accent-primary) !important;
        text-decoration: none;
    }

    .quick-list-card .list-group-item a:hover {
        color: var(--accent-secondary) !important;
    }

    .quick-list-card .badge {
        background: var(--accent-primary) !important;
        color: var(--text-primary) !important;
    }

    .text-muted {
        color: var(--text-muted) !important;
    }

    .badge.bg-danger {
        background-color: #dc3545 !important;
        animation: pulse 2s infinite;
    }

    .badge.bg-success {
        background-color: #198754 !important;
    }

    .badge.bg-warning {
        background-color: #ffc107 !important;
        color: #000 !important;
    }

    @keyframes pulse {
        0% {
            box-shadow: 0 0 0 0 rgba(220, 53, 69, 0.7);
        }

        70% {
            box-shadow: 0 0 0 10px rgba(220, 53, 69, 0);
        }

        100% {
            box-shadow: 0 0 0 0 rgba(220, 53, 69, 0);
        }
    }

    .quick-list-card .list-group-item {
        padding: 1rem;
    }

    .quick-list-card .list-group-item .fw-semibold {
        margin-bottom: 0.25rem;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h1 class="fw-bold mb-4 dashboard-title"><i class="bi bi-speedometer2"></i> Bảng Điều Khiển</h1>

    <!-- Statistics Cards -->
    <div class="row g-4 mb-4">
        <?php if(auth()->user()->hasRole('mod')): ?>
        <div class="col-md-6 col-lg-3">
            <div class="card stat-card stat-card-primary shadow-sm h-100">
                <div class="card-body">
                    <div>
                        <h5 class="card-title">Tổng Giải Đấu</h5>
                        <p class="card-text fs-2 fw-bold"><?php echo e($stats['tournaments']); ?></p>
                    </div>
                    <i class="bi bi-trophy-fill stat-icon"></i>
                </div>
                <a href="<?php echo e(route('admin.tournaments.index')); ?>" class="card-footer text-decoration-none">
                    Xem chi tiết <i class="bi bi-arrow-right-circle"></i>
                </a>
            </div>
        </div>
        <div class="col-md-6 col-lg-3">
            <div class="card stat-card stat-card-success text-white shadow-sm h-100">
                <div class="card-body">
                    <div>
                        <h5 class="card-title">Tổng Vận Động Viên</h5>
                        <p class="card-text fs-2 fw-bold"><?php echo e($stats['players']); ?></p>
                    </div>
                    <i class="bi bi-people-fill stat-icon"></i>
                </div>
                <a href="<?php echo e(route('admin.players.index')); ?>" class="card-footer text-white text-decoration-none">
                    Xem chi tiết <i class="bi bi-arrow-right-circle"></i>
                </a>
            </div>
        </div>
        <?php else: ?>
        <div class="col-md-6 col-lg-3">
            <div class="card stat-card stat-card-primary shadow-sm h-100">
                <div class="card-body">
                    <div>
                        <h5 class="card-title">Tổng Giải Đấu</h5>
                        <p class="card-text fs-2 fw-bold"><?php echo e($stats['tournaments']); ?></p>
                    </div>
                    <i class="bi bi-trophy-fill stat-icon"></i>
                </div>
                <a href="<?php echo e(route('admin.tournaments.index')); ?>" class="card-footer text-decoration-none">
                    Xem chi tiết <i class="bi bi-arrow-right-circle"></i>
                </a>
            </div>
        </div>
        <div class="col-md-6 col-lg-3">
            <div class="card stat-card stat-card-success text-white shadow-sm h-100">
                <div class="card-body">
                    <div>
                        <h5 class="card-title">Tổng Vận Động Viên</h5>
                        <p class="card-text fs-2 fw-bold"><?php echo e($stats['players']); ?></p>
                    </div>
                    <i class="bi bi-people-fill stat-icon"></i>
                </div>
                <a href="<?php echo e(route('admin.players.index')); ?>" class="card-footer text-white text-decoration-none">
                    Xem chi tiết <i class="bi bi-arrow-right-circle"></i>
                </a>
            </div>
        </div>

        <div class="col-md-6 col-lg-3">
            <div class="card stat-card stat-card-info shadow-sm h-100">
                <div class="card-body">
                    <div>
                        <h5 class="card-title">Tổng Người Dùng</h5>
                        <p class="card-text fs-2 fw-bold"><?php echo e($stats['users']); ?></p>
                    </div>
                    <i class="bi bi-person-circle stat-icon"></i>
                </div>
                <a href="<?php echo e(route('admin.users.index')); ?>" class="card-footer text-decoration-none">
                    Xem chi tiết <i class="bi bi-arrow-right-circle"></i>
                </a>
            </div>
        </div>
        <div class="col-md-6 col-lg-3">
            <div class="card stat-card stat-card-secondary shadow-sm h-100">
                <div class="card-body">
                    <div>
                        <h5 class="card-title">Tổng Số Sân</h5>
                        <p class="card-text fs-2 fw-bold"><?php echo e($stats['venues']); ?></p>
                    </div>
                    <i class="bi bi-geo-alt-fill stat-icon"></i>
                </div>
                <a href="<?php echo e(route('admin.venues.index')); ?>" class="card-footer text-decoration-none">
                    Xem chi tiết <i class="bi bi-arrow-right-circle"></i>
                </a>
            </div>
        </div>
        <?php endif; ?>
    </div>
    <!-- Quick Lists -->
    <div class="row g-4">
        <div class="col-lg-6">
            <div class="card shadow-sm quick-list-card">
                <div class="card-header">
                    <i class="bi bi-calendar-event-fill me-2"></i>
                    <strong>Giải Đấu Sắp Diễn Ra</strong>
                </div>
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $upcoming_tournaments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tournament): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div class="d-flex flex-column">
                            <a href="<?php echo e(route('admin.tournaments.show', $tournament)); ?>" class="fw-semibold"><?php echo e($tournament->name); ?></a>
                            <small class="text-muted"><?php echo e($tournament->start_date->format('d/m/Y')); ?></small>
                        </div>
                        <div class="d-flex gap-2 align-items-center">
                            <?php if($tournament->registrations->count() > 0): ?>
                            <?php
                            $recentRegistrations = $tournament->registrations->where('created_at', '>=',
                            now()->subDays(3))->count();
                            ?>
                            <?php if($recentRegistrations > 0): ?>
                            <span class="badge bg-danger rounded-pill"><?php echo e($recentRegistrations); ?> mới</span>
                            <?php endif; ?>
                            <span class="badge bg-primary rounded-pill"><?php echo e($tournament->registrations->count()); ?> đăng
                                ký</span>
                            <?php else: ?>
                            <span class="badge bg-secondary rounded-pill">Chưa có đăng ký</span>
                            <?php endif; ?>
                        </div>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-muted">Không có giải đấu nào sắp diễn ra.</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow-sm quick-list-card">
                <div class="card-header">
                    <i class="bi bi-people-fill me-2"></i>
                    <strong>Vận Động Viên Mới</strong>
                </div>
                <ul class="list-group list-group-flush">
                    <?php $__empty_1 = true; $__currentLoopData = $recent_players; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $player): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <div class="d-flex flex-column">
                            <a href="<?php echo e(route('admin.players.edit', $player)); ?>" class="fw-semibold"><?php echo e($player->name); ?></a>
                            <small class="text-muted">Đăng ký: <?php echo e($player->created_at->format('d/m/Y H:i')); ?></small>
                        </div>
                        <?php if($player->created_at >= now()->subDays(1)): ?>
                        <span class="badge bg-success rounded-pill">Mới</span>
                        <?php endif; ?>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-muted">Không có vận động viên mới.</li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>