<?php $__env->startSection('title', $tournament->name); ?>

<?php $__env->startPush('layout_css'); ?>
<style>
    /* Styles from admin show view for consistency */
    .tournament-detail-page {
        background-color: var(--primary-bg);
        color: var(--text-primary);
    }

    .tournament-detail-page.bg-light,
    .tournament-detail-page .bg-light,
    .tournament-detail-page .bg-white {
        background-color: var(--card-bg) !important;
        color: var(--text-primary) !important;
    }

    .tournament-detail-page .border,
    .tournament-detail-page .card,
    .tournament-detail-page .match-card,
    .tournament-detail-page .modal-content,
    .tournament-detail-page .list-group-item,
    .tournament-detail-page .table,
    .tournament-detail-page .table thead th,
    .tournament-detail-page .table tbody td {
        border-color: var(--border-color) !important;
    }

    .tournament-detail-page .text-secondary {
        color: var(--text-secondary) !important;
    }

    .tournament-detail-page .text-white-50 {
        color: rgba(255, 255, 255, 0.55) !important;
    }

    .tournament-detail-page .match-card .text-dark,
    .tournament-detail-page .list-group-item .text-dark {
        color: var(--text-primary) !important;
    }

    .tournament-detail-page .shadow,
    .tournament-detail-page .shadow-lg {
        box-shadow: 0 12px 30px var(--shadow-dark) !important;
    }

    .tournament-card {
        border-radius: 1.5rem;
        padding: 2.25rem;
        min-height: 440px;
        gap: 1.5rem;
    }

    .tournament-hero-card,
    .tournament-registrations-card {
        min-height: 420px;
    }

    .tournament-logo {
        width: 92px;
        height: 92px;
        object-fit: contain;
        filter: drop-shadow(0 4px 16px rgba(37, 99, 235, 0.2));
        margin-bottom: 1.15rem;
    }

    .tournament-title {
        font-size: clamp(2.1rem, 3vw, 2.75rem);
    }

    .tournament-section-title {
        font-size: clamp(1.5rem, 2.2vw, 2.1rem);
    }

    .tournament-date {
        font-size: clamp(1.05rem, 2.2vw, 1.3rem);
    }

    .tournament-badges .badge {
        font-size: 0.85rem !important;
        padding: 0.45rem 0.9rem;
        border-radius: 999px;
    }

    .tournament-detail-page .btn-lg {
        font-size: 1.05rem;
        padding: 0.75rem 1.4rem;
        border-radius: 0.9rem;
    }

    .tournament-detail-page .card {
        background-color: var(--card-bg);
        color: var(--text-primary);
        border-color: var(--border-color);
    }

    .tournament-detail-page .card-header {
        background-color: rgba(255, 255, 255, 0.04);
        border-bottom: 1px solid var(--border-color);
        color: var(--text-primary);
    }

    .tournament-detail-page .card-header.bg-dark {
        background-color: rgba(255, 255, 255, 0.05) !important;
        color: var(--text-primary) !important;
    }

    .tournament-detail-page .card-title {
        color: var(--text-primary);
    }

    .tournament-detail-page .table {
        color: var(--text-secondary);
    }

    .tournament-detail-page .table thead th {
        background-color: rgba(255, 255, 255, 0.04);
        color: var(--text-primary);
    }

    .tournament-detail-page .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(255, 255, 255, 0.02);
    }

    .tournament-detail-page .table-hover tbody tr:hover {
        background-color: rgba(59, 130, 246, 0.15);
        color: var(--text-primary);
    }

    .tournament-detail-page .standings-table-wrapper {
        background: rgba(255, 255, 255, 0.02);
        border: 1px solid var(--border-color);
        border-radius: 1rem;
        padding: 0.75rem;
        box-shadow: 0 10px 28px rgba(0, 0, 0, 0.35);
        backdrop-filter: blur(6px);
    }

    .tournament-detail-page .standings-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        color: var(--text-secondary);
        background-color: rgba(12, 15, 22, 0.85);
        border-radius: 0.85rem;
        overflow: hidden;
    }

    .tournament-detail-page .standings-table thead th {
        background: linear-gradient(135deg, rgba(59, 130, 246, 0.85) 0%, rgba(34, 211, 238, 0.65) 100%);
        color: var(--text-primary);
        border-bottom: none;
        text-transform: uppercase;
        letter-spacing: 0.04em;
        font-size: 0.82rem;
        padding: 0.85rem 0.75rem;
    }

    .tournament-detail-page .standings-table tbody tr {
        background-color: rgba(255, 255, 255, 0.02) !important;
        transition: transform 0.18s ease, background-color 0.18s ease, box-shadow 0.18s ease;
    }

    .tournament-detail-page .standings-table tbody tr:nth-of-type(even) {
        background-color: rgba(255, 255, 255, 0.05) !important;
    }

    .tournament-detail-page .standings-table tbody tr:hover {
        background-color: rgba(59, 130, 246, 0.18) !important;
        transform: translateY(-2px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.32);
        color: var(--text-primary);
    }

    .tournament-detail-page .standings-table th,
    .tournament-detail-page .standings-table td {
        border-color: rgba(255, 255, 255, 0.08) !important;
        padding: 0.85rem 0.75rem;
        vertical-align: middle;
        background-color: transparent !important;
    }

    .tournament-detail-page .standings-table tbody tr+tr td {
        border-top: 1px solid rgba(255, 255, 255, 0.06);
    }

    .tournament-detail-page .standings-table tbody tr:first-child {
        background: linear-gradient(135deg, rgba(59, 130, 246, 0.25) 0%, rgba(34, 211, 238, 0.15) 100%) !important;
        box-shadow: inset 0 0 0 1px rgba(34, 211, 238, 0.35);
    }

    .tournament-detail-page .standings-table tbody td,
    .tournament-detail-page .standings-table thead th {
        color: var(--text-primary);
    }

    .tournament-detail-page .standings-table tbody td a {
        color: var(--accent-secondary);
    }

    .tournament-detail-page .standings-table tbody td a:hover {
        color: var(--accent-primary);
    }

    .tournament-detail-page .standings-table .text-muted {
        color: rgba(255, 255, 255, 0.55) !important;
    }

    .tournament-detail-page .standings-table .text-success {
        color: var(--success) !important;
    }

    .tournament-detail-page .alert-info {
        background-color: rgba(34, 211, 238, 0.12);
        border-color: rgba(34, 211, 238, 0.35);
        color: var(--accent-secondary);
    }

    .tournament-detail-page .alert-secondary {
        background-color: rgba(148, 163, 184, 0.12);
        border-color: rgba(148, 163, 184, 0.35);
        color: var(--text-secondary);
    }

    .match-card {
        background-color: var(--card-bg);
        border: 1px solid var(--border-color);
        border-radius: .5rem;
        padding: 1rem;
        margin-bottom: 1rem;
        box-shadow: 0 8px 24px var(--shadow-dark);
        position: relative;
    }

    .match-team-info {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
    }

    .team-avatars {
        display: flex;
        margin-bottom: .5rem;
    }

    .team-avatars .avatar,
    .team-avatars .avatar-placeholder {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
        border: 2px solid rgba(255, 255, 255, 0.06);
        box-shadow: 0 2px 6px rgba(0, 0, 0, .3);
    }

    .team-avatars .avatar:first-child,
    .team-avatars .avatar-placeholder:first-child {
        margin-right: 3px;
    }

    .team-name {
        font-weight: 600;
        font-size: 0.7rem;
        min-height: 40px;
        display: flex;
        align-items: center;
        color: var(--text-primary);
    }

    /* Player number tags (1 and 2) - consistent with admin view */
    .player-number-tag {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 18px;
        height: 18px;
        border-radius: 50%;
        font-size: 0.75rem;
        font-weight: 700;
        color: var(--text-primary);
        margin-right: 8px;
    }

    .player-number-tag.p1 {
        background: var(--accent-primary);
    }

    .player-number-tag.p2 {
        background: var(--success);
    }

    .score-input-display {
        font-size: 1.3rem;
        font-weight: bold;
        padding: 0 0.35rem;
        min-width: 32px;
        text-align: center;
        border-radius: 0.4rem;
        background: var(--secondary-bg);
        color: var(--text-primary);
        box-shadow: 0 4px 14px rgba(0, 0, 0, 0.25);
        display: inline-block;
    }

    @media (max-width: 1199.98px) {
        .tournament-card {
            padding: 2rem;
            min-height: 400px;
        }

        .tournament-logo {
            width: 84px;
            height: 84px;
        }
    }

    @media (max-width: 991.98px) {
        .tournament-card {
            padding: 1.75rem;
            min-height: auto;
        }

        .tournament-hero-card,
        .tournament-registrations-card {
            min-height: auto;
        }

        .tournament-detail-page .standings-table-wrapper {
            padding: 0.55rem;
        }

        .tournament-detail-page .standings-table thead th {
            font-size: 0.78rem;
            padding: 0.75rem 0.6rem;
        }

        .tournament-detail-page .standings-table td {
            padding: 0.75rem 0.6rem;
            font-size: 0.92rem;
        }

        .tournament-detail-page .btn-lg {
            font-size: 0.98rem;
            padding: 0.65rem 1.1rem;
        }

        .tournament-detail-page .alert {
            font-size: 0.95rem;
        }

        .tournament-detail-page .alert i {
            font-size: 1.3rem !important;
        }
    }

    @media (max-width: 767.98px) {
        .tournament-card {
            padding: 1.5rem;
            border-radius: 1.25rem;
        }

        .tournament-logo {
            width: 70px;
            height: 70px;
            margin-bottom: 0.9rem;
        }

        .tournament-section-title {
            font-size: clamp(1.35rem, 5vw, 1.75rem);
        }

        .tournament-detail-page .standings-table-wrapper {
            padding: 0.45rem 0.5rem;
        }

        .tournament-detail-page .standings-table thead th,
        .tournament-detail-page .standings-table td {
            padding: 0.65rem 0.55rem;
        }

        .tournament-detail-page .standings-table td {
            font-size: 0.88rem;
        }

        .tournament-detail-page .list-group .d-flex.align-items-center {
            flex-direction: column;
            align-items: stretch !important;
            text-align: center;
        }

        .tournament-badges .badge {
            font-size: 0.78rem !important;
            padding: 0.35rem 0.75rem;
        }

        .tournament-detail-page .alert {
            padding: 0.85rem 1rem;
        }

        .score-input-display {
            font-size: 1.0rem;
            min-width: 25px;
            padding: 0 0.15rem;
        }

        .col-2.text-center {
            flex: 0 0 40px;
            max-width: 50px;
        }
    }

    @media (max-width: 575.98px) {
        .tournament-title {
            font-size: 1.8rem;
        }

        .tournament-date {
            font-size: 0.95rem;
        }

        .tournament-logo {
            width: 62px;
            height: 62px;
        }

        .tournament-detail-page .btn-lg {
            width: 100%;
            font-size: 0.9rem;
            padding: 0.6rem 1rem;
        }

        .tournament-detail-page .badge {
            font-size: 0.72rem !important;
        }

        .tournament-detail-page .alert {
            font-size: 0.9rem;
        }

        .tournament-detail-page .list-group .d-flex.align-items-center {
            gap: 1rem;
        }

        .tournament-detail-page .standings-table-wrapper {
            padding: 0.35rem 0.4rem;
        }

        .tournament-detail-page .standings-table thead th,
        .tournament-detail-page .standings-table td {
            padding: 0.55rem 0.5rem;
            font-size: 0.82rem;
        }
    }

    /* Highlights for standings top positions */
    .standing-top-1 {
        background: linear-gradient(90deg, rgba(255, 223, 93, 0.25), rgba(255, 223, 93, 0.1));
        border-left: 4px solid #f6c84c;
        color: var(--text-primary);
    }

    .standing-top-2 {
        background: linear-gradient(90deg, rgba(192, 192, 192, 0.15), rgba(192, 192, 192, 0.05));
        border-left: 4px solid #bdbdbd;
        color: var(--text-primary);
    }

    .standing-top-3 {
        background: linear-gradient(90deg, rgba(205, 127, 50, 0.15), rgba(205, 127, 50, 0.05));
        border-left: 4px solid #cd7f32;
        color: var(--text-primary);
    }

    .standing-badge {
        font-size: 0.7rem;
        padding: 0.15rem 0.4rem;
        border-radius: 0.35rem;
        margin-left: 0.5rem;
        vertical-align: middle;
        background: var(--accent-primary);
        color: var(--text-primary);
    }

    /* Tournament Description & Rules Styling */
    .tournament-description,
    .tournament-rules {
        line-height: 1.8;
        color: var(--text-secondary);
    }

    .tournament-description h1,
    .tournament-description h2,
    .tournament-description h3,
    .tournament-description h4,
    .tournament-description h5,
    .tournament-description h6,
    .tournament-rules h1,
    .tournament-rules h2,
    .tournament-rules h3,
    .tournament-rules h4,
    .tournament-rules h5,
    .tournament-rules h6 {
        color: var(--accent-primary);
        margin-top: 1.5rem;
        margin-bottom: 1rem;
        font-weight: 600;
    }

    .tournament-description h2,
    .tournament-rules h2 {
        font-size: 1.4rem;
    }

    .tournament-description h3,
    .tournament-rules h3 {
        font-size: 1.3rem;
    }

    .tournament-description h4,
    .tournament-rules h4 {
        font-size: 1.2rem;
    }

    .tournament-description h5,
    .tournament-rules h5 {
        font-size: 1.1rem;
    }

    .tournament-description h6,
    .tournament-rules h6 {
        font-size: 1rem;
    }

    .tournament-description ul,
    .tournament-description ol,
    .tournament-rules ul,
    .tournament-rules ol {
        padding-left: 1.5rem;
        margin-bottom: 1rem;
    }

    .tournament-description li,
    .tournament-rules li {
        margin-bottom: 0.5rem;
        line-height: 1.6;
    }

    .tournament-description ul li,
    .tournament-rules ul li {
        list-style-type: none;
        position: relative;
    }

    .tournament-description ul li:before,
    .tournament-rules ul li:before {
        content: "•";
        color: var(--accent-primary);
        font-weight: bold;
        position: absolute;
        left: -1rem;
    }

    .tournament-description p,
    .tournament-rules p {
        margin-bottom: 1rem;
        line-height: 1.7;
    }

    .tournament-description a,
    .tournament-rules a {
        color: var(--accent-secondary);
        text-decoration: none;
        border-bottom: 1px dotted var(--accent-secondary);
        transition: all 0.2s ease;
    }

    .tournament-description a:hover,
    .tournament-rules a:hover {
        color: var(--accent-primary);
        border-bottom-style: solid;
    }

    .tournament-description img,
    .tournament-rules img {
        max-width: 100%;
        height: auto;
        border-radius: 0.5rem;
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.45);
        margin: 1rem 0;
    }

    .tournament-description b,
    .tournament-description strong,
    .tournament-rules b,
    .tournament-rules strong {
        color: var(--text-primary);
        font-weight: 600;
    }

    .tournament-description i,
    .tournament-description em,
    .tournament-rules i,
    .tournament-rules em {
        color: var(--text-muted);
        font-style: italic;
    }

    .tournament-description u,
    .tournament-rules u {
        text-decoration: underline;
        text-underline-offset: 2px;
    }

    .tournament-description blockquote,
    .tournament-rules blockquote {
        border-left: 4px solid var(--accent-primary);
        padding-left: 1rem;
        margin: 1.5rem 0;
        font-style: italic;
        background-color: rgba(59, 130, 246, 0.08);
        padding: 1rem;
        border-radius: 0.25rem;
        color: var(--text-secondary);
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="tournament-detail-page py-5 bg-light" style="min-height:100vh;">
    <div class="container-xl">
        <div class="row align-items-center g-4 mb-5">
            <div class="col-lg-6 d-flex">
                <div
                    class="tournament-card tournament-hero-card bg-white rounded-4 p-4 shadow-lg border flex-fill d-flex flex-column justify-content-between h-100">
                    <div
                        class="flex-grow-1 d-flex flex-column align-items-center justify-content-center text-center w-100">
                        <img src="<?php echo e($tournament->image ? asset($tournament->image) : asset('assets/images/tournament-details-logo.webp')); ?>"
                            alt="Pickleball" class="tournament-logo">
                        <h1 class="tournament-title display-6 fw-bold text-primary mb-2"
                            style="text-shadow:0 2px 8px #2563eb22;"><?php echo e($tournament->name); ?></h1>
                        <div class="tournament-date fs-5 text-secondary mb-2">Thi đấu: <?php echo e($tournament->start_date->format('d/m/Y')); ?>

                        </div>
                        <div class="tournament-badges d-flex flex-wrap gap-2 mb-3 justify-content-center">
                            <span class="badge bg-primary bg-opacity-75 fs-6 text-white shadow-sm"><?php echo e($tournament->type
                                == 'singles' ? 'Đơn' : 'Đôi'); ?></span>
                            <span class="badge bg-success bg-opacity-75 fs-6 text-white shadow-sm"><?php echo e($tournament->location); ?></span>
                            <?php if(isset($tournament->skill_point)): ?>
                            <span class="badge bg-secondary bg-gradient fs-6 text-white shadow-lg px-3 py-2"
                                style="font-size:1.1rem;border:2px solid #ffe066;">
                                <i class="bi bi-star-fill text-warning"></i> Điểm trình: <b><?php echo e(number_format($tournament->skill_point, 2)); ?></b>
                            </span>
                            <?php endif; ?>
                            <?php if(isset($tournament->skill_tolerance)): ?>
                            <span class="badge bg-info bg-gradient fs-6 text-dark shadow-lg px-3 py-2"
                                style="font-size:1.1rem;border:2px solid #2563eb;">
                                <i class="bi bi-arrows-angle-contract text-primary"></i> Dung sai: <b>&plusmn;<?php echo e(number_format($tournament->skill_tolerance, 2)); ?></b>
                            </span>
                            <?php endif; ?>
                            <span class="badge bg-warning bg-opacity-75 text-dark fs-6 shadow-sm"><i
                                    class="bi bi-trophy"></i> <?php echo e($tournament->prizes); ?></span>
                            <span class="badge bg-info bg-opacity-75 text-dark fs-6 shadow-sm"><i
                                    class="bi bi-cash"></i> <?php echo e(number_format($tournament->fee)); ?>đ</span>
                        </div>
                        <?php
                        $now = now();
                        $startDate = \Carbon\Carbon::parse($tournament->start_date);
                        $endDate = \Carbon\Carbon::parse($tournament->end_date);
                        $tournamentStatus = '';
                        $showRegisterButton = false;

                        if ($now->lt($startDate)) {
                        $tournamentStatus = 'upcoming';
                        // Only show register button if it's more than 24 hours before the start date
                        if ($now->lt($startDate->copy()->subHours(24))) {
                        $showRegisterButton = true;
                        }
                        } elseif ($now->between($startDate, $endDate->endOfDay())) {
                        $tournamentStatus = 'ongoing';
                        } else {
                        $tournamentStatus = 'finished';
                        }
                        ?>
                        <div class="my-4 text-center">
                            <?php if($tournamentStatus == 'upcoming'): ?>
                            <div class="mb-4 d-flex flex-column align-items-center justify-content-center">
                                <div id="countdown" class="fs-5 fw-bold text-danger mt-2"></div>
                            </div>
                            <div class="alert alert-info d-inline-flex align-items-center gap-2"><i
                                    class="bi bi-calendar-event fs-4"></i> <span>Giải đấu sẽ bắt đầu vào: <strong><?php echo e($startDate->format('d/m/Y')); ?></strong></span></div>

                            <?php elseif($tournamentStatus == 'ongoing'): ?>
                            <div class="alert alert-success d-inline-flex align-items-center gap-2"><i
                                    class="bi bi-play-circle-fill fs-4"></i> <span>Giải đấu đang diễn ra</span></div>
                            <?php else: ?>
                            <div class="alert alert-secondary d-inline-flex align-items-center gap-2"><i
                                    class="bi bi-check-circle-fill fs-4"></i> <span>Giải đấu đã kết thúc <br>(<?php echo e($startDate->format('d/m/Y')); ?> - <?php echo e($endDate->format('d/m/Y')); ?>)</span></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="d-flex flex-column flex-lg-row gap-3 w-100 mt-3">
                        <?php if($showRegisterButton): ?>
                        <button type="button" class="btn btn-primary btn-lg flex-fill fw-bold shadow"
                            data-bs-toggle="modal" data-bs-target="#registerModal">Đăng ký ngay</button>
                        <?php endif; ?>
                        <a href="<?php echo e(route('tournament.setting.index', $tournament->id)); ?>"
                            class="btn btn-outline-primary btn-lg flex-fill fw-bold">Quản lý dành cho BTC và trọng
                            tài!</a>
                    </div>
                    <!-- Modal: Đăng ký giải đấu -->
                    <div class="modal fade" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content bg-dark text-white">
                                <div class="modal-header border-0">
                                    <h5 class="modal-title text-white" id="registerModalLabel">Đăng ký giải <?php echo e(strtoupper($tournament->name)); ?></h5>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- Single inline alert container for client-side messages and server-side validation -->
                                    <div id="registerAlerts" class="mb-3">
                                        <?php if($errors->any()): ?>
                                        <div class="alert alert-danger p-3 rounded-3 mb-3">
                                            <div class="fw-bold mb-2"><i
                                                    class="bi bi-exclamation-triangle-fill text-warning"></i> Đăng ký
                                                không thành công!</div>
                                            <ul class="mb-0">
                                                <?php if($errors->has('player1_phone')): ?>
                                                <li class="text-danger"><b>Người chơi 1:</b> <?php echo e($errors->first('player1_phone')); ?></li>
                                                <?php endif; ?>
                                                <?php if($errors->has('player2_phone')): ?>
                                                <li class="text-danger"><b>Người chơi 2:</b> <?php echo e($errors->first('player2_phone')); ?></li>
                                                <?php endif; ?>
                                                <?php if($errors->has('score_sum')): ?>
                                                <li class="text-danger"><b>Điểm trình:</b> <?php echo e($errors->first('score_sum')); ?></li>
                                                <?php endif; ?>
                                                <?php if($errors->has('max_pairs')): ?>
                                                <li class="text-danger"><b>Giới hạn số cặp/đội:</b> <?php echo e($errors->first('max_pairs')); ?></li>
                                                <?php endif; ?>
                                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!$errors->has('player1_phone') && !$errors->has('player2_phone') &&
                                                !$errors->has('score_sum') && !$errors->has('max_pairs')): ?>
                                                <li class="text-danger"><?php echo e($error); ?></li>
                                                <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="mb-3">
                                        <span>Bạn đã là thành viên của PVNA chưa? Nếu chưa, <a
                                                href="<?php echo e(route('register-member.show')); ?>"
                                                class="text-danger fw-bold">hãy đăng ký
                                                tại đây</a>. Nếu đã là thành viên có thông tin trên hệ thống, hãy nhập
                                            số điện thoại, tên hoặc email và tìm kiếm đúng thông tin của 2 người chơi</span>
                                    </div>
                                    <div class="mb-3">
                                        <span class="text-danger fw-bold">Lưu ý:</span>
                                        <ul class="small text-white-50 mb-0">
                                            <li>PVNA là hệ thống xếp hạng vận động viên Pickleball. PVNA không tham gia
                                                tổ chức giải. PVNA chỉ hỗ trợ BTC ghi nhận đăng ký và xếp loại trình vận
                                                động viên theo thông tin trên hệ thống.</li>
                                            <li>Toàn bộ thông tin đăng ký sẽ được chuyển cho BTC giải. Việc nhận thanh
                                                toán, duyệt tham gia là do BTC Giải chịu trách nhiệm. PVNA sẽ không can
                                                thiệp các bước đó.</li>
                                        </ul>
                                    </div>
                                    <!-- Consolidated alerts are rendered inside #registerAlerts above -->
                                    <form id="registerForm" method="POST"
                                        action="<?php echo e(route('tournament.register', $tournament->id)); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="mb-3">
                                            <label for="player1_phone" class="form-label fw-bold">Người chơi 1:</label>
                                            <input type="text"
                                                class="form-control <?php $__errorArgs = ['player1_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="player1_phone" name="player1_phone" placeholder="Nhập số điện thoại, tên hoặc email"
                                                value="<?php echo e(old('player1_phone')); ?>" autocomplete="off" required>
                                            <div id="player1_info" class="mt-2"></div>
                                        </div>
                                        <?php if($tournament->type=='doubles'): ?>
                                        <div class="mb-3">
                                            <label for="player2_phone" class="form-label fw-bold">Người chơi 2:</label>
                                            <input type="text"
                                                class="form-control <?php $__errorArgs = ['player2_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                id="player2_phone" name="player2_phone" placeholder="Nhập số điện thoại, tên hoặc email"
                                                value="<?php echo e(old('player2_phone')); ?>" autocomplete="off" required>
                                            <div id="player2_info" class="mt-2"></div>
                                        </div>
                                        <?php endif; ?>
                                        <div class="mb-3">
                                            <label for="note" class="form-label fw-bold">Ghi chú:</label>
                                            <textarea class="form-control <?php $__errorArgs = ['note'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="note"
                                                name="note" rows="2"
                                                placeholder="Ví dụ: Tên team dành cho các giải đồng đội ..."><?php echo e(old('note')); ?></textarea>
                                        </div>
                                        <div class="text-end">
                                            <button type="submit" class="btn btn-danger fw-bold px-4">ĐĂNG KÝ</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div
                    class="tournament-card tournament-registrations-card bg-white rounded-4 p-4 shadow-lg border flex-fill d-flex flex-column justify-content-between h-100">
                    <div class="d-flex align-items-center mb-2">
                        <h1 class="tournament-section-title text-primary fw-bold"><i class="bi bi-people-fill"></i> Ứng
                            viên tham
                            gia</h1>
                        <span class="badge bg-gradient bg-danger text-white ms-3 px-4 py-2 shadow-lg"><?php echo e($tournament->active_registrations_count); ?> cặp đấu</span>
                    </div>
                    <div class="list-group list-group-flush">
                        <?php $__currentLoopData = $tournament->registrations->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex align-items-center gap-2 p-2 rounded-3 bg-light border">
                            <div class="team-avatars me-3">
                                <!-- Avatar player 1 -->
                                <div class="rounded-circle d-flex align-items-center justify-content-center overflow-hidden bg-secondary text-white fw-bold"
                                    style="width:44px;height:44px;font-size:1.2rem;">
                                    <?php if($reg->player1 && $reg->player1->avatar): ?>
                                    <img src="<?php echo e(asset($reg->player1->avatar)); ?>" alt="avatar1"
                                        class="w-100 h-100 object-fit-cover" style="object-fit:cover;">
                                    <?php else: ?>
                                    <?php echo e($reg->player1 ? mb_substr($reg->player1->name,0,1) : '?'); ?>

                                    <?php endif; ?>
                                </div>
                                <?php if($tournament->type=='doubles' && $reg->player2): ?>
                                <!-- Avatar player 2 -->
                                <div class="rounded-circle d-flex align-items-center justify-content-center overflow-hidden bg-secondary text-white fw-bold"
                                    style="width:44px;height:44px;font-size:1.2rem;">
                                    <?php if($reg->player2 && $reg->player2->avatar): ?>
                                    <img src="<?php echo e(asset($reg->player2->avatar)); ?>" alt="avatar2"
                                        class="w-100 h-100 object-fit-cover" style="object-fit:cover;">
                                    <?php else: ?>
                                    <?php echo e($reg->player2 ? mb_substr($reg->player2->name,0,1) : '?'); ?>

                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="flex-grow-1">
                                <div class="fw-bold text-white">
                                    <?php
                                    // Player status: 0-xám, 1-xanh, 2-vàng
                                    $player1Color = ($reg->player1 && isset($reg->player1->status)) ?
                                    ($reg->player1->status == 1 ? 'text-success' : ($reg->player1->status == 2 ?
                                    'text-warning' : 'text-secondary')) : 'text-secondary';
                                    $player2Color = ($tournament->type=='doubles' && $reg->player2 &&
                                    isset($reg->player2->status)) ? ($reg->player2->status == 1 ? 'text-success' :
                                    ($reg->player2->status == 2 ? 'text-warning' : 'text-secondary')) : '';
                                    ?>
                                    <span class="<?php echo e($player1Color); ?>"><i class="bi bi-award"></i> <a
                                            href="<?php echo e($reg->player1 ? route('players.show', $reg->player1->id) : '#'); ?>"
                                            class="text-decoration-none fw-bold"><?php echo e($reg->player1 ? $reg->player1->name
                                            : '?'); ?></a></span>
                                    <?php if($tournament->type=='doubles' && $reg->player2): ?>
                                    <span class="ms-1 <?php echo e($player2Color); ?>">- <i class="bi bi-award"></i> <a
                                            href="<?php echo e($reg->player2 ? route('players.show', $reg->player2->id) : '#'); ?>"
                                            class="text-decoration-none fw-bold"><?php echo e($reg->player2 ? $reg->player2->name
                                            : '?'); ?></a></span>
                                    <?php endif; ?>
                                </div>
                                <div class="small text-white-50">
                                    <i class="bi bi-geo-alt text-primary"></i> <span class="text-secondary"><?php echo e($reg->player1->location ?? ''); ?></span>
                                </div>
                                <div class="small text-white-50">
                                    <i class="bi bi-people text-primary"></i> <span class="text-secondary"><?php echo e($reg->player1 ? number_format($reg->player1->doubles_score,2) : '?'); ?></span>
                                    <?php if($tournament->type=='doubles' && $reg->player2): ?>
                                    <span class="ms-2 text-secondary"><i class="bi bi-people text-primary"></i> <?php echo e($reg->player2 ? number_format($reg->player2->doubles_score,2) : '?'); ?>

                                    </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="text-end">
                                <?php if($reg->status=='approved'): ?>
                                <span class="badge bg-success bg-opacity-75 text-white px-3 py-1">Đã duyệt</span>
                                <?php elseif($reg->status=='pending'): ?>
                                <span class="badge bg-warning bg-opacity-75 text-dark px-3 py-1">Đang chờ duyệt</span>
                                <?php else: ?>
                                <span class="badge bg-danger bg-opacity-75 text-white px-3 py-1">Không duyệt</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="d-flex justify-content-center mt-3">
                        <button type="button" class="btn btn-primary btn-lg flex-fill fw-bold shadow"
                            data-bs-toggle="modal" data-bs-target="#allPlayersModal">Xem thêm</button>
                    </div>

                    <!-- Modal: Danh sách tất cả ứng viên tham gia -->
                    <div class="modal fade" id="allPlayersModal" tabindex="-1" aria-labelledby="allPlayersModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content bg-white text-dark">
                                <div class="modal-header border-0">
                                    <h5 class="modal-title text-primary" id="allPlayersModalLabel"><i
                                            class="bi bi-people-fill"></i> Tất cả ứng viên tham gia</h5><span
                                        class="badge bg-gradient bg-danger text-white ms-3 px-4 py-22 shadow-lg"><?php echo e($tournament->active_registrations_count); ?> cặp đấu</span>
                                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <div class="container-fluid">
                                        <div class="row g-3">
                                            <?php $__currentLoopData = $tournament->registrations->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row">
                                                <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="col-12 col-md-6">
                                                    <div
                                                        class="d-flex align-items-center gap-2 p-2 rounded-3 bg-light border">
                                                        <div class="d-flex align-items-center gap-1">
                                                            <div class="rounded-circle d-flex align-items-center justify-content-center overflow-hidden bg-secondary text-white fw-bold"
                                                                style="width:40px;height:40px;font-size:1.1rem;">
                                                                <?php if($reg->player1 && $reg->player1->avatar): ?>
                                                                <img src="<?php echo e(asset($reg->player1->avatar)); ?>"
                                                                    alt="avatar1" class="w-100 h-100 object-fit-cover"
                                                                    style="object-fit:cover;">
                                                                <?php else: ?>
                                                                <?php echo e($reg->player1 ? mb_substr($reg->player1->name,0,1) :
                                                                '?'); ?>

                                                                <?php endif; ?>
                                                            </div>
                                                            <?php if($tournament->type=='doubles' && $reg->player2): ?>
                                                            <div class="rounded-circle d-flex align-items-center justify-content-center overflow-hidden bg-secondary text-white fw-bold"
                                                                style="width:40px;height:40px;font-size:1.1rem;">
                                                                <?php if($reg->player2 && $reg->player2->avatar): ?>
                                                                <img src="<?php echo e(asset($reg->player2->avatar)); ?>"
                                                                    alt="avatar2" class="w-100 h-100 object-fit-cover"
                                                                    style="object-fit:cover;">
                                                                <?php else: ?>
                                                                <?php echo e($reg->player2 ? mb_substr($reg->player2->name,0,1) :
                                                                '?'); ?>

                                                                <?php endif; ?>
                                                            </div>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="flex-grow-1 ms-2">
                                                            <?php
                                                            $player1Color = ($reg->player1 &&
                                                            isset($reg->player1->status)) ?
                                                            ($reg->player1->status == 1 ? 'text-success' :
                                                            ($reg->player1->status == 2 ?
                                                            'text-warning' : 'text-secondary')) : 'text-secondary';
                                                            $player2Color = ($tournament->type=='doubles' &&
                                                            $reg->player2 &&
                                                            isset($reg->player2->status)) ? ($reg->player2->status == 1
                                                            ?
                                                            'text-success' :
                                                            ($reg->player2->status == 2 ? 'text-warning' :
                                                            'text-secondary')) :
                                                            '';
                                                            ?>
                                                            <span class="<?php echo e($player1Color); ?>"><i
                                                                    class="bi bi-award"></i> <a
                                                                    href="<?php echo e($reg->player1 ? route('players.show', $reg->player1->id) : '#'); ?>"
                                                                    class="text-decoration-none fw-bold"><?php echo e($reg->player1 ? $reg->player1->name : '?'); ?></a></span>
                                                            <?php if($tournament->type=='doubles' && $reg->player2): ?>
                                                            <span class="ms-1 <?php echo e($player2Color); ?>">- <i
                                                                    class="bi bi-award"></i>
                                                                <a href="<?php echo e($reg->player2 ? route('players.show', $reg->player2->id) : '#'); ?>"
                                                                    class="text-decoration-none fw-bold"><?php echo e($reg->player2 ? $reg->player2->name : '?'); ?></a></span>
                                                            <?php endif; ?>
                                                            <div class="small text-secondary mt-1">
                                                                <i class="bi bi-geo-alt text-primary"></i> <?php echo e($reg->player1->location ?? ''); ?>

                                                            </div>
                                                            <div class="small text-secondary">
                                                                <i class="bi bi-people text-primary"></i> <?php echo e($reg->player1 ?
                                                                number_format($reg->player1->doubles_score,2) : '?'); ?>

                                                                <?php if($tournament->type=='doubles' && $reg->player2): ?>
                                                                <span class="ms-2"><i
                                                                        class="bi bi-people text-primary"></i> <?php echo e($reg->player2 ?
                                                                    number_format($reg->player2->doubles_score,2) : '?'); ?></span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                        <div class="text-end">
                                                            <?php if($reg->status=='approved'): ?>
                                                            <span
                                                                class="badge bg-success bg-opacity-75 text-white px-3 py-1">Đã
                                                                duyệt</span>
                                                            <?php elseif($reg->status=='pending'): ?>
                                                            <span
                                                                class="badge bg-warning bg-opacity-75 text-dark px-3 py-1">Đang
                                                                chờ duyệt</span>
                                                            <?php else: ?>
                                                            <span
                                                                class="badge bg-danger bg-opacity-75 text-white px-3 py-1">Không
                                                                duyệt</span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Countdown script & Player search script -->
        <script>
            <?php if($tournamentStatus == 'upcoming'): ?>
            function countdownTimer() {
                const eventTime = new Date("<?php echo e($tournament->start_date->format('Y-m-d H:i:s')); ?>").getTime();
                const now = new Date().getTime();
                let distance = eventTime - now;
                if (distance < 0) {
                    document.getElementById('countdown').innerHTML = '<span class="text-success">Giải đấu đã bắt đầu!</span>';
                    // Optionally, hide the register button if it's past the start time
                    // document.querySelector('[data-bs-target="#registerModal"]').style.display = 'none';
                    return;
                }
                const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                const seconds = Math.floor((distance % (1000 * 60)) / 1000);
                document.getElementById('countdown').innerText = `${days.toString().padStart(2,'0')} ngày ${hours.toString().padStart(2,'0')} giờ ${minutes.toString().padStart(2,'0')} phút ${seconds.toString().padStart(2,'0')} giây`;
            }
            countdownTimer();
            setInterval(countdownTimer, 1000);
            <?php endif; ?>
            // Expose tournament settings to JS for client-side validation
            const TOURNAMENT_SETTINGS = {
                type: '<?php echo e($tournament->type); ?>',
                skill_point: <?php echo e(isset($tournament->skill_point) ? number_format($tournament->skill_point, 2, '.', '') : '0'); ?>,
                skill_tolerance: <?php echo e(isset($tournament->skill_tolerance) ? number_format($tournament->skill_tolerance, 2, '.', '') : '0'); ?>,
                max_pairs: <?php echo e($tournament->max_pairs ?? 0); ?>

            };

            // Player search logic
            function searchPlayer(input, infoDiv, inputId, otherInputId) {
                if (!input || input.length < 3) {
                    infoDiv.innerHTML = '';
                    document.getElementById(inputId).classList.remove('is-valid');
                    document.getElementById(inputId).classList.remove('is-invalid');
                    return;
                }
                let type = 'name'; // default
                if (/^\d+$/.test(input) && input.length >= 8) {
                    type = 'phone';
                } else if (input.includes('@')) {
                    type = 'email';
                }
                fetch(`/players/api/check?${type}=${encodeURIComponent(input)}`)
                    .then(res => res.json())
                    .then(data => {
                        if (Array.isArray(data) && data.length > 0) {
                            let html = '<div class="list-group">';
                            data.forEach(player => {
                                let avatarHtml = '';
                                if (player.avatar) {
                                    let avatarSrc = player.avatar.startsWith('/') ? player.avatar : ('/' + player.avatar);
                                    avatarHtml = `<img src='${avatarSrc}' alt='avatar' style='width:32px;height:32px;border-radius:50%;object-fit:cover;margin-right:8px;'>`;
                                } else {
                                    avatarHtml = `<span class='avatar bg-secondary text-white rounded-circle d-flex align-items-center justify-content-center' style='width:32px;height:32px;margin-right:8px;'>${player.name ? player.name.charAt(0) : '?'}</span>`;
                                }
                                html += `<button type="button" class="list-group-item list-group-item-action p-2 d-flex align-items-center player-suggestion" data-phone="${player.phone}" data-input-id="${inputId}" data-other-input-id="${otherInputId || ''}">`;
                                html += avatarHtml;
                                html += `<div><b>${player.name ?? ''}</b> (${player.phone ?? ''})`;
                                if (player.email) {
                                    html += `<br><small class="text-muted">${player.email}</small>`;
                                }
                                html += `<br><small>Điểm đôi: ${typeof player.doubles_score !== 'undefined' ? player.doubles_score : '-'} | Điểm đơn: ${typeof player.singles_score !== 'undefined' ? player.singles_score : '-'}</small></div>`;
                                html += '</button>';
                            });
                            html += '</div>';
                            infoDiv.innerHTML = html;

                            // Add click handlers for suggestions
                            document.querySelectorAll('.player-suggestion').forEach(btn => {
                                btn.addEventListener('click', function() {
                                    const selectedPhone = this.getAttribute('data-phone');
                                    const inputElement = document.getElementById(this.getAttribute('data-input-id'));
                                    const otherInputId = this.getAttribute('data-other-input-id');

                                    inputElement.value = selectedPhone;
                                    inputElement.classList.add('is-valid');
                                    inputElement.classList.remove('is-invalid');

                                    // Clear suggestions
                                    infoDiv.innerHTML = '';

                                    // Check for duplicate phone numbers
                                    if (otherInputId && document.getElementById(otherInputId).value === selectedPhone) {
                                        infoDiv.innerHTML = '<div class="alert alert-danger p-2 mt-1">Không được chọn trùng số điện thoại!</div>';
                                        inputElement.classList.remove('is-valid');
                                        inputElement.classList.add('is-invalid');
                                    }
                                });
                            });

                            document.getElementById(inputId).classList.remove('is-valid');
                            document.getElementById(inputId).classList.remove('is-invalid');
                        } else {
                            infoDiv.innerHTML = `<div class='alert alert-danger p-2 mb-1'>Không tìm thấy VĐV này!</div>`;
                            document.getElementById(inputId).classList.remove('is-valid');
                            document.getElementById(inputId).classList.add('is-invalid');
                        }
                    })
                    .catch(() => {
                        infoDiv.innerHTML = `<div class='alert alert-danger p-2 mb-1'>Không tìm thấy VĐV này!</div>`;
                        document.getElementById(inputId).classList.remove('is-valid');
                        document.getElementById(inputId).classList.add('is-invalid');
                    });
            }

            document.addEventListener('DOMContentLoaded', function() {
                const player1Input = document.getElementById('player1_phone');
                const player2Input = document.getElementById('player2_phone');
                const player1Info = document.getElementById('player1_info');
                const player2Info = document.getElementById('player2_info');
                if (player1Input) {
                    player1Input.addEventListener('input', function() {
                        searchPlayer(this.value, player1Info, 'player1_phone', player2Input ? 'player2_phone' : null);
                    });
                }
                if (player2Input) {
                    player2Input.addEventListener('input', function() {
                        searchPlayer(this.value, player2Info, 'player2_phone', 'player1_phone');
                    });
                }
                // Ngăn submit nếu chưa hợp lệ
                    // Helper to render inline alerts inside the modal
                    function showInlineAlert(message, type = 'danger') {
                        const container = document.getElementById('registerAlerts');
                        if (!container) return;
                        container.innerHTML = `<div class="alert alert-${type} alert-dismissible" role="alert">` +
                            `<div>${message}</div>` +
                            `<button type="button" class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="Close"></button>` +
                            `</div>`;
                    }

                    document.getElementById('registerForm').addEventListener('submit', function(e) {
                        let valid1 = player1Input && player1Input.classList.contains('is-valid');
                        let valid2 = !player2Input || player2Input.classList.contains('is-valid');
                        if (!valid1 || !valid2) {
                            e.preventDefault();
                            showInlineAlert('Vui lòng nhập đúng thông tin và chọn VĐV hợp lệ!', 'danger');
                            return;
                        }

                        // Client-side score validation: fetch player data (if not already loaded by search) to calculate combined score
                        const phone1 = player1Input.value.trim();
                        const phone2 = player2Input ? player2Input.value.trim() : null;
                        const fetchPlayer = (phone) => fetch(`/players/api/check?phone=${encodeURIComponent(phone)}`).then(r => r.json()).catch(() => null);

                        e.preventDefault(); // perform async validation first
                        Promise.all([fetchPlayer(phone1), phone2 ? fetchPlayer(phone2) : Promise.resolve(null)])
                            .then(([p1, p2]) => {
                                // If any fetch returned null (network error or not found), fallback to server-side validation by submitting the form
                                if (!p1 || (TOURNAMENT_SETTINGS.type === 'doubles' && !p2)) {
                                    // If the fetch succeeded but returned not found (no id), show inline; if it was a network error (null), submit and let server handle
                                    if (p1 === null || (TOURNAMENT_SETTINGS.type === 'doubles' && p2 === null)) {
                                        // network error -> submit to server to validate
                                        this.submit();
                                        return;
                                    }
                                    showInlineAlert('Không tìm thấy thông tin VĐV. Vui lòng kiểm tra lại thông tin.', 'danger');
                                    return;
                                }
                                const p1Singles = parseFloat(p1.singles_score || 0);
                                const p1Doubles = parseFloat(p1.doubles_score || 0);
                                const p2Doubles = p2 ? parseFloat(p2.doubles_score || 0) : 0;
                                const scoreSum = TOURNAMENT_SETTINGS.type === 'doubles' ? (p1Doubles + p2Doubles) : p1Singles;
                                const skillPoint = parseFloat(TOURNAMENT_SETTINGS.skill_point || 0);
                                const tolerance = parseFloat(TOURNAMENT_SETTINGS.skill_tolerance || 0);
                                const maxScore = skillPoint + tolerance;
                                if (scoreSum > maxScore) {
                                    showInlineAlert('Không thể đăng ký: tổng trình vượt giới hạn (tối đa: ' + maxScore.toFixed(2) + ').', 'danger');
                                    return;
                                }

                                // All good on client -> submit
                                this.submit();
                            })
                            .catch(() => {
                                // On unexpected fetch error, fallback to server-side validation
                                this.submit();
                            });
                    });
            });
        </script>
        <script>
            // If server returned errors or success, open the modal and copy server messages into #registerAlerts
            document.addEventListener('DOMContentLoaded', function() {
                const hasServerErrors = <?php echo e($errors->any() ? 'true' : 'false'); ?>;
                // Success messages are shown globally in the layout; only auto-open modal when there are server-side errors
                if (hasServerErrors) {
                    const registerModalEl = document.getElementById('registerModal');
                    if (registerModalEl) {
                        const modal = new bootstrap.Modal(registerModalEl);
                        modal.show();
                        const container = document.getElementById('registerAlerts');
                        if (container) {
                            let html = '';
                            <?php if($errors->any()): ?>
                                html += `<div class="alert alert-danger"><ul class="mb-0">`;
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    html += `<li><?php echo e(Js::from($error)); ?></li>`;
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                html += `</ul></div>`;
                            <?php endif; ?>
                            // success is handled by the global layout flash alert
                            container.innerHTML = html;
                        }
                    }
                }
            });
        </script>

        <!-- Tabs for schedule, standings etc. -->
        <div class="mt-5">
            <ul class="nav nav-tabs nav-fill mb-4" id="tournamentPublicTab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="public-info-tab" data-bs-toggle="tab"
                        data-bs-target="#public-info" type="button" role="tab" aria-controls="public-info"
                        aria-selected="true"><i class="bi bi-info-circle-fill"></i> Thông Tin Chung</button>
                </li>
                <?php if($tournament->groups->isNotEmpty()): ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="public-groups-tab" data-bs-toggle="tab" data-bs-target="#public-groups"
                        type="button" role="tab" aria-controls="public-groups" aria-selected="false"><i
                            class="bi bi-people-fill"></i> Bảng Đấu & Lịch Thi Đấu</button>
                </li>
                <?php endif; ?>
                <?php
                $hasPlayoffs = (isset($roundOf64) && $roundOf64->matches->isNotEmpty()) ||
                (isset($roundOf32) && $roundOf32->matches->isNotEmpty()) ||
                (isset($roundOf16) && $roundOf16->matches->isNotEmpty()) ||
                (isset($quarterFinals) && $quarterFinals->matches->isNotEmpty()) ||
                (isset($semiFinals) && $semiFinals->matches->isNotEmpty()) ||
                (isset($final) && $final->matches->isNotEmpty());
                ?>
                <?php if($hasPlayoffs): ?>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="public-bracket-tab" data-bs-toggle="tab"
                        data-bs-target="#public-bracket" type="button" role="tab" aria-controls="public-bracket"
                        aria-selected="false"><i class="bi bi-diagram-3-fill"></i> Nhánh Đấu</button>
                </li>
                <?php endif; ?>
            </ul>

            <div class="tab-content" id="tournamentPublicTabContent">
                <!-- General Info Tab -->
                <div class="tab-pane fade show active" id="public-info" role="tabpanel"
                    aria-labelledby="public-info-tab">
                    <div class="card shadow-sm">
                        <div class="card-body">
                            <h3 class="card-title text-primary"><i class="bi bi-card-text me-2"></i>Mô tả giải đấu</h3>
                            <div class="tournament-description">
                                <?php if($tournament->description): ?>
                                <?php echo nl2br($tournament->description); ?>

                                <?php else: ?>
                                <p class="text-muted fst-italic">Chưa có mô tả chi tiết cho giải đấu này.</p>
                                <?php endif; ?>
                            </div>
                            <h3 class="card-title text-primary mt-4"><i class="bi bi-journal-text me-2"></i>Thể lệ giải
                                đấu</h3>
                            <div class="tournament-rules">
                                <?php if($tournament->rules): ?>
                                <?php echo nl2br($tournament->rules); ?>

                                <?php else: ?>
                                <p class="text-muted fst-italic">Chưa có thể lệ chi tiết cho giải đấu này.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Groups & Schedule Tab -->
                <?php if($tournament->groups->isNotEmpty()): ?>
                <div class="tab-pane fade" id="public-groups" role="tabpanel" aria-labelledby="public-groups-tab">
                    <?php
                    // Helper function để tạo avatar
                    function renderPlayerAvatar($player) {
                    if (!$player) {
                    return '<div class="avatar-placeholder"
                        style="background-color: #6c757d; width: 40px; height: 40px; border-radius: 50%; border: 2px solid rgba(255, 255, 255, 0.06); box-shadow: 0 2px 6px rgba(0, 0, 0, .3); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;">
                        ?</div>';
                    }

                    // Lấy avatar từ player object
                    $avatarPath = null;
                    if (isset($player->avatar) && $player->avatar) {
                    $avatarPath = $player->avatar;
                    } elseif (property_exists($player, 'avatar') && $player->avatar) {
                    $avatarPath = $player->avatar;
                    }

                    // Nếu có avatar và không rỗng
                    if ($avatarPath && trim($avatarPath) !== '' && trim($avatarPath) !== 'null') {
                    return '<img src="'.asset($avatarPath).'" alt="Avatar" class="avatar"
                        style="width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 2px solid rgba(255, 255, 255, 0.06); box-shadow: 0 2px 6px rgba(0, 0, 0, .3);" />';
                    }

                    // Fallback: tạo avatar từ tên
                    $name = $player->name ?? 'Player';
                    $initial = mb_strtoupper(mb_substr($name, 0, 1, 'UTF-8'));
                    $playerHash = isset($player->id) ? crc32($player->id) : crc32($name . time());
                    $bgColor = 'hsl('. abs($playerHash) % 360 .', 50%, 50%)';

                    return '<div class="avatar-placeholder"
                        style="background-color: '.$bgColor.'; width: 40px; height: 40px; border-radius: 50%; border: 2px solid rgba(255, 255, 255, 0.06); box-shadow: 0 2px 6px rgba(0, 0, 0, .3); display: flex; align-items: center; justify-content: center; color: white; font-weight: bold;">
                        '.$initial.'</div>';
                    }
                    ?>

                    <h2 class="text-primary fw-bold mb-3">Danh sách các Bảng đấu</h2>
                    <div class="row">
                        <?php $__currentLoopData = $tournament->groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 mb-4">
                            <div class="card shadow-sm">
                                <div class="card-header bg-dark text-white">
                                    <h5 class="mb-0">Bảng <?php echo e($group->name); ?></h5>
                                </div>
                                <ul class="list-group list-group-flush">
                                    <?php $__empty_1 = true; $__currentLoopData = $group->pairs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <li class="list-group-item group-pair-item">
                                        <div class="group-pair-content">
                                            <div class="team-avatars">
                                                <?php if($pair->player1): ?>
                                                <div class="avatar-wrapper"
                                                    style="margin-right: <?php echo e($tournament->type == 'doubles' && $pair->player2 ? '-10px' : '0'); ?>; z-index: 2; position: relative;">
                                                    <?php echo renderPlayerAvatar($pair->player1); ?>

                                                </div>
                                                <?php endif; ?>
                                                <?php if($tournament->type == 'doubles' && $pair->player2): ?>
                                                <div class="avatar-wrapper" style="z-index: 1; position: relative;">
                                                    <?php echo renderPlayerAvatar($pair->player2); ?>

                                                </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="player-names">
                                                <?php if($pair->player1): ?>
                                                <span class="player-number-tag p1">1</span>
                                                <a href="<?php echo e($pair->player1 ? route('players.show', $pair->player1->id) : '#'); ?>"
                                                    class="text-decoration-none fw-bold"><?php echo e($pair->player1->name); ?></a>
                                                <?php endif; ?>
                                                <?php if($tournament->type == 'doubles' && $pair->player2): ?>
                                                & <span class="player-number-tag p2">2</span>
                                                <a href="<?php echo e($pair->player2 ? route('players.show', $pair->player2->id) : '#'); ?>"
                                                    class="text-decoration-none fw-bold"><?php echo e($pair->player2->name); ?></a>
                                                <?php else: ?>
                                                
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <li class="list-group-item text-muted">Chưa có cặp đấu nào trong bảng này.</li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <?php if($groupRounds->isNotEmpty()): ?>
                    <hr class="my-5">
                    <?php endif; ?>

                    <?php if($groupRounds->isNotEmpty()): ?>
                    <h2 class="text-primary fw-bold mb-3">Lịch thi đấu Vòng Bảng</h2>
                    <?php
                    // Group matches by tournament groups
                    if (!function_exists('computeRoundRobinOrder')) {
                    function computeRoundRobinOrder(array $teamIds): array {
                    $teams = array_values($teamIds);
                    $rounds = [];
                    if (count($teams) % 2 === 1) { $teams[] = null; }
                    $n = count($teams);
                    if ($n < 2) return $rounds; $half=intval($n/2); $rotation=$teams; for ($r=0; $r < $n - 1; $r++) {
                        $pairs=[]; for ($i=0; $i < $half; $i++) { $t1=$rotation[$i]; $t2=$rotation[$n - 1 - $i]; if ($t1
                        !==null && $t2 !==null) { $pairs[]=[$t1,$t2]; } } $rounds[]=$pairs; $last=array_pop($rotation);
                        array_splice($rotation, 1, 0, [$last]); } return $rounds; } } $matchesByGroup=[];
                        $orderedByGroup=[]; foreach($tournament->groups as $group) {
                        $groupPairIds = $group->pairs->pluck('id');
                        $groupMatches = collect();
                        foreach($groupRounds as $round) {
                        $roundMatches = $round->matches->filter(function($match) use ($groupPairIds) {
                        return $groupPairIds->contains($match->pair1_id) && $groupPairIds->contains($match->pair2_id);
                        });
                        $groupMatches = $groupMatches->merge($roundMatches);
                        }
                        if($groupMatches->isNotEmpty()) {
                        $matchesByGroup[$group->name] = $groupMatches;
                        // Build ordered entries using the circle method
                        $pairIds = $group->pairs->pluck('id')->values()->all();
                        $rrRounds = computeRoundRobinOrder($pairIds);
                        $index = [];
                        foreach ($groupMatches as $m) {
                        if ($m->pair1_id && $m->pair2_id) {
                        $a = min($m->pair1_id, $m->pair2_id);
                        $b = max($m->pair1_id, $m->pair2_id);
                        $index[$a.'-'.$b] = $m;
                        }
                        }
                        $entries = [];
                        $seen = [];
                        foreach ($rrRounds as $rid => $pairs) {
                        foreach ($pairs as $p) {
                        [$a,$b] = $p;
                        $key = min($a,$b).'-'.max($a,$b);
                        if (isset($index[$key])) {
                        $m = $index[$key];
                        $entries[] = ['round' => $rid+1, 'match' => $m];
                        $seen[$m->id] = true;
                        }
                        }
                        }
                        foreach ($groupMatches->sortBy('id') as $m) {
                        if (!isset($seen[$m->id])) {
                        $entries[] = ['round' => null, 'match' => $m];
                        }
                        }
                        $orderedByGroup[$group->name] = $entries;
                        }
                        }
                        ?>

                        <?php $__currentLoopData = $orderedByGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $ordered): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-primary text-white">
                                <h5><i class="bi bi-grid-3x3"></i> Bảng <?php echo e($groupName); ?> - Vòng Bảng</h5>
                                <small class="text-light"><?php echo e(count($ordered)); ?> trận đấu</small>
                            </div>
                            <div class="card-body">
                                <?php $__prevRound = null; ?>
                                <?php $__empty_1 = true; $__currentLoopData = $ordered; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $__entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php $match = $__entry['match']; $__roundNo = $__entry['round']; ?>
                                <?php if($__roundNo !== null && $__roundNo !== $__prevRound): ?>
                                <div class="mt-2 mb-2">
                                    <span class="badge bg-secondary">Lượt <?php echo e($__roundNo); ?></span>
                                </div>
                                <?php $__prevRound = $__roundNo; ?>
                                <?php endif; ?>
                                <div class="match-card">
                                    <?php
                                    $scoresArray = $match->score ? explode('-', $match->score) : [0, 0];
                                    $scores = [($scoresArray[0] ?? 0), ($scoresArray[1] ?? 0)];
                                    $status = $match->status ?? 'Chưa bắt đầu';
                                    $color = 'secondary'; $icon = 'clock';
                                    if($status == 'Hoàn thành') { $color = 'success'; $icon = 'check-circle'; }
                                    elseif($status == 'Đang diễn ra') { $color = 'warning'; $icon = 'play-circle'; }
                                    elseif($status == 'Tạm hoãn') { $color = 'info'; $icon = 'pause-circle'; }
                                    elseif($status == 'Bị hủy') { $color = 'danger'; $icon = 'x-circle'; }
                                    ?>
                                    <div class="row align-items-center g-2">
                                        <div class="col-12 mb-2">
                                            <span class="badge bg-<?php echo e($color); ?> px-3 py-2"><i
                                                    class="bi bi-<?php echo e($icon); ?>-fill"></i> <?php echo e($status); ?></span>
                                        </div>
                                        <div class="col-5">
                                            <div class="match-team-info">
                                                <div class="team-avatars">
                                                    <?php if($match->pair1 && $match->pair1->player1): ?>
                                                    <div
                                                        style="margin-right: <?php echo e($tournament->type == 'doubles' && $match->pair1->player2 ? '-10px' : '0'); ?>; z-index: 2; position: relative;">
                                                        <?php echo renderPlayerAvatar($match->pair1->player1); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                    <?php if($tournament->type == 'doubles' && $match->pair1 &&
                                                    $match->pair1->player2): ?>
                                                    <div style="z-index: 1; position: relative;">
                                                        <?php echo renderPlayerAvatar($match->pair1->player2); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="team-name">
                                                    <?php if($match->pair1): ?>
                                                    <?php if($match->pair1->player1): ?>
                                                    <span class="player-number-tag p1">1</span>
                                                    <a href="<?php echo e($match->pair1 && $match->pair1->player1 ? route('players.show', $match->pair1->player1->id) : '#'); ?>"
                                                        class="text-decoration-none fw-bold"><?php echo e($match->pair1->player1->name); ?></a>
                                                    <?php endif; ?>
                                                    <?php if($tournament->type == 'doubles' && $match->pair1->player2): ?>
                                                    & <span class="player-number-tag p2">2</span>
                                                    <a href="<?php echo e($match->pair1 && $match->pair1->player2 ? route('players.show', $match->pair1->player2->id) : '#'); ?>"
                                                        class="text-decoration-none fw-bold"><?php echo e($match->pair1->player2->name); ?></a>
                                                    <?php endif; ?>
                                                    <?php else: ?>
                                                    Chưa xác định
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-2 text-center">
                                            <div class="d-flex justify-content-center align-items-center">
                                                <div class="score-input-display"><?php echo e($scores[0]); ?></div>
                                                <span class="px-2 fs-4">-</span>
                                                <div class="score-input-display"><?php echo e($scores[1]); ?></div>
                                            </div>
                                        </div>
                                        <div class="col-5">
                                            <div class="match-team-info">
                                                <div class="team-avatars">
                                                    <?php if($match->pair2 && $match->pair2->player1): ?>
                                                    <div
                                                        style="margin-right: <?php echo e($tournament->type == 'doubles' && $match->pair2->player2 ? '-10px' : '0'); ?>; z-index: 2; position: relative;">
                                                        <?php echo renderPlayerAvatar($match->pair2->player1); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                    <?php if($tournament->type == 'doubles' && $match->pair2 &&
                                                    $match->pair2->player2): ?>
                                                    <div style="z-index: 1; position: relative;">
                                                        <?php echo renderPlayerAvatar($match->pair2->player2); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="team-name">
                                                    <?php if($match->pair2): ?>
                                                    <?php if($match->pair2->player1): ?>
                                                    <span class="player-number-tag p1">1</span>
                                                    <a href="<?php echo e($match->pair2 && $match->pair2->player1 ? route('players.show', $match->pair2->player1->id) : '#'); ?>"
                                                        class="text-decoration-none fw-bold"><?php echo e($match->pair2->player1->name); ?></a>
                                                    <?php endif; ?>
                                                    <?php if($tournament->type == 'doubles' && $match->pair2->player2): ?>
                                                    & <span class="player-number-tag p2">2</span>
                                                    <a href="<?php echo e($match->pair2 && $match->pair2->player2 ? route('players.show', $match->pair2->player2->id) : '#'); ?>"
                                                        class="text-decoration-none fw-bold"><?php echo e($match->pair2->player2->name); ?></a>
                                                    <?php endif; ?>
                                                    <?php else: ?>
                                                    Chưa xác định
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted">Chưa có trận đấu nào trong bảng này.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                        
                        <?php
                        $playoffRounds = [];

                        // Thêm các vòng playoff theo thứ tự từ lớn đến nhỏ
                        if(isset($roundOf64) && $roundOf64->matches->isNotEmpty()) {
                        $playoffRounds[] = ['data' => $roundOf64, 'name' => 'Vòng 1/64', 'color' => 'primary'];
                        }
                        if(isset($roundOf32) && $roundOf32->matches->isNotEmpty()) {
                        $playoffRounds[] = ['data' => $roundOf32, 'name' => 'Vòng 1/32', 'color' => 'primary'];
                        }
                        if(isset($roundOf16) && $roundOf16->matches->isNotEmpty()) {
                        $playoffRounds[] = ['data' => $roundOf16, 'name' => 'Vòng 1/16', 'color' => 'warning'];
                        }
                        if(isset($quarterFinals) && $quarterFinals->matches->isNotEmpty()) {
                        $playoffRounds[] = ['data' => $quarterFinals, 'name' => 'Tứ kết', 'color' => 'warning'];
                        }
                        if(isset($semiFinals) && $semiFinals->matches->isNotEmpty()) {
                        $playoffRounds[] = ['data' => $semiFinals, 'name' => 'Bán kết', 'color' => 'info'];
                        }
                        if(isset($final) && $final->matches->isNotEmpty()) {
                        $playoffRounds[] = ['data' => $final, 'name' => 'Chung kết', 'color' => 'success'];
                        }
                        if(isset($thirdPlace) && $thirdPlace->matches->isNotEmpty()) {
                        $playoffRounds[] = ['data' => $thirdPlace, 'name' => 'Tranh hạng 3', 'color' => 'secondary'];
                        }
                        ?>

                        <?php if(!empty($playoffRounds)): ?>
                        <hr class="my-5">
                        <h2 class="text-primary fw-bold mb-3">Lịch thi đấu Vòng Play-off</h2>
                        <?php $__currentLoopData = $playoffRounds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $playoffRound): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="card shadow-sm mb-4">
                            <div
                                class="card-header bg-<?php echo e($playoffRound['color']); ?> <?php echo e(in_array($playoffRound['color'], ['success', 'primary', 'dark']) ? 'text-white' : 'text-dark'); ?>">
                                <h5><?php echo e($playoffRound['name']); ?></h5>
                            </div>
                            <div class="card-body">
                                <?php $__empty_1 = true; $__currentLoopData = $playoffRound['data']->matches->sortBy('id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="match-card">
                                    <?php
                                    $scoresArray = $match->score ? explode('-', $match->score) : [0, 0];
                                    $scores = [($scoresArray[0] ?? 0), ($scoresArray[1] ?? 0)];
                                    $status = $match->status ?? 'Chưa bắt đầu';
                                    $color = 'secondary'; $icon = 'clock';
                                    if($status == 'Hoàn thành') { $color = 'success'; $icon = 'check-circle'; }
                                    elseif($status == 'Đang diễn ra') { $color = 'warning'; $icon = 'play-circle'; }
                                    elseif($status == 'Tạm hoãn') { $color = 'info'; $icon = 'pause-circle'; }
                                    elseif($status == 'Bị hủy') { $color = 'danger'; $icon = 'x-circle'; }
                                    elseif($status == 'Bye') { $color = 'secondary'; $icon = 'fast-forward'; }
                                    ?>
                                    <div class="row align-items-center g-2">
                                        <div class="col-12 mb-2">
                                            <span class="badge bg-<?php echo e($color); ?> px-3 py-2"><i
                                                    class="bi bi-<?php echo e($icon); ?>-fill"></i> <?php echo e($status); ?></span>
                                        </div>
                                        <div class="col-5">
                                            <div class="match-team-info">
                                                <div class="team-avatars">
                                                    <?php if($match->pair1 && $match->pair1->player1): ?>
                                                    <div
                                                        style="margin-right: <?php echo e($tournament->type == 'doubles' && $match->pair1->player2 ? '-10px' : '0'); ?>; z-index: 2; position: relative;">
                                                        <?php echo renderPlayerAvatar($match->pair1->player1); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                    <?php if($tournament->type == 'doubles' && $match->pair1 &&
                                                    $match->pair1->player2): ?>
                                                    <div style="z-index: 1; position: relative;">
                                                        <?php echo renderPlayerAvatar($match->pair1->player2); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="team-name">
                                                    <?php if($match->pair1): ?>
                                                    <?php if($match->pair1->player1): ?>
                                                    <span class="player-number-tag p1">1</span>
                                                    <a href="<?php echo e($match->pair1 && $match->pair1->player1 ? route('players.show', $match->pair1->player1->id) : '#'); ?>"
                                                        class="text-decoration-none fw-bold"><?php echo e($match->pair1->player1->name); ?></a>
                                                    <?php endif; ?>
                                                    <?php if($tournament->type == 'doubles' && $match->pair1->player2): ?>
                                                    & <span class="player-number-tag p2">2</span>
                                                    <a href="<?php echo e($match->pair1 && $match->pair1->player2 ? route('players.show', $match->pair1->player2->id) : '#'); ?>"
                                                        class="text-decoration-none fw-bold"><?php echo e($match->pair1->player2->name); ?></a>
                                                    <?php endif; ?>
                                                    <?php else: ?>
                                                    TBD
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-2 text-center">
                                            <div class="d-flex justify-content-center align-items-center">
                                                <div class="score-input-display"><?php echo e($scores[0]); ?></div>
                                                <span class="px-2 fs-4">-</span>
                                                <div class="score-input-display"><?php echo e($scores[1]); ?></div>
                                            </div>
                                        </div>
                                        <div class="col-5">
                                            <div class="match-team-info">
                                                <div class="team-avatars">
                                                    <?php if($match->pair2 && $match->pair2->player1): ?>
                                                    <div
                                                        style="margin-right: <?php echo e($tournament->type == 'doubles' && $match->pair2->player2 ? '-10px' : '0'); ?>; z-index: 2; position: relative;">
                                                        <?php echo renderPlayerAvatar($match->pair2->player1); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                    <?php if($tournament->type == 'doubles' && $match->pair2 &&
                                                    $match->pair2->player2): ?>
                                                    <div style="z-index: 1; position: relative;">
                                                        <?php echo renderPlayerAvatar($match->pair2->player2); ?>

                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="team-name">
                                                    <?php if($match->pair2): ?>
                                                    <?php if($match->pair2->player1): ?>
                                                    <span class="player-number-tag p1">1</span>
                                                    <a href="<?php echo e($match->pair2 && $match->pair2->player1 ? route('players.show', $match->pair2->player1->id) : '#'); ?>"
                                                        class="text-decoration-none fw-bold"><?php echo e($match->pair2->player1->name); ?></a>
                                                    <?php endif; ?>
                                                    <?php if($tournament->type == 'doubles' && $match->pair2->player2): ?>
                                                    & <span class="player-number-tag p2">2</span>
                                                    <a href="<?php echo e($match->pair2 && $match->pair2->player2 ? route('players.show', $match->pair2->player2->id) : '#'); ?>"
                                                        class="text-decoration-none fw-bold"><?php echo e($match->pair2->player2->name); ?></a>
                                                    <?php endif; ?>
                                                    <?php else: ?>
                                                    TBD
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-center text-muted">Chưa có trận đấu nào trong vòng này.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                        <?php if(!empty($standingsByGroup) && $tournament->groups->count() > 0 &&
                        $tournament->rounds->where('type', 'round_robin')->count() > 0): ?>
                        <h2 class="text-primary fw-bold mb-3 mt-5">Bảng xếp hạng Vòng Bảng</h2>
                        <div class="row">
                            <?php $__currentLoopData = $standingsByGroup; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupName => $standings): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-6 mb-4" wire:key="standings-group-<?php echo e($groupName); ?>">
                                <div class="card">
                                    <div class="card-header bg-dark text-white">
                                        <h5>Bảng <?php echo e($groupName); ?></h5>
                                    </div>
                                    <div class="table-responsive standings-table-wrapper">
                                        <table class="table table-hover standings-table mb-0">
                                            <thead class="table-light">
                                                <tr>
                                                    <th scope="col">#</th>
                                                    <th scope="col">Cặp đấu</th>
                                                    <th scope="col" class="text-center">ST</th>
                                                    <th scope="col" class="text-center">T</th>
                                                    <th scope="col" class="text-center">B</th>
                                                    <th scope="col" class="text-center">HS</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__empty_1 = true; $__currentLoopData = $standings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $standing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <?php
                                                $rowClass = '';
                                                $badge = null;
                                                if ($index === 0) { $rowClass = 'standing-top-1'; $badge = 'Nhất'; }
                                                elseif ($index === 1) { $rowClass = 'standing-top-2'; $badge = 'Nhì'; }
                                                elseif ($index === 2) { $rowClass = 'standing-top-3'; $badge = 'Ba'; }
                                                ?>
                                                <tr class="<?php echo e($rowClass); ?>">
                                                    <th scope="row"><?php echo e($index + 1); ?></th>
                                                    <td>
                                                        <?php if($tournament->type == 'doubles'): ?>
                                                        <span class="player-number-tag p1">1</span>
                                                        <?php echo e($standing['pair']->player1->name ?? 'N/A'); ?>

                                                        &
                                                        <span class="player-number-tag p2">2</span>
                                                        <?php echo e($standing['pair']->player2->name ?? 'N/A'); ?>

                                                        <?php else: ?>
                                                        <span class="player-number-tag p1">1</span>
                                                        <?php echo e($standing['pair']->player1->name ?? 'N/A'); ?>

                                                        <?php endif; ?>
                                                        <?php if($badge === 'Nhất'): ?>
                                                        <span class="standing-badge badge bg-success text-dark"><?php echo e($badge); ?></span>
                                                        <?php elseif($badge === 'Nhì'): ?>
                                                        <span class="standing-badge badge bg-warning text-dark"><?php echo e($badge); ?></span>
                                                        <?php elseif($badge === 'Ba'): ?>
                                                        <span class="standing-badge badge bg-danger text-dark"><?php echo e($badge); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td class="text-center"><?php echo e($standing['played']); ?></td>
                                                    <td class="text-center fw-bold text-success"><?php echo e($standing['wins']); ?>

                                                    </td>
                                                    <td class="text-center"><?php echo e($standing['losses']); ?></td>
                                                    <td class="text-center fw-bold"><?php echo e(($standing['points_for'] ?? 0) -
                                                        ($standing['points_against'] ?? 0)); ?></td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="6" class="text-center text-muted">Chưa có dữ liệu xếp
                                                        hạng
                                                        cho bảng này.</td>
                                                </tr>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>
                </div>
                <?php endif; ?>

                <!-- Bracket Tab -->
                <?php if($hasPlayoffs): ?>
                <div class="tab-pane fade" id="public-bracket" role="tabpanel" aria-labelledby="public-bracket-tab">
                    <?php echo $__env->make('tournaments.partials.bracket_view', [
                    'roundOf64' => $roundOf64 ?? null,
                    'roundOf32' => $roundOf32 ?? null,
                    'roundOf16' => $roundOf16 ?? null,
                    'quarterFinals' => $quarterFinals ?? null,
                    'semiFinals' => $semiFinals ?? null,
                    'final' => $final ?? null,
                    'thirdPlace' => $thirdPlace ?? null,
                    'tournament' => $tournament
                    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('layout_css'); ?>
<style>
    /* Bracket Styles from admin show view */
    .bracket {
        display: flex;
        justify-content: center;
        background-color: var(--secondary-bg);
        padding: 20px;
        border-radius: 8px;
        border: 1px solid var(--border-color);
        box-shadow: 0 12px 30px var(--shadow-dark);
    }

    .bracket-round {
        display: flex;
        flex-direction: column;
        justify-content: space-around;
        flex: 1;
    }

    .bracket-match {
        display: flex;
        flex-direction: column;
        justify-content: center;
        margin: 20px 10px;
        position: relative;
    }

    .bracket-pair {
        background: var(--card-bg);
        color: var(--text-primary);
        padding: 10px;
        margin: 5px 0;
        border-radius: 5px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border: 1px solid var(--border-color);
        border-left: 5px solid rgba(59, 130, 246, 0.6);
        min-width: 220px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.35);
    }

    .bracket-pair.winner {
        border-left-color: var(--success);
        font-weight: bold;
        background-color: rgba(16, 185, 129, 0.12);
    }

    .bracket-pair .score {
        font-weight: bold;
        color: var(--warning);
    }

    .final-rounds-container {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 2rem;
        margin-top: 2rem;
    }

    .final-match {
        background-color: var(--card-bg);
        border: 1px solid var(--border-color);
        padding: 20px;
        border-radius: 8px;
        min-width: 300px;
        display: flex;
        flex-direction: column;
        align-items: center;
        box-shadow: 0 14px 32px var(--shadow-dark);
    }

    .final-match .bracket-pair {
        width: 100%;
    }

    @media (max-width: 767.98px) {
        .bracket {
            flex-direction: column;
            align-items: stretch;
        }

        .bracket-round {
            margin-bottom: 2rem;
        }
    }

    .tournament-detail-page .list-group-item {
        background: rgba(255, 255, 255, 0.02);
        border: 1px solid transparent;
        border-radius: 0.75rem;
        transition: background 0.2s, border-color 0.2s, color 0.2s;
        color: var(--text-secondary);
    }

    .tournament-detail-page .list-group-item:hover {
        background: linear-gradient(135deg, rgba(59, 130, 246, 0.25) 0%, rgba(34, 211, 238, 0.1) 100%);
        color: var(--text-primary);
        border-color: rgba(59, 130, 246, 0.35);
    }

    /* Đảm bảo tên VĐV trong bảng đấu cũng đổi màu khi hover */
    #public-groups .list-group-item:hover .fw-bold {
        color: var(--text-primary) !important;
    }

    /* Group pairs responsive layout */
    .group-pair-item {
        padding: 1rem;
    }

    .group-pair-content {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .team-avatars {
        display: flex;
        align-items: center;
        flex-shrink: 0;
    }

    .player-names {
        flex: 1;
        font-weight: bold;
    }

    /* Responsive cho màn hình nhỏ */
    @media (max-width: 767.98px) {
        .group-pair-content {
            flex-direction: column;
            text-align: center;
            gap: 0.75rem;
        }

        .team-avatars {
            justify-content: center;
            margin-bottom: 0.5rem;
        }

        .player-names {
            text-align: center;
        }
    }

    @media (max-width: 575.98px) {
        .group-pair-item {
            padding: 0.75rem;
        }

        .group-pair-content {
            gap: 0.5rem;
        }

        .team-avatars {
            margin-bottom: 0.25rem;
        }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('layout_script'); ?>
<script>
    // Handle tab persistence on page reload
    document.addEventListener('DOMContentLoaded', function() {
        var triggerTabList = [].slice.call(document.querySelectorAll('#tournamentPublicTab button'));
        triggerTabList.forEach(function(triggerEl) {
            var tabTrigger = new bootstrap.Tab(triggerEl);

            triggerEl.addEventListener('click', function(event) {
                event.preventDefault();
                localStorage.setItem('activeTournamentPublicTab', this.getAttribute('data-bs-target'));
                tabTrigger.show();
            });
        });

        var activeTab = localStorage.getItem('activeTournamentPublicTab');
        if (activeTab) {
            var activeTabEl = document.querySelector('button[data-bs-target="' + activeTab + '"]');
            if (activeTabEl) {
                new bootstrap.Tab(activeTabEl).show();
            }
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/tournaments/show.blade.php ENDPATH**/ ?>