<?php $__env->startSection('title', $player->name); ?>

<?php $__env->startSection('content'); ?>
<style>
    /* Page-scoped modal fixes to avoid conflicts with global app.css */
    #editAvatarModal.modal,
    #galleryModal.modal {
        z-index: 2200 !important;
        /* stay above backdrop */
    }

    /* Bootstrap interaction model: dialog container off, content on */
    #editAvatarModal.modal.show,
    #galleryModal.modal.show {
        pointer-events: auto;
    }

    #editAvatarModal .modal-dialog,
    #galleryModal .modal-dialog {
        pointer-events: none;
    }

    #editAvatarModal .modal-content,
    #galleryModal .modal-content {
        pointer-events: auto;
    }

    /* Ensure avatar modal surface is opaque and legible */
    #editAvatarModal .modal-content.player-modal {
        background: #111 !important;
        border: 1px solid rgba(255, 255, 255, 0.12) !important;
        color: #f7f7f7 !important;
    }

    #editAvatarModal .modal-header,
    #editAvatarModal .modal-footer {
        border-color: rgba(255, 255, 255, 0.12) !important;
    }

    /* Backdrop on this page: no blur, consistent dim, sit under modal */
    .modal-backdrop {
        z-index: 2150 !important;
        background: rgba(5, 5, 5, 0.75) !important;
        backdrop-filter: none !important;
    }

    /* Keep the white close icon visible regardless of theme */
    .btn-close-white {
        filter: invert(1) grayscale(100%) brightness(175%);
        opacity: .9;
    }

    .btn-close-white:hover,
    .btn-close-white:focus {
        opacity: 1;
    }

    /* Ensure the pencil button is always clickable above the avatar */
    .player-avatar-edit {
        z-index: 3;
        pointer-events: auto;
        width: 36px;
        height: 36px;
        padding: 0.35rem;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .player-avatar-wrapper {
        position: relative;
        z-index: 2;
    }

    /* Avoid avatar image intercepting clicks around the edit button */
    .player-profile-card img.player-avatar {
        pointer-events: none;
    }

    /* Icon size inside the button */
    .player-avatar-edit i {
        font-size: 0.95rem;
        line-height: 1;
    }

    /* Responsive layout for profile info on small screens */
    @media (max-width: 576px) {
        .player-profile-card .card-body {
            padding: 1rem;
        }

        .player-info-table {
            width: 100%;
        }

        .player-info-table tr {
            display: grid;
            grid-template-columns: 42% 58%;
            align-items: center;
            padding: 6px 0;
            border-bottom: 1px solid rgba(255, 255, 255, 0.06);
        }

        .player-info-table tr:last-child {
            border-bottom: 0;
        }

        .player-info-table td {
            padding: 2px 0 !important;
        }

        .player-info-table td:first-child {
            font-size: 0.85rem;
            color: var(--text-muted);
            font-weight: 500;
        }

        .player-info-table td:last-child {
            font-size: 0.95rem;
            font-weight: 600;
        }
    }

    /* Mobile tweaks: make the icon button more compact */
    @media (max-width: 576px) {
        .player-avatar-edit {
            width: 30px;
            height: 30px;
            padding: 0.25rem;
        }

        .player-avatar-edit i {
            font-size: 0.85rem;
        }
    }

    @media (max-width: 400px) {
        .player-avatar-edit {
            width: 28px;
            height: 28px;
            padding: 0.2rem;
        }

        .player-avatar-edit i {
            font-size: 0.8rem;
        }

        /* Stack label above value on very small screens */
        .player-info-table tr {
            grid-template-columns: 1fr;
        }

        .player-info-table td:first-child {
            margin-bottom: 2px;
        }
    }
</style>
<div class="container py-5">
    
    <?php if(session('avatar_success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle-fill me-2"></i><?php echo e(session('avatar_success')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <?php if(session('avatar_error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle-fill me-2"></i><?php echo e(session('avatar_error')); ?>

        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php endif; ?>

    <div class="row g-4">
        <div class="col-md-5">
            <div class="card shadow border mb-4 player-profile-card">
                <div class="card-body text-center">
                    <div class="d-flex flex-row justify-content-center align-items-center">
                        <div class="position-relative d-inline-block player-avatar-wrapper">
                            <?php if($player->avatar): ?>
                            <img src="<?php echo e(asset($player->avatar)); ?>" alt="Avatar"
                                class="rounded-circle border shadow player-avatar">
                            <?php else: ?>
                            <div class="rounded-circle player-avatar player-avatar--fallback">
                                <?php echo e(mb_strtoupper(mb_substr($player->name, 0, 1, 'UTF-8'), 'UTF-8')); ?>

                            </div>
                            <?php endif; ?>
                            <!-- Edit icon - chỉ hiển thị cho player có trạng thái chưa duyệt -->
                            <?php if($player->status == 0): ?>
                            <button type="button"
                                class="btn btn-sm position-absolute top-0 end-0 m-1 rounded-circle shadow player-avatar-edit"
                                data-bs-toggle="modal" data-bs-target="#editAvatarModal" title="Chỉnh sửa avatar">
                                <i class="bi bi-pencil"></i>
                            </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!-- Modal Edit Avatar moved below to avoid stacking-context issues -->
                    <h1 class="h4 fw-bold mb-2"><?php echo e($player->name); ?></h1>
                    <div class="mb-2"><span class="badge badge-accent-secondary text-uppercase">Mã VĐV: <?php echo e($player->player_id); ?></span>
                    </div>
                    <table class="table table-sm table-borderless text-start mb-0 player-info-table">
                        <tr>
                            <td class="fw-bold">
                                Địa điểm</td>
                            <td>
                                <span class="badge badge-accent-secondary d-inline-flex align-items-center gap-1"><i
                                        class="bi bi-geo-alt-fill"></i><?php echo e($player->location); ?></span>
                            </td>
                        </tr>
                        <tr>
                            <td class="fw-bold">
                                Số điện thoại</td>
                            <td>
                                <?php echo e($player->phone ?
                                substr($player->phone,0,3) .
                                str_repeat('*', max(0,strlen($player->phone)-3)) : 'Ẩn'); ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">
                                Giới tính</td>
                            <td>
                                <?php echo e($player->gender); ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">
                                Điểm đôi</td>
                            <td class="fw-bold text-success">
                                <?php echo e(number_format($player->doubles_score,2)); ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">
                                Trận đôi</td>
                            <td>
                                <?php echo e($player->doubles_matches); ?> (<span class="text-success"><?php echo e($player->doubles_wins); ?></span>/<span class="text-danger"><?php echo e($player->doubles_losses); ?></span>)
                            </td>
                        </tr>
                        <tr>
                            <td class="fw-bold">
                                Điểm đơn</td>
                            <td class="fw-bold text-primary">
                                <?php echo e(number_format($player->singles_score ?? 2.5, 2)); ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">
                                Trận đơn</td>
                            <td>
                                <?php echo e($player->singles_matches ?? 0); ?> (<span class="text-success"><?php echo e($player->singles_wins
                                    ?? 0); ?></span>/<span class="text-danger"><?php echo e($player->singles_losses ?? 0); ?></span>)
                            </td>
                        </tr>
                        <tr>
                            <td class="fw-bold">
                                Điểm cao nhất</td>
                            <td><?php echo e(number_format($player->max_score,2)); ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">
                                Trạng thái</td>
                            <td>
                                <?php if($player->status==0): ?><span class="badge badge-status badge-status--pending">Chưa
                                    duyệt</span><?php elseif($player->status==1): ?><span
                                    class="badge badge-status badge-status--approved">Đã
                                    duyệt</span><?php elseif($player->status==2): ?><span
                                    class="badge badge-status badge-status--guaranteed">Bảo lãnh</span><?php endif; ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-md-7">
            <div class="card shadow border player-profile-card">
                <div class="card-header fw-bold player-history-card__header">
                    Lịch sử thi đấu</div>
                <div class="card-body">
                    
                    
                    <?php if($matches->isEmpty()): ?>
                    <p class="text-muted">Chưa có lịch sử thi đấu.</p>
                    <?php else: ?>
                    <div class="list-group">
                        <?php $__currentLoopData = $matches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $match): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        // Determine which pair the viewed player belongs to and the opponent pair
                        $side=null; $oppSide=null; $isPlayerInPair1=false;
                        if ($match->pair1 && ((isset($match->pair1->player1_id) && ($match->pair1->player1_id ==
                        $player->id)) || (isset($match->pair1->player2_id) && ($match->pair1->player2_id ==
                        $player->id)))) {
                        $side = $match->pair1; $oppSide = $match->pair2; $isPlayerInPair1 = true;
                        } elseif ($match->pair2 && ((isset($match->pair2->player1_id) && ($match->pair2->player1_id ==
                        $player->id)) || (isset($match->pair2->player2_id) && ($match->pair2->player2_id ==
                        $player->id)))) {
                        $side = $match->pair2; $oppSide = $match->pair1; $isPlayerInPair1 = false;
                        }

                        // Xác định thắng/thua ưu tiên theo tỷ số; fallback theo trạng thái Bye hoặc trường result
                        $isWin = false; // mặc định
                        $winnerSide = null; // 'pair1' | 'pair2' | null

                        // 1) Nếu là Bye: pair1 là đội đi tiếp theo logic tạo trận
                        if (isset($match->status) && strtolower($match->status) === 'bye') {
                        $winnerSide = 'pair1';
                        }

                        // 2) Nếu có tỷ số hợp lệ dạng "x-y": quyết định theo điểm
                        if ($winnerSide === null && !empty($match->score) && str_contains($match->score, '-')) {
                        $parts = explode('-', $match->score);
                        if (count($parts) === 2) {
                        $s1 = (int)trim($parts[0]);
                        $s2 = (int)trim($parts[1]);
                        if ($s1 !== $s2) {
                        $winnerSide = $s1 > $s2 ? 'pair1' : 'pair2';
                        }
                        }
                        }

                        // 3) Fallback: dùng field result nếu có ('pair1' | 'pair2')
                        if ($winnerSide === null && !empty($match->result)) {
                        $res = strtolower($match->result);
                        if ($res === 'pair1' || $res === 'pair2') {
                        $winnerSide = $res;
                        }
                        }

                        if ($winnerSide === 'pair1') {
                        $isWin = $isPlayerInPair1;
                        } elseif ($winnerSide === 'pair2') {
                        $isWin = !$isPlayerInPair1;
                        }

                        // Tính điểm thay đổi thực tế cho player này từ match
                        $actualScoreChange = 0;
                        if ($match->score_change != 0) {
                        // Nếu có score_change từ database, tính cho player cụ thể
                        if ($isPlayerInPair1) {
                        // Player trong pair1, lấy score_change trực tiếp
                        $actualScoreChange = $match->score_change;
                        } else {
                        // Player trong pair2, lấy score_change ngược lại
                        $actualScoreChange = -$match->score_change;
                        }
                        } else {
                        // Fallback: tính ước lượng nếu chưa có dữ liệu
                        if ($side && $oppSide) {
                        $playerRating = $player->doubles_score;

                        $oppPlayer1 = $oppSide->player1;
                        $oppPlayer2 = $oppSide->player2;
                        $oppRating = 2.5;

                        if ($oppPlayer1 && $oppPlayer2) {
                        $oppRating = ($oppPlayer1->doubles_score + $oppPlayer2->doubles_score) / 2;
                        } elseif ($oppPlayer1) {
                        $oppRating = $oppPlayer1->doubles_score;
                        } elseif ($oppPlayer2) {
                        $oppRating = $oppPlayer2->doubles_score;
                        }

                        $expectedScore = 1 / (1 + pow(10, ($oppRating - $playerRating) / 400));
                        $actualScore = $isWin ? 1 : 0;
                        $actualScoreChange = 0.03 * ($actualScore - $expectedScore);
                        }
                        }
                        ?>

                        <div class="match-card mb-3 rounded-3 shadow-sm">
                            <div class="p-3">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <strong class="text-accent"><?php echo e($match->tournament->name ??
                                            'Giao hữu'); ?></strong>
                                        <div class="small text-muted"><?php echo e($match->updated_at ?
                                            $match->updated_at->format('d/m/Y') :
                                            '--/--/----'); ?></div>
                                    </div>
                                    <div class="text-end ms-2">
                                        <span
                                            class="badge badge-result <?php echo e($isWin ? 'badge-result--win' : 'badge-result--loss'); ?>"><?php echo e($isWin ?
                                            'Thắng' : 'Thua'); ?> (<?php echo e($actualScoreChange > 0 ? '+' : ''); ?><?php echo e(number_format($actualScoreChange, 3)); ?>)</span>
                                        <div class="small text-muted"><?php echo e(ucfirst($match->type ??
                                            'N/A')); ?></div>
                                    </div>
                                </div>

                                <div class="row align-items-center justify-content-center mt-3 gx-2">
                                    <?php
                                    $scores = $match->score ? explode('-', $match->score) : [null, null];
                                    $scoreSide = null;
                                    $scoreOppSide = null;
                                    if ($side && $oppSide) {
                                    if ($isPlayerInPair1) {
                                    // Player trong pair1, lấy điểm đầu tiên
                                    $scoreSide = $scores[0] ?? null;
                                    $scoreOppSide = $scores[1] ?? null;
                                    } else {
                                    // Player trong pair2, lấy điểm thứ hai
                                    $scoreSide = $scores[1] ?? null;
                                    $scoreOppSide = $scores[0] ?? null;
                                    }
                                    }
                                    $sideWon = $scoreSide !== null && $scoreOppSide !== null && (int)$scoreSide >
                                    (int)$scoreOppSide;
                                    ?>
                                    <div class="col home-side <?php echo e(!$isWin ? 'opacity-75' : 'opacity-100'); ?>">
                                        
                                        <?php if($side): ?>
                                        <div class="d-flex flex-column">
                                            <?php $__currentLoopData = [$side->player1, $side->player2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($p): ?>
                                            <a href="<?php echo e(route('players.show', $p->id)); ?>"
                                                class="d-flex align-items-center text-decoration-none py-1">
                                                <div class="flex-shrink-0 me-2">
                                                    <?php if($p->avatar): ?>
                                                    <img src="<?php echo e(asset($p->avatar)); ?>" alt="<?php echo e($p->name); ?>"
                                                        class="rounded-circle match-avatar">
                                                    <?php else: ?>
                                                    <div class="rounded-circle player-initial">
                                                        <?php echo e(mb_strtoupper(mb_substr($p->name ?? '', 0, 1, 'UTF-8'), 'UTF-8')); ?></div>
                                                    <?php endif; ?>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="fw-semibold text-truncate"><?php echo e($p->name ?? ''); ?></div>
                                                    <div class="small text-truncate text-muted">
                                                        <?php if(isset($p->location)): ?> <i class="bi bi-geo-alt me-1"></i><?php echo e($p->location); ?> <?php endif; ?></div>
                                                </div>
                                            </a>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php else: ?>
                                        <div class="small text-muted">Đội trống</div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-auto col-score text-center my-2 my-sm-0">
                                        <?php if($scoreSide !== null): ?>
                                        <div class="d-flex justify-content-center align-items-center">
                                            <span
                                                class="score-badge <?php echo e($sideWon ? 'bg-success text-white' : 'bg-danger text-white'); ?>"><?php echo e($scoreSide); ?></span>
                                            <span class="mx-2 fw-bold fs-5">-</span>
                                            <span
                                                class="score-badge <?php echo e(!$sideWon ? 'bg-success text-white' : 'bg-danger text-white'); ?>"><?php echo e($scoreOppSide); ?></span>
                                        </div>
                                        <?php else: ?>
                                        <div class="score h5 mb-0 fw-bold">vs</div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col opp-side <?php echo e($isWin ? 'opacity-75' : 'opacity-100'); ?>">
                                        
                                        <?php if($oppSide): ?>
                                        <div class="d-flex flex-column align-items-end">
                                            <?php $__currentLoopData = [$oppSide->player1, $oppSide->player2]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($op): ?>
                                            <a href="<?php echo e(route('players.show', $op->id)); ?>"
                                                class="d-flex align-items-center text-decoration-none py-1 justify-content-end">
                                                <div class="text-end me-2">
                                                    <div class="fw-semibold text-truncate"><?php echo e($op->name ?? ''); ?></div>
                                                    <div class="small text-truncate text-muted">
                                                        <?php if(isset($op->location)): ?> <i class="bi bi-geo-alt me-1"></i><?php echo e($op->location); ?> <?php endif; ?></div>
                                                </div>
                                                <div class="flex-shrink-0">
                                                    <?php if($op->avatar): ?>
                                                    <img src="<?php echo e(asset($op->avatar)); ?>" alt="<?php echo e($op->name); ?>"
                                                        class="rounded-circle match-avatar">
                                                    <?php else: ?>
                                                    <div class="rounded-circle player-initial player-initial--danger">
                                                        <?php echo e(mb_strtoupper(mb_substr($op->name ?? '', 0, 1, 'UTF-8'),
                                                        'UTF-8')); ?></div>
                                                    <?php endif; ?>
                                                </div>
                                            </a>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php else: ?>
                                        <div class="small text-muted">Đối thủ trống</div>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <?php if($match->images && is_array($match->images) && count($match->images)): ?>
                                <div class="mt-3 text-center">
                                    <img src="<?php echo e(asset($match->images[0])); ?>" alt="Match image"
                                        class="img-fluid rounded shadow match-thumb"
                                        data-images="<?php echo e(implode('|', $match->images)); ?>">
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>

                    
                    <div class="mt-3">
                        <div class="pagination-responsive-wrapper d-flex justify-content-center">
                            
                            <div class="d-none d-sm-block">
                                
                                <?php echo e($matches->links('vendor.pagination.no-arrow')); ?>

                            </div>

                            
                            <div class="d-block d-sm-none w-100">
                                
                                <?php echo e($matches->links('vendor.pagination.no-arrow')); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="galleryModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content bg-transparent border-0">
            <div class="modal-body p-0 position-relative">
                <button type="button" class="btn-close btn-close-white position-absolute top-0 end-0 m-2 z-2"
                    data-bs-dismiss="modal" aria-label="Close"></button>
                <div id="galleryInner" class="gallery-inner">
                    
                </div>
                <div class="d-flex justify-content-between position-absolute w-100 top-50 translate-middle-y px-2">
                    <button id="prevImage" class="btn gallery-nav-btn opacity-75" aria-label="Previous image"><i
                            class="bi bi-chevron-left"></i></button>
                    <button id="nextImage" class="btn gallery-nav-btn opacity-75" aria-label="Next image"><i
                            class="bi bi-chevron-right"></i></button>
                </div>
            </div>
        </div>
    </div>
</div>



<?php if($player->status == 0): ?>
<div class="modal fade" id="editAvatarModal" tabindex="-1" aria-labelledby="editAvatarModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content player-modal">
            <div class="modal-header player-modal__header">
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <?php if(session('avatar_success')): ?>
            <div class="alert alert-success mb-2"><?php echo e(session('avatar_success')); ?></div>
            <?php endif; ?>
            <?php if(session('avatar_error')): ?>
            <div class="alert alert-danger mb-2"><?php echo e(session('avatar_error')); ?></div>
            <?php endif; ?>
            <form action="<?php echo e(route('players.updateAvatar', $player->id)); ?>" method="POST" enctype="multipart/form-data"
                id="avatarForm">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="avatar" class="form-label">Chọn ảnh mới</label>
                        <input type="file" class="form-control" id="avatar" name="avatar" accept="image/*"
                            aria-describedby="avatarHelp">
                        <div id="avatarHelp" class="form-text">Chọn ảnh JPG/PNG tối đa 2MB. Nên tải ảnh vuông để tránh
                            bị crop không mong muốn.</div>
                    </div>
                    <div class="alert alert-info">
                        Avatar sẽ được cập nhật trong vòng <b>24h</b> khi admin duyệt.
                    </div>
                </div>
                <div class="modal-footer player-modal__footer">
                    <button type="button" class="btn btn-surface" data-bs-dismiss="modal">Đóng</button>
                    <button type="submit" class="btn btn-accent-gradient" id="submitAvatarBtn">
                        <span class="submit-text">Gửi yêu cầu</span>
                        <span class="loading-text d-none">
                            <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>
                            Đang gửi...
                        </span>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endif; ?>

<?php $__env->startPush('layout_script'); ?>
<script>
    // Force-open avatar modal on pencil click in case data attributes are blocked by other scripts
    // Chỉ xử lý cho player có trạng thái chưa duyệt
    <?php if($player->status == 0): ?>
    (function(){
        const btn = document.querySelector('.player-avatar-edit');
        const modalEl = document.getElementById('editAvatarModal');
        if (btn && modalEl && window.bootstrap) {
            btn.addEventListener('click', function(ev){
                ev.preventDefault();
                ev.stopPropagation();
                const modal = bootstrap.Modal.getOrCreateInstance(modalEl);
                modal.show();
            }, { capture: true });
        }
    })();
    <?php endif; ?>

    // Ensure backdrop stacking/opacity if any global CSS competes
    (function(){
        function normalizeBackdrop() {
            document.querySelectorAll('.modal-backdrop').forEach(function(b){
                b.style.zIndex = '2150';
                b.style.background = 'rgba(5,5,5,0.75)';
                b.style.backdropFilter = 'none';
                b.style.opacity = '';
            });
        }
        var modals = ['galleryModal'];
        <?php if($player->status == 0): ?>
        modals.push('editAvatarModal');
        <?php endif; ?>
        modals.forEach(function(id){
            var el = document.getElementById(id);
            if (!el) return;
            el.addEventListener('shown.bs.modal', normalizeBackdrop);
        });
    })();

    // Gallery modal behavior
    (function(){
        const galleryModalEl = document.getElementById('galleryModal');
        if (!galleryModalEl) return;
        const galleryModal = new bootstrap.Modal(galleryModalEl);
        let currentImages = [];
        let currentIndex = 0;

        function showImage(index){
            const container = document.getElementById('galleryInner');
            container.innerHTML = '';
            const img = document.createElement('img');
            // currentImages already contains absolute URLs; set directly to avoid escaping which breaks URLs
            img.src = currentImages[index];
            img.className = 'img-fluid';
            img.style.maxHeight = '70vh';
            img.style.maxWidth = '100%';
            container.appendChild(img);
        }

        document.querySelectorAll('.match-thumb').forEach(function(el){
            el.addEventListener('click', function(){
                const baseOrigin = window.location.origin;
                const imgs = this.getAttribute('data-images').split('|').map(i => i.trim()).filter(Boolean).map(i => i.startsWith('http') ? i : (baseOrigin + '/' + i.replace(/^\//,'')));
                currentImages = imgs;
                currentIndex = 0;
                showImage(currentIndex);
                galleryModal.show();
            });
        });

        const prevBtn = document.getElementById('prevImage');
        const nextBtn = document.getElementById('nextImage');
        if (prevBtn) prevBtn.addEventListener('click', function(){
            if(!currentImages.length) return;
            currentIndex = (currentIndex - 1 + currentImages.length) % currentImages.length;
            showImage(currentIndex);
        });
        if (nextBtn) nextBtn.addEventListener('click', function(){
            if(!currentImages.length) return;
            currentIndex = (currentIndex + 1) % currentImages.length;
            showImage(currentIndex);
        });
    })();

    // Avatar form submission handling - chỉ cho player có trạng thái chưa duyệt
    <?php if($player->status == 0): ?>
    document.addEventListener('DOMContentLoaded', function() {
        const avatarForm = document.getElementById('avatarForm');
        const submitBtn = document.getElementById('submitAvatarBtn');
        const submitText = submitBtn ? submitBtn.querySelector('.submit-text') : null;
        const loadingText = submitBtn ? submitBtn.querySelector('.loading-text') : null;
        const editAvatarModal = document.getElementById('editAvatarModal');
        const editAvatarBtns = document.querySelectorAll('.player-avatar-edit');
        
        if (avatarForm && submitBtn) {
            avatarForm.addEventListener('submit', function(e) {
                // Kiểm tra file có được chọn không
                const fileInput = document.getElementById('avatar');
                if (!fileInput.files.length) {
                    e.preventDefault();
                    alert('Vui lòng chọn một file ảnh.');
                    return;
                }
                
                // Hiển thị trạng thái loading
                submitBtn.disabled = true;
                if (submitText) submitText.classList.add('d-none');
                if (loadingText) loadingText.classList.remove('d-none');
            });
        }

        // Ensure clicking the pencil always opens the modal (programmatic show)
        if (editAvatarBtns.length && editAvatarModal) {
            editAvatarBtns.forEach(function(btn){
                btn.addEventListener('click', function(e){
                    if (window.bootstrap && window.bootstrap.Modal) {
                        e.preventDefault();
                        e.stopPropagation();
                        window.bootstrap.Modal.getOrCreateInstance(editAvatarModal).show();
                    }
                }, true);
            });
        }
        
        // Tự động đóng modal nếu có thông báo thành công
        <?php if(session('avatar_success')): ?>
        if (editAvatarModal) {
            const modal = bootstrap.Modal.getInstance(editAvatarModal);
            if (modal) {
                modal.hide();
            }
        }
        <?php endif; ?>
        
        // Reset form khi đóng modal
        if (editAvatarModal) {
            editAvatarModal.addEventListener('hidden.bs.modal', function() {
                if (avatarForm) {
                    avatarForm.reset();
                }
                if (submitBtn) {
                    submitBtn.disabled = false;
                    if (submitText) submitText.classList.remove('d-none');
                    if (loadingText) loadingText.classList.add('d-none');
                }
            });
        }
    });
    <?php endif; ?>
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/players/show.blade.php ENDPATH**/ ?>