<?php $__env->startSection('title', 'Đăng Nhập'); ?>

<?php $__env->startPush('layout_css'); ?>
<style>
    .login-container {
        min-height: calc(100vh - 150px);
        /* Adjust based on your header/footer height */
        display: flex;
        align-items: center;
        justify-content: center;
        background: var(--primary-bg);
    }

    .login-card {
        background: var(--card-bg);
        backdrop-filter: blur(10px);
        border-radius: 1.5rem;
        border: 1px solid var(--border-color);
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        transition: all 0.3s ease;
        overflow: hidden;
    }

    .login-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.4);
    }

    .form-control-icon {
        position: absolute;
        top: 50%;
        left: 1rem;
        transform: translateY(-50%);
        color: var(--text-muted);
    }

    .form-control-password-toggle {
        position: absolute;
        top: 50%;
        right: 1rem;
        transform: translateY(-50%);
        cursor: pointer;
        color: var(--text-muted);
        transition: color 0.3s ease;
    }

    .form-control-password-toggle:hover {
        color: var(--accent-primary);
    }

    .form-control-with-icon {
        padding-left: 3rem;
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .form-control-with-icon:focus {
        background: var(--card-bg) !important;
        border-color: var(--accent-primary) !important;
        color: var(--text-primary) !important;
        box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.25) !important;
    }

    .form-control-with-icon::placeholder {
        color: var(--text-muted) !important;
    }

    .btn-primary {
        background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary)) !important;
        border: none !important;
        color: var(--text-primary) !important;
        transition: all 0.3s ease;
    }

    .btn-primary:hover {
        background: linear-gradient(135deg, var(--accent-secondary), var(--accent-primary)) !important;
        transform: translateY(-2px);
        box-shadow: 0 8px 25px rgba(59, 130, 246, 0.3);
    }

    .form-check-input {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
    }

    .form-check-input:checked {
        background: var(--accent-primary) !important;
        border-color: var(--accent-primary) !important;
    }

    .form-check-label {
        color: var(--text-primary) !important;
    }

    .text-muted {
        color: var(--text-muted) !important;
    }

    .text-primary {
        color: var(--accent-primary) !important;
    }

    .card-body h2 {
        color: var(--text-primary) !important;
    }

    .card-body a {
        color: var(--accent-primary) !important;
    }

    .card-body a:hover {
        color: var(--accent-secondary) !important;
    }

    .invalid-feedback {
        color: var(--danger) !important;
    }

    .is-invalid {
        border-color: var(--danger) !important;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="login-container py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5 col-xl-4">
                <div class="card login-card border-0">
                    <div class="card-body p-4 p-md-5">
                        <div class="text-center mb-4">
                            <i class="bi bi-box-arrow-in-right fs-1" style="color: var(--accent-primary);"></i>
                            <h2 class="h3 fw-bold mt-2" style="color: var(--text-primary);">Đăng Nhập</h2>
                            <p class="text-muted" style="color: var(--text-muted);">Chào mừng bạn trở lại!</p>
                        </div>
                        <form method="POST" action="<?php echo e(route('login')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3 position-relative">
                                <label for="email" class="form-label visually-hidden">Email</label>
                                <i class="bi bi-envelope-fill form-control-icon"></i>
                                <input type="email" name="email" id="email"
                                    class="form-control form-control-lg form-control-with-icon <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Địa chỉ email" value="<?php echo e(old('email')); ?>" required autocomplete="email"
                                    autofocus>
                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="mb-3 position-relative">
                                <label for="password" class="form-label visually-hidden">Mật Khẩu</label>
                                <i class="bi bi-lock-fill form-control-icon"></i>
                                <input type="password" name="password" id="password"
                                    class="form-control form-control-lg form-control-with-icon <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Mật khẩu" required autocomplete="current-password">
                                <i class="bi bi-eye-slash-fill form-control-password-toggle" id="togglePassword"></i>
                                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="remember" id="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="remember" style="color: var(--text-primary);">
                                        Ghi nhớ
                                    </label>
                                </div>
                                
                                <a href="https://zalo.me/0905647582" target="_blank" class="small text-decoration-none"
                                    style="color: var(--accent-primary);">Quên mật
                                    khẩu?</a>
                                
                            </div>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary btn-lg fw-bold">Đăng Nhập</button>
                            </div>
                            <div class="text-center mt-4">
                                <p class="text-muted small" style="color: var(--text-muted);">Chưa có tài khoản? <a
                                        href="<?php echo e(route('register-member.register')); ?>"
                                        class="text-decoration-none fw-bold" style="color: var(--accent-primary);">Đăng
                                        ký ngay</a></p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('layout_script'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const togglePassword = document.querySelector('#togglePassword');
        const password = document.querySelector('#password');

        if (togglePassword && password) {
            togglePassword.addEventListener('click', function (e) {
                // toggle the type attribute
                const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
                password.setAttribute('type', type);
                // toggle the eye / eye slash icon
                this.classList.toggle('bi-eye-fill');
                this.classList.toggle('bi-eye-slash-fill');
            });
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/auth/login.blade.php ENDPATH**/ ?>