<?php if($venues->isEmpty()): ?>
<div class="alert alert-info text-center">Không tìm thấy sân nào phù hợp.</div>
<?php else: ?>
<div class="table-responsive dark-table-wrapper">
    <table class="table table-hover table-striped table-dark-mode align-middle">
        <thead class="table-dark-mode-head">
            <tr>
                <th>Tên Sân</th>
                <th>Khu vực</th>
                <th>Liên hệ</th>
                <th class="text-center">Hình ảnh</th>
                <th>Ngày tạo</th>
                <th class="text-center">Hành động</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $venues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <a href="<?php echo e(route('venues.show', $venue->slug)); ?>" target="_blank"
                        class="text-decoration-none fw-bold"><?php echo e($venue->name); ?></a>
                    <p class="small text-muted mb-0"><?php echo e($venue->address); ?></p>
                </td>
                <td><span class="badge bg-info bg-opacity-75"><?php echo e($venue->location); ?></span></td>
                <td>
                    <?php if($venue->contact_phone): ?>
                    <div class="small"><i class="bi bi-telephone-fill me-1"></i><?php echo e($venue->contact_phone); ?>

                    </div>
                    <?php endif; ?>
                    <?php if($venue->contact_email): ?>
                    <div class="small"><i class="bi bi-envelope-fill me-1"></i><?php echo e($venue->contact_email); ?>

                    </div>
                    <?php endif; ?>
                </td>
                <td class="text-center">
                    <div class="d-flex justify-content-center gap-1">
                        <?php $__empty_1 = true; $__currentLoopData = array_slice($venue->images ?? [], 0, 3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <img src="<?php echo e(asset($img)); ?>"
                            style="width: 50px; height: 35px; object-fit: cover; border-radius: 4px;" loading="lazy"
                            alt="Ảnh <?php echo e($venue->name); ?>">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <span class="text-muted small">N/A</span>
                        <?php endif; ?>
                    </div>
                </td>
                <td class="small"><?php echo e($venue->created_at->format('d/m/Y')); ?></td>
                <td class="text-center">
                    <div class="btn-group btn-group-sm">
                        <a href="<?php echo e(route('admin.venues.edit', $venue)); ?>" class="btn btn-outline-primary"
                            title="Sửa"><i class="bi bi-pencil-fill"></i></a>
                        <form action="<?php echo e(route('admin.venues.destroy', $venue)); ?>" method="POST"
                            class="d-inline delete-venue-form" data-venue-name="<?php echo e($venue->name); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-outline-danger delete-venue" title="Xóa"><i
                                    class="bi bi-trash-fill"></i></button>
                        </form>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<div class="mt-4 d-flex justify-content-center">
    <?php echo e($venues->appends(request()->query())->links('vendor.pagination.no-arrow')); ?>

</div>
<?php endif; ?><?php /**PATH /home/nasalaut/domains/pick.nasalauto.com/public_html/resources/views/admin/venues/partials/_venues_table.blade.php ENDPATH**/ ?>