@extends('layouts.app')

@section('title', $venue->name)

@push('layout_css')
<style>
    .venue-gallery .main-image {
        height: 500px;
        object-fit: cover;
        border-radius: 1rem;
        cursor: pointer;
        border: 1px solid var(--border-color);
    }

    .venue-gallery .thumb-image {
        height: 100px;
        object-fit: cover;
        cursor: pointer;
        border-radius: 0.5rem;
        transition: transform 0.2s, opacity 0.2s;
        border: 2px solid var(--border-color);
    }

    .venue-gallery .thumb-image:hover {
        transform: scale(1.05);
        opacity: 0.9;
    }

    .venue-gallery .thumb-image.active {
        border-color: var(--accent-primary);
        box-shadow: 0 0 8px var(--shadow-primary);
    }

    .info-card {
        background-color: var(--card-bg);
        border-radius: 1rem;
        border: 1px solid var(--border-color);
    }

    .info-card .list-group-item {
        background-color: transparent;
        border: none;
        color: var(--text-primary);
    }

    .info-card .list-group-item i {
        color: var(--accent-primary);
    }

    .map-container {
        height: 400px;
        border-radius: 1rem;
        overflow: hidden;
        border: 1px solid var(--border-color);
    }

    .rating-stars .bi-star-fill {
        color: var(--warning);
    }

    .rating-stars .bi-star {
        color: var(--text-muted);
    }

    .review-form .star-rating-input {
        display: flex;
        flex-direction: row-reverse;
        justify-content: flex-end;
    }

    .review-form .star-rating-input input[type="radio"] {
        display: none;
    }

    .review-form .star-rating-input label {
        font-size: 2rem;
        color: var(--text-muted);
        cursor: pointer;
        transition: color 0.2s;
    }

    .review-form .star-rating-input input[type="radio"]:checked~label,
    .review-form .star-rating-input label:hover,
    .review-form .star-rating-input label:hover~label {
        color: var(--warning);
    }

    .review-item .avatar {
        width: 48px;
        height: 48px;
        object-fit: cover;
        border-radius: 50%;
        border: 1px solid var(--border-color);
    }

    /* Venue Description Styling for Dark Theme */
    .venue-description {
        line-height: 1.8;
        color: var(--text-secondary);
    }

    .venue-description h1,
    .venue-description h2,
    .venue-description h3,
    .venue-description h4,
    .venue-description h5,
    .venue-description h6 {
        color: var(--accent-primary);
        margin-top: 1.5rem;
        margin-bottom: 1rem;
        font-weight: 600;
    }

    .venue-description h1 {
        font-size: 1.5rem;
    }

    .venue-description h2 {
        font-size: 1.4rem;
    }

    .venue-description h3 {
        font-size: 1.3rem;
    }

    .venue-description h4 {
        font-size: 1.2rem;
    }

    .venue-description h5 {
        font-size: 1.1rem;
    }

    .venue-description h6 {
        font-size: 1rem;
    }

    .venue-description ul,
    .venue-description ol {
        padding-left: 1.5rem;
        margin-bottom: 1rem;
    }

    .venue-description li {
        margin-bottom: 0.5rem;
        line-height: 1.6;
        color: var(--text-secondary);
    }

    .venue-description ul li {
        list-style-type: none;
        position: relative;
    }

    .venue-description ul li:before {
        content: "•";
        color: var(--accent-primary);
        font-weight: bold;
        position: absolute;
        left: -1rem;
    }

    .venue-description ol li {
        margin-bottom: 0.5rem;
    }

    .venue-description p {
        margin-bottom: 1rem;
        line-height: 1.7;
        color: var(--text-secondary);
    }

    .venue-description a {
        color: var(--accent-primary);
        text-decoration: none;
        border-bottom: 1px dotted var(--accent-primary);
        transition: all 0.2s ease;
    }

    .venue-description a:hover {
        color: var(--accent-hover);
        border-bottom-style: solid;
    }

    .venue-description img {
        max-width: 100%;
        height: auto;
        border-radius: 0.5rem;
        box-shadow: 0 2px 8px var(--shadow-dark);
        margin: 1rem 0;
        border: 1px solid var(--border-color);
    }

    .venue-description b,
    .venue-description strong {
        color: var(--text-primary);
        font-weight: 600;
    }

    .venue-description i,
    .venue-description em {
        color: var(--text-muted);
        font-style: italic;
    }

    .venue-description u {
        text-decoration: underline;
        text-underline-offset: 2px;
    }

    .venue-description .table {
        margin: 1rem 0;
        border-radius: 0.5rem;
        overflow: hidden;
        box-shadow: 0 2px 4px var(--shadow-dark);
        background: var(--card-bg);
        color: var(--text-primary);
        border: 1px solid var(--border-color);
    }

    .venue-description blockquote {
        border-left: 4px solid var(--accent-primary);
        padding-left: 1rem;
        margin: 1.5rem 0;
        font-style: italic;
        background-color: var(--card-bg);
        padding: 1rem;
        border-radius: 0.25rem;
        color: var(--text-secondary);
        border: 1px solid var(--border-color);
    }

    /* Card styles for dark theme */
    .card {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .card-title {
        color: var(--accent-primary) !important;
    }

    /* Form controls for dark theme */
    .form-control,
    .form-select {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .form-control:focus,
    .form-select:focus {
        background: var(--card-bg) !important;
        border-color: var(--accent-primary) !important;
        color: var(--text-primary) !important;
        box-shadow: 0 0 0 0.2rem var(--shadow-primary) !important;
    }

    .form-label {
        color: var(--text-primary) !important;
    }

    /* Button styles */
    .btn-primary {
        background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary)) !important;
        border: none !important;
        color: var(--text-primary) !important;
    }

    .btn-primary:hover {
        background: linear-gradient(135deg, var(--accent-hover), var(--accent-primary)) !important;
        transform: translateY(-1px);
    }

    /* Alert styles */
    .alert-info {
        background: rgba(59, 130, 246, 0.1) !important;
        border: 1px solid var(--accent-primary) !important;
        color: var(--accent-primary) !important;
    }

    .alert-info a {
        color: var(--accent-secondary) !important;
    }

    /* Text colors */
    .text-muted {
        color: var(--text-muted) !important;
    }

    .text-primary {
        color: var(--accent-primary) !important;
    }
</style>
@endpush

@section('content')
<div class="container py-5">
    <div class="row g-5">
        <div class="col-lg-8">
            <!-- Venue Gallery -->
            <div class="venue-gallery mb-4">
                <img src="{{ $venue->main_image }}" id="mainImage" class="img-fluid main-image w-100 shadow-lg"
                    alt="Main image of {{ $venue->name }}">

                @if($venue->images && count($venue->images) > 1)
                <div class="row g-2 mt-3">
                    @foreach($venue->images as $index => $image)
                    <div class="col-3">
                        <img src="{{ asset($image) }}"
                            class="img-fluid thumb-image w-100 {{ $index == 0 ? 'active' : '' }}"
                            onclick="changeMainImage('{{ asset($image) }}', this)" alt="Thumbnail {{ $index + 1 }}">
                    </div>
                    @endforeach
                </div>
                @endif
            </div>

            <!-- Venue Description -->
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-body p-4">
                    <h2 class="card-title h4 fw-bold text-primary mb-3">
                        <i class="bi bi-card-text me-2"></i>Mô tả chi tiết
                    </h2>
                    <div class="venue-description">
                        @if($venue->description)
                        {!! nl2br($venue->description) !!}
                        @else
                        <p class="text-muted fst-italic">Chưa có mô tả chi tiết cho sân này.</p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Reviews Section -->
            <div class="card border-0 shadow-sm rounded-4 mt-4">
                <div class="card-body p-4">
                    <h2 class="card-title h4 fw-bold text-primary mb-4">Đánh giá & Bình luận</h2>

                    <!-- Review Form -->
                    @auth
                    <div class="mb-5">
                        <h3 class="h5 mb-3">Gửi đánh giá của bạn</h3>
                        <form action="{{ route('reviews.store', $venue) }}" method="POST">
                            @csrf
                            <div class="mb-3">
                                <label class="form-label">Xếp hạng</label>
                                <div class="star-rating-input">
                                    <input type="radio" id="star5" name="rating" value="5" required /><label for="star5"
                                        title="5 sao"><i class="bi bi-star-fill"></i></label>
                                    <input type="radio" id="star4" name="rating" value="4" /><label for="star4"
                                        title="4 sao"><i class="bi bi-star-fill"></i></label>
                                    <input type="radio" id="star3" name="rating" value="3" /><label for="star3"
                                        title="3 sao"><i class="bi bi-star-fill"></i></label>
                                    <input type="radio" id="star2" name="rating" value="2" /><label for="star2"
                                        title="2 sao"><i class="bi bi-star-fill"></i></label>
                                    <input type="radio" id="star1" name="rating" value="1" /><label for="star1"
                                        title="1 sao"><i class="bi bi-star-fill"></i></label>
                                </div>
                                @error('rating') <div class="text-danger small mt-1">{{ $message }}</div> @enderror
                            </div>
                            <div class="mb-3">
                                <label for="comment" class="form-label">Bình luận của bạn</label>
                                <textarea name="comment" id="comment" rows="4"
                                    class="form-control @error('comment') is-invalid @enderror"
                                    placeholder="Chia sẻ trải nghiệm của bạn về sân này..."
                                    required>{{ old('comment') }}</textarea>
                                @error('comment') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            </div>
                            <button type="submit" class="btn btn-primary">Gửi đánh giá</button>
                        </form>
                    </div>
                    @else
                    <div class="alert alert-info">
                        Vui lòng <a href="{{ route('login') }}">đăng nhập</a> để gửi đánh giá.
                    </div>
                    @endauth

                    <!-- Reviews List -->
                    @forelse($venue->reviews as $review)
                    <div class="d-flex mb-4 review-item">
                        <div class="flex-shrink-0 me-3">
                            <img src="{{ $review->user->avatar ?? 'https://via.placeholder.com/48' }}"
                                alt="{{ $review->user->name }}" class="avatar">
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="fw-bold mb-0">{{ $review->user->name }}</h6>
                            <div class="d-flex align-items-center mb-1">
                                <div class="rating-stars me-2">
                                    @for ($i = 1; $i <= 5; $i++) <i
                                        class="bi {{ $i <= $review->rating ? 'bi-star-fill' : 'bi-star' }}"></i>
                                        @endfor
                                </div>
                                <small class="text-muted">{{ $review->created_at->diffForHumans() }}</small>
                            </div>
                            <p class="mb-0 text-muted">{{ $review->comment }}</p>
                        </div>
                    </div>
                    @empty
                    <div class="text-center text-muted py-3">
                        <p>Chưa có đánh giá nào cho sân này. Hãy là người đầu tiên đánh giá!</p>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Venue Info -->
            <div class="card border-0 shadow-sm rounded-4 mb-4">
                <div class="card-body p-4">
                    <h1 class="h2 fw-bold text-primary mb-3">{{ $venue->name }}</h1>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item px-0 d-flex align-items-start">
                            <i class="bi bi-geo-alt-fill fs-5 me-3 mt-1"></i>
                            <div>
                                <h6 class="fw-bold mb-0">Địa chỉ</h6>
                                <p class="text-muted mb-0">{{ $venue->address }}</p>
                            </div>
                        </li>
                        <li class="list-group-item px-0 d-flex align-items-start">
                            <i class="bi bi-compass-fill fs-5 me-3 mt-1"></i>
                            <div>
                                <h6 class="fw-bold mb-0">Khu vực</h6>
                                <p class="text-muted mb-0">{{ $venue->location }}</p>
                            </div>
                        </li>
                        @if($venue->contact_phone)
                        <li class="list-group-item px-0 d-flex align-items-start">
                            <i class="bi bi-telephone-fill fs-5 me-3 mt-1"></i>
                            <div>
                                <h6 class="fw-bold mb-0">Số điện thoại</h6>
                                <a href="tel:{{ $venue->contact_phone }}" class="text-decoration-none">{{
                                    $venue->contact_phone }}</a>
                            </div>
                        </li>
                        @endif
                        @if($venue->contact_email)
                        <li class="list-group-item px-0 d-flex align-items-start">
                            <i class="bi bi-envelope-fill fs-5 me-3 mt-1"></i>
                            <div>
                                <h6 class="fw-bold mb-0">Email</h6>
                                <a href="mailto:{{ $venue->contact_email }}" class="text-decoration-none">{{
                                    $venue->contact_email }}</a>
                            </div>
                        </li>
                        @endif
                    </ul>
                </div>
            </div>

            <!-- Map -->
            <div class="card border-0 shadow-sm rounded-4">
                <div class="card-body p-4">
                    <h3 class="h5 fw-bold mb-3 text-primary">Vị trí trên bản đồ</h3>
                    <div class="map-container shadow-inner">
                        <iframe width="100%" height="100%" style="border:0" loading="lazy" allowfullscreen
                            referrerpolicy="no-referrer-when-downgrade"
                            src="https://www.google.com/maps?q={{ urlencode($venue->address . ', ' . $venue->location) }}&output=embed">
                        </iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('layout_script')
<script>
    function changeMainImage(src, thumbElement) {
        document.getElementById('mainImage').src = src;
        document.querySelectorAll('.thumb-image.active').forEach(el => el.classList.remove('active'));
        thumbElement.classList.add('active');
    }
</script>
@endpush