@if($venues->isEmpty())
<div class="text-center py-5">
    <i class="bi bi-exclamation-circle-fill fs-1" style="color: var(--warning);"></i>
    <p class="fs-5 mt-3" style="color: var(--text-muted);">Không tìm thấy sân nào phù hợp.</p>
</div>
@else
<div class="row g-4">
    @foreach($venues as $venue)
    <div class="col-md-6 col-lg-4">
        <div class="card h-100 shadow-sm rounded-4 overflow-hidden venue-card">
            <a href="{{ route('venues.show', $venue->slug) }}">
                <img class="card-img-top" src="{{ $venue->main_image }}" alt="Hình ảnh của {{ $venue->name }}"
                    loading="lazy">
            </a>
            <div class="card-body p-4">
                <h3 class="card-title h5 mb-2">
                    <a href="{{ route('venues.show', $venue->slug) }}" class="text-decoration-none">{{ $venue->name
                        }}</a>
                </h3>
                <p class="card-text small mb-3" style="color: var(--text-muted);"><i
                        class="bi bi-geo-alt-fill me-1"></i> {{
                    $venue->address ?? 'Chưa có địa chỉ' }}</p>
                <div class="mt-auto">
                    <span class="badge" style="background: var(--accent-primary); color: var(--text-primary);">{{
                        $venue->location ?? 'Khác' }}</span>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</div>

<!-- Pagination -->
<div class="mt-5 d-flex justify-content-center">
    {{ $venues->appends(request()->query())->links() }}
</div>
@endif