<div class="col-12 col-sm-6 col-md-4 col-lg-3">
    <div class="card h-100 shadow-sm border position-relative"
        style="min-height: 270px; background: var(--card-bg); border-color: var(--border-color) !important; color: var(--text-primary);">
        <div class="position-relative" style="height: 140px; overflow: hidden;">
            @if($tournament->image)
            <img src="{{ asset($tournament->image) }}" alt="image" class="w-100 h-100 object-fit-cover"
                style="object-fit:cover;">
            @else
            <div class="w-100 h-100 d-flex align-items-center justify-content-center"
                style="height:140px; background: var(--secondary-bg);">
                <span style="color: var(--text-muted);">No Image</span>
            </div>
            @endif
            <span class="position-absolute top-0 end-0 m-2 badge"
                style="font-size:0.9rem;opacity:0.95; background: var(--accent-primary); color: var(--text-primary);">{{
                $tournament->start_date->format('Y-m-d') }}</span>
        </div>
        <div class="card-body d-flex flex-column p-3">
            <div class="mb-1 small">
                <span class="badge"
                    style="background: {{ $tournament->type == 'singles' ? 'var(--warning)' : 'var(--accent-secondary)' }}; color: var(--primary-bg);">{{
                    $tournament->type == 'singles' ? 'Đơn' : 'Đôi' }}</span>
                <span class="badge ms-1" style="background: var(--success); color: var(--text-primary);">{{
                    $tournament->location }}</span>
                @if(isset($tournament->skill_point))
                <span class="badge ms-1" title="Điểm trình"
                    style="background: var(--text-muted); color: var(--text-primary);">
                    <i class="bi bi-star-fill"></i> Trình {{ number_format($tournament->skill_point, 2) }}
                </span>
                @endif
                @if(isset($tournament->skill_tolerance))
                <span class="badge ms-1" title="Dung sai điểm trình"
                    style="background: var(--accent-secondary); color: var(--primary-bg);">
                    &plusmn;{{ number_format($tournament->skill_tolerance, 2) }}
                </span>
                @endif
            </div>
            <h3 class="h6 fw-bold mb-2 text-truncate" title="{{ $tournament->name }}"
                style="color: var(--text-primary);">{{ $tournament->name }}
            </h3>
            <div class="mb-2 small" style="color: var(--text-secondary);">{{ $tournament->start_date->format('d/m/Y') }}
                - {{
                $tournament->end_date->format('d/m/Y') }}</div>
            <div class="mb-2">
                <span class="badge" style="background: var(--warning); color: var(--primary-bg);"><i
                        class="bi bi-trophy"></i> {{ $tournament->prizes }}</span>
                <span class="badge ms-1" style="background: var(--accent-primary); color: var(--text-primary);"><i
                        class="bi bi-cash"></i> {{ number_format($tournament->fee)
                    }}đ</span>
            </div>
            <div class="mt-auto">
                <a href="{{ route('tournaments.show', $tournament->slug) }}" class="btn btn-sm w-100"
                    style="background: transparent; border: 1px solid var(--accent-secondary); color: var(--accent-secondary); transition: all 0.3s;"
                    onmouseover="this.style.background='var(--accent-secondary)'; this.style.color='var(--primary-bg)'"
                    onmouseout="this.style.background='transparent'; this.style.color='var(--accent-secondary)'">Xem Chi
                    Tiết</a>
            </div>
        </div>
    </div>
</div>