{{-- Tournament Standings Partial --}}
<div class="tournament-standings">
    @if(isset($standingsByGroup) && count($standingsByGroup) > 0)
    <div class="row">
        @foreach($standingsByGroup as $groupName => $standings)
        <div class="col-lg-6 mb-4">
            <div class="card">
                <div class="card-header bg-success text-white">
                    <h6 class="mb-0">
                        <i class="bi bi-trophy me-2"></i>
                        Bảng xếp hạng - {{ $groupName }}
                    </h6>
                </div>
                <div class="card-body p-0">
                    @if(count($standings) > 0)
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 50px;">#</th>
                                    <th>Cặp đấu</th>
                                    <th style="width: 60px;" class="text-center">Thắng</th>
                                    <th style="width: 60px;" class="text-center">Thua</th>
                                    <th style="width: 80px;" class="text-center">Tỷ số</th>
                                    <th style="width: 60px;" class="text-center">Điểm</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($standings as $index => $standing)
                                <tr class="{{ $index < 2 ? 'table-success' : '' }}">
                                    <td class="fw-bold">
                                        @if($index < 2) <i class="bi bi-star-fill text-warning"></i>
                                            @endif
                                            {{ $index + 1 }}
                                    </td>
                                    <td>
                                        <div class="fw-bold">
                                            {{ $standing['pair']->player1->name ?? 'N/A' }}
                                            @if($standing['pair']->player2)
                                            & {{ $standing['pair']->player2->name }}
                                            @endif
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-success">{{ $standing['wins'] ?? 0 }}</span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-danger">{{ $standing['losses'] ?? 0 }}</span>
                                    </td>
                                    <td class="text-center">
                                        <small class="text-muted">
                                            {{ $standing['points_for'] ?? 0 }}:{{ $standing['points_against'] ?? 0 }}
                                        </small>
                                    </td>
                                    <td class="text-center">
                                        <span class="fw-bold">{{ $standing['points_diff'] ?? 0 }}</span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    @if(count($standings) > 2)
                    <div class="card-footer text-muted small">
                        <i class="bi bi-info-circle me-1"></i>
                        <i class="bi bi-star-fill text-warning me-1"></i>
                        Top 2 đội có thể vào vòng playoffs
                    </div>
                    @endif
                    @else
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-list-ul mb-2" style="font-size: 2rem;"></i>
                        <p>Chưa có kết quả</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        @endforeach
    </div>
    @else
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-trophy text-muted mb-3" style="font-size: 4rem;"></i>
            <h5 class="text-muted">Chưa có bảng xếp hạng</h5>
            <p class="text-muted">Bảng xếp hạng sẽ được cập nhật khi có kết quả thi đấu.</p>
        </div>
    </div>
    @endif

    {{-- Overall Tournament Progress --}}
    @if(isset($standingsByGroup) && count($standingsByGroup) > 0)
    <div class="mt-4">
        <div class="card">
            <div class="card-body">
                <h6 class="card-title">
                    <i class="bi bi-graph-up me-2"></i>
                    Tiến độ giải đấu
                </h6>

                @php
                $totalMatches = 0;
                $completedMatches = 0;

                if(isset($groupRounds)) {
                foreach($groupRounds as $round) {
                if($round->matches) {
                $totalMatches += $round->matches->count();
                $completedMatches += $round->matches->where('status', 'Hoàn thành')->count();
                }
                }
                }

                $progressPercentage = $totalMatches > 0 ? ($completedMatches / $totalMatches) * 100 : 0;
                @endphp

                <div class="row">
                    <div class="col-md-8">
                        <div class="progress" style="height: 25px;">
                            <div class="progress-bar bg-success" role="progressbar"
                                style="width: {{ $progressPercentage }}%">
                                {{ round($progressPercentage, 1) }}%
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 text-end">
                        <span class="text-muted">
                            {{ $completedMatches }}/{{ $totalMatches }} trận đấu
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>