{{-- Tournament Schedule Partial --}}
<div class="tournament-schedule">
    @if($groupRounds && $groupRounds->count() > 0)
    <div class="row">
        @foreach($groupRounds as $round)
        <div class="col-lg-6 mb-4">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h6 class="mb-0">
                        <i class="bi bi-calendar-event me-2"></i>
                        {{ $round->name }}
                    </h6>
                </div>
                <div class="card-body">
                    @if($round->matches && $round->matches->count() > 0)
                    <div class="matches-list">
                        @foreach($round->matches as $match)
                        <div class="match-item d-flex justify-content-between align-items-center py-2 border-bottom">
                            <div class="match-teams">
                                <div class="fw-bold">
                                    @if($match->pair1)
                                    {{ $match->pair1->player1->name ?? 'N/A' }}
                                    @if($match->pair1->player2)
                                    & {{ $match->pair1->player2->name }}
                                    @endif
                                    @else
                                    Cặp 1
                                    @endif
                                </div>
                                <div class="text-muted small">vs</div>
                                <div class="fw-bold">
                                    @if($match->pair2)
                                    {{ $match->pair2->player1->name ?? 'N/A' }}
                                    @if($match->pair2->player2)
                                    & {{ $match->pair2->player2->name }}
                                    @endif
                                    @else
                                    Cặp 2
                                    @endif
                                </div>
                            </div>
                            <div class="match-info text-end">
                                @if($match->score)
                                <div class="fw-bold text-success">{{ $match->score }}</div>
                                @endif
                                <div class="small">
                                    @php
                                    $statusColor = match($match->status) {
                                    'Hoàn thành' => 'success',
                                    'Đang thi đấu' => 'warning',
                                    'Tạm hoãn' => 'danger',
                                    default => 'secondary'
                                    };
                                    @endphp
                                    <span class="badge bg-{{ $statusColor }}">{{ $match->status }}</span>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @else
                    <div class="text-center text-muted py-4">
                        <i class="bi bi-calendar-x mb-2" style="font-size: 2rem;"></i>
                        <p>Chưa có lịch thi đấu</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
        @endforeach
    </div>
    @else
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-calendar-plus text-muted mb-3" style="font-size: 4rem;"></i>
            <h5 class="text-muted">Chưa có lịch thi đấu</h5>
            <p class="text-muted">Lịch thi đấu sẽ được cập nhật sau khi có đủ số lượng đăng ký.</p>
        </div>
    </div>
    @endif

    {{-- Additional Schedule Info --}}
    @if($tournament->start_date)
    <div class="mt-4">
        <div class="alert alert-info">
            <h6><i class="bi bi-info-circle me-1"></i> Thông tin lịch thi đấu:</h6>
            <ul class="mb-0">
                <li><strong>Ngày bắt đầu:</strong> {{ $tournament->start_date->format('d/m/Y H:i') }}</li>
                @if($tournament->end_date && $tournament->end_date != $tournament->start_date)
                <li><strong>Ngày kết thúc:</strong> {{ $tournament->end_date->format('d/m/Y H:i') }}</li>
                @endif
                <li><strong>Địa điểm:</strong> {{ $tournament->location }}</li>
                @if($tournament->venue)
                <li><strong>Sân thi đấu:</strong> {{ $tournament->venue->name }}</li>
                @endif
            </ul>
        </div>
    </div>
    @endif
</div>