{{-- Tournament Registration Form Partial --}}
<div class="tournament-registration">
    @php
    $canRegister = ($tournament->status === 'published') &&
    ($tournament->approved_registrations_count < $tournament->max_pairs);
        @endphp

        @if($canRegister)
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">
                    <i class="bi bi-person-plus me-2"></i>
                    Đăng ký tham gia
                </h5>

                <form action="{{ route('tournament.register', $tournament) }}" method="POST">
                    @csrf

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="player1_phone" class="form-label">
                                    Số điện thoại người chơi 1 <span class="text-danger">*</span>
                                </label>
                                <input type="tel" class="form-control @error('player1_phone') is-invalid @enderror"
                                    id="player1_phone" name="player1_phone" value="{{ old('player1_phone') }}"
                                    placeholder="0901234567" required>
                                @error('player1_phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        @if($tournament->type === 'doubles')
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="player2_phone" class="form-label">
                                    Số điện thoại người chơi 2 <span class="text-danger">*</span>
                                </label>
                                <input type="tel" class="form-control @error('player2_phone') is-invalid @enderror"
                                    id="player2_phone" name="player2_phone" value="{{ old('player2_phone') }}"
                                    placeholder="0901234568" required>
                                @error('player2_phone')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        @endif
                    </div>

                    <div class="mb-3">
                        <label for="note" class="form-label">Ghi chú (tùy chọn)</label>
                        <textarea class="form-control" id="note" name="note" rows="3"
                            placeholder="Thông tin thêm về đăng ký...">{{ old('note') }}</textarea>
                    </div>

                    {{-- Registration Requirements --}}
                    <div class="alert alert-info">
                        <h6><i class="bi bi-info-circle me-1"></i> Lưu ý khi đăng ký:</h6>
                        <ul class="mb-0">
                            <li>Tổng điểm skill không được vượt quá {{ $tournament->skill_point +
                                $tournament->skill_tolerance }}</li>
                            <li>Mỗi người chơi chỉ được đăng ký một lần cho giải đấu này</li>
                            <li>Lệ phí: {{ $tournament->fee > 0 ? number_format($tournament->fee) . ' VNĐ' : 'Miễn phí'
                                }}</li>
                            <li>Đăng ký sẽ được BTC duyệt sau khi gửi</li>
                        </ul>
                    </div>

                    @error('max_pairs')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror

                    @error('score_sum')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror

                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary btn-lg">
                            <i class="bi bi-send me-2"></i>
                            Gửi đăng ký
                        </button>
                    </div>
                </form>
            </div>
        </div>
        @else
        <div class="card">
            <div class="card-body text-center">
                <div class="mb-3">
                    <i class="bi bi-lock text-muted" style="font-size: 3rem;"></i>
                </div>
                <h5 class="card-title">Không thể đăng ký</h5>

                @if($tournament->status !== 'published')
                <p class="card-text text-muted">Giải đấu chưa mở đăng ký.</p>
                @elseif($tournament->approved_registrations_count >= $tournament->max_pairs)
                <p class="card-text text-muted">Đã đủ số lượng đăng ký cho giải đấu này.</p>
                @else
                <p class="card-text text-muted">Giải đấu không nhận đăng ký mới.</p>
                @endif
            </div>
        </div>
        @endif

        {{-- Current Registrations Count --}}
        <div class="mt-4">
            <div class="row text-center">
                <div class="col-4">
                    <div class="border-end">
                        <div class="fs-4 fw-bold text-success">{{ $tournament->approved_registrations_count }}</div>
                        <small class="text-muted">Đã duyệt</small>
                    </div>
                </div>
                <div class="col-4">
                    <div class="border-end">
                        <div class="fs-4 fw-bold text-warning">{{ $tournament->pending_registrations_count }}</div>
                        <small class="text-muted">Chờ duyệt</small>
                    </div>
                </div>
                <div class="col-4">
                    <div class="fs-4 fw-bold text-primary">{{ $tournament->max_pairs }}</div>
                    <small class="text-muted">Tối đa</small>
                </div>
            </div>
        </div>
</div>