{{-- Tournament Playoffs Partial --}}
<div class="tournament-playoffs">
    @php
    $playoffRounds = [];
    if(isset($quarterFinals)) $playoffRounds['quarter_final'] = $quarterFinals;
    if(isset($semiFinals)) $playoffRounds['semi_final'] = $semiFinals;
    if(isset($finals)) $playoffRounds['final'] = $finals;
    if(isset($thirdPlace)) $playoffRounds['third_place'] = $thirdPlace;

    $hasPlayoffs = count($playoffRounds) > 0;
    @endphp

    @if($hasPlayoffs)
    <div class="playoffs-bracket">
        {{-- Finals --}}
        @if(isset($finals) && count($finals) > 0)
        <div class="mb-5">
            <h4 class="text-center mb-4">
                <i class="bi bi-trophy-fill text-warning me-2"></i>
                Chung kết
            </h4>
            <div class="row justify-content-center">
                @foreach($finals as $match)
                <div class="col-md-6">
                    <div class="card border-warning">
                        <div class="card-body text-center">
                            <div class="match-teams">
                                <div class="team mb-2 {{ $match->result === 'pair1' ? 'fw-bold text-success' : '' }}">
                                    @if($match->pair1)
                                    {{ $match->pair1->player1->name ?? 'N/A' }}
                                    @if($match->pair1->player2)
                                    & {{ $match->pair1->player2->name }}
                                    @endif
                                    @else
                                    Đội 1
                                    @endif
                                </div>

                                <div class="vs-divider my-2">
                                    @if($match->score)
                                    <span class="badge bg-primary fs-6">{{ $match->score }}</span>
                                    @else
                                    <span class="text-muted">vs</span>
                                    @endif
                                </div>

                                <div class="team {{ $match->result === 'pair2' ? 'fw-bold text-success' : '' }}">
                                    @if($match->pair2)
                                    {{ $match->pair2->player1->name ?? 'N/A' }}
                                    @if($match->pair2->player2)
                                    & {{ $match->pair2->player2->name }}
                                    @endif
                                    @else
                                    Đội 2
                                    @endif
                                </div>
                            </div>

                            <div class="mt-3">
                                @php
                                $statusColor = match($match->status) {
                                'Hoàn thành' => 'success',
                                'Đang thi đấu' => 'warning',
                                default => 'secondary'
                                };
                                @endphp
                                <span class="badge bg-{{ $statusColor }}">{{ $match->status }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif

        {{-- Third Place --}}
        @if(isset($thirdPlace) && count($thirdPlace) > 0)
        <div class="mb-5">
            <h5 class="text-center mb-4">
                <i class="bi bi-award text-info me-2"></i>
                Tranh hạng 3
            </h5>
            <div class="row justify-content-center">
                @foreach($thirdPlace as $match)
                <div class="col-md-6">
                    <div class="card border-info">
                        <div class="card-body text-center">
                            <div class="match-teams">
                                <div class="team mb-2 {{ $match->result === 'pair1' ? 'fw-bold text-success' : '' }}">
                                    @if($match->pair1)
                                    {{ $match->pair1->player1->name ?? 'N/A' }}
                                    @if($match->pair1->player2)
                                    & {{ $match->pair1->player2->name }}
                                    @endif
                                    @else
                                    Đội 1
                                    @endif
                                </div>

                                <div class="vs-divider my-2">
                                    @if($match->score)
                                    <span class="badge bg-primary">{{ $match->score }}</span>
                                    @else
                                    <span class="text-muted">vs</span>
                                    @endif
                                </div>

                                <div class="team {{ $match->result === 'pair2' ? 'fw-bold text-success' : '' }}">
                                    @if($match->pair2)
                                    {{ $match->pair2->player1->name ?? 'N/A' }}
                                    @if($match->pair2->player2)
                                    & {{ $match->pair2->player2->name }}
                                    @endif
                                    @else
                                    Đội 2
                                    @endif
                                </div>
                            </div>

                            <div class="mt-3">
                                @php
                                $statusColor = match($match->status) {
                                'Hoàn thành' => 'success',
                                'Đang thi đấu' => 'warning',
                                default => 'secondary'
                                };
                                @endphp
                                <span class="badge bg-{{ $statusColor }}">{{ $match->status }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif

        {{-- Semi Finals --}}
        @if(isset($semiFinals) && count($semiFinals) > 0)
        <div class="mb-5">
            <h5 class="text-center mb-4">
                <i class="bi bi-trophy text-primary me-2"></i>
                Bán kết
            </h5>
            <div class="row">
                @foreach($semiFinals as $index => $match)
                <div class="col-md-6">
                    <div class="card border-primary">
                        <div class="card-header bg-primary text-white text-center">
                            Bán kết {{ $index + 1 }}
                        </div>
                        <div class="card-body text-center">
                            <div class="match-teams">
                                <div class="team mb-2 {{ $match->result === 'pair1' ? 'fw-bold text-success' : '' }}">
                                    @if($match->pair1)
                                    {{ $match->pair1->player1->name ?? 'N/A' }}
                                    @if($match->pair1->player2)
                                    & {{ $match->pair1->player2->name }}
                                    @endif
                                    @else
                                    Đội 1
                                    @endif
                                </div>

                                <div class="vs-divider my-2">
                                    @if($match->score)
                                    <span class="badge bg-primary">{{ $match->score }}</span>
                                    @else
                                    <span class="text-muted">vs</span>
                                    @endif
                                </div>

                                <div class="team {{ $match->result === 'pair2' ? 'fw-bold text-success' : '' }}">
                                    @if($match->pair2)
                                    {{ $match->pair2->player1->name ?? 'N/A' }}
                                    @if($match->pair2->player2)
                                    & {{ $match->pair2->player2->name }}
                                    @endif
                                    @else
                                    Đội 2
                                    @endif
                                </div>
                            </div>

                            <div class="mt-3">
                                @php
                                $statusColor = match($match->status) {
                                'Hoàn thành' => 'success',
                                'Đang thi đấu' => 'warning',
                                default => 'secondary'
                                };
                                @endphp
                                <span class="badge bg-{{ $statusColor }}">{{ $match->status }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif

        {{-- Quarter Finals --}}
        @if(isset($quarterFinals) && count($quarterFinals) > 0)
        <div class="mb-5">
            <h5 class="text-center mb-4">
                <i class="bi bi-award text-secondary me-2"></i>
                Tứ kết
            </h5>
            <div class="row">
                @foreach($quarterFinals as $index => $match)
                <div class="col-md-6 col-lg-3 mb-3">
                    <div class="card border-secondary">
                        <div class="card-header bg-secondary text-white text-center">
                            Tứ kết {{ $index + 1 }}
                        </div>
                        <div class="card-body text-center">
                            <div class="match-teams">
                                <div class="team mb-2 {{ $match->result === 'pair1' ? 'fw-bold text-success' : '' }}">
                                    @if($match->pair1)
                                    <small>
                                        {{ $match->pair1->player1->name ?? 'N/A' }}
                                        @if($match->pair1->player2)
                                        & {{ $match->pair1->player2->name }}
                                        @endif
                                    </small>
                                    @else
                                    <small>Đội 1</small>
                                    @endif
                                </div>

                                <div class="vs-divider my-2">
                                    @if($match->score)
                                    <span class="badge bg-secondary small">{{ $match->score }}</span>
                                    @else
                                    <span class="text-muted small">vs</span>
                                    @endif
                                </div>

                                <div class="team {{ $match->result === 'pair2' ? 'fw-bold text-success' : '' }}">
                                    @if($match->pair2)
                                    <small>
                                        {{ $match->pair2->player1->name ?? 'N/A' }}
                                        @if($match->pair2->player2)
                                        & {{ $match->pair2->player2->name }}
                                        @endif
                                    </small>
                                    @else
                                    <small>Đội 2</small>
                                    @endif
                                </div>
                            </div>

                            <div class="mt-2">
                                @php
                                $statusColor = match($match->status) {
                                'Hoàn thành' => 'success',
                                'Đang thi đấu' => 'warning',
                                default => 'secondary'
                                };
                                @endphp
                                <span class="badge bg-{{ $statusColor }} small">{{ $match->status }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
    @else
    <div class="card">
        <div class="card-body text-center py-5">
            <i class="bi bi-diagram-3 text-muted mb-3" style="font-size: 4rem;"></i>
            <h5 class="text-muted">Chưa có vòng playoffs</h5>
            <p class="text-muted">Vòng playoffs sẽ được tạo sau khi hoàn thành vòng bảng.</p>
        </div>
    </div>
    @endif
</div>