{{-- Tournament Overview Partial --}}
<div class="tournament-overview">
    <div class="row">
        <div class="col-lg-8">
            {{-- Tournament Info --}}
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-info-circle me-2"></i>
                        Thông tin giải đấu
                    </h5>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <strong>Địa điểm:</strong>
                                <span class="text-muted">{{ $tournament->location }}</span>
                            </div>
                            <div class="mb-3">
                                <strong>Ngày thi đấu:</strong>
                                <span class="text-muted">
                                    {{ $tournament->start_date->format('d/m/Y') }}
                                    @if($tournament->end_date && $tournament->end_date != $tournament->start_date)
                                    - {{ $tournament->end_date->format('d/m/Y') }}
                                    @endif
                                </span>
                            </div>
                            <div class="mb-3">
                                <strong>Loại giải:</strong>
                                <span class="badge bg-primary">{{ $tournament->type === 'doubles' ? 'Đôi' : 'Đơn'
                                    }}</span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <strong>Lệ phí:</strong>
                                @if($tournament->fee > 0)
                                <span class="text-success fw-bold">{{ number_format($tournament->fee) }} VNĐ</span>
                                @else
                                <span class="text-success fw-bold">Miễn phí</span>
                                @endif
                            </div>
                            <div class="mb-3">
                                <strong>Số cặp tối đa:</strong>
                                <span class="text-muted">{{ $tournament->max_pairs }} cặp</span>
                            </div>
                            <div class="mb-3">
                                <strong>Giới hạn skill:</strong>
                                <span class="text-muted">
                                    {{ $tournament->skill_point }} ± {{ $tournament->skill_tolerance }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Tournament Description --}}
            @if($tournament->description)
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-file-text me-2"></i>
                        Mô tả giải đấu
                    </h5>
                    <p class="card-text">{!! nl2br(e($tournament->description)) !!}</p>
                </div>
            </div>
            @endif

            {{-- Tournament Rules --}}
            @if($tournament->rules)
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-list-check me-2"></i>
                        Thể lệ giải đấu
                    </h5>
                    <p class="card-text">{!! nl2br(e($tournament->rules)) !!}</p>
                </div>
            </div>
            @endif
        </div>

        <div class="col-lg-4">
            {{-- Tournament Status --}}
            <div class="card mb-4">
                <div class="card-body text-center">
                    <h5 class="card-title">Trạng thái giải đấu</h5>
                    @php
                    $status = $tournament->status ?? 'draft';
                    $statusColor = match($status) {
                    'published' => 'success',
                    'ongoing' => 'warning',
                    'completed' => 'primary',
                    default => 'secondary'
                    };
                    $statusText = match($status) {
                    'published' => 'Đang mở đăng ký',
                    'ongoing' => 'Đang diễn ra',
                    'completed' => 'Đã kết thúc',
                    default => 'Chưa mở'
                    };
                    @endphp
                    <span class="badge bg-{{ $statusColor }} fs-6">{{ $statusText }}</span>

                    @php
                    $registeredCount = $tournament->approved_registrations_count;
                    $totalSlots = $tournament->max_pairs;
                    $percentage = $totalSlots > 0 ? ($registeredCount / $totalSlots) * 100 : 0;
                    @endphp

                    <div class="mt-3">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <small class="text-muted">Đã đăng ký</small>
                            <small class="fw-bold">{{ $registeredCount }}/{{ $totalSlots }}</small>
                        </div>
                        <div class="progress" style="height: 8px;">
                            <div class="progress-bar bg-success" style="width: {{ min($percentage, 100) }}%"
                                role="progressbar">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Prizes --}}
            @if($tournament->prizes)
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-trophy me-2"></i>
                        Giải thưởng
                    </h5>
                    <p class="card-text">{!! nl2br(e($tournament->prizes)) !!}</p>
                </div>
            </div>
            @endif

            {{-- Venue Info --}}
            @if($tournament->venue)
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">
                        <i class="bi bi-geo-alt me-2"></i>
                        Thông tin sân
                    </h5>
                    <h6 class="fw-bold">{{ $tournament->venue->name }}</h6>
                    <p class="text-muted mb-2">{{ $tournament->venue->address }}</p>
                    @if($tournament->venue->contact_phone)
                    <p class="mb-1">
                        <i class="bi bi-telephone me-1"></i>
                        <a href="tel:{{ $tournament->venue->contact_phone }}">{{ $tournament->venue->contact_phone
                            }}</a>
                    </p>
                    @endif
                    @if($tournament->venue->contact_email)
                    <p class="mb-0">
                        <i class="bi bi-envelope me-1"></i>
                        <a href="mailto:{{ $tournament->venue->contact_email }}">{{ $tournament->venue->contact_email
                            }}</a>
                    </p>
                    @endif
                </div>
            </div>
            @endif
        </div>
    </div>
</div>