<style>
    /* Dark theme styles for bracket view */
    .bracket {
        display: flex;
        justify-content: center;
        background: var(--secondary-bg) !important;
        padding: 20px;
        border-radius: 8px;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .bracket-round {
        display: flex;
        flex-direction: column;
        justify-content: space-around;
        flex: 1;
    }

    .bracket-round h4 {
        color: var(--accent-primary) !important;
    }

    .bracket-match {
        display: flex;
        flex-direction: column;
        justify-content: center;
        margin: 20px 10px;
        position: relative;
    }

    .bracket-pair {
        background: var(--card-bg) !important;
        color: var(--text-primary) !important;
        padding: 10px;
        margin: 5px 0;
        border-radius: 5px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        border: 1px solid var(--border-color) !important;
        border-left: 5px solid var(--text-muted);
        min-width: 220px;
    }

    .bracket-pair.winner {
        border-left-color: var(--success) !important;
        font-weight: bold;
        background: rgba(16, 185, 129, 0.1) !important;
    }

    .bracket-pair .score {
        font-weight: bold;
        color: var(--warning) !important;
    }

    .final-rounds-container {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 2rem;
        margin-top: 2rem;
    }

    .final-match {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        padding: 20px;
        border-radius: 8px;
        min-width: 300px;
        display: flex;
        flex-direction: column;
        align-items: center;
        box-shadow: 0 4px 8px var(--shadow-dark);
    }

    .final-match h4 {
        color: var(--accent-primary) !important;
    }

    .final-match .bracket-pair {
        width: 100%;
    }

    .player-number-tag {
        background: var(--accent-primary);
        color: #ffffff;
        padding: 2px 6px;
        border-radius: 50%;
        font-size: 0.7rem;
        font-weight: bold;
        margin: 0 2px;
    }

    @media (max-width: 767.98px) {
        .bracket {
            flex-direction: column;
            align-items: stretch;
        }

        .bracket-round {
            margin-bottom: 2rem;
        }
    }
</style>

<div id="printable-bracket">
    <div class="bracket">
        <!-- Round of 64 -->
        @if(!empty($roundOf64))
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Vòng 1/64</h4>
            @foreach($roundOf64->matches->chunk(2) as $matchGroup)
            <div class="bracket-match-group">
                @foreach($matchGroup as $index => $match)
                <div class="bracket-match">
                    @php $scores = $match->score ? explode('-', $match->score) : [null, null]; @endphp
                    @if($match->status === 'Bye')
                    <div class="bracket-pair winner" title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">BYE</span>
                    </div>
                    @else
                    <div class="bracket-pair {{ ($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : '' }}"
                        title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">{{ $scores[0] ?? '-' }}</span>
                    </div>
                    <div class="bracket-pair {{ ($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : '' }}"
                        title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair2->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">{{ $scores[1] ?? '-' }}</span>
                    </div>
                    @endif
                </div>
                @endforeach
            </div>
            @endforeach
        </div>
        @endif

        <!-- Round of 32 -->
        @if(!empty($roundOf32))
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Vòng 1/32</h4>
            @foreach($roundOf32->matches->chunk(2) as $matchGroup)
            <div class="bracket-match-group">
                @foreach($matchGroup as $index => $match)
                <div class="bracket-match">
                    @php $scores = $match->score ? explode('-', $match->score) : [null, null]; @endphp
                    @if($match->status === 'Bye')
                    <div class="bracket-pair winner" title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">BYE</span>
                    </div>
                    @else
                    <div class="bracket-pair {{ ($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : '' }}"
                        title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">{{ $scores[0] ?? '-' }}</span>
                    </div>
                    <div class="bracket-pair {{ ($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : '' }}"
                        title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair2->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">{{ $scores[1] ?? '-' }}</span>
                    </div>
                    @endif
                </div>
                @endforeach
            </div>
            @endforeach
        </div>
        @endif

        <!-- Round of 16 -->
        @if(!empty($roundOf16))
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Vòng 1/16</h4>
            @foreach($roundOf16->matches->chunk(2) as $matchGroup)
            <div class="bracket-match-group">
                @foreach($matchGroup as $index => $match)
                <div class="bracket-match">
                    @php $scores = $match->score ? explode('-', $match->score) : [null, null]; @endphp
                    @if($match->status === 'Bye')
                    <div class="bracket-pair winner" title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">BYE</span>
                    </div>
                    @else
                    <div class="bracket-pair {{ ($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : '' }}"
                        title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">{{ $scores[0] ?? '-' }}</span>
                    </div>
                    <div class="bracket-pair {{ ($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : '' }}"
                        title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair2->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">{{ $scores[1] ?? '-' }}</span>
                    </div>
                    @endif
                </div>
                @endforeach
            </div>
            @endforeach
        </div>
        @endif

        <!-- Quarter-finals -->
        @if(!empty($quarterFinals))
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Tứ kết</h4>
            @foreach($quarterFinals->matches->chunk(2) as $matchGroup)
            <div class="bracket-match-group">
                @foreach($matchGroup as $index => $match)
                <div class="bracket-match">
                    @php $scores = $match->score ? explode('-', $match->score) : [null, null]; @endphp
                    <div class="bracket-pair {{ ($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : '' }}"
                        title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">{{ $scores[0] ?? '-' }}</span>
                    </div>
                    <div class="bracket-pair {{ ($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : '' }}"
                        title="ID Trận: {{ $match->id }}">
                        <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                            $match->pair2->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : ''
                            }}<span class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : ''
                                }}</span>{{
                            $tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''
                            }}</span>
                        <span class="score">{{ $scores[1] ?? '-' }}</span>
                    </div>
                </div>
                @endforeach
            </div>
            @endforeach
        </div>
        @endif

        <!-- Semi-finals -->
        @if(!empty($semiFinals))
        <div class="bracket-round">
            <h4 class="text-primary text-center mb-3 fw-bold">Bán kết</h4>
            @foreach($semiFinals->matches as $index => $match)
            <div class="bracket-match">
                @php $scores = $match->score ? explode('-', $match->score) : [null, null]; @endphp
                <div class="bracket-pair {{ ($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : '' }}"
                    title="ID Trận: {{ $match->id }}">
                    <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                        $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : '' }}<span
                            class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : '' }}</span>{{
                        $tournament->type == 'doubles' ? ($match->pair1->player2->name ?? '') : ''
                        }}</span>
                    <span class="score">{{ $scores[0] ?? '-' }}</span>
                </div>
                <div class="bracket-pair {{ ($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : '' }}"
                    title="ID Trận: {{ $match->id }}">
                    <span class="pair-name"><span class="player-number-tag p1">1</span>{{
                        $match->pair2->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles' ? ' & ' : '' }}<span
                            class="player-number-tag p2">{{ $tournament->type == 'doubles' ? '2' : '' }}</span>{{
                        $tournament->type == 'doubles' ? ($match->pair2->player2->name ?? '') : ''
                        }}</span>
                    <span class="score">{{ $scores[1] ?? '-' }}</span>
                </div>
            </div>
            @endforeach
        </div>
        @endif
    </div>

    <!-- Final & 3rd Place -->
    @if(!empty($final) || !empty($thirdPlace))
    <div class="final-rounds-container">
        <!-- Tranh Hạng Ba -->
        @if(!empty($thirdPlace) && $thirdPlace->matches->first())
        @php $match = $thirdPlace->matches->first(); @endphp
        <div class="bracket-round final-match">
            <h4 class="text-primary text-center mb-3 fw-bold">{{ $thirdPlace->name }}</h4>
            <div class="bracket-match">
                @php $scores = $match->score ? explode('-', $match->score) : [null, null]; @endphp
                <div class="bracket-pair {{ ($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : '' }}">
                    <span class="pair-name">{{ $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles'
                        ? ' & ' . ($match->pair1->player2->name ?? '') : '' }}</span>
                    <span class="score">{{ $scores[0] ?? '-' }}</span>
                </div>
                <div class="bracket-pair {{ ($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : '' }}">
                    <span class="pair-name">{{ $match->pair2->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles'
                        ? ' & ' . ($match->pair2->player2->name ?? '') : '' }}</span>
                    <span class="score">{{ $scores[1] ?? '-' }}</span>
                </div>
            </div>
        </div>
        @endif

        <!-- Chung kết -->
        @if(!empty($final) && $final->matches->first())
        @php $match = $final->matches->first(); @endphp
        <div class="bracket-round final-match" style="border-color: #f1c40f;">
            <h4 class="text-primary text-center mb-3 fw-bold">{{ $final->name }}</h4>
            <div class="bracket-match">
                @php $scores = $match->score ? explode('-', $match->score) : [null, null]; @endphp
                <div class="bracket-pair {{ ($scores[0] ?? -1) > ($scores[1] ?? -1) ? 'winner' : '' }}">
                    <span class="pair-name">{{ $match->pair1->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles'
                        ? ' & ' . ($match->pair1->player2->name ?? '') : '' }}</span>
                    <span class="score">{{ $scores[0] ?? '-' }}</span>
                </div>
                <div class="bracket-pair {{ ($scores[1] ?? -1) > ($scores[0] ?? -1) ? 'winner' : '' }}">
                    <span class="pair-name">{{ $match->pair2->player1->name ?? 'TBD' }}{{ $tournament->type == 'doubles'
                        ? ' & ' . ($match->pair2->player2->name ?? '') : '' }}</span>
                    <span class="score">{{ $scores[1] ?? '-' }}</span>
                </div>
            </div>
        </div>
        @endif
    </div>
    @endif
</div>