@extends('layouts.app')

@section('title', 'Danh Sách Giải Đấu Pickleball Việt Nam')

@section('content')
<div class="container py-5">
    <h1 class="h2 fw-bold mb-3 text-center" style="color: var(--accent-primary);">Danh Sách Giải Đấu</h1>
    <p class="mb-4 text-center" style="color: var(--text-secondary);">Tìm kiếm và khám phá các giải đấu Pickleball trên
        toàn quốc.</p>

    <!-- Search & Filter (Unified with Home) -->
    <form id="tournamentSearchForm" method="GET" action="" class="row g-3 g-md-2 mb-4 justify-content-center">
        <div class="col-12 col-md-4">
            <label for="tournamentSearch" class="visually-hidden">Tìm kiếm tên giải</label>
            <input type="text" name="search" id="tournamentSearch" value="{{ request('search') }}" class="form-control"
                placeholder="Tìm kiếm tên giải...">
        </div>
        <div class="col-6 col-md-2">
            <label for="tournamentLocation" class="visually-hidden">Địa điểm</label>
            <select name="location" id="tournamentLocation" class="form-select">
                <option value="">Địa điểm (Tất cả)</option>
                @foreach($locations as $loc)
                <option value="{{ $loc }}" {{ request('location')==$loc ? 'selected' : '' }}>{{ $loc }}</option>
                @endforeach
            </select>
        </div>
        <div class="col-6 col-md-2">
            <label for="tournamentType" class="visually-hidden">Loại giải</label>
            <select name="type" id="tournamentType" class="form-select">
                <option value="">Loại giải</option>
                <option value="singles" {{ request('type')=='singles' ? 'selected' : '' }}>Đơn</option>
                <option value="doubles" {{ request('type')=='doubles' ? 'selected' : '' }}>Đôi</option>
            </select>
        </div>
        <div class="col-12 col-md-2">
            <button type="submit" id="tournamentSearchBtn" class="btn btn-primary btn-icon w-100">
                <span class="btn-text d-inline-flex align-items-center gap-2">
                    <i class="bi bi-search"></i>
                    Tìm kiếm
                </span>
                <span class="btn-loading d-none align-items-center gap-2">
                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    <span>Đang tìm...</span>
                </span>
            </button>
        </div>
    </form>

    <div id="tournamentResults" class="results-container tournament-results">
        @if(($ongoing->isEmpty() ?? true) && ($upcoming->isEmpty() ?? true) && ($finished->isEmpty() ?? true))
        <div class="text-center py-5 text-muted">
            <i class="bi bi-calendar-x mb-3 display-6"></i>
            <p class="mb-0">Không tìm thấy giải đấu phù hợp.</p>
        </div>
        @else
        @if(!$ongoing->isEmpty())
        <h2 class="h5 fw-bold mt-2 mb-3 text-center" style="color: var(--danger);">Giải Đấu Đang Diễn Ra</h2>
        <div class="row g-4 mb-4">
            @foreach($ongoing as $tournament)
            @php
            $typeMeta = $tournament->type === 'singles'
            ? ['icon' => 'bi-person-fill', 'label' => 'Đơn']
            : ['icon' => 'bi-people-fill', 'label' => 'Đôi'];

            $skillScoreClass = 'text-info';
            if (($tournament->skill_point ?? 0) >= 4) {
            $skillScoreClass = 'text-success';
            } elseif (($tournament->skill_point ?? 0) >= 3.5) {
            $skillScoreClass = 'text-warning';
            } elseif (($tournament->skill_point ?? 0) < 3) { $skillScoreClass='text-muted' ; }
                $toleranceClass='text-info' ; if (($tournament->skill_tolerance ?? 0) <= 0.3) {
                    $toleranceClass='text-danger' ; } elseif (($tournament->skill_tolerance ?? 0) <= 0.5) {
                        $toleranceClass='text-warning' ; } elseif (($tournament->skill_tolerance ?? 0) > 0.8) {
                        $toleranceClass = 'text-success';
                        }

                        $fee = $tournament->fee ?? 0;
                        $feeClass = 'text-success';
                        if ($fee > 500000) {
                        $feeClass = 'text-danger';
                        } elseif ($fee > 300000) {
                        $feeClass = 'text-warning';
                        } elseif ($fee > 100000) {
                        $feeClass = 'text-info';
                        }
                        @endphp
                        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                            <div class="card h-100 shadow-soft surface-hover border-0">
                                <div class="ratio ratio-16x9 rounded-top-3 overflow-hidden bg-dark bg-opacity-25">
                                    @if($tournament->image)
                                    <img src="{{ asset($tournament->image) }}" alt="Tournament image"
                                        class="w-100 h-100 object-fit-cover">
                                    @else
                                    <div
                                        class="d-flex align-items-center justify-content-center text-muted fw-semibold">
                                        Chưa có hình ảnh
                                    </div>
                                    @endif
                                </div>
                                <div class="card-body d-flex flex-column p-3">
                                    <div class="mb-2 d-flex flex-wrap gap-2 small">
                                        <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                            <i class="bi {{ $typeMeta['icon'] }}"></i>
                                            {{ $typeMeta['label'] }}
                                        </span>


                                        @if(isset($tournament->skill_point))
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $skillScoreClass }}">
                                            <i class="bi bi-star-fill"></i>
                                            {{ number_format($tournament->skill_point, 1) }}
                                        </span>
                                        @endif

                                        @if(isset($tournament->skill_tolerance))
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $toleranceClass }}">
                                            <i class="bi bi-activity"></i>
                                            ± {{ $tournament->skill_tolerance }}
                                        </span>
                                        @endif

                                        @if($tournament->location)
                                        <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                            <i class="bi bi-geo-alt-fill"></i>
                                            {{ $tournament->location }}
                                        </span>
                                        @endif
                                    </div>

                                    <h3 class="h6 fw-bold text-truncate mb-2" title="{{ $tournament->name }}">
                                        {{ $tournament->name }}
                                    </h3>

                                    <div class="small text-secondary fw-semibold d-flex align-items-center gap-2 mb-3">
                                        <i class="bi bi-calendar3"></i>
                                        <span>{{ $tournament->start_date->format('d/m/Y') }} → {{
                                            $tournament->end_date->format('d/m/Y') }}</span>
                                    </div>

                                    <div class="d-flex flex-wrap gap-2 mb-3">
                                        @if($tournament->prizes)
                                        <span class="badge accent-gradient d-inline-flex align-items-center gap-2">
                                            <i class="bi bi-trophy-fill"></i>
                                            {{ $tournament->prizes }}
                                        </span>
                                        @endif
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $feeClass }}">
                                            <i class="bi bi-cash-stack"></i>
                                            {{ number_format($fee) }}đ
                                        </span>
                                    </div>

                                    <div class="mt-auto">
                                        <a href="{{ route('tournaments.show', $tournament->slug) }}"
                                            class="btn btn-outline-primary btn-sm btn-icon w-100">
                                            <span>Xem chi tiết</span>
                                            <i class="bi bi-arrow-right-short"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
        </div>
        @endif

        @if(!$upcoming->isEmpty())
        <h2 class="h5 fw-bold mt-2 mb-3 text-center" style="color: var(--success);">Giải Đấu Sắp Diễn Ra</h2>
        <div class="row g-4 mb-4">
            @foreach($upcoming as $tournament)
            @php
            $typeMeta = $tournament->type === 'singles'
            ? ['icon' => 'bi-person-fill', 'label' => 'Đơn']
            : ['icon' => 'bi-people-fill', 'label' => 'Đôi'];

            $skillScoreClass = 'text-info';
            if (($tournament->skill_point ?? 0) >= 4) {
            $skillScoreClass = 'text-success';
            } elseif (($tournament->skill_point ?? 0) >= 3.5) {
            $skillScoreClass = 'text-warning';
            } elseif (($tournament->skill_point ?? 0) < 3) { $skillScoreClass='text-muted' ; }
                $toleranceClass='text-info' ; if (($tournament->skill_tolerance ?? 0) <= 0.3) {
                    $toleranceClass='text-danger' ; } elseif (($tournament->skill_tolerance ?? 0) <= 0.5) {
                        $toleranceClass='text-warning' ; } elseif (($tournament->skill_tolerance ?? 0) > 0.8) {
                        $toleranceClass = 'text-success';
                        }

                        $fee = $tournament->fee ?? 0;
                        $feeClass = 'text-success';
                        if ($fee > 500000) {
                        $feeClass = 'text-danger';
                        } elseif ($fee > 300000) {
                        $feeClass = 'text-warning';
                        } elseif ($fee > 100000) {
                        $feeClass = 'text-info';
                        }
                        @endphp
                        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                            <div class="card h-100 shadow-soft surface-hover border-0">
                                <div class="ratio ratio-16x9 rounded-top-3 overflow-hidden bg-dark bg-opacity-25">
                                    @if($tournament->image)
                                    <img src="{{ asset($tournament->image) }}" alt="Tournament image"
                                        class="w-100 h-100 object-fit-cover">
                                    @else
                                    <div
                                        class="d-flex align-items-center justify-content-center text-muted fw-semibold">
                                        Chưa có hình ảnh
                                    </div>
                                    @endif
                                </div>
                                <div class="card-body d-flex flex-column p-3">
                                    <div class="mb-2 d-flex flex-wrap gap-2 small">
                                        <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                            <i class="bi {{ $typeMeta['icon'] }}"></i>
                                            {{ $typeMeta['label'] }}
                                        </span>


                                        @if(isset($tournament->skill_point))
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $skillScoreClass }}">
                                            <i class="bi bi-star-fill"></i>
                                            {{ number_format($tournament->skill_point, 1) }}
                                        </span>
                                        @endif

                                        @if(isset($tournament->skill_tolerance))
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $toleranceClass }}">
                                            <i class="bi bi-activity"></i>
                                            ± {{ $tournament->skill_tolerance }}
                                        </span>
                                        @endif

                                        @if($tournament->location)
                                        <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                            <i class="bi bi-geo-alt-fill"></i>
                                            {{ $tournament->location }}
                                        </span>
                                        @endif
                                    </div>

                                    <h3 class="h6 fw-bold text-truncate mb-2" title="{{ $tournament->name }}">
                                        {{ $tournament->name }}
                                    </h3>

                                    <div class="small text-secondary fw-semibold d-flex align-items-center gap-2 mb-3">
                                        <i class="bi bi-calendar3"></i>
                                        <span>{{ $tournament->start_date->format('d/m/Y') }} → {{
                                            $tournament->end_date->format('d/m/Y') }}</span>
                                    </div>

                                    <div class="d-flex flex-wrap gap-2 mb-3">
                                        @if($tournament->prizes)
                                        <span class="badge accent-gradient d-inline-flex align-items-center gap-2">
                                            <i class="bi bi-trophy-fill"></i>
                                            {{ $tournament->prizes }}
                                        </span>
                                        @endif
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $feeClass }}">
                                            <i class="bi bi-cash-stack"></i>
                                            {{ number_format($fee) }}đ
                                        </span>
                                    </div>

                                    <div class="mt-auto">
                                        <a href="{{ route('tournaments.show', $tournament->slug) }}"
                                            class="btn btn-outline-primary btn-sm btn-icon w-100">
                                            <span>Xem chi tiết</span>
                                            <i class="bi bi-arrow-right-short"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
        </div>
        @endif

        @if(!$finished->isEmpty())
        <h2 class="h5 fw-bold mt-2 mb-3 text-center" style="color: var(--text-muted);">Giải Đấu Đã Kết Thúc</h2>
        <div class="row g-4 mb-2">
            @foreach($finished as $tournament)
            @php
            $typeMeta = $tournament->type === 'singles'
            ? ['icon' => 'bi-person-fill', 'label' => 'Đơn']
            : ['icon' => 'bi-people-fill', 'label' => 'Đôi'];

            $skillScoreClass = 'text-info';
            if (($tournament->skill_point ?? 0) >= 4) {
            $skillScoreClass = 'text-success';
            } elseif (($tournament->skill_point ?? 0) >= 3.5) {
            $skillScoreClass = 'text-warning';
            } elseif (($tournament->skill_point ?? 0) < 3) { $skillScoreClass='text-muted' ; }
                $toleranceClass='text-info' ; if (($tournament->skill_tolerance ?? 0) <= 0.3) {
                    $toleranceClass='text-danger' ; } elseif (($tournament->skill_tolerance ?? 0) <= 0.5) {
                        $toleranceClass='text-warning' ; } elseif (($tournament->skill_tolerance ?? 0) > 0.8) {
                        $toleranceClass = 'text-success';
                        }

                        $fee = $tournament->fee ?? 0;
                        $feeClass = 'text-success';
                        if ($fee > 500000) {
                        $feeClass = 'text-danger';
                        } elseif ($fee > 300000) {
                        $feeClass = 'text-warning';
                        } elseif ($fee > 100000) {
                        $feeClass = 'text-info';
                        }
                        @endphp
                        <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                            <div class="card h-100 shadow-soft surface-hover border-0">
                                <div class="ratio ratio-16x9 rounded-top-3 overflow-hidden bg-dark bg-opacity-25">
                                    @if($tournament->image)
                                    <img src="{{ asset($tournament->image) }}" alt="Tournament image"
                                        class="w-100 h-100 object-fit-cover">
                                    @else
                                    <div
                                        class="d-flex align-items-center justify-content-center text-muted fw-semibold">
                                        Chưa có hình ảnh
                                    </div>
                                    @endif
                                </div>
                                <div class="card-body d-flex flex-column p-3">
                                    <div class="mb-2 d-flex flex-wrap gap-2 small">
                                        <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                            <i class="bi {{ $typeMeta['icon'] }}"></i>
                                            {{ $typeMeta['label'] }}
                                        </span>

                                        @if(isset($tournament->skill_point))
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $skillScoreClass }}">
                                            <i class="bi bi-star-fill"></i>
                                            {{ number_format($tournament->skill_point, 1) }}
                                        </span>
                                        @endif

                                        @if(isset($tournament->skill_tolerance))
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $toleranceClass }}">
                                            <i class="bi bi-activity"></i>
                                            ± {{ $tournament->skill_tolerance }}
                                        </span>
                                        @endif

                                        @if($tournament->location)
                                        <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                            <i class="bi bi-geo-alt-fill"></i>
                                            {{ $tournament->location }}
                                        </span>
                                        @endif
                                    </div>

                                    <h3 class="h6 fw-bold text-truncate mb-2" title="{{ $tournament->name }}">
                                        {{ $tournament->name }}
                                    </h3>

                                    <div class="small text-secondary fw-semibold d-flex align-items-center gap-2 mb-3">
                                        <i class="bi bi-calendar3"></i>
                                        <span>{{ $tournament->start_date->format('d/m/Y') }} → {{
                                            $tournament->end_date->format('d/m/Y') }}</span>
                                    </div>

                                    <div class="d-flex flex-wrap gap-2 mb-3">
                                        @if($tournament->prizes)
                                        <span class="badge accent-gradient d-inline-flex align-items-center gap-2">
                                            <i class="bi bi-trophy-fill"></i>
                                            {{ $tournament->prizes }}
                                        </span>
                                        @endif
                                        <span
                                            class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $feeClass }}">
                                            <i class="bi bi-cash-stack"></i>
                                            {{ number_format($fee) }}đ
                                        </span>
                                    </div>

                                    <div class="mt-auto">
                                        <a href="{{ route('tournaments.show', $tournament->slug) }}"
                                            class="btn btn-outline-primary btn-sm btn-icon w-100">
                                            <span>Xem chi tiết</span>
                                            <i class="bi bi-arrow-right-short"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
        </div>
        @endif

        <div class="mt-4 d-flex justify-content-center">
            <nav>
                <div class="pagination-wrapper">
                    {{ $tournaments->withQueryString()->links() }}
                </div>
            </nav>
        </div>
        @endif
    </div>
</div>

<style>
    .results-container {
        transition: opacity 0.3s ease, transform 0.3s ease;
    }

    .results-container.loading {
        opacity: 0.5;
        transform: translateY(6px);
        pointer-events: none;
    }

    /* Preserve dark theme styles for controls */
    .form-control,
    .form-select {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .form-control:focus,
    .form-select:focus {
        background: var(--card-bg) !important;
        border-color: var(--accent-primary) !important;
        color: var(--text-primary) !important;
        box-shadow: 0 0 0 0.2rem var(--shadow-primary) !important;
    }

    .pagination-wrapper .pagination .page-link {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--accent-primary) !important;
    }

    .pagination-wrapper .pagination .page-item.active .page-link {
        background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary)) !important;
        border-color: var(--accent-primary) !important;
        color: var(--text-primary) !important;
    }

    .pagination-wrapper .pagination .page-item.disabled .page-link {
        background: var(--card-bg) !important;
        border-color: var(--border-color) !important;
        color: var(--text-muted) !important;
    }

    .pagination-wrapper .pagination .page-link:hover {
        background: var(--secondary-bg) !important;
        border-color: var(--accent-primary) !important;
        color: var(--accent-primary) !important;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('tournamentSearchForm');
        const results = document.getElementById('tournamentResults');
        const btn = document.getElementById('tournamentSearchBtn');

        if (!form || !results || !btn) return;

        form.addEventListener('submit', function(e) {
            e.preventDefault();
            performSearch();
        });

        const tournamentSearch = document.getElementById('tournamentSearch');
        const tournamentLocation = document.getElementById('tournamentLocation');
        const tournamentType = document.getElementById('tournamentType');

        if (tournamentSearch) tournamentSearch.addEventListener('input', debounce(() => performSearch(), 500));
        if (tournamentLocation) tournamentLocation.addEventListener('change', () => performSearch());
        if (tournamentType) tournamentType.addEventListener('change', () => performSearch());

        function performSearch() {
            showLoadingState(btn, results);

            const formData = new FormData(form);
            const searchParams = new URLSearchParams();
            for (let [key, value] of formData.entries()) {
                if ((value || '').toString().trim()) {
                    searchParams.append(key, value);
                }
            }
            searchParams.append('ajax', '1');

            fetch(window.location.pathname + '?' + searchParams.toString(), {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'text/html'
                }
            })
            .then(res => {
                if (!res.ok) throw new Error('Network error');
                return res.text();
            })
            .then(html => {
                // Parse the entire HTML and extract the results container to avoid broken markup
                const parser = new DOMParser();
                const doc = parser.parseFromString(html, 'text/html');
                const container = doc.querySelector('#tournamentResults');
                if (container) {
                    results.innerHTML = container.innerHTML;
                } else {
                    // Fallback: try to find the grid rows
                    const grid = doc.querySelector('.tournament-results .row.g-4');
                    results.innerHTML = grid ? grid.outerHTML : '<div class="text-center py-4 text-muted"><i class="bi bi-search mb-2"></i><p class="mb-0">Không tìm thấy kết quả nào phù hợp.</p></div>';
                }
            })
            .catch(err => {
                console.error('Search error:', err);
                results.innerHTML = '<div class="text-center py-4 text-muted"><i class="bi bi-exclamation-triangle mb-2"></i><p class="mb-0">Có lỗi xảy ra khi tìm kiếm. Vui lòng thử lại.</p></div>';
            })
            .finally(() => {
                hideLoadingState(btn, results);
                results.style.opacity = '0';
                results.style.transform = 'translateY(10px)';
                setTimeout(() => {
                    results.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
                    results.style.opacity = '1';
                    results.style.transform = 'translateY(0)';
                }, 50);
            });
        }

        function showLoadingState(btn, results) {
            const btnText = btn.querySelector('.btn-text');
            const btnLoading = btn.querySelector('.btn-loading');
            if (btnText) btnText.classList.add('d-none');
            if (btnLoading) btnLoading.classList.remove('d-none');
            btn.disabled = true;
            results.classList.add('loading');
        }
        function hideLoadingState(btn, results) {
            const btnText = btn.querySelector('.btn-text');
            const btnLoading = btn.querySelector('.btn-loading');
            if (btnText) btnText.classList.remove('d-none');
            if (btnLoading) btnLoading.classList.add('d-none');
            btn.disabled = false;
            results.classList.remove('loading');
        }
        function debounce(func, wait) {
            let timeout; return function(...args){ clearTimeout(timeout); timeout = setTimeout(() => func.apply(this, args), wait); };
        }
    });
</script>
@endsection