@extends('layouts.app')
@section('title', 'Xác thực mật khẩu Tournament')
@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-12 col-sm-8 col-md-6 col-lg-5 col-xl-4">
            <div class="card glass-panel border-glow shadow-soft p-4">
                <div class="card-body">
                    <div class="text-center mb-4">
                        <div class="icon-pill mb-3">
                            <i class="bi bi-shield-lock-fill"></i>
                        </div>
                        <h2 class="h4 fw-bold text-primary mb-2">Xác thực giải đấu</h2>
                        <p class="text-muted mb-0">Nhập mật khẩu để truy cập quản lý giải đấu</p>
                    </div>

                    <form id="tournamentPasswordForm" method="POST"
                        action="/tournament-setting/{{ $tournamentId }}/setting/check">
                        @csrf
                        <div class="mb-3">
                            <label for="user_type" class="form-label">
                                <i class="bi bi-person-badge me-2"></i>Vai trò
                            </label>
                            <select name="user_type" id="user_type" class="form-select">
                                <option value="auto">Tự động xác định</option>
                                <option value="organizer">Ban tổ chức</option>
                                <option value="referee">Trọng tài</option>
                            </select>
                        </div>

                        <div class="mb-4">
                            <label for="password" class="form-label">
                                <i class="bi bi-key me-2"></i>Mật khẩu giải đấu
                            </label>
                            <input type="password" name="password" id="password" class="form-control"
                                placeholder="Nhập mật khẩu giải đấu" required>
                        </div>

                        <button type="submit" class="btn btn-primary btn-icon w-100">
                            <i class="bi bi-shield-check"></i>
                            <span>Xác thực</span>
                        </button>
                    </form>

                    @if(session('error'))
                    <div class="alert alert-danger mt-3 text-center">
                        <i class="bi bi-exclamation-triangle me-2"></i>
                        {{ session('error') }}
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('tournamentPasswordForm');
        const submitBtn = form.querySelector('button[type="submit"]');
        const originalBtnContent = submitBtn.innerHTML;
        
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtn.innerHTML = `
                <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                Đang xác thực...
            `;
            
            const formData = new FormData(form);
            
            fetch(form.action, {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': formData.get('_token'),
                    'Accept': 'application/json'
                },
                body: formData
            })
            .then(response => {
                // Try to parse JSON; if not JSON, treat as a success and reload/redirect
                return response.json().catch(() => ({ 
                    __nonJson: true, 
                    status: response.status,
                    ok: response.ok 
                }));
            })
            .then(data => {
                if (data.__nonJson) {
                    // Non-JSON response (likely a redirect) — reload so browser follows it
                    if (data.ok) {
                        window.location.reload();
                    } else {
                        throw new Error('Request failed');
                    }
                    return;
                }

                if (data.success) {
                    // Show success message
                    if (typeof Swal !== 'undefined') {
                        Swal.fire({
                            icon: 'success',
                            title: 'Thành công!',
                            text: 'Xác thực thành công!',
                            showConfirmButton: false,
                            timer: 1500
                        });
                    }
                    
                    // Redirect if URL provided, otherwise reload
                    setTimeout(() => {
                        if (data.redirect) {
                            window.location.href = data.redirect;
                        } else {
                            window.location.reload();
                        }
                    }, 1500);
                    return;
                }

                // Show error message
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Sai mật khẩu',
                        text: 'Vui lòng kiểm tra lại mật khẩu và thử lại!',
                        confirmButtonText: 'Thử lại'
                    });
                } else {
                    alert('Sai mật khẩu. Vui lòng thử lại!');
                }
            })
            .catch(error => {
                console.error('Authentication error:', error);
                
                if (typeof Swal !== 'undefined') {
                    Swal.fire({
                        icon: 'error',
                        title: 'Lỗi kết nối',
                        text: 'Không thể kết nối đến máy chủ. Vui lòng thử lại!',
                        confirmButtonText: 'Thử lại'
                    });
                } else {
                    alert('Lỗi kết nối. Vui lòng thử lại!');
                }
            })
            .finally(() => {
                // Reset button state
                submitBtn.disabled = false;
                submitBtn.innerHTML = originalBtnContent;
            });
        });
        
        // Auto-focus on password field
        const passwordField = document.getElementById('password');
        if (passwordField) {
            passwordField.focus();
        }
        
        // Handle Enter key in form fields
        form.addEventListener('keypress', function(e) {
            if (e.key === 'Enter' && !submitBtn.disabled) {
                e.preventDefault();
                form.dispatchEvent(new Event('submit'));
            }
        });
    });
</script>
@endsection