@extends('layouts.app')

@section('title', 'Đăng Ký Thành Viên')

@push('layout_css')
<style>
    /* Dark theme form styles */
    .form-control:focus,
    .form-select:focus {
        background: var(--card-bg) !important;
        border-color: var(--accent-primary) !important;
        color: var(--text-primary) !important;
        box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.25) !important;
    }

    .form-control::placeholder {
        color: var(--text-muted) !important;
    }

    .form-select option {
        background: var(--card-bg) !important;
        color: var(--text-primary) !important;
    }

    /* Alert styling for dark theme */
    .alert-success {
        background: rgba(34, 197, 94, 0.15) !important;
        border: 1px solid rgba(34, 197, 94, 0.3) !important;
        color: var(--success) !important;
    }
</style>
@endpush

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-6 col-md-8">
            <div class="card shadow-lg border rounded-4"
                style="background: var(--card-bg); border-color: var(--border-color) !important;">
                <div class="card-header text-white text-center rounded-top-4"
                    style="background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary));">
                    <h2 class="mb-0" style="color: var(--text-primary);">Đăng Ký Thành Viên Pickleball</h2>
                </div>
                <div class="card-body p-4">
                    @if(session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    <form method="POST" action="{{ route('register-member.register') }}" enctype="multipart/form-data"
                        autocomplete="off">
                        @csrf
                        <div class="mb-3">
                            <label for="name" class="form-label" style="color: var(--text-primary);">Họ và tên <span
                                    class="text-danger">*</span></label>
                            <input type="text" name="name" id="name" class="form-control" value="{{ old('name') }}"
                                required maxlength="255"
                                style="background: var(--card-bg); border: 1px solid var(--border-color); color: var(--text-primary);">
                            @error('name')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label" style="color: var(--text-primary);">Email <span
                                    class="text-danger">*</span></label>
                            <input type="email" name="email" id="email" class="form-control" value="{{ old('email') }}"
                                required maxlength="255"
                                style="background: var(--card-bg); border: 1px solid var(--border-color); color: var(--text-primary);">
                            @error('email')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div>
                        {{-- <div class="mb-3">
                            <label for="password" class="form-label">Mật khẩu <span class="text-danger">*</span></label>
                            <input type="password" name="password" id="password" class="form-control" required
                                minlength="6">
                            @error('password')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div>
                        <div class="mb-3">
                            <label for="password_confirmation" class="form-label">Xác nhận mật khẩu <span
                                    class="text-danger">*</span></label>
                            <input type="password" name="password_confirmation" id="password_confirmation"
                                class="form-control" required minlength="6">
                            @error('password_confirmation')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div> --}}
                        <div class="mb-3">
                            <label for="phone" class="form-label" style="color: var(--text-primary);">Số điện thoại
                                <span class="text-danger">*</span></label>
                            <input type="text" name="phone" id="phone" class="form-control" value="{{ old('phone') }}"
                                maxlength="20"
                                style="background: var(--card-bg); border: 1px solid var(--border-color); color: var(--text-primary);">
                            @error('phone')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div>
                        <div class="mb-3">
                            <label for="location" class="form-label" style="color: var(--text-primary);">Địa điểm <span
                                    class="text-danger">*</span></label>
                            <select name="location" id="location" class="form-select" required
                                style="background: var(--card-bg); border: 1px solid var(--border-color); color: var(--text-primary);">
                                <option value="Đà Nẵng" @if(old('location')=='Đà Nẵng' ) selected @endif>Đà Nẵng
                                </option>
                                <option value="Hội An" @if(old('location')=='Hội An' ) selected @endif>Hội An</option>
                                <option value="An Giang" @if(old('location')=='An Giang' ) selected @endif>An Giang
                                </option>
                                <option value="Bà Rịa - Vũng Tàu" @if(old('location')=='Bà Rịa - Vũng Tàu' ) selected
                                    @endif>Bà Rịa
                                    - Vũng Tàu</option>
                                <option value="Bắc Giang" @if(old('location')=='Bắc Giang' ) selected @endif>Bắc Giang
                                </option>
                                <option value="Bắc Kạn" @if(old('location')=='Bắc Kạn' ) selected @endif>Bắc Kạn
                                </option>
                                <option value="Bạc Liêu" @if(old('location')=='Bạc Liêu' ) selected @endif>Bạc Liêu
                                </option>
                                <option value="Bắc Ninh" @if(old('location')=='Bắc Ninh' ) selected @endif>Bắc Ninh
                                </option>
                                <option value="Bến Tre" @if(old('location')=='Bến Tre' ) selected @endif>Bến Tre
                                </option>
                                <option value="Bình Định" @if(old('location')=='Bình Định' ) selected @endif>Bình Định
                                </option>
                                <option value="Bình Dương" @if(old('location')=='Bình Dương' ) selected @endif>Bình
                                    Dương</option>
                                <option value="Bình Phước" @if(old('location')=='Bình Phước' ) selected @endif>Bình
                                    Phước</option>
                                <option value="Bình Thuận" @if(old('location')=='Bình Thuận' ) selected @endif>Bình
                                    Thuận</option>
                                <option value="Cà Mau" @if(old('location')=='Cà Mau' ) selected @endif>Cà Mau</option>
                                <option value="Cần Thơ" @if(old('location')=='Cần Thơ' ) selected @endif>Cần Thơ
                                </option>
                                <option value="Cao Bằng" @if(old('location')=='Cao Bằng' ) selected @endif>Cao Bằng
                                </option>
                                <option value="Đắk Lắk" @if(old('location')=='Đắk Lắk' ) selected @endif>Đắk Lắk
                                </option>
                                <option value="Đắk Nông" @if(old('location')=='Đắk Nông' ) selected @endif>Đắk Nông
                                </option>
                                <option value="Điện Biên" @if(old('location')=='Điện Biên' ) selected @endif>Điện Biên
                                </option>
                                <option value="Đồng Nai" @if(old('location')=='Đồng Nai' ) selected @endif>Đồng Nai
                                </option>
                                <option value="Đồng Tháp" @if(old('location')=='Đồng Tháp' ) selected @endif>Đồng Tháp
                                </option>
                                <option value="Gia Lai" @if(old('location')=='Gia Lai' ) selected @endif>Gia Lai
                                </option>
                                <option value="Hà Giang" @if(old('location')=='Hà Giang' ) selected @endif>Hà Giang
                                </option>
                                <option value="Hà Nam" @if(old('location')=='Hà Nam' ) selected @endif>Hà Nam</option>
                                <option value="Hà Nội" @if(old('location')=='Hà Nội' ) selected @endif>Hà Nội</option>
                                <option value="Hà Tĩnh" @if(old('location')=='Hà Tĩnh' ) selected @endif>Hà Tĩnh
                                </option>
                                <option value="Hải Dương" @if(old('location')=='Hải Dương' ) selected @endif>Hải Dương
                                </option>
                                <option value="Hải Phòng" @if(old('location')=='Hải Phòng' ) selected @endif>Hải Phòng
                                </option>
                                <option value="Hậu Giang" @if(old('location')=='Hậu Giang' ) selected @endif>Hậu Giang
                                </option>
                                <option value="Hòa Bình" @if(old('location')=='Hòa Bình' ) selected @endif>Hòa Bình
                                </option>
                                <option value="Hưng Yên" @if(old('location')=='Hưng Yên' ) selected @endif>Hưng Yên
                                </option>
                                <option value="Khánh Hòa" @if(old('location')=='Khánh Hòa' ) selected @endif>Khánh Hòa
                                </option>
                                <option value="Kiên Giang" @if(old('location')=='Kiên Giang' ) selected @endif>Kiên
                                    Giang</option>
                                <option value="Kon Tum" @if(old('location')=='Kon Tum' ) selected @endif>Kon Tum
                                </option>
                                <option value="Lai Châu" @if(old('location')=='Lai Châu' ) selected @endif>Lai Châu
                                </option>
                                <option value="Lâm Đồng" @if(old('location')=='Lâm Đồng' ) selected @endif>Lâm Đồng
                                </option>
                                <option value="Lạng Sơn" @if(old('location')=='Lạng Sơn' ) selected @endif>Lạng Sơn
                                </option>
                                <option value="Lào Cai" @if(old('location')=='Lào Cai' ) selected @endif>Lào Cai
                                </option>
                                <option value="Long An" @if(old('location')=='Long An' ) selected @endif>Long An
                                </option>
                                <option value="Nam Định" @if(old('location')=='Nam Định' ) selected @endif>Nam Định
                                </option>
                                <option value="Nghệ An" @if(old('location')=='Nghệ An' ) selected @endif>Nghệ An
                                </option>
                                <option value="Ninh Bình" @if(old('location')=='Ninh Bình' ) selected @endif>Ninh Bình
                                </option>
                                <option value="Ninh Thuận" @if(old('location')=='Ninh Thuận' ) selected @endif>Ninh
                                    Thuận</option>
                                <option value="Phú Thọ" @if(old('location')=='Phú Thọ' ) selected @endif>Phú Thọ
                                </option>
                                <option value="Phú Yên" @if(old('location')=='Phú Yên' ) selected @endif>Phú Yên
                                </option>
                                <option value="Quảng Bình" @if(old('location')=='Quảng Bình' ) selected @endif>Quảng
                                    Bình</option>
                                <option value="Quảng Nam" @if(old('location')=='Quảng Nam' ) selected @endif>Quảng Nam
                                </option>
                                <option value="Quảng Ngãi" @if(old('location')=='Quảng Ngãi' ) selected @endif>Quảng
                                    Ngãi</option>
                                <option value="Quảng Ninh" @if(old('location')=='Quảng Ninh' ) selected @endif>Quảng
                                    Ninh</option>
                                <option value="Quảng Trị" @if(old('location')=='Quảng Trị' ) selected @endif>Quảng Trị
                                </option>
                                <option value="Sóc Trăng" @if(old('location')=='Sóc Trăng' ) selected @endif>Sóc Trăng
                                </option>
                                <option value="Sơn La" @if(old('location')=='Sơn La' ) selected @endif>Sơn La</option>
                                <option value="Tây Ninh" @if(old('location')=='Tây Ninh' ) selected @endif>Tây Ninh
                                </option>
                                <option value="Thái Bình" @if(old('location')=='Thái Bình' ) selected @endif>Thái Bình
                                </option>
                                <option value="Thái Nguyên" @if(old('location')=='Thái Nguyên' ) selected @endif>Thái
                                    Nguyên
                                </option>
                                <option value="Thanh Hóa" @if(old('location')=='Thanh Hóa' ) selected @endif>Thanh Hóa
                                </option>
                                <option value="Thừa Thiên Huế" @if(old('location')=='Thừa Thiên Huế' ) selected @endif>
                                    Thừa Thiên
                                    Huế</option>
                                <option value="Tiền Giang" @if(old('location')=='Tiền Giang' ) selected @endif>Tiền
                                    Giang</option>
                                <option value="TP Hồ Chí Minh" @if(old('location')=='TP Hồ Chí Minh' ) selected @endif>
                                    TP Hồ Chí
                                    Minh</option>
                                <option value="Trà Vinh" @if(old('location')=='Trà Vinh' ) selected @endif>Trà Vinh
                                </option>
                                <option value="Tuyên Quang" @if(old('location')=='Tuyên Quang' ) selected @endif>Tuyên
                                    Quang
                                </option>
                                <option value="Vĩnh Long" @if(old('location')=='Vĩnh Long' ) selected @endif>Vĩnh Long
                                </option>
                                <option value="Vĩnh Phúc" @if(old('location')=='Vĩnh Phúc' ) selected @endif>Vĩnh Phúc
                                </option>
                                <option value="Yên Bái" @if(old('location')=='Yên Bái' ) selected @endif>Yên Bái
                                </option>
                                <option value="Khác" @if(old('location')=='Khác' ) selected @endif>Khác</option>
                            </select>
                            @error('location')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div>
                        <div class="mb-3">
                            <label for="initial_level" class="form-label" style="color: var(--text-primary);">Trình độ
                                ban đầu <span class="text-danger">*</span></label>
                            <select name="initial_level" id="initial_level" class="form-select" required
                                style="background: var(--card-bg); border: 1px solid var(--border-color); color: var(--text-primary);">
                                <option value="2.6">2.6</option>
                                @for($i = 2.0; $i <= 6.0; $i +=0.1) <option value="{{ number_format($i,1) }}"
                                    @if(old('initial_level')==number_format($i,1)) selected @endif>{{
                                    number_format($i,1)
                                    }}</option>
                                    @endfor
                            </select>
                            @error('initial_level')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div>
                        <div class="mb-3">
                            <label for="gender" class="form-label" style="color: var(--text-primary);">Giới tính <span
                                    class="text-danger">*</span></label>
                            <select name="gender" id="gender" class="form-select"
                                style="background: var(--card-bg); border: 1px solid var(--border-color); color: var(--text-primary);">
                                <option value="Nam">Nam</option>
                                <option value="Nữ" @if(old('gender')=='Nữ' ) selected @endif>Nữ</option>
                                <option value="Khác" @if(old('gender')=='Khác' ) selected @endif>Khác</option>
                            </select>
                            @error('gender')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div>
                        <div class="mb-3">
                            <label for="avatar" class="form-label" style="color: var(--text-primary);">Ảnh đại
                                diện</label>
                            <input type="file" name="avatar" id="avatar" class="form-control" accept="image/*"
                                style="background: var(--card-bg); border: 1px solid var(--border-color); color: var(--text-primary);">
                            @error('avatar')<div class="text-danger small">{{ $message }}</div>@enderror
                        </div>
                        <button type="submit" class="btn w-100 py-2 fw-bold"
                            style="background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary)); border: none; color: var(--text-primary);">Đăng
                            Ký</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection