{{-- Playoff Bracket Display --}}
@if(!empty($playoffRounds))
<div class="row">
    {{-- Quarter Finals --}}
    @if(!empty($playoffRounds['quarter_finals']))
    <div class="col-lg-3 mb-4">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0"><i class="bi bi-diagram-2"></i> Tứ kết</h6>
            </div>
            <div class="card-body">
                @foreach($playoffRounds['quarter_finals']->matches as $match)
                <div class="playoff-match mb-2 p-2 border rounded">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-1">
                            @if($match->pair1)
                            <small class="fw-bold">{{ $match->pair1->player1->name }} / {{ $match->pair1->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-score">
                            @if($match->score)
                            <span class="badge bg-primary">{{ $match->score }}</span>
                            @else
                            <span class="badge bg-secondary">-</span>
                            @endif
                        </div>
                    </div>
                    <hr class="my-1">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-2">
                            @if($match->pair2)
                            <small class="fw-bold">{{ $match->pair2->player1->name }} / {{ $match->pair2->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-status">
                            <small class="text-muted">{{ $match->status ?? 'Chưa bắt đầu' }}</small>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    {{-- Semi Finals --}}
    @if(!empty($playoffRounds['semi_finals']))
    <div class="col-lg-3 mb-4">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-warning text-white">
                <h6 class="mb-0"><i class="bi bi-diagram-2"></i> Bán kết</h6>
            </div>
            <div class="card-body">
                @foreach($playoffRounds['semi_finals']->matches as $match)
                <div class="playoff-match mb-2 p-2 border rounded">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-1">
                            @if($match->pair1)
                            <small class="fw-bold">{{ $match->pair1->player1->name }} / {{ $match->pair1->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-score">
                            @if($match->score)
                            <span class="badge bg-primary">{{ $match->score }}</span>
                            @else
                            <span class="badge bg-secondary">-</span>
                            @endif
                        </div>
                    </div>
                    <hr class="my-1">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-2">
                            @if($match->pair2)
                            <small class="fw-bold">{{ $match->pair2->player1->name }} / {{ $match->pair2->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-status">
                            <small class="text-muted">{{ $match->status ?? 'Chưa bắt đầu' }}</small>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif

    {{-- Finals Column --}}
    <div class="col-lg-3 mb-4">
        {{-- Final --}}
        @if(!empty($playoffRounds['final']))
        <div class="card border-0 shadow-sm mb-3">
            <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="bi bi-trophy"></i> Chung kết</h6>
            </div>
            <div class="card-body">
                @foreach($playoffRounds['final']->matches as $match)
                <div class="playoff-match mb-2 p-2 border rounded border-success">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-1">
                            @if($match->pair1)
                            <small class="fw-bold">{{ $match->pair1->player1->name }} / {{ $match->pair1->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-score">
                            @if($match->score)
                            <span class="badge bg-success">{{ $match->score }}</span>
                            @else
                            <span class="badge bg-secondary">-</span>
                            @endif
                        </div>
                    </div>
                    <hr class="my-1">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-2">
                            @if($match->pair2)
                            <small class="fw-bold">{{ $match->pair2->player1->name }} / {{ $match->pair2->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-status">
                            <small class="text-muted">{{ $match->status ?? 'Chưa bắt đầu' }}</small>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif

        {{-- Third Place --}}
        @if(!empty($playoffRounds['third_place']))
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-secondary text-white">
                <h6 class="mb-0"><i class="bi bi-award"></i> Tranh hạng 3</h6>
            </div>
            <div class="card-body">
                @foreach($playoffRounds['third_place']->matches as $match)
                <div class="playoff-match mb-2 p-2 border rounded">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-1">
                            @if($match->pair1)
                            <small class="fw-bold">{{ $match->pair1->player1->name }} / {{ $match->pair1->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-score">
                            @if($match->score)
                            <span class="badge bg-primary">{{ $match->score }}</span>
                            @else
                            <span class="badge bg-secondary">-</span>
                            @endif
                        </div>
                    </div>
                    <hr class="my-1">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-2">
                            @if($match->pair2)
                            <small class="fw-bold">{{ $match->pair2->player1->name }} / {{ $match->pair2->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-status">
                            <small class="text-muted">{{ $match->status ?? 'Chưa bắt đầu' }}</small>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>

    {{-- Other Playoff Rounds --}}
    @if(!empty($playoffRounds['other']) && $playoffRounds['other']->count() > 0)
    <div class="col-lg-3 mb-4">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="bi bi-diagram-3"></i> Vòng khác</h6>
            </div>
            <div class="card-body">
                @foreach($playoffRounds['other'] as $round)
                <h6 class="text-muted">{{ $round->name }}</h6>
                @foreach($round->matches as $match)
                <div class="playoff-match mb-2 p-2 border rounded">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-1">
                            @if($match->pair1)
                            <small class="fw-bold">{{ $match->pair1->player1->name }} / {{ $match->pair1->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-score">
                            @if($match->score)
                            <span class="badge bg-primary">{{ $match->score }}</span>
                            @else
                            <span class="badge bg-secondary">-</span>
                            @endif
                        </div>
                    </div>
                    <hr class="my-1">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="team-2">
                            @if($match->pair2)
                            <small class="fw-bold">{{ $match->pair2->player1->name }} / {{ $match->pair2->player2->name
                                }}</small>
                            @else
                            <small class="text-muted">TBD</small>
                            @endif
                        </div>
                        <div class="match-status">
                            <small class="text-muted">{{ $match->status ?? 'Chưa bắt đầu' }}</small>
                        </div>
                    </div>
                </div>
                @endforeach
                @endforeach
            </div>
        </div>
    </div>
    @endif
</div>
@else
<div class="text-center py-4">
    <i class="bi bi-diagram-3 text-muted" style="font-size: 3rem;"></i>
    <h5 class="text-muted">Chưa có vòng playoffs</h5>
    <p class="text-muted">Vòng playoffs sẽ hiển thị sau khi hoàn thành vòng bảng.</p>
</div>
@endif

<style>
    .playoff-match {
        transition: all 0.3s ease;
    }

    .playoff-match:hover {
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        transform: translateY(-1px);
    }

    .bracket-container {
        overflow-x: auto;
        min-height: 400px;
    }

    @media (max-width: 991px) {
        .bracket-container .col-lg-3 {
            flex: 0 0 auto;
            width: 280px;
        }

        .bracket-container .row {
            flex-wrap: nowrap;
            width: max-content;
        }
    }
</style>