@extends('layouts.app')

@section('title', 'Trang Chủ')

@section('content')
<div class="container py-5">
    <section class="hero-banner glass-panel border-glow shadow-soft p-5 mb-5 position-relative overflow-hidden">
        <div class="hero-banner__media position-absolute top-0 start-0 w-100 h-100"
            style="background-image: url('{{ asset('assets/images/banner.jpg') }}');"></div>
        <div class="hero-banner__overlay position-absolute top-0 start-0 w-100 h-100"></div>
        <div class="position-relative z-1">
            <div class="row align-items-center gy-4">
                <div class="col-lg-8 col-xl-6">
                    <span class="badge glass-badge text-uppercase mb-3 d-inline-flex align-items-center gap-2">
                        <i class="bi bi-lightning-charge-fill"></i>
                        {{ __('Nền tảng Pickleball Việt Nam') }}
                    </span>
                    <h1 class="h3 fw-bold text-primary text-uppercase mb-3">
                        Hiệp Hội Pickleball Việt Nam
                    </h1>
                    <p class="lead text-secondary mb-4">
                        Cập nhật lịch thi đấu, địa điểm, thể lệ, chi phí và đăng ký nhanh chóng.
                    </p>
                    <div class="d-flex flex-wrap gap-3">
                        <a href="{{ route('tournaments.list') }}" class="btn btn-primary btn-icon shadow-soft">
                            <i class="bi bi-trophy"></i>
                            <span>{{ __('Xem tất cả giải đấu') }}</span>
                        </a>
                        <a href="{{ route('register-member.show') }}" class="btn btn-outline-light btn-icon">
                            <i class="bi bi-rocket-takeoff"></i>
                            <span>{{ __('Đăng ký thành viên') }}</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="mb-5">
        <div class="text-center mb-4">
            <h2 class="h3 fw-bold text-primary mb-2">{{ __('Các Giải Đấu Sắp Diễn Ra') }}</h2>
            <p class="text-muted mb-0">{{ __('Lọc theo địa điểm, loại giải và từ khóa để tìm giải đấu phù hợp nhất.') }}
            </p>
        </div>
        <form id="tournamentSearchForm" method="GET" action="" class="row g-3 g-md-2 mb-4 justify-content-center">
            <div class="col-12 col-md-4">
                <label for="tournamentSearch" class="visually-hidden">{{ __('Tìm kiếm tên giải') }}</label>
                <input type="text" name="search" id="tournamentSearch" value="{{ request('search') }}"
                    class="form-control" placeholder="{{ __('Tìm kiếm tên giải...') }}">
            </div>
            <div class="col-6 col-md-2">
                <label for="tournamentLocation" class="visually-hidden">{{ __('Địa điểm') }}</label>
                <select name="location" id="tournamentLocation" class="form-select">
                    <option value="">{{ __('Địa điểm (Tất cả)') }}</option>
                    @if(isset($locations))
                    @foreach($locations as $loc)
                    <option value="{{ $loc }}" {{ request('location')==$loc ? 'selected' : '' }}>{{ $loc }}</option>
                    @endforeach
                    @endif
                </select>
            </div>
            <div class="col-6 col-md-2">
                <label for="tournamentType" class="visually-hidden">{{ __('Loại giải') }}</label>
                <select name="type" id="tournamentType" class="form-select">
                    <option value="">{{ __('Loại giải') }}</option>
                    <option value="singles" {{ request('type')=='singles' ? 'selected' : '' }}>{{ __('Đơn') }}</option>
                    <option value="doubles" {{ request('type')=='doubles' ? 'selected' : '' }}>{{ __('Đôi') }}</option>
                </select>
            </div>
            <div class="col-12 col-md-2">
                <button type="submit" id="tournamentSearchBtn" class="btn btn-primary btn-icon w-100">
                    <span class="btn-text d-inline-flex align-items-center gap-2">
                        <i class="bi bi-search"></i>
                        {{ __('Tìm kiếm') }}
                    </span>
                    <span class="btn-loading d-none align-items-center gap-2">
                        <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span>{{ __('Đang tìm...') }}</span>
                    </span>
                </button>
            </div>
        </form>

        <div id="tournamentResults" class="results-container tournament-results">
            @if($tournaments->isEmpty())
            <div class="text-center py-5 text-muted">
                <i class="bi bi-calendar-x mb-3 display-6"></i>
                <p class="mb-0">{{ __('Hiện tại chưa có giải đấu nào sắp diễn ra.') }}</p>
            </div>
            @else
            <div class="row g-4">
                @foreach($tournaments as $tournament)
                @php
                $typeMeta = $tournament->type === 'singles'
                ? ['icon' => 'bi-person-fill', 'label' => __('Đơn')]
                : ['icon' => 'bi-people-fill', 'label' => __('Đôi')];

                $skillScoreClass = 'text-info';
                if (($tournament->skill_point ?? 0) >= 4) {
                $skillScoreClass = 'text-success';
                } elseif (($tournament->skill_point ?? 0) >= 3.5) {
                $skillScoreClass = 'text-warning';
                } elseif (($tournament->skill_point ?? 0) < 3) { $skillScoreClass='text-muted' ; }
                    $toleranceClass='text-info' ; if (($tournament->skill_tolerance ?? 0) <= 0.3) {
                        $toleranceClass='text-danger' ; } elseif (($tournament->skill_tolerance ?? 0) <= 0.5) {
                            $toleranceClass='text-warning' ; } elseif (($tournament->skill_tolerance ?? 0) > 0.8) {
                            $toleranceClass = 'text-success';
                            }

                            $fee = $tournament->fee ?? 0;
                            $feeClass = 'text-success';
                            if ($fee > 500000) {
                            $feeClass = 'text-danger';
                            } elseif ($fee > 300000) {
                            $feeClass = 'text-warning';
                            } elseif ($fee > 100000) {
                            $feeClass = 'text-info';
                            }
                            @endphp
                            <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                                <div class="card h-100 shadow-soft surface-hover border-0">
                                    <div class="ratio ratio-16x9 rounded-top-3 overflow-hidden bg-dark bg-opacity-25">
                                        @if($tournament->image)
                                        <img src="{{ asset($tournament->image) }}" alt="Tournament image"
                                            class="w-100 h-100 object-fit-cover">
                                        @else
                                        <div
                                            class="d-flex align-items-center justify-content-center text-muted fw-semibold">
                                            {{ __('Chưa có hình ảnh') }}
                                        </div>
                                        @endif
                                    </div>
                                    <div class="card-body d-flex flex-column p-3">
                                        <div class="mb-2 d-flex flex-wrap gap-2 small">
                                            <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                                <i class="bi {{ $typeMeta['icon'] }}"></i>
                                                {{ $typeMeta['label'] }}
                                            </span>


                                            @if(isset($tournament->skill_point))
                                            <span
                                                class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $skillScoreClass }}">
                                                <i class="bi bi-star-fill"></i>
                                                {{ number_format($tournament->skill_point, 1) }}
                                            </span>
                                            @endif

                                            @if(isset($tournament->skill_tolerance))
                                            <span
                                                class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $toleranceClass }}">
                                                <i class="bi bi-activity"></i>
                                                ± {{ $tournament->skill_tolerance }}
                                            </span>
                                            @endif

                                            @if($tournament->location)
                                            <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                                <i class="bi bi-geo-alt-fill"></i>
                                                {{ $tournament->location }}
                                            </span>
                                            @endif
                                        </div>

                                        <h3 class="h6 fw-bold text-truncate mb-2" title="{{ $tournament->name }}">
                                            {{ $tournament->name }}
                                        </h3>

                                        <div
                                            class="small text-secondary fw-semibold d-flex align-items-center gap-2 mb-3">
                                            <i class="bi bi-calendar3"></i>
                                            <span>{{ $tournament->start_date->format('d/m/Y') }} → {{
                                                $tournament->end_date->format('d/m/Y') }}</span>
                                        </div>

                                        <div class="d-flex flex-wrap gap-2 mb-3">
                                            @if($tournament->prizes)
                                            <span class="badge accent-gradient d-inline-flex align-items-center gap-2">
                                                <i class="bi bi-trophy"></i>
                                                {{ $tournament->prizes }}
                                            </span>
                                            @endif
                                            <span
                                                class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $feeClass }}">
                                                <i class="bi bi-cash-stack"></i>
                                                {{ number_format($fee) }}đ
                                            </span>
                                        </div>

                                        <div class="mt-auto">
                                            <a href="{{ route('tournaments.show', $tournament->slug) }}"
                                                class="btn btn-outline-primary btn-sm btn-icon w-100">
                                                <span>{{ __('Xem chi tiết') }}</span>
                                                <i class="bi bi-arrow-right-short"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endforeach
            </div>
            @endif
        </div>
    </section>

    <section class="mb-5">
        <div class="text-center mb-4">
            <h2 class="h3 fw-bold text-success mb-2">{{ __('Thành Viên Mới Nhất') }}</h2>
            <p class="text-muted mb-0">{{ __('Tìm kiếm thành viên mới đăng ký theo tên, giới tính hoặc khu vực.') }}</p>
        </div>

        <form id="playerSearchForm" method="GET" action="{{ route('home') }}"
            class="row g-3 g-md-2 mb-4 justify-content-center">
            <div class="col-12 col-md-4">
                <label for="playerSearch" class="visually-hidden">{{ __('Tìm kiếm vận động viên') }}</label>
                <input type="text" name="search" id="playerSearch" value="{{ request('search') }}" class="form-control"
                    placeholder="{{ __('Tìm kiếm VĐV...') }}">
            </div>
            <div class="col-12 col-md-3">
                <label for="playerPhone" class="visually-hidden">{{ __('Số điện thoại') }}</label>
                <input type="text" name="phone" id="playerPhone" value="{{ request('phone') }}" class="form-control"
                    placeholder="{{ __('Số điện thoại (ví dụ: 09xx...)') }}">
            </div>
            <div class="col-6 col-md-2">
                <label for="playerGender" class="visually-hidden">{{ __('Giới tính') }}</label>
                <select name="gender" id="playerGender" class="form-select">
                    <option value="">{{ __('Giới tính') }}</option>
                    <option value="Nam" {{ request('gender')=='Nam' ? 'selected' : '' }}>{{ __('Nam') }}</option>
                    <option value="Nữ" {{ request('gender')=='Nữ' ? 'selected' : '' }}>{{ __('Nữ') }}</option>
                </select>
            </div>
            <div class="col-6 col-md-2">
                <label for="playerLocation" class="visually-hidden">{{ __('Địa điểm vận động viên') }}</label>
                <select name="player_location" id="playerLocation" class="form-select">
                    <option value="">{{ __('Địa điểm (Tất cả)') }}</option>
                    @if(isset($playerLocations))
                    @foreach($playerLocations as $loc)
                    <option value="{{ $loc }}" {{ request('player_location')==$loc ? 'selected' : '' }}>{{ $loc }}
                    </option>
                    @endforeach
                    @endif
                </select>
            </div>
            <div class="col-12 col-md-2">
                <button type="submit" id="playerSearchBtn" class="btn btn-primary btn-icon w-100">
                    <span class="btn-text d-inline-flex align-items-center gap-2">
                        <i class="bi bi-search"></i>
                        {{ __('Tìm kiếm') }}
                    </span>
                    <span class="btn-loading d-none align-items-center gap-2">
                        <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        <span>{{ __('Đang tìm...') }}</span>
                    </span>
                </button>
            </div>
        </form>

        <div id="playerResults" class="results-container player-results">
            @if($players->isEmpty())
            <div class="text-center py-5 text-muted">
                <i class="bi bi-person-x mb-3 display-6"></i>
                <p class="mb-0">{{ __('Hiện tại chưa có vận động viên nào.') }}</p>
            </div>
            @else
            <div class="row g-4">
                @foreach($players as $player)
                @php
                $statusMeta = [
                0 => ['class' => 'badge bg-secondary', 'icon' => 'bi-person', 'label' => __('Thành viên')],
                1 => ['class' => 'badge bg-success', 'icon' => 'bi-trophy', 'label' => __('Hạng Nhất')],
                2 => ['class' => 'badge bg-primary', 'icon' => 'bi-award', 'label' => __('Hạng Nhì')],
                ];
                $statusBadge = $statusMeta[$player->status] ?? $statusMeta[0];

                $score = $player->doubles_score ?? 0;
                $scoreClass = 'text-muted';
                if ($score >= 4.0) {
                $scoreClass = 'text-success';
                } elseif ($score >= 3.5) {
                $scoreClass = 'text-warning';
                } elseif ($score >= 3.0) {
                $scoreClass = 'text-info';
                }

                // Check if player is new (registered within last 7 days)
                $isNewMember = $player->created_at && $player->created_at->isAfter(now()->subDays(7));

                $pillVariants = [
                'icon-pill',
                'icon-pill icon-pill--success',
                'icon-pill icon-pill--warning',
                'icon-pill icon-pill--danger',
                ];
                $pillClass = $pillVariants[abs(crc32($player->name)) % count($pillVariants)];
                @endphp
                <div class="col-12 col-sm-6 col-md-4 col-lg-2">
                    <div class="card h-100 shadow-soft surface-hover text-center border-0 p-3">
                        <div class="card-body d-flex flex-column align-items-center p-0">
                            <div class="mb-3">
                                @if($player->avatar)
                                <img src="{{ asset($player->avatar) }}" alt="Avatar"
                                    class="rounded-circle border-3 border-glow shadow-soft"
                                    style="width: 72px; height: 72px; object-fit: cover;">
                                @else
                                <div class="{{ $pillClass }} fs-4">
                                    <span class="fw-bold">
                                        {{ mb_strtoupper(mb_substr($player->name, 0, 1, 'UTF-8'), 'UTF-8') }}
                                    </span>
                                </div>
                                @endif
                            </div>

                            <h3 class="h6 fw-bold text-truncate mb-2" title="{{ $player->name }}">
                                {{ $player->name }}
                            </h3>

                            <div class="mb-2 w-100">
                                <span class="{{ $statusBadge['class'] }} d-inline-flex align-items-center gap-2">
                                    <i class="bi {{ $statusBadge['icon'] }}"></i>
                                    {{ $player->player_id }}
                                </span>
                            </div>

                            <div class="mb-2 w-100">
                                <span
                                    class="badge glass-badge d-inline-flex align-items-center gap-2 {{ $scoreClass }}">
                                    <i class="bi bi-bar-chart-line-fill"></i>
                                    {{ number_format($player->doubles_score, 2) }}
                                    <small class="text-muted ms-1">({{ $player->doubles_matches }})</small>
                                </span>
                            </div>

                            <div class="mb-2 w-100">
                                <span class="badge glass-badge d-inline-flex align-items-center gap-2">
                                    <i
                                        class="bi {{ $player->gender == 'Nam' ? 'bi-gender-male' : 'bi-gender-female' }}"></i>
                                    {{ $player->gender }}
                                </span>
                            </div>

                            @if($player->location)
                            <div class="mb-2 w-100">
                                <span class="tag-muted d-inline-flex align-items-center gap-2">
                                    <i class="bi bi-geo-alt"></i>
                                    {{ $player->location }}
                                </span>
                            </div>
                            @endif

                            <div class="mb-3 w-100">
                                <span class="tag-muted d-inline-flex align-items-center gap-2">
                                    <i class="bi bi-calendar-plus"></i>
                                    {{ $player->created_at ? $player->created_at->format('d/m/Y') : 'N/A' }}
                                </span>
                            </div>

                            <div class="mt-auto w-100">
                                <a href="{{ route('players.show', $player->id) }}"
                                    class="btn btn-outline-primary btn-sm btn-icon w-100">
                                    <i class="bi bi-person-lines-fill"></i>
                                    <span>{{ __('Hồ sơ') }}</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>

            <div class="d-flex justify-content-center mt-4">
                {{ $players->links('vendor.pagination.no-arrow') }}
            </div>
            @endif
        </div>
    </section>

    <section class="glass-panel border-glow shadow-soft text-center p-5 mt-5">
        <h4 class="fw-bold text-secondary mb-3">
            {{ __('Tham gia cộng đồng Pickleball Việt Nam ngay hôm nay!') }}
        </h4>
        <a href="{{ route('register-member.show') }}" class="btn btn-success btn-icon px-4 py-3">
            <i class="bi bi-rocket-takeoff"></i>
            <span>{{ __('Đăng ký thành viên') }}</span>
        </a>
    </section>
</div>

<style>
    .hero-banner {
        min-height: 380px;
        position: relative;
    }

    .hero-banner__media {
        background-position: center;
        background-size: cover;
        filter: saturate(1.15);
        opacity: 0.4;
    }

    .hero-banner__overlay {
        background: radial-gradient(circle at 20% 20%, rgba(56, 189, 248, 0.28), transparent 55%),
            linear-gradient(135deg, rgba(5, 7, 13, 0.85), rgba(16, 24, 40, 0.55));
    }

    .results-container {
        transition: opacity 0.3s ease, transform 0.3s ease;
    }

    .results-container.loading {
        opacity: 0.5;
        transform: translateY(6px);
        pointer-events: none;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const tournamentForm = document.getElementById('tournamentSearchForm');
        const tournamentResults = document.getElementById('tournamentResults');
        const tournamentBtn = document.getElementById('tournamentSearchBtn');

        const playerForm = document.getElementById('playerSearchForm');
        const playerResults = document.getElementById('playerResults');
        const playerBtn = document.getElementById('playerSearchBtn');

        if (tournamentForm) {
            tournamentForm.addEventListener('submit', function(e) {
                e.preventDefault();
                performSearch('tournament');
            });

            const tournamentSearch = document.getElementById('tournamentSearch');
            const tournamentLocation = document.getElementById('tournamentLocation');
            const tournamentType = document.getElementById('tournamentType');

            if (tournamentSearch) {
                tournamentSearch.addEventListener('input', debounce(() => performSearch('tournament'), 500));
            }
            if (tournamentLocation) {
                tournamentLocation.addEventListener('change', () => performSearch('tournament'));
            }
            if (tournamentType) {
                tournamentType.addEventListener('change', () => performSearch('tournament'));
            }
        }

        if (playerForm) {
            playerForm.addEventListener('submit', function(e) {
                e.preventDefault();
                performSearch('player');
            });

            const playerSearch = document.getElementById('playerSearch');
            const playerPhone = document.getElementById('playerPhone');
            const playerGender = document.getElementById('playerGender');
            const playerLocation = document.getElementById('playerLocation');

            if (playerSearch) {
                playerSearch.addEventListener('input', debounce(() => performSearch('player'), 500));
            }
            if (playerPhone) {
                playerPhone.addEventListener('input', debounce(() => performSearch('player'), 500));
            }
            if (playerGender) {
                playerGender.addEventListener('change', () => performSearch('player'));
            }
            if (playerLocation) {
                playerLocation.addEventListener('change', () => performSearch('player'));
            }
        }

        function performSearch(type) {
            const isPlayer = type === 'player';
            const form = isPlayer ? playerForm : tournamentForm;
            const results = isPlayer ? playerResults : tournamentResults;
            const btn = isPlayer ? playerBtn : tournamentBtn;

            if (!form || !results || !btn) return;

            showLoadingState(btn, results);

            const formData = new FormData(form);
            const searchParams = new URLSearchParams();

            for (let [key, value] of formData.entries()) {
                if (value.trim()) {
                    searchParams.append(key, value);
                }
            }

            searchParams.append('ajax', '1');
            searchParams.append('search_type', isPlayer ? 'player' : 'tournament');

            fetch(window.location.pathname + '?' + searchParams.toString(), {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'text/html',
                }
            })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.text();
                })
                .then(html => {
                    let extractedContent = '';

                    if (isPlayer) {
                        const playerResultsMatch = html.match(/<div[^>]*id=["']playerResults["'][^>]*>(.*?)<\/div>\s*<!--\s*End Player Results Container\s*-->/s);
                        if (playerResultsMatch) {
                            extractedContent = playerResultsMatch[1];
                        } else {
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(html, 'text/html');
                            const playerRows = doc.querySelectorAll('.row.g-4');
                            for (let row of playerRows) {
                                if (row.querySelector('.col-lg-2')) {
                                    extractedContent = row.outerHTML;
                                    break;
                                }
                            }
                            if (!extractedContent.trim()) {
                                const emptyMessages = doc.querySelectorAll('p');
                                for (let msg of emptyMessages) {
                                    if (msg.textContent.includes('vận động viên')) {
                                        extractedContent = msg.outerHTML;
                                        break;
                                    }
                                }
                            }
                        }
                    } else {
                        const tournamentResultsMatch = html.match(/<div[^>]*id=["']tournamentResults["'][^>]*>(.*?)<\/div>\s*<!--\s*End Tournament Results Container\s*-->/s);
                        if (tournamentResultsMatch) {
                            extractedContent = tournamentResultsMatch[1];
                        } else {
                            const parser = new DOMParser();
                            const doc = parser.parseFromString(html, 'text/html');
                            const tournamentRows = doc.querySelectorAll('.row.g-4');
                            for (let row of tournamentRows) {
                                if (row.querySelector('.col-lg-3')) {
                                    extractedContent = row.outerHTML;
                                    break;
                                }
                            }
                            if (!extractedContent.trim()) {
                                const emptyMessages = doc.querySelectorAll('p');
                                for (let msg of emptyMessages) {
                                    if (msg.textContent.includes('giải đấu')) {
                                        extractedContent = msg.outerHTML;
                                        break;
                                    }
                                }
                            }
                        }
                    }

                    if (extractedContent.trim()) {
                        results.innerHTML = extractedContent;
                    } else {
                        results.innerHTML = `
                            <div class="text-center py-4 text-muted">
                                <i class="bi bi-search mb-2"></i>
                                <p class="mb-0">{{ __('Không tìm thấy kết quả nào phù hợp.') }}</p>
                            </div>
                        `;
                    }

                    hideLoadingState(btn, results);

                    results.style.opacity = '0';
                    results.style.transform = 'translateY(10px)';

                    setTimeout(() => {
                        results.style.transition = 'opacity 0.3s ease, transform 0.3s ease';
                        results.style.opacity = '1';
                        results.style.transform = 'translateY(0)';
                    }, 50);
                })
                .catch(error => {
                    console.error('Search error:', error);
                    hideLoadingState(btn, results);

                    results.innerHTML = `
                        <div class="text-center py-4 text-muted">
                            <i class="bi bi-exclamation-triangle mb-2"></i>
                            <p class="mb-0">{{ __('Có lỗi xảy ra khi tìm kiếm. Vui lòng thử lại.') }}</p>
                        </div>
                    `;
                });
        }

        function showLoadingState(btn, results) {
            const btnText = btn.querySelector('.btn-text');
            const btnLoading = btn.querySelector('.btn-loading');

            if (btnText) btnText.classList.add('d-none');
            if (btnLoading) btnLoading.classList.remove('d-none');

            btn.disabled = true;
            results.classList.add('loading');
        }

        function hideLoadingState(btn, results) {
            const btnText = btn.querySelector('.btn-text');
            const btnLoading = btn.querySelector('.btn-loading');

            if (btnText) btnText.classList.remove('d-none');
            if (btnLoading) btnLoading.classList.add('d-none');

            btn.disabled = false;
            results.classList.remove('loading');
        }

        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }
    });
</script>
@endsection