{{-- Responsive Image Component với WebP support và lazy loading --}}
<picture class="responsive-image-wrapper {{ $class }}">
    @foreach($getPictureSources() as $source)
    <source type="{{ $source['type'] }}" srcset="{{ $source['srcset'] }}" sizes="{{ $sizes }}" @if($lazy)
        data-srcset="{{ $source['srcset'] }}" @endif>
    @endforeach

    <img @if($lazy) src="data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 1 1'%3E%3C/svg%3E"
        data-src="{{ $src }}" loading="lazy" class="lazy-image {{ $class }}" @else src="{{ $src }}" class="{{ $class }}"
        @endif alt="{{ $alt }}" sizes="{{ $sizes }}" @if($aspectRatio !=='auto' )
        style="aspect-ratio: {{ $aspectRatio }}; object-fit: cover;" @endif onload="this.classList.add('loaded')"
        onerror="this.src='{{ asset('assets/images/default.jpg') }}'; this.classList.add('error');">
</picture>

@once
<style>
    .responsive-image-wrapper {
        display: block;
        overflow: hidden;
    }

    .lazy-image {
        transition: opacity 0.3s ease;
        opacity: 0;
    }

    .lazy-image.loaded {
        opacity: 1;
    }

    .lazy-image.error {
        opacity: 0.7;
        filter: grayscale(100%);
    }

    /* Placeholder blur effect */
    .lazy-image:not(.loaded) {
        filter: blur(5px);
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    // Intersection Observer for lazy loading
    if ('IntersectionObserver' in window) {
        const imageObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    const dataSrc = img.getAttribute('data-src');
                    
                    if (dataSrc) {
                        img.src = dataSrc;
                        img.removeAttribute('data-src');
                    }
                    
                    // Handle srcset for picture sources
                    const picture = img.closest('picture');
                    if (picture) {
                        const sources = picture.querySelectorAll('source[data-srcset]');
                        sources.forEach(source => {
                            const dataSrcset = source.getAttribute('data-srcset');
                            if (dataSrcset) {
                                source.srcset = dataSrcset;
                                source.removeAttribute('data-srcset');
                            }
                        });
                    }
                    
                    observer.unobserve(img);
                }
            });
        }, {
            rootMargin: '50px 0px', // Load images 50px before they enter viewport
            threshold: 0.1
        });
        
        // Observe all lazy images
        document.querySelectorAll('.lazy-image').forEach(img => {
            imageObserver.observe(img);
        });
    } else {
        // Fallback for older browsers
        document.querySelectorAll('.lazy-image').forEach(img => {
            const dataSrc = img.getAttribute('data-src');
            if (dataSrc) {
                img.src = dataSrc;
                img.removeAttribute('data-src');
            }
        });
    }
});
</script>
@endonce