@if($venues->isEmpty())
<div class="alert alert-info text-center">Không tìm thấy sân nào phù hợp.</div>
@else
<div class="table-responsive dark-table-wrapper">
    <table class="table table-hover table-striped table-dark-mode align-middle">
        <thead class="table-dark-mode-head">
            <tr>
                <th>Tên Sân</th>
                <th>Khu vực</th>
                <th>Liên hệ</th>
                <th class="text-center">Hình ảnh</th>
                <th>Ngày tạo</th>
                <th class="text-center">Hành động</th>
            </tr>
        </thead>
        <tbody>
            @foreach($venues as $venue)
            <tr>
                <td>
                    <a href="{{ route('venues.show', $venue->slug) }}" target="_blank"
                        class="text-decoration-none fw-bold">{{ $venue->name }}</a>
                    <p class="small text-muted mb-0">{{ $venue->address }}</p>
                </td>
                <td><span class="badge bg-info bg-opacity-75">{{ $venue->location }}</span></td>
                <td>
                    @if($venue->contact_phone)
                    <div class="small"><i class="bi bi-telephone-fill me-1"></i>{{ $venue->contact_phone }}
                    </div>
                    @endif
                    @if($venue->contact_email)
                    <div class="small"><i class="bi bi-envelope-fill me-1"></i>{{ $venue->contact_email }}
                    </div>
                    @endif
                </td>
                <td class="text-center">
                    <div class="d-flex justify-content-center gap-1">
                        @forelse(array_slice($venue->images ?? [], 0, 3) as $img)
                        <img src="{{ asset($img) }}"
                            style="width: 50px; height: 35px; object-fit: cover; border-radius: 4px;" loading="lazy"
                            alt="Ảnh {{ $venue->name }}">
                        @empty
                        <span class="text-muted small">N/A</span>
                        @endforelse
                    </div>
                </td>
                <td class="small">{{ $venue->created_at->format('d/m/Y') }}</td>
                <td class="text-center">
                    <div class="btn-group btn-group-sm">
                        <a href="{{ route('admin.venues.edit', $venue) }}" class="btn btn-outline-primary"
                            title="Sửa"><i class="bi bi-pencil-fill"></i></a>
                        <form action="{{ route('admin.venues.destroy', $venue) }}" method="POST"
                            class="d-inline delete-venue-form" data-venue-name="{{ $venue->name }}">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-outline-danger delete-venue" title="Xóa"><i
                                    class="bi bi-trash-fill"></i></button>
                        </form>
                    </div>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
<div class="mt-4 d-flex justify-content-center">
    {{ $venues->appends(request()->query())->links('vendor.pagination.no-arrow') }}
</div>
@endif