@extends('layouts.app')

@section('title', 'Quản lý Sân')

@section('content')
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 fw-bold mb-0"><i class="bi bi-building me-2"></i>Quản lý Sân</h1>
        <a href="{{ route('admin.venues.create') }}" class="btn btn-primary">
            <i class="bi bi-plus-circle me-1"></i>Thêm Sân Mới
        </a>
    </div>

    <!-- Search and Filter Form -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form id="searchForm" class="row g-3 align-items-end">
                <div class="col-md-5">
                    <label for="search" class="form-label">Tìm theo tên, địa chỉ, khu vực, liên hệ</label>
                    <input type="text" name="search" id="search" class="form-control" placeholder="Nhập từ khóa..."
                        value="{{ request('search') }}">
                </div>
                <div class="col-md-5">
                    <label for="location" class="form-label">Lọc theo khu vực</label>
                    <select name="location" id="location" class="form-select">
                        <option value="">Tất cả khu vực</option>
                        @foreach($locations as $location)
                        <option value="{{ $location }}" @selected(request('location')==$location)>{{ $location }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2 d-grid">
                    <button type="button" id="clearSearch" class="btn btn-outline-secondary">
                        <i class="bi bi-x-circle"></i> Xóa bộ lọc
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <!-- Loading overlay -->
            <div id="loadingOverlay" class="d-none">
                <div class="d-flex justify-content-center align-items-center" style="height: 200px;">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Đang tải...</span>
                    </div>
                </div>
            </div>

            <!-- Content container -->
            <div id="venuesContent">
                @include('admin.venues.partials._venues_table')
            </div>
        </div>
    </div>
</div>

@push('layout_script')
<style>
    #loadingOverlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(255, 255, 255, 0.8);
        z-index: 1000;
        border-radius: 0.375rem;
    }

    .card-body {
        position: relative;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        let searchTimeout;
        const searchInput = document.getElementById('search');
        const locationSelect = document.getElementById('location');
        const clearSearchBtn = document.getElementById('clearSearch');
        const loadingOverlay = document.getElementById('loadingOverlay');
        const venuesContent = document.getElementById('venuesContent');

        // Debounced search function
        function performSearch() {
            const searchValue = searchInput.value.trim();
            const locationValue = locationSelect.value;

            // Show loading
            loadingOverlay.classList.remove('d-none');
            
            // Build URL params
            const params = new URLSearchParams();
            if (searchValue) params.append('search', searchValue);
            if (locationValue) params.append('location', locationValue);

            // Update URL without reload
            const newUrl = new URL(window.location);
            newUrl.search = params.toString();
            window.history.replaceState({}, '', newUrl);

            // Make AJAX request
            fetch(`{{ route('admin.venues.search') }}?${params.toString()}`, {
                method: 'GET',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'Accept': 'text/html'
                }
            })
            .then(response => {
                if (!response.ok) {
                    // Try to parse JSON error response
                    return response.json().then(data => {
                        throw new Error(data.error || 'Network response was not ok');
                    }).catch(() => {
                        throw new Error('Network response was not ok');
                    });
                }
                return response.text();
            })
            .then(html => {
                venuesContent.innerHTML = html;
                loadingOverlay.classList.add('d-none');
                
                // Re-initialize delete venue handlers
                initializeDeleteHandlers();
            })
            .catch(error => {
                console.error('Search error:', error);
                loadingOverlay.classList.add('d-none');
                venuesContent.innerHTML = `<div class="alert alert-danger">${error.message}</div>`;
            });
        }

        // Search input with debounce
        searchInput.addEventListener('input', function() {
            clearTimeout(searchTimeout);
            searchTimeout = setTimeout(performSearch, 500);
        });

        // Location filter change
        locationSelect.addEventListener('change', performSearch);

        // Clear search
        clearSearchBtn.addEventListener('click', function() {
            searchInput.value = '';
            locationSelect.value = '';
            performSearch();
        });

        // Initialize delete handlers
        function initializeDeleteHandlers() {
            document.querySelectorAll('.delete-venue-form').forEach(function(form) {
                form.removeEventListener('submit', handleDeleteSubmit); // Remove existing listeners
                form.addEventListener('submit', handleDeleteSubmit);
            });
        }

        // Delete handler function
        function handleDeleteSubmit(e) {
            e.preventDefault();
            const form = e.target;
            const name = form.getAttribute('data-venue-name') || '';
            
            Swal.fire({
                title: 'Bạn có chắc chắn?',
                text: `Bạn sẽ không thể hoàn tác hành động xóa sân "${name}"!`,
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Vâng, xóa nó!',
                cancelButtonText: 'Hủy'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        }

        // Initial setup
        initializeDeleteHandlers();

        // Handle pagination clicks
        document.addEventListener('click', function(e) {
            if (e.target.closest('.pagination a')) {
                e.preventDefault();
                const link = e.target.closest('.pagination a');
                const url = new URL(link.href);
                
                // Add current search params to pagination
                const currentParams = new URLSearchParams(window.location.search);
                for (const [key, value] of currentParams) {
                    if (key !== 'page') {
                        url.searchParams.set(key, value);
                    }
                }
                
                loadingOverlay.classList.remove('d-none');
                
                fetch(`{{ route('admin.venues.search') }}?${url.searchParams.toString()}`, {
                    method: 'GET',
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'text/html'
                    }
                })
                .then(response => {
                    if (!response.ok) {
                        return response.json().then(data => {
                            throw new Error(data.error || 'Network response was not ok');
                        }).catch(() => {
                            throw new Error('Network response was not ok');
                        });
                    }
                    return response.text();
                })
                .then(html => {
                    venuesContent.innerHTML = html;
                    loadingOverlay.classList.add('d-none');
                    
                    // Update URL
                    window.history.replaceState({}, '', url);
                    
                    // Re-initialize handlers
                    initializeDeleteHandlers();
                })
                .catch(error => {
                    console.error('Pagination error:', error);
                    loadingOverlay.classList.add('d-none');
                    venuesContent.innerHTML = `<div class="alert alert-danger">${error.message}</div>`;
                });
            }
        });
    });
</script>
@endpush
@endsection