@extends('layouts.app')

@section('title', 'Chỉnh sửa Sân')

@section('content')
<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h1 class="h5 mb-0 fw-bold"><i class="bi bi-pencil-square me-2"></i>Chỉnh sửa Sân: {{ $venue->name }}</h1>
        </div>
        <div class="card-body">
            <!-- Success Message -->
            @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            
            <!-- Error Message -->
            @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="bi bi-exclamation-circle me-2"></i>{{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif

            <form action="{{ route('admin.venues.update', $venue) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')


                <div class="row g-4">
                    <!-- Cột trái -->
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="name" class="form-label">Tên sân <span class="text-danger">*</span></label>
                            <input type="text" name="name" id="name"
                                class="form-control @error('name') is-invalid @enderror"
                                value="{{ old('name', $venue->name) }}" required>
                            @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="address" class="form-label">Địa chỉ <span class="text-danger">*</span></label>
                            <input type="text" name="address" id="address"
                                class="form-control @error('address') is-invalid @enderror"
                                value="{{ old('address', $venue->address) }}" required>
                            @error('address') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="location" class="form-label">Khu vực <span class="text-danger">*</span></label>
                            <select name="location" id="location"
                                class="form-select @error('location') is-invalid @enderror" required>
                                <option value="">Chọn khu vực</option>
                                @foreach($locations as $loc)
                                <option value="{{ $loc }}" @selected(old('location', $venue->location)==$loc)>{{ $loc }}
                                </option>
                                @endforeach
                            </select>
                            @error('location') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="description" class="form-label fw-bold">
                                <i class="bi bi-card-text me-1"></i>Mô tả sân
                            </label>
                            <div class="border rounded p-2 mb-2">
                                <div class="btn-toolbar mb-2" role="toolbar">
                                    <div class="btn-group btn-group-sm me-2" role="group">
                                        <button type="button" class="btn btn-outline-secondary"
                                            onclick="formatText('description', 'bold')" title="Bold">
                                            <i class="bi bi-type-bold"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary"
                                            onclick="formatText('description', 'italic')" title="Italic">
                                            <i class="bi bi-type-italic"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary"
                                            onclick="formatText('description', 'underline')" title="Underline">
                                            <i class="bi bi-type-underline"></i>
                                        </button>
                                    </div>
                                    <div class="btn-group btn-group-sm me-2" role="group">
                                        <button type="button" class="btn btn-outline-secondary"
                                            onclick="formatList('description', 'ul')" title="Bullet List">
                                            <i class="bi bi-list-ul"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary"
                                            onclick="formatList('description', 'ol')" title="Numbered List">
                                            <i class="bi bi-list-ol"></i>
                                        </button>
                                    </div>
                                    <div class="btn-group btn-group-sm me-2" role="group">
                                        <button type="button" class="btn btn-outline-secondary"
                                            onclick="insertVenueTemplate('description')" title="Insert Template">
                                            <i class="bi bi-file-earmark-text"></i>
                                        </button>
                                    </div>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <button type="button" class="btn btn-outline-secondary"
                                            onclick="insertImage('description')" title="Insert Image">
                                            <i class="bi bi-image"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-secondary"
                                            onclick="insertLink('description')" title="Insert Link">
                                            <i class="bi bi-link-45deg"></i>
                                        </button>
                                    </div>
                                </div>
                                <textarea name="description" id="description" rows="6"
                                    class="form-control @error('description') is-invalid @enderror"
                                    placeholder="Nhập mô tả chi tiết về sân...&#10;&#10;Bạn có thể sử dụng:&#10;• Thông tin về sân&#10;• Tiện ích và dịch vụ&#10;• Giờ mở cửa&#10;• Quy định sử dụng&#10;• HTML tags để định dạng">{{ old('description', $venue->description) }}</textarea>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1"></i>
                                    Hỗ trợ HTML cơ bản và template mẫu cho mô tả sân
                                </small>
                                <button type="button" class="btn btn-sm btn-outline-info"
                                    onclick="previewContent('description')">
                                    <i class="bi bi-eye me-1"></i>Xem trước
                                </button>
                            </div>
                            @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <!-- Cột phải -->
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label for="contact_phone" class="form-label">SĐT liên hệ</label>
                            <input type="text" name="contact_phone" id="contact_phone"
                                class="form-control @error('contact_phone') is-invalid @enderror"
                                value="{{ old('contact_phone', $venue->contact_phone) }}">
                            @error('contact_phone') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="contact_email" class="form-label">Email liên hệ</label>
                            <input type="email" name="contact_email" id="contact_email"
                                class="form-control @error('contact_email') is-invalid @enderror"
                                value="{{ old('contact_email', $venue->contact_email) }}">
                            @error('contact_email') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="images" class="form-label">Hình ảnh (chọn để thay thế)</label>
                            <input type="file" name="images[]" id="images" multiple accept="image/*"
                                class="form-control @if($errors->has('images') || $errors->has('images.*') || collect($errors->keys())->contains(fn($key) => str_starts_with($key, 'images.'))) is-invalid @endif">
                            <div class="form-text">
                                <small class="text-muted">
                                    <i class="bi bi-info-circle me-1"></i>
                                    Chọn tối đa 10 ảnh để thay thế, mỗi ảnh không quá 5MB. Định dạng: JPG, PNG, GIF,
                                    WebP. Để trống nếu không muốn thay đổi.
                                </small>
                            </div>

                            <!-- Current Images Display -->
                            @if($venue->images && count($venue->images) > 0)
                            <div class="mt-2 mb-3">
                                <small class="text-muted fw-bold">Ảnh hiện tại:</small>
                                <div class="d-flex flex-wrap gap-2 mt-1">
                                    @foreach($venue->images as $img)
                                    <div class="position-relative">
                                        <img src="{{ asset($img) }}" alt="Current image"
                                            style="width: 100px; height: 75px; object-fit: cover;"
                                            class="rounded shadow-sm border">
                                        <span class="position-absolute top-0 start-0 badge bg-primary"
                                            style="font-size: 0.6em;">Hiện tại</span>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            @endif

                            <!-- New Images Preview Container -->
                            <div id="image-preview-container" class="mt-3 d-flex flex-wrap gap-2"></div>

                            {{-- Hiển thị lỗi validation cho images --}}
                            @if($errors->has('images') || collect($errors->keys())->contains(fn($key) =>
                            str_starts_with($key, 'images.')))
                            <div class="mt-2">
                                @error('images')
                                <div class="invalid-feedback d-block mb-2">
                                    <i class="bi bi-exclamation-triangle me-1"></i>{{ $message }}
                                </div>
                                @enderror

                                {{-- Hiển thị lỗi cụ thể cho từng file --}}
                                @for ($i = 0; $i < 10; $i++) @error("images.{$i}") <div
                                    class="invalid-feedback d-block mb-1">
                                    <i class="bi bi-exclamation-triangle me-1"></i>Ảnh thứ {{ $i + 1 }}: {{ $message }}
                            </div>
                            @enderror
                            @endfor
                        </div>
                        @endif
                    </div>
                </div>
        </div>
        <!-- Actions -->
        <div class="mt-4 d-flex justify-content-end gap-2">
            <a href="{{ route('admin.venues.index') }}" class="btn btn-secondary">Hủy</a>
            <button type="submit" class="btn btn-primary">Lưu thay đổi</button>
        </div>
        </form>
    </div>
</div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="previewModalLabel">
                    <i class="bi bi-eye me-2"></i>Xem trước nội dung
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="previewContent" class="border rounded p-3" style="min-height: 200px;"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Đóng</button>
            </div>
        </div>
    </div>
</div>

@push('layout_script')
<script>
    // Format text functions
    function formatText(fieldId, format) {
        const textarea = document.getElementById(fieldId);
        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        const selectedText = textarea.value.substring(start, end);
        
        if (selectedText) {
            let formattedText;
            switch(format) {
                case 'bold':
                    formattedText = `<b>${selectedText}</b>`;
                    break;
                case 'italic':
                    formattedText = `<i>${selectedText}</i>`;
                    break;
                case 'underline':
                    formattedText = `<u>${selectedText}</u>`;
                    break;
            }
            
            textarea.value = textarea.value.substring(0, start) + formattedText + textarea.value.substring(end);
            textarea.focus();
        } else {
            alert('Vui lòng chọn text để định dạng');
        }
    }

    function formatList(fieldId, listType) {
        const textarea = document.getElementById(fieldId);
        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        const selectedText = textarea.value.substring(start, end);
        
        if (selectedText) {
            const lines = selectedText.split('\n');
            let formattedList;
            
            if (listType === 'ul') {
                formattedList = '<ul>\n' + lines.map(line => line.trim() ? `  <li>${line.trim()}</li>` : '').filter(line => line).join('\n') + '\n</ul>';
            } else {
                formattedList = '<ol>\n' + lines.map(line => line.trim() ? `  <li>${line.trim()}</li>` : '').filter(line => line).join('\n') + '\n</ol>';
            }
            
            textarea.value = textarea.value.substring(0, start) + formattedList + textarea.value.substring(end);
            textarea.focus();
        } else {
            const listTemplate = listType === 'ul' ? 
                '<ul>\n  <li>Mục 1</li>\n  <li>Mục 2</li>\n  <li>Mục 3</li>\n</ul>' :
                '<ol>\n  <li>Mục 1</li>\n  <li>Mục 2</li>\n  <li>Mục 3</li>\n</ol>';
            insertAtCursor(textarea, listTemplate);
        }
    }

    function insertImage(fieldId) {
        const imageUrl = prompt('Nhập URL hình ảnh:');
        if (imageUrl) {
            const altText = prompt('Nhập mô tả hình ảnh (tùy chọn):') || 'Hình ảnh sân';
            const imageHtml = `<img src="${imageUrl}" alt="${altText}" class="img-fluid rounded my-2" style="max-width: 100%;">`;
            const textarea = document.getElementById(fieldId);
            insertAtCursor(textarea, imageHtml);
        }
    }

    function insertLink(fieldId) {
        const linkUrl = prompt('Nhập URL liên kết:');
        if (linkUrl) {
            const linkText = prompt('Nhập text hiển thị:') || linkUrl;
            const linkHtml = `<a href="${linkUrl}" target="_blank">${linkText}</a>`;
            const textarea = document.getElementById(fieldId);
            insertAtCursor(textarea, linkHtml);
        }
    }

    function insertVenueTemplate(fieldId) {
        const template = `<h4>🏟️ THÔNG TIN SÂN</h4>
<ul>
  <li>Loại sân: Sân ngoài trời/trong nhà</li>
  <li>Số lượng sân: [X] sân chuẩn</li>
  <li>Mặt sân: Bê tông/Acrylic/PU</li>
  <li>Chiếu sáng: Đầy đủ cho thi đấu ban đêm</li>
</ul>

<h4>🏪 TIỆN ÍCH & DỊCH VỤ</h4>
<ul>
  <li>🚗 Bãi đỗ xe: Miễn phí</li>
  <li>🚿 Phòng thay đồ & tắm</li>
  <li>🥤 Khu vực nghỉ ngơi & giải khát</li>
  <li>🛒 Cửa hàng thiết bị thể thao</li>
  <li>🍕 Căng tin/quán ăn</li>
</ul>

<h4>⏰ GIỜ HOẠT ĐỘNG</h4>
<ul>
  <li>Thứ 2 - Thứ 6: 6:00 - 22:00</li>
  <li>Thứ 7 - Chủ nhật: 5:30 - 22:30</li>
  <li>Lễ Tết: Theo thông báo riêng</li>
</ul>

<h4>💰 GIÁ THUÊ SÂN</h4>
<ul>
  <li>Giờ sáng (6:00-11:00): 100.000đ/giờ</li>
  <li>Giờ trưa (11:00-17:00): 120.000đ/giờ</li>
  <li>Giờ tối (17:00-22:00): 150.000đ/giờ</li>
  <li>Cuối tuần: +20% phụ thu</li>
</ul>

<h4>📋 QUY ĐỊNH</h4>
<ul>
  <li>Đặt sân trước ít nhất 2 tiếng</li>
  <li>Hủy sân trước 1 tiếng không mất phí</li>
  <li>Mang giày thể thao có đế không đen</li>
  <li>Giữ gìn vệ sinh và trật tự</li>
</ul>

<h4>📞 LIÊN Hệ ĐẶT SÂN</h4>
<p><b>Hotline:</b> 0xxx.xxx.xxx</p>
<p><b>Zalo/Viber:</b> 0xxx.xxx.xxx</p>
<p><b>Facebook:</b> <a href="#" target="_blank">Tên Fanpage</a></p>`;

        const textarea = document.getElementById(fieldId);
        insertAtCursor(textarea, template);
    }

    function insertAtCursor(textarea, text) {
        const start = textarea.selectionStart;
        const end = textarea.selectionEnd;
        textarea.value = textarea.value.substring(0, start) + text + textarea.value.substring(end);
        textarea.focus();
        textarea.setSelectionRange(start + text.length, start + text.length);
    }

    function previewContent(fieldId) {
        const content = document.getElementById(fieldId).value;
        const previewDiv = document.getElementById('previewContent');
        
        // Convert basic HTML to display
        previewDiv.innerHTML = content || '<p class="text-muted">Không có nội dung để xem trước</p>';
        
        // Show modal
        const modal = new bootstrap.Modal(document.getElementById('previewModal'));
        modal.show();
    }

    // Auto-resize textareas and existing image preview code
    (function(){
        // Auto-resize textarea
        const textarea = document.querySelector('textarea[name="description"]');
        if (textarea) {
            textarea.addEventListener('input', function() {
                this.style.height = 'auto';
                this.style.height = (this.scrollHeight) + 'px';
            });
            
            // Initial resize for existing content
            textarea.style.height = 'auto';
            textarea.style.height = (textarea.scrollHeight) + 'px';
        }

        // Existing image preview code
        var input = document.getElementById('images');
        input.addEventListener('change', function(event) {
            var previewContainer = document.getElementById('image-preview-container');
            var errorContainer = document.getElementById('client-validation-errors');
            
            // Clear previous errors
            if (errorContainer) {
                errorContainer.remove();
            }
            
            previewContainer.innerHTML = ''; // Xóa các ảnh xem trước cũ
            var files = event.target.files;
            var errors = [];

            if (files && files.length) {
                // Validate file count
                if (files.length > 10) {
                    errors.push('Bạn chỉ có thể chọn tối đa 10 ảnh.');
                    event.target.value = '';
                    showClientErrors(errors);
                    return;
                }

                Array.from(files).forEach(function(file, index) {
                    // Validate file type
                    if (!file.type.startsWith('image/')) {
                        errors.push(`File "${file.name}" không phải là hình ảnh.`);
                        return;
                    }

                    // Validate file size (5MB = 5 * 1024 * 1024 bytes)
                    if (file.size > 5 * 1024 * 1024) {
                        errors.push(`File "${file.name}" quá lớn. Kích thước tối đa là 5MB.`);
                        return;
                    }

                    var reader = new FileReader();
                    reader.onload = function(e) {
                        var div = document.createElement('div');
                        div.className = 'position-relative';
                        
                        var img = document.createElement('img');
                        img.src = e.target.result;
                        img.alt = 'Preview ' + (index + 1);
                        img.style.width = '100px';
                        img.style.height = '75px';
                        img.style.objectFit = 'cover';
                        img.className = 'rounded shadow-sm border';
                        img.title = file.name;
                        
                        var badge = document.createElement('span');
                        badge.className = 'position-absolute top-0 start-0 badge bg-success';
                        badge.style.fontSize = '0.6em';
                        badge.textContent = 'Mới';
                        
                        div.appendChild(img);
                        div.appendChild(badge);
                        previewContainer.appendChild(div);
                    };
                    reader.readAsDataURL(file);
                });
                
                if (errors.length > 0) {
                    event.target.value = '';
                    previewContainer.innerHTML = '';
                    showClientErrors(errors);
                }
            }
        });
        
        function showClientErrors(errors) {
            var input = document.getElementById('images');
            var errorContainer = document.createElement('div');
            errorContainer.id = 'client-validation-errors';
            errorContainer.className = 'mt-2';
            
            errors.forEach(function(error) {
                var errorDiv = document.createElement('div');
                errorDiv.className = 'invalid-feedback d-block';
                errorDiv.innerHTML = '<i class="bi bi-exclamation-triangle me-1"></i>' + error;
                errorContainer.appendChild(errorDiv);
            });
            
            input.parentNode.appendChild(errorContainer);
        }


    })();
</script>
@endpush
@endsection