@foreach($users as $user)
<tr>
    <td>{{ $user->id }}</td>
    <td>
        <div class="d-flex align-items-center">
            @can('view', $user)
            <a href="{{ route('admin.users.edit', $user->id) }}" class="fw-medium text-decoration-none">
                {{ $user->name }}
            </a>
            @else
            <span class="fw-medium">{{ $user->name }}</span>
            @endcan
            @if($user->hasRole('admin'))
            <span class="badge bg-danger ms-2">Admin</span>
            @endif
        </div>
    </td>
    <td>{{ $user->email }}</td>
    <td>
        <span class="text-muted">{{ $user->phone ?: 'Chưa có' }}</span>
    </td>
    <td>
        <span class="badge text-dark">{{ $user->location ?: 'Chưa có' }}</span>
    </td>
    <td>
        @if($user->gender)
        <span
            class="badge {{ $user->gender == 'Nam' ? 'bg-primary' : ($user->gender == 'Nữ' ? 'bg-warning' : 'bg-secondary') }}">
            {{ $user->gender }}
        </span>
        @else
        <span class="text-muted">Chưa có</span>
        @endif
    </td>
    <td>
        @if($user->avatar)
        <img src="{{ str_starts_with($user->avatar, 'http') ? $user->avatar : asset($user->avatar) }}" width="40"
            height="40" alt="Avatar" style="object-fit:cover; border-radius: 50%;" class="border"
            onerror="this.style.display='none'; this.nextElementSibling.style.display='inline-flex';">
        @else
        <div class="d-inline-flex align-items-center justify-content-center bg-secondary text-white rounded-circle"
            style="width: 40px; height: 40px; font-size: 14px;">
            {{ strtoupper(substr($user->name, 0, 1)) }}
        </div>
        @endif
    </td>
    <td>
        @if($user->getRoleNames()->isNotEmpty())
        @foreach($user->getRoleNames() as $role)
        <span class="badge bg-info text-dark me-1">{{ ucfirst($role) }}</span>
        @endforeach
        @else
        <span class="text-muted">Chưa có vai trò</span>
        @endif
    </td>
    <td>
        <small class="text-muted">{{ $user->created_at->format('d/m/Y H:i') }}</small>
    </td>
    <td>
        <div class="btn-group btn-group-sm" role="group">
            @can('update', $user)
            <a href="{{ route('admin.users.edit', $user->id) }}" class="btn btn-outline-primary" title="Chỉnh sửa">
                <i class="bi bi-pencil"></i>
            </a>
            @endcan
            @can('delete', $user)
            <form action="{{ route('admin.users.destroy', $user->id) }}" method="POST" class="d-inline">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-outline-danger" title="Xóa"
                    onclick="return confirm('Bạn có chắc muốn xóa người dùng này?')">
                    <i class="bi bi-trash"></i>
                </button>
            </form>
            @else
            @if($user->id === auth()->id())
            <button class="btn btn-sm btn-outline-light text-muted" disabled title="Không thể xóa chính mình">
                <i class="bi bi-shield-lock"></i>
            </button>
            @elseif($user->hasRole('admin'))
            <button class="btn btn-sm btn-outline-light text-muted" disabled title="Không thể xóa admin">
                <i class="bi bi-shield-check"></i>
            </button>
            @endif
            @endcan
        </div>
    </td>
</tr>
@endforeach

@if($users->isEmpty())
<tr>
    <td colspan="10" class="text-center text-light py-4">
        <i class="bi bi-people text-muted mb-3" style="font-size: 3rem;"></i>
        <h5 class="text-muted">Không có người dùng nào</h5>
        <p class="text-muted">Hãy thêm người dùng mới hoặc thay đổi bộ lọc</p>
        @can('create', App\Models\User::class)
        <a href="{{ route('admin.users.create') }}" class="btn btn-primary fw-semibold shadow-sm">
            <i class="bi bi-plus-circle me-1"></i> Thêm User Đầu Tiên
        </a>
        @endcan
    </td>
</tr>
@endif