@extends('layouts.app')

@section('title', __('admin.user_management.edit_user_title', ['name' => $user->name]))

@section('content')
<div class="container py-4">
    {{-- Hiển thị thông báo lỗi --}}
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    {{-- Hiển thị thông báo thành công/lỗi --}}
    @if (session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <div class="card shadow-sm">
        <div class="card-header bg-light">
            <h2 class="h5 mb-0 fw-bold">
                <i class="bi bi-pencil-square me-2"></i>
                {{ __('admin.user_management.edit_user_title', ['name' => $user->name]) }}
            </h2>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('admin.users.update', $user->id) }}" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row g-4">
                    {{-- Left Column: Main Info --}}
                    <div class="col-lg-8">
                        <div class="card border-0">
                            <div class="card-body p-0">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="name" class="form-label fw-semibold">{{
                                            __('validation.attributes.name') }} <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="name" name="name" class="form-control"
                                            value="{{ old('name', $user->name) }}" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="email" class="form-label fw-semibold">{{
                                            __('validation.attributes.email') }} <span
                                                class="text-danger">*</span></label>
                                        <input type="email" id="email" name="email" class="form-control"
                                            value="{{ old('email', $user->email) }}" required>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label fw-semibold">{{ __('model.user.role') }} <span
                                                class="text-danger">*</span></label>
                                        <div class="d-flex flex-wrap gap-3">
                                            @foreach($roles as $role)
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="role"
                                                    id="role_{{ $role->id }}" value="{{ $role->name }}"
                                                    @checked(old('role', $user->getRoleNames()->first()) ==
                                                $role->name)>
                                                <label class="form-check-label" for="role_{{ $role->id }}">
                                                    {{ ucfirst($role->name) }}
                                                </label>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="password" class="form-label fw-semibold">{{
                                            __('validation.attributes.password') }}</label>
                                        <input type="password" id="password" name="password" class="form-control"
                                            autocomplete="new-password">
                                        <div class="form-text">{{ __('common.stay_unchanged') }}</div>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="password_confirmation" class="form-label fw-semibold">Xác nhận mật
                                            khẩu</label>
                                        <input type="password" id="password_confirmation" name="password_confirmation"
                                            class="form-control" autocomplete="new-password">
                                        <div class="form-text">Chỉ cần nhập nếu thay đổi mật khẩu</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Right Column: Additional Info --}}
                    <div class="col-lg-4">
                        <div class="card bg-light border-0">
                            <div class="card-body">
                                <h5 class="fw-semibold mb-3">Thông tin bổ sung</h5>
                                <div class="mb-3">
                                    <label for="phone" class="form-label">{{ __('validation.attributes.phone')
                                        }}</label>
                                    <input type="text" id="phone" name="phone" class="form-control"
                                        value="{{ old('phone', $user->phone) }}">
                                </div>
                                <div class="mb-3">
                                    <label for="location" class="form-label">Khu vực</label>
                                    <select name="location" id="location" class="form-select">
                                        <option value="Hội An" @if($user->location=='Hội An') selected @endif>Hội An
                                        </option>
                                        <option value="An Giang" @if($user->location=='An Giang') selected @endif>An
                                            Giang</option>
                                        <option value="Bà Rịa - Vũng Tàu" @if($user->location=='Bà Rịa - Vũng Tàu')
                                            selected @endif>Bà Rịa -
                                            Vũng Tàu</option>
                                        <option value="Bắc Giang" @if($user->location=='Bắc Giang') selected @endif>Bắc
                                            Giang</option>
                                        <option value="Bắc Kạn" @if($user->location=='Bắc Kạn') selected @endif>Bắc Kạn
                                        </option>
                                        <option value="Bạc Liêu" @if($user->location=='Bạc Liêu') selected @endif>Bạc
                                            Liêu</option>
                                        <option value="Bắc Ninh" @if($user->location=='Bắc Ninh') selected @endif>Bắc
                                            Ninh</option>
                                        <option value="Bến Tre" @if($user->location=='Bến Tre') selected @endif>Bến Tre
                                        </option>
                                        <option value="Bình Định" @if($user->location=='Bình Định') selected @endif>Bình
                                            Định</option>
                                        <option value="Bình Dương" @if($user->location=='Bình Dương') selected
                                            @endif>Bình Dương</option>
                                        <option value="Bình Phước" @if($user->location=='Bình Phước') selected
                                            @endif>Bình Phước</option>
                                        <option value="Bình Thuận" @if($user->location=='Bình Thuận') selected
                                            @endif>Bình Thuận</option>
                                        <option value="Cà Mau" @if($user->location=='Cà Mau') selected @endif>Cà Mau
                                        </option>
                                        <option value="Cần Thơ" @if($user->location=='Cần Thơ') selected @endif>Cần Thơ
                                        </option>
                                        <option value="Cao Bằng" @if($user->location=='Cao Bằng') selected @endif>Cao
                                            Bằng</option>
                                        <option value="Đà Nẵng" @if($user->location=='Đà Nẵng') selected @endif>Đà Nẵng
                                        </option>
                                        <option value="Đắk Lắk" @if($user->location=='Đắk Lắk') selected @endif>Đắk Lắk
                                        </option>
                                        <option value="Đắk Nông" @if($user->location=='Đắk Nông') selected @endif>Đắk
                                            Nông</option>
                                        <option value="Điện Biên" @if($user->location=='Điện Biên') selected @endif>Điện
                                            Biên</option>
                                        <option value="Đồng Nai" @if($user->location=='Đồng Nai') selected @endif>Đồng
                                            Nai</option>
                                        <option value="Đồng Tháp" @if($user->location=='Đồng Tháp') selected @endif>Đồng
                                            Tháp</option>
                                        <option value="Gia Lai" @if($user->location=='Gia Lai') selected @endif>Gia Lai
                                        </option>
                                        <option value="Hà Giang" @if($user->location=='Hà Giang') selected @endif>Hà
                                            Giang</option>
                                        <option value="Hà Nam" @if($user->location=='Hà Nam') selected @endif>Hà Nam
                                        </option>
                                        <option value="Hà Nội" @if($user->location=='Hà Nội') selected @endif>Hà Nội
                                        </option>
                                        <option value="Hà Tĩnh" @if($user->location=='Hà Tĩnh') selected @endif>Hà Tĩnh
                                        </option>
                                        <option value="Hải Dương" @if($user->location=='Hải Dương') selected @endif>Hải
                                            Dương</option>
                                        <option value="Hải Phòng" @if($user->location=='Hải Phòng') selected @endif>Hải
                                            Phòng</option>
                                        <option value="Hậu Giang" @if($user->location=='Hậu Giang') selected @endif>Hậu
                                            Giang</option>
                                        <option value="Hòa Bình" @if($user->location=='Hòa Bình') selected @endif>Hòa
                                            Bình</option>
                                        <option value="Hưng Yên" @if($user->location=='Hưng Yên') selected @endif>Hưng
                                            Yên</option>
                                        <option value="Khánh Hòa" @if($user->location=='Khánh Hòa') selected
                                            @endif>Khánh Hòa</option>
                                        <option value="Kiên Giang" @if($user->location=='Kiên Giang') selected
                                            @endif>Kiên Giang</option>
                                        <option value="Kon Tum" @if($user->location=='Kon Tum') selected @endif>Kon Tum
                                        </option>
                                        <option value="Lai Châu" @if($user->location=='Lai Châu') selected @endif>Lai
                                            Châu</option>
                                        <option value="Lâm Đồng" @if($user->location=='Lâm Đồng') selected @endif>Lâm
                                            Đồng</option>
                                        <option value="Lạng Sơn" @if($user->location=='Lạng Sơn') selected @endif>Lạng
                                            Sơn</option>
                                        <option value="Lào Cai" @if($user->location=='Lào Cai') selected @endif>Lào Cai
                                        </option>
                                        <option value="Long An" @if($user->location=='Long An') selected @endif>Long An
                                        </option>
                                        <option value="Nam Định" @if($user->location=='Nam Định') selected @endif>Nam
                                            Định</option>
                                        <option value="Nghệ An" @if($user->location=='Nghệ An') selected @endif>Nghệ An
                                        </option>
                                        <option value="Ninh Bình" @if($user->location=='Ninh Bình') selected @endif>Ninh
                                            Bình</option>
                                        <option value="Ninh Thuận" @if($user->location=='Ninh Thuận') selected
                                            @endif>Ninh Thuận</option>
                                        <option value="Phú Thọ" @if($user->location=='Phú Thọ') selected @endif>Phú Thọ
                                        </option>
                                        <option value="Phú Yên" @if($user->location=='Phú Yên') selected @endif>Phú Yên
                                        </option>
                                        <option value="Quảng Bình" @if($user->location=='Quảng Bình') selected
                                            @endif>Quảng Bình</option>
                                        <option value="Quảng Nam" @if($user->location=='Quảng Nam') selected
                                            @endif>Quảng Nam</option>
                                        <option value="Quảng Ngãi" @if($user->location=='Quảng Ngãi') selected
                                            @endif>Quảng Ngãi</option>
                                        <option value="Quảng Ninh" @if($user->location=='Quảng Ninh') selected
                                            @endif>Quảng Ninh</option>
                                        <option value="Quảng Trị" @if($user->location=='Quảng Trị') selected
                                            @endif>Quảng Trị</option>
                                        <option value="Sóc Trăng" @if($user->location=='Sóc Trăng') selected @endif>Sóc
                                            Trăng</option>
                                        <option value="Sơn La" @if($user->location=='Sơn La') selected @endif>Sơn La
                                        </option>
                                        <option value="Tây Ninh" @if($user->location=='Tây Ninh') selected @endif>Tây
                                            Ninh</option>
                                        <option value="Thái Bình" @if($user->location=='Thái Bình') selected @endif>Thái
                                            Bình</option>
                                        <option value="Thái Nguyên" @if($user->location=='Thái Nguyên') selected
                                            @endif>Thái Nguyên</option>
                                        <option value="Thanh Hóa" @if($user->location=='Thanh Hóa') selected
                                            @endif>Thanh Hóa</option>
                                        <option value="Thừa Thiên Huế" @if($user->location=='Thừa Thiên Huế') selected
                                            @endif>Thừa Thiên Huế
                                        </option>
                                        <option value="Tiền Giang" @if($user->location=='Tiền Giang') selected
                                            @endif>Tiền Giang</option>
                                        <option value="TP Hồ Chí Minh" @if($user->location=='TP Hồ Chí Minh') selected
                                            @endif>TP Hồ Chí Minh
                                        </option>
                                        <option value="Trà Vinh" @if($user->location=='Trà Vinh') selected @endif>Trà
                                            Vinh</option>
                                        <option value="Tuyên Quang" @if($user->location=='Tuyên Quang') selected
                                            @endif>Tuyên Quang</option>
                                        <option value="Vĩnh Long" @if($user->location=='Vĩnh Long') selected @endif>Vĩnh
                                            Long</option>
                                        <option value="Vĩnh Phúc" @if($user->location=='Vĩnh Phúc') selected @endif>Vĩnh
                                            Phúc</option>
                                        <option value="Yên Bái" @if($user->location=='Yên Bái') selected @endif>Yên Bái
                                        </option>
                                        <option value="Khác" @if($user->location=='Khác') selected @endif>Khác</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="gender" class="form-label">{{ __('validation.attributes.gender')
                                        }}</label>
                                    <select name="gender" id="gender" class="form-select" aria-label="Chọn giới tính">
                                        <option value="" @selected(old('gender', $user->gender) == '')>-- Chọn giới tính
                                            --</option>
                                        <option value="Nam" @selected(old('gender', $user->gender) == 'Nam')>Nam
                                        </option>
                                        <option value="Nữ" @selected(old('gender', $user->gender) == 'Nữ')>Nữ</option>
                                        <option value="Khác" @selected(old('gender', $user->gender) == 'Khác')>Khác
                                        </option>
                                    </select>
                                </div>
                                <div>
                                    <label for="avatar" class="form-label">{{ __('common.avatar') }}</label>
                                    <input type="file" id="avatar" name="avatar" class="form-control"
                                        accept="image/png, image/jpeg, image/gif">
                                    @if($user->avatar)
                                    <div class="mt-2">
                                        <img src="{{ $user->avatar ? (str_starts_with($user->avatar, 'http') ? $user->avatar : asset($user->avatar)) : '' }}"
                                            alt="Avatar" width="60" height="60" class="rounded-circle"
                                            style="object-fit:cover;">
                                        <small class="d-block mt-1">Ảnh đại diện hiện tại.</small>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.users.index') }}" class="btn btn-secondary">
                        <i class="bi bi-x-circle me-1"></i>
                        {{ __('common.back') }}
                    </a>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle me-1"></i>
                        {{ __('common.update') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection