@extends('layouts.app')

@section('title', __('admin.user_management.menu_title') . ' - ' . __('admin.action.add_item', ['attribute' => '']))

@section('content')
<div class="container py-4">
    <div class="card shadow-sm">
        <div class="card-header bg-light">
            <h2 class="h5 mb-0 fw-bold">
                <i class="bi bi-person-plus-fill me-2"></i>
                {{ __('admin.action.add_item', ['attribute' => __('admin.user_management.menu_title')]) }}
            </h2>
        </div>
        <div class="card-body">
            <!-- Success Message -->
            @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            
            <!-- Error Message -->
            @if(session('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <i class="bi bi-exclamation-circle me-2"></i>{{ session('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            <form method="POST" action="{{ route('admin.users.store') }}" enctype="multipart/form-data">
                @csrf
                <div class="row g-4">
                    {{-- Left Column: Main Info --}}
                    <div class="col-lg-8">
                        <div class="card border-0">
                            <div class="card-body p-0">
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <label for="name" class="form-label fw-semibold">{{
                                            __('validation.attributes.name') }} <span
                                                class="text-danger">*</span></label>
                                        <input type="text" id="name" name="name" class="form-control"
                                            value="{{ old('name') }}" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="email" class="form-label fw-semibold">{{
                                            __('validation.attributes.email') }} <span
                                                class="text-danger">*</span></label>
                                        <input type="email" id="email" name="email" class="form-control"
                                            value="{{ old('email') }}" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="password" class="form-label fw-semibold">{{
                                            __('validation.attributes.password') }} <span
                                                class="text-danger">*</span></label>
                                        <input type="password" id="password" name="password" class="form-control"
                                            required autocomplete="new-password">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="password_confirmation" class="form-label fw-semibold">{{
                                            __('validation.attributes.password_confirmation') }} <span
                                                class="text-danger">*</span></label>
                                        <input type="password" id="password_confirmation" name="password_confirmation"
                                            class="form-control" required autocomplete="new-password">
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label fw-semibold">{{ __('model.user.role') }} <span
                                                class="text-danger">*</span></label>
                                        <div class="d-flex flex-wrap gap-3">
                                            @foreach($roles as $role)
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="role"
                                                    id="role_{{ $role->id }}" value="{{ $role->name }}"
                                                    @checked(old('role')==$role->name)>
                                                <label class="form-check-label" for="role_{{ $role->id }}">
                                                    {{ ucfirst($role->name) }}
                                                </label>
                                            </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Right Column: Additional Info --}}
                    <div class="col-lg-4">
                        <div class="card bg-light border-0">
                            <div class="card-body">
                                <h5 class="fw-semibold mb-3">Thông tin bổ sung</h5>
                                <div class="mb-3">
                                    <label for="phone" class="form-label">{{ __('validation.attributes.phone')
                                        }}</label>
                                    <input type="text" id="phone" name="phone" class="form-control"
                                        value="{{ old('phone') }}">
                                </div>
                                <div class="mb-3">
                                    <label for="location">Khu vực<span class="text-danger">*</span></label>
                                    <select name="location" id="location" class="form-select">
                                        <option value="Hội An" @if(old('location')=='Hội An' ) selected @endif>Hội An
                                        </option>
                                        <option value="An Giang" @if(old('location')=='An Giang' ) selected @endif>An
                                            Giang</option>
                                        <option value="Bà Rịa - Vũng Tàu" @if(old('location')=='Bà Rịa - Vũng Tàu' )
                                            selected @endif>Bà Rịa
                                            - Vũng Tàu</option>
                                        <option value="Bắc Giang" @if(old('location')=='Bắc Giang' ) selected @endif>Bắc
                                            Giang</option>
                                        <option value="Bắc Kạn" @if(old('location')=='Bắc Kạn' ) selected @endif>Bắc Kạn
                                        </option>
                                        <option value="Bạc Liêu" @if(old('location')=='Bạc Liêu' ) selected @endif>Bạc
                                            Liêu</option>
                                        <option value="Bắc Ninh" @if(old('location')=='Bắc Ninh' ) selected @endif>Bắc
                                            Ninh</option>
                                        <option value="Bến Tre" @if(old('location')=='Bến Tre' ) selected @endif>Bến Tre
                                        </option>
                                        <option value="Bình Định" @if(old('location')=='Bình Định' ) selected @endif>
                                            Bình Định</option>
                                        <option value="Bình Dương" @if(old('location')=='Bình Dương' ) selected @endif>
                                            Bình Dương</option>
                                        <option value="Bình Phước" @if(old('location')=='Bình Phước' ) selected @endif>
                                            Bình Phước</option>
                                        <option value="Bình Thuận" @if(old('location')=='Bình Thuận' ) selected @endif>
                                            Bình Thuận</option>
                                        <option value="Cà Mau" @if(old('location')=='Cà Mau' ) selected @endif>Cà Mau
                                        </option>
                                        <option value="Cần Thơ" @if(old('location')=='Cần Thơ' ) selected @endif>Cần Thơ
                                        </option>
                                        <option value="Cao Bằng" @if(old('location')=='Cao Bằng' ) selected @endif>Cao
                                            Bằng</option>
                                        <option value="Đà Nẵng" @if(old('location')=='Đà Nẵng' ) selected @endif>Đà Nẵng
                                        </option>
                                        <option value="Đắk Lắk" @if(old('location')=='Đắk Lắk' ) selected @endif>Đắk Lắk
                                        </option>
                                        <option value="Đắk Nông" @if(old('location')=='Đắk Nông' ) selected @endif>Đắk
                                            Nông</option>
                                        <option value="Điện Biên" @if(old('location')=='Điện Biên' ) selected @endif>
                                            Điện Biên</option>
                                        <option value="Đồng Nai" @if(old('location')=='Đồng Nai' ) selected @endif>Đồng
                                            Nai</option>
                                        <option value="Đồng Tháp" @if(old('location')=='Đồng Tháp' ) selected @endif>
                                            Đồng Tháp</option>
                                        <option value="Gia Lai" @if(old('location')=='Gia Lai' ) selected @endif>Gia Lai
                                        </option>
                                        <option value="Hà Giang" @if(old('location')=='Hà Giang' ) selected @endif>Hà
                                            Giang</option>
                                        <option value="Hà Nam" @if(old('location')=='Hà Nam' ) selected @endif>Hà Nam
                                        </option>
                                        <option value="Hà Nội" @if(old('location')=='Hà Nội' ) selected @endif>Hà Nội
                                        </option>
                                        <option value="Hà Tĩnh" @if(old('location')=='Hà Tĩnh' ) selected @endif>Hà Tĩnh
                                        </option>
                                        <option value="Hải Dương" @if(old('location')=='Hải Dương' ) selected @endif>Hải
                                            Dương</option>
                                        <option value="Hải Phòng" @if(old('location')=='Hải Phòng' ) selected @endif>Hải
                                            Phòng</option>
                                        <option value="Hậu Giang" @if(old('location')=='Hậu Giang' ) selected @endif>Hậu
                                            Giang</option>
                                        <option value="Hòa Bình" @if(old('location')=='Hòa Bình' ) selected @endif>Hòa
                                            Bình</option>
                                        <option value="Hưng Yên" @if(old('location')=='Hưng Yên' ) selected @endif>Hưng
                                            Yên</option>
                                        <option value="Khánh Hòa" @if(old('location')=='Khánh Hòa' ) selected @endif>
                                            Khánh Hòa</option>
                                        <option value="Kiên Giang" @if(old('location')=='Kiên Giang' ) selected @endif>
                                            Kiên Giang</option>
                                        <option value="Kon Tum" @if(old('location')=='Kon Tum' ) selected @endif>Kon Tum
                                        </option>
                                        <option value="Lai Châu" @if(old('location')=='Lai Châu' ) selected @endif>Lai
                                            Châu</option>
                                        <option value="Lâm Đồng" @if(old('location')=='Lâm Đồng' ) selected @endif>Lâm
                                            Đồng</option>
                                        <option value="Lạng Sơn" @if(old('location')=='Lạng Sơn' ) selected @endif>Lạng
                                            Sơn</option>
                                        <option value="Lào Cai" @if(old('location')=='Lào Cai' ) selected @endif>Lào Cai
                                        </option>
                                        <option value="Long An" @if(old('location')=='Long An' ) selected @endif>Long An
                                        </option>
                                        <option value="Nam Định" @if(old('location')=='Nam Định' ) selected @endif>Nam
                                            Định</option>
                                        <option value="Nghệ An" @if(old('location')=='Nghệ An' ) selected @endif>Nghệ An
                                        </option>
                                        <option value="Ninh Bình" @if(old('location')=='Ninh Bình' ) selected @endif>
                                            Ninh Bình</option>
                                        <option value="Ninh Thuận" @if(old('location')=='Ninh Thuận' ) selected @endif>
                                            Ninh Thuận</option>
                                        <option value="Phú Thọ" @if(old('location')=='Phú Thọ' ) selected @endif>Phú Thọ
                                        </option>
                                        <option value="Phú Yên" @if(old('location')=='Phú Yên' ) selected @endif>Phú Yên
                                        </option>
                                        <option value="Quảng Bình" @if(old('location')=='Quảng Bình' ) selected @endif>
                                            Quảng Bình</option>
                                        <option value="Quảng Nam" @if(old('location')=='Quảng Nam' ) selected @endif>
                                            Quảng Nam</option>
                                        <option value="Quảng Ngãi" @if(old('location')=='Quảng Ngãi' ) selected @endif>
                                            Quảng Ngãi</option>
                                        <option value="Quảng Ninh" @if(old('location')=='Quảng Ninh' ) selected @endif>
                                            Quảng Ninh</option>
                                        <option value="Quảng Trị" @if(old('location')=='Quảng Trị' ) selected @endif>
                                            Quảng Trị</option>
                                        <option value="Sóc Trăng" @if(old('location')=='Sóc Trăng' ) selected @endif>Sóc
                                            Trăng</option>
                                        <option value="Sơn La" @if(old('location')=='Sơn La' ) selected @endif>Sơn La
                                        </option>
                                        <option value="Tây Ninh" @if(old('location')=='Tây Ninh' ) selected @endif>Tây
                                            Ninh</option>
                                        <option value="Thái Bình" @if(old('location')=='Thái Bình' ) selected @endif>
                                            Thái Bình</option>
                                        <option value="Thái Nguyên" @if(old('location')=='Thái Nguyên' ) selected
                                            @endif>Thái Nguyên
                                        </option>
                                        <option value="Thanh Hóa" @if(old('location')=='Thanh Hóa' ) selected @endif>
                                            Thanh Hóa</option>
                                        <option value="Thừa Thiên Huế" @if(old('location')=='Thừa Thiên Huế' ) selected
                                            @endif>Thừa Thiên
                                            Huế</option>
                                        <option value="Tiền Giang" @if(old('location')=='Tiền Giang' ) selected @endif>
                                            Tiền Giang</option>
                                        <option value="TP Hồ Chí Minh" @if(old('location')=='TP Hồ Chí Minh' ) selected
                                            @endif>TP Hồ Chí
                                            Minh</option>
                                        <option value="Trà Vinh" @if(old('location')=='Trà Vinh' ) selected @endif>Trà
                                            Vinh</option>
                                        <option value="Tuyên Quang" @if(old('location')=='Tuyên Quang' ) selected
                                            @endif>Tuyên Quang
                                        </option>
                                        <option value="Vĩnh Long" @if(old('location')=='Vĩnh Long' ) selected @endif>
                                            Vĩnh Long</option>
                                        <option value="Vĩnh Phúc" @if(old('location')=='Vĩnh Phúc' ) selected @endif>
                                            Vĩnh Phúc</option>
                                        <option value="Yên Bái" @if(old('location')=='Yên Bái' ) selected @endif>Yên Bái
                                        </option>
                                        <option value="Khác" @if(old('location')=='Khác' ) selected @endif>Khác</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="gender" class="form-label">{{ __('validation.attributes.gender')
                                        }}</label>
                                    <select name="gender" id="gender" class="form-select" aria-label="Chọn giới tính">
                                        <option value="" @selected(old('gender')=='' )>-- Chọn giới tính --</option>
                                        <option value="Nam" @selected(old('gender')=='Nam' )>Nam</option>
                                        <option value="Nữ" @selected(old('gender')=='Nữ' )>Nữ</option>
                                        <option value="Khác" @selected(old('gender')=='Khác' )>Khác</option>
                                    </select>
                                </div>
                                <div>
                                    <label for="avatar" class="form-label">{{ __('common.avatar') }}</label>
                                    <input type="file" id="avatar" name="avatar" class="form-control"
                                        accept="image/png, image/jpeg, image/gif">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-end gap-2">
                    <a href="{{ route('admin.users.index') }}" class="btn btn-outline-light fw-semibold shadow-sm">
                        <i class="bi bi-x-circle me-1"></i>
                        {{ __('common.back') }}
                    </a>
                    <button type="submit" class="btn btn-primary fw-semibold shadow-sm">
                        <i class="bi bi-check-circle me-1"></i>
                        {{ __('common.create') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection