@extends('layouts.app')
@section('title', 'Chi tiết Giải Đấu')

@push('layout_css')
<style>
    .step-button {
        white-space: nowrap;
    }

    .score-input-wrapper {
        display: flex;
        align-items: center;
    }

    .score-input-wrapper .form-control {
        text-align: center;
        border-left: none;
        border-right: none;
        border-radius: 0;
        background: var(--card-bg) !important;
        border-color: var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .score-input-wrapper .btn {
        border-radius: 0;
        background: var(--secondary-bg) !important;
        border-color: var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .score-input-wrapper .btn-group-sm>.btn {
        padding: .25rem .5rem;
        font-size: .875rem;
    }

    /* New styles for the match score update form */
    .match-card {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        border-radius: .5rem;
        padding: 1rem;
        margin-bottom: 1rem;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
        position: relative;
        color: var(--text-primary) !important;
    }

    /* Bye match specific styling */
    .match-card.bye-match {
        background: rgba(34, 197, 94, 0.1) !important;
        border-color: var(--success) !important;
        border-left: 4px solid var(--success) !important;
    }

    .bye-match .match-status-selector select {
        background: rgba(34, 197, 94, 0.15) !important;
        color: var(--success) !important;
        border-color: var(--success) !important;
    }

    .match-team-info {
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        color: var(--text-primary);
    }

    .team-avatars {
        display: flex;
        margin-bottom: .5rem;
    }

    .team-avatars .avatar,
    .team-avatars .avatar-placeholder {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        object-fit: cover;
        border: 2px solid var(--border-color);
        box-shadow: 0 1px 3px rgba(0, 0, 0, .3);
    }

    .team-avatars .avatar:first-child,
    .team-avatars .avatar-placeholder:first-child {
        margin-right: -10px;
    }

    .team-name {
        font-weight: 600;
        font-size: 0.9rem;
        min-height: 40px;
        /* Đảm bảo chiều cao đồng đều */
        display: flex;
        align-items: center;
        color: var(--text-primary);
    }

    /* Player number tags (1 and 2) */
    .player-number-tag {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 22px;
        height: 22px;
        border-radius: 50%;
        font-size: 0.75rem;
        font-weight: 700;
        color: var(--text-primary);
        margin-right: 8px;
    }

    .player-number-tag.p1 {
        background: var(--accent-primary);
    }

    .player-number-tag.p2 {
        background: var(--success);
    }

    .avatar-placeholder {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        color: var(--text-primary);
        font-weight: bold;
        font-size: 1.2rem;
        border: 2px solid var(--border-color);
    }

    .score-control-wrapper {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        gap: 0.25rem;
    }

    .score-input-display {
        font-size: 2rem;
        font-weight: bold;
        padding: 0 1rem;
        min-width: 60px;
        text-align: center;
        color: var(--text-primary);
    }

    .score-control-buttons .btn {
        font-size: 1.2rem;
        line-height: 1;
        background: var(--secondary-bg) !important;
        border-color: var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .score-control-buttons .btn:hover {
        background: var(--accent-primary) !important;
        border-color: var(--accent-primary) !important;
    }

    .match-status-selector {
        position: absolute;
        top: 0.5rem;
        right: 0.5rem;
    }

    .match-status-selector .form-select {
        background: var(--card-bg) !important;
        border-color: var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .match-status-selector .form-select:focus {
        background: var(--card-bg) !important;
        border-color: var(--accent-primary) !important;
        box-shadow: 0 0 0 0.2rem rgba(59, 130, 246, 0.25) !important;
    }

    .score-control-center {
        font-size: 1.5rem;
        color: var(--text-primary);
    }

    @media (max-width: 767.98px) {
        .match-card .row {
            flex-direction: column;
        }

        .match-card .col-5,
        .match-card .col-2 {
            width: 100%;
            flex: 1 1 100%;
        }

        .score-control-center-mobile {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 1rem 0;
        }

        .match-status-selector {
            position: static;
            /* Reset position on mobile */
            margin-bottom: 1rem;
            max-width: 200px;
        }

        /* Responsive standings table */
        .standings-table-wrapper {
            padding: 0.45rem 0.5rem;
        }

        .standings-table thead th,
        .standings-table td {
            padding: 0.65rem 0.55rem;
            font-size: 0.88rem;
        }
    }

    @media (max-width: 991.98px) {
        .standings-table-wrapper {
            padding: 0.55rem;
        }

        .standings-table thead th {
            font-size: 0.78rem;
            padding: 0.75rem 0.6rem;
        }

        .standings-table td {
            padding: 0.75rem 0.6rem;
            font-size: 0.92rem;
        }
    }

    @media (max-width: 575.98px) {
        .standings-table-wrapper {
            padding: 0.35rem 0.4rem;
        }

        .standings-table thead th,
        .standings-table td {
            padding: 0.55rem 0.5rem;
            font-size: 0.82rem;
        }
    }

    /* Highlights for standings top positions */
    .standing-top-1 {
        background: linear-gradient(90deg, rgba(255, 223, 93, 0.25), rgba(255, 223, 93, 0.1));
        border-left: 4px solid #f6c84c;
        color: var(--text-primary);
    }

    .standing-top-2 {
        background: linear-gradient(90deg, rgba(192, 192, 192, 0.15), rgba(192, 192, 192, 0.05));
        border-left: 4px solid #bdbdbd;
        color: var(--text-primary);
    }

    .standing-top-3 {
        background: linear-gradient(90deg, rgba(205, 127, 50, 0.15), rgba(205, 127, 50, 0.05));
        border-left: 4px solid #cd7f32;
        color: var(--text-primary);
    }

    .standing-badge {
        font-size: 0.7rem;
        padding: 0.15rem 0.4rem;
        border-radius: 0.35rem;
        margin-left: 0.5rem;
        vertical-align: middle;
        background: var(--accent-primary);
        color: var(--text-primary);
    }

    /* Standings table styling */
    .standings-table-wrapper {
        background: rgba(255, 255, 255, 0.02);
        border: 1px solid var(--border-color);
        border-radius: 1rem;
        padding: 0.75rem;
        box-shadow: 0 10px 28px rgba(0, 0, 0, 0.35);
        backdrop-filter: blur(6px);
    }

    .standings-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        color: var(--text-secondary);
        background-color: rgba(12, 15, 22, 0.85);
        border-radius: 0.85rem;
        overflow: hidden;
    }

    .standings-table thead th {
        background: linear-gradient(135deg, rgba(59, 130, 246, 0.85) 0%, rgba(34, 211, 238, 0.65) 100%);
        color: var(--text-primary);
        border-bottom: none;
        text-transform: uppercase;
        letter-spacing: 0.04em;
        font-size: 0.82rem;
        padding: 0.85rem 0.75rem;
    }

    .standings-table tbody tr {
        background-color: rgba(255, 255, 255, 0.02) !important;
        transition: transform 0.18s ease, background-color 0.18s ease, box-shadow 0.18s ease;
    }

    .standings-table tbody tr:nth-of-type(even) {
        background-color: rgba(255, 255, 255, 0.05) !important;
    }

    .standings-table tbody tr:hover {
        background-color: rgba(59, 130, 246, 0.18) !important;
        transform: translateY(-2px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.32);
        color: var(--text-primary);
    }

    .standings-table th,
    .standings-table td {
        border-color: rgba(255, 255, 255, 0.08) !important;
        padding: 0.85rem 0.75rem;
        vertical-align: middle;
        background-color: transparent !important;
    }

    .standings-table tbody tr+tr td {
        border-top: 1px solid rgba(255, 255, 255, 0.06);
    }

    .standings-table tbody tr:first-child {
        background: linear-gradient(135deg, rgba(59, 130, 246, 0.25) 0%, rgba(34, 211, 238, 0.15) 100%) !important;
        box-shadow: inset 0 0 0 1px rgba(34, 211, 238, 0.35);
    }

    .standings-table tbody td,
    .standings-table thead th {
        color: var(--text-primary);
    }

    .standings-table tbody td a {
        color: var(--accent-secondary);
    }

    .standings-table tbody td a:hover {
        color: var(--accent-primary);
    }

    .standings-table .text-muted {
        color: rgba(255, 255, 255, 0.55) !important;
    }

    .standings-table .text-success {
        color: var(--success) !important;
    }
</style>
<style>
    .swap-players-btn {
        cursor: pointer;
        color: var(--accent-primary);
        margin: 0 8px;
    }

    .swap-players-btn:hover {
        color: var(--accent-secondary);
    }

    /* Referee mode indicator */
    .referee-mode-indicator {
        background: linear-gradient(135deg, var(--success), #20c997);
        color: var(--text-primary);
        padding: 8px 16px;
        border-radius: 25px;
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        box-shadow: 0 2px 8px rgba(34, 197, 94, 0.3);
        animation: pulse-referee 2s infinite;
    }

    @keyframes pulse-referee {
        0% {
            box-shadow: 0 2px 8px rgba(34, 197, 94, 0.3);
        }

        50% {
            box-shadow: 0 4px 16px rgba(34, 197, 94, 0.5);
        }

        100% {
            box-shadow: 0 2px 8px rgba(34, 197, 94, 0.3);
        }
    }

    /* Hide certain elements for referee mode */
    .referee-mode .hidden-for-referee {
        display: none !important;
    }

    /* Card styling for dark theme */
    .card {
        background: var(--card-bg) !important;
        border: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .card-header {
        background: var(--secondary-bg) !important;
        border-bottom: 1px solid var(--border-color) !important;
        color: var(--text-primary) !important;
    }

    .card-header.bg-light {
        background: var(--secondary-bg) !important;
    }

    .card-header.bg-primary {
        background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary)) !important;
        color: var(--text-primary) !important;
    }

    .card-header.bg-danger {
        background: linear-gradient(135deg, var(--danger), #dc2626) !important;
        color: var(--text-primary) !important;
    }

    .card-header.bg-dark {
        background: var(--primary-bg) !important;
        color: var(--text-primary) !important;
    }
</style>
@endpush

@section('content')
@php
// Xác định trạng thái hoàn thành của các bước để vô hiệu hóa các nút không hợp lệ
$groupRounds = $tournament->rounds->where('type', 'round_robin');
$allGroupMatchesCompleted = $groupRounds->isNotEmpty() &&
$groupRounds->pluck('matches')->flatten()->every(function($match) {
return $match->status === 'Hoàn thành' || $match->status === 'Bye';
});

// Get playoff rounds by playoff_level to handle all types of playoff rounds
// Find the LATEST playoff round that's not final/third_place to check completion
$playoffRounds = $tournament->rounds->where('type', 'playoff')
->sortBy('created_at'); // Sort by creation order

// Find different types of rounds (from largest to smallest)
$roundOf64 = $playoffRounds->first(function($round) {
return $round->playoff_level === 'round_of_64' || str_contains($round->name, 'Vòng 1/64');
});
$roundOf32 = $playoffRounds->first(function($round) {
return $round->playoff_level === 'round_of_32' || str_contains($round->name, 'Vòng 1/32');
});
$roundOf16 = $playoffRounds->first(function($round) {
return $round->playoff_level === 'round_of_16' || str_contains($round->name, 'Vòng 1/16');
});
$quarterFinals = $playoffRounds->first(function($round) {
return $round->playoff_level === 'quarter_final' || str_contains($round->name, 'Tứ kết');
});
$semiFinals = $playoffRounds->first(function($round) {
return $round->playoff_level === 'semi_final' || str_contains($round->name, 'Bán kết');
});

// New logic for progressive playoff step generation:
// Progressive playoff step generation logic (handles any tournament size):
// Step 3: Create initial playoffs (Round of 64/32/16 or Quarter Finals depending on team count)
// Step 4: Create next round (could be Round of 32, Round of 16, or Quarter Finals)
// Step 5: Create next round (could be Round of 16, Quarter Finals, or Semi Finals)
// Step 6+: Continue until Finals

// Round completion checks (from largest to smallest)
$allRoundOf64Completed = $roundOf64 && $roundOf64->matches->every(function($match) {
return $match->status === 'Hoàn thành' || $match->status === 'Bye';
});

$allRoundOf32Completed = $roundOf32 && $roundOf32->matches->every(function($match) {
return $match->status === 'Hoàn thành' || $match->status === 'Bye';
});

$allRoundOf16Completed = $roundOf16 && $roundOf16->matches->every(function($match) {
return $match->status === 'Hoàn thành' || $match->status === 'Bye';
});

$allQuarterFinalsCompleted = $quarterFinals && $quarterFinals->matches->every(function($match) {
return $match->status === 'Hoàn thành' || $match->status === 'Bye';
});

$allSemiFinalsCompleted = $semiFinals && $semiFinals->matches->every(function($match) {
return $match->status === 'Hoàn thành' || $match->status === 'Bye';
});

$final = $tournament->rounds->first(function($round) {
return $round->type === 'playoff' && (
$round->playoff_level === 'final' ||
str_contains($round->name, 'Chung kết')
);
});
$thirdPlace = $tournament->rounds->first(function($round) {
return $round->type === 'playoff' && (
$round->playoff_level === 'third_place' ||
str_contains($round->name, 'Tranh hạng ba')
);
});

// Step completion logic (dynamic for any tournament size)
$step1Completed = $tournament->groups->isNotEmpty();
$step2Completed = $groupRounds->isNotEmpty();
$step3Generated = !empty($roundOf64) || !empty($roundOf32) || !empty($roundOf16) || !empty($quarterFinals) ||
!empty($semiFinals) || !empty($final);
$step3Completed = $allGroupMatchesCompleted; // Điều kiện để tạo playoff

// Determine which is the current active round (largest existing round)
$currentPlayoffRound = $roundOf64 ?: ($roundOf32 ?: ($roundOf16 ?: $quarterFinals));
$currentPlayoffCompleted = false;

if ($roundOf64) {
$currentPlayoffCompleted = $allRoundOf64Completed;
} elseif ($roundOf32) {
$currentPlayoffCompleted = $allRoundOf32Completed;
} elseif ($roundOf16) {
$currentPlayoffCompleted = $allRoundOf16Completed;
} elseif ($quarterFinals) {
$currentPlayoffCompleted = $allQuarterFinalsCompleted;
}

// Dynamic step generation flags
$stepNextRoundGenerated = !empty($semiFinals); // Next progression round exists
$stepNextRoundCompleted = $currentPlayoffCompleted; // Current round completed
$stepFinalsCompleted = $allSemiFinalsCompleted; // Semi Finals completed (for finals)
// Flag: is organizer session for this tournament (tournament setting)
$isOrganizer = session('tournament_pw_'.$tournament->id) ? true : false;
// Flag: is referee session for this tournament
$isReferee = session('tournament_role_'.$tournament->id) === 'referee';
@endphp

<div class="container py-4 {{ $isReferee ? 'referee-mode' : '' }}">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div class="d-flex align-items-center gap-3">
            @if($tournament->image)
            <img src="/{{ $tournament->image }}" alt="Hình ảnh giải đấu"
                style="max-width:80px;max-height:60px;object-fit:cover;border-radius:6px;">
            @endif
            <h1 class="fw-bold mb-0" style="color: var(--text-primary);">
                <i class="bi bi-trophy-fill" style="color: var(--accent-primary);"></i>
                <a href="{{ route('tournaments.show', $tournament->slug) }}" target="_blank"
                    class="text-decoration-none" style="color: var(--accent-primary);">{{ $tournament->name }}</a>
                @if($isReferee)
                <span class="referee-mode-indicator ms-3">
                    <i class="bi bi-person-badge"></i> Chế độ Trọng tài
                </span>
                @endif
            </h1>
        </div>
        <div>
            @if(!$isOrganizer && !$isReferee)
            <a href="{{ route('admin.tournaments.pairs.index', $tournament) }}" class="btn btn-primary"><i
                    class="bi bi-person-lines-fill"></i> Quản lý Cặp đấu</a>
            @endif
            @if(!$isReferee)
            <a href="{{ $isOrganizer
                    ? route('tournament.setting.registrations.index', $tournament)
                    : route('admin.tournaments.registrations', $tournament) }}" class="btn btn-info"><i
                    class="bi bi-clipboard-check"></i> Duyệt Đăng ký ({{ $tournament->pending_registrations_count
                }})</a>
            @endif

            @if(!$isReferee)
            <a href="{{ $isOrganizer ? route('tournament.setting.activity-log', ['tournament' => $tournament->id]) : route('admin.tournaments.activity-log', $tournament) }}"
                class="btn btn-outline-info"><i class="bi bi-clock-history"></i> Lịch sử</a>
            @endif
            @if($isOrganizer || $isReferee)
            <form action="/tournament-setting/logout" method="POST" class="d-inline">
                @csrf
                <input type="hidden" name="tournamentId" value="{{ $tournament->id }}">
                <button type="submit" class="btn btn-light">Đăng xuất</button>
            </form>
            @endif
            {{-- @if($isReferee)
            <form action="/referee-setting/logout" method="POST" class="d-inline">
                @csrf
                <input type="hidden" name="tournamentId" value="{{ $tournament->id }}">
                <button type="submit" class="btn btn-light"><i class="bi bi-box-arrow-right"></i> Đăng xuất Trọng
                    tài</button>
            </form>
            @endif --}}
        </div>
    </div>

    @if($isReferee)
    <!-- Referee Instructions -->
    <div class="alert border-0 mb-4"
        style="background: rgba(59, 130, 246, 0.1); border: 1px solid var(--accent-primary) !important;">
        <div class="d-flex align-items-center">
            <i class="bi bi-info-circle-fill fs-4 me-3" style="color: var(--accent-primary);"></i>
            <div>
                <h6 class="alert-heading mb-1" style="color: var(--text-primary);"><i class="bi bi-person-badge"></i>
                    Hướng dẫn cho Trọng tài</h6>
                <p class="mb-0" style="color: var(--text-primary);">Bạn đang ở chế độ <strong>Trọng tài</strong>. Bạn có
                    thể xem và cập nhật điểm số các
                    trận đấu trong các tab: <strong>Lịch Thi đấu</strong>, <strong>Vòng Play-off</strong>, và
                    <strong>Nhánh Đấu</strong>.
                </p>
            </div>
        </div>
    </div>
    @endif

    <!-- Tab navigation -->
    <ul class="nav nav-tabs nav-fill mb-4" id="tournamentTab" role="tablist">
        @if(!$isReferee)
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $isReferee ? '' : 'active' }}" id="control-panel-tab" data-bs-toggle="tab"
                data-bs-target="#control-panel" type="button" role="tab" aria-controls="control-panel"
                aria-selected="{{ $isReferee ? 'false' : 'true' }}"><i class="bi bi-sliders"></i> Bảng Điều
                Khiển</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="groups-pairs-tab" data-bs-toggle="tab" data-bs-target="#groups-pairs"
                type="button" role="tab" aria-controls="groups-pairs" aria-selected="false"><i
                    class="bi bi-people-fill"></i> Bảng Đấu & Cặp Đấu</button>
        </li>
        @endif
        <li class="nav-item" role="presentation">
            <button class="nav-link {{ $isReferee ? 'active' : '' }}" id="schedule-tab" data-bs-toggle="tab"
                data-bs-target="#schedule" type="button" role="tab" aria-controls="schedule"
                aria-selected="{{ $isReferee ? 'true' : 'false' }}"><i class="bi bi-calendar-event"></i> Lịch
                Thi
                Đấu</button>
        </li>@if($tournament->rounds->where('type', 'playoff')->isNotEmpty())
        <li class="nav-item" role="presentation">
            <button class="nav-link{{ $isReferee ? 'active' : '' }}" id="playoffs-tab" data-bs-toggle="tab"
                data-bs-target="#playoffs" type="button" role="tab" aria-controls="playoffs" aria-selected="false"><i
                    class="bi bi-diagram-2-fill"></i> Vòng
                Play-off</button>
        </li>
        @endif @if(!empty($roundOf16) || !empty($quarterFinals) || !empty($semiFinals) || !empty($final))
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="bracket-tab" data-bs-toggle="tab" data-bs-target="#bracket" type="button"
                role="tab" aria-controls="bracket" aria-selected="false"><i class="bi bi-diagram-3-fill"></i> Nhánh
                Đấu</button>
        </li>
        @endif
    </ul>

    <!-- Tab content -->
    <div class="tab-content" id="tournamentTabContent">
        <!-- Control Panel Tab -->
        @if(!$isReferee)
        <div class="tab-pane fade {{ $isReferee ? '' : 'show active' }}" id="control-panel" role="tabpanel"
            aria-labelledby="control-panel-tab">
            <div class="card shadow-sm">
                <div class="card-header bg-light">
                    <h5 class="mb-0"><i class="bi bi-joystick"></i> Các bước vận hành giải đấu</h5>
                </div>
                <div class="card-body">
                    <p class="mb-0">Thực hiện các bước theo thứ tự để thiết lập và quản lý giải đấu một cách
                        tự
                        động.</p>

                    <!-- Step 1 & 2 -->
                    <div class="mb-4 p-3 border rounded">
                        <h6 class="fw-bold">Giai đoạn 1: Chia Bảng<span class="mb-0">({{
                                $tournament->approved_registrations_count }} cặp
                                đã
                                duyệt)</span></h6>
                        <div class="d-flex flex-wrap gap-2 align-items-end">
                            <form id="step1-form"
                                action="{{ $isOrganizer ? route('tournament.setting.auto-generate-groups', $tournament) : route('admin.tournaments.auto-generate-groups', $tournament) }}"
                                method="POST" class="d-flex gap-2 align-items-end">
                                @csrf
                                <div>
                                    <label for="number_of_groups" class="form-label small mb-1">
                                        Số bảng
                                    </label>
                                    <input type="number" name="number_of_groups" id="number_of_groups"
                                        class="form-control form-control-sm" value="4" min="1" style="width: 40px;">
                                </div>
                                <div>
                                    <button type="submit" class="btn btn-primary btn-sm step-button"><i
                                            class="bi bi-dice-5"></i> STEP 1: TỰ ĐỘNG CHIA BẢNG</button>
                                </div>
                            </form>

                            <form
                                action="{{ $isOrganizer ? route('tournament.setting.clear-groups', $tournament) : route('admin.tournaments.clear-groups', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-outline-danger btn-sm step-button"
                                    onclick="return confirm('Bạn có chắc muốn xóa TẤT CẢ các bảng và cặp đấu đã tạo? Hành động này không thể hoàn tác.')"
                                    {{ !$step1Completed ? 'disabled' : '' }}><i class="bi bi-trash"></i> Xóa
                                    Bảng</button>
                            </form>
                        </div>
                    </div>

                    <!-- Step 3 -->
                    <div class="mb-4 p-3 border rounded">
                        <h6 class="fw-bold">Giai đoạn 2: Vòng Bảng</h6>
                        <div class="d-flex flex-wrap gap-2 align-items-end">
                            <form id="step3-form"
                                action="{{ $isOrganizer ? route('tournament.setting.auto-generate-group-rounds', $tournament) : route('admin.tournaments.auto-generate-group-rounds', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                <button type="submit" id="step2-button"
                                    class="btn btn-success btn-sm step-button {{ !$step1Completed ? 'disabled' : '' }}"
                                    {{ !$step1Completed ? 'disabled' : '' }}><i class="bi bi-card-list"></i> STEP 2:
                                    TẠO
                                    VÒNG ĐẤU BẢNG</button>
                            </form>
                            <form
                                action="{{ $isOrganizer ? route('tournament.setting.clear-group-rounds', $tournament) : route('admin.tournaments.clear-group-rounds', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-outline-danger btn-sm step-button"
                                    onclick="return confirm('Bạn có chắc muốn xóa TẤT CẢ các vòng đấu bảng đã tạo? Hành động này không thể hoàn tác.')"><i
                                        class="bi bi-trash"></i> Xóa Vòng Bảng</button>
                            </form>
                        </div>
                    </div>

                    <!-- Step 3, 4, 5, 6 - Progressive Playoff Generation -->
                    <div class="p-3 border rounded">
                        <h6 class="fw-bold">Giai đoạn 3: Vòng Play-off</h6>
                        <div class="d-flex flex-wrap gap-2 align-items-end">
                            <!-- Step 3: Create initial playoffs -->
                            <form id="generate-playoffs-form"
                                action="{{ $isOrganizer ? route('tournament.setting.generate-playoffs', $tournament) : route('admin.tournaments.generate-playoffs', $tournament) }}"
                                method="POST" class="d-flex gap-2 align-items-end">
                                @csrf
                                <div>
                                    <label for="teams_to_advance" class="form-label small mb-1">
                                        Số đội đi tiếp/bảng
                                    </label>
                                    <input type="number" name="teams_to_advance" id="teams_to_advance"
                                        class="form-control form-control-sm" value="2" min="1" style="width: 40px;">
                                </div>
                                <div>
                                    <button type="submit" id="step3-button" class="btn btn-danger btn-sm step-button" {{
                                        !$allGroupMatchesCompleted ? 'disabled' : '' }}><i class="bi bi-diagram-2"></i>
                                        STEP
                                        3: TẠO VÒNG PLAY-OFF</button>
                                </div>
                            </form>

                            <!-- Step 4: Create Quarter Finals (only if Round of 16 exists) -->
                            @if($roundOf16 && !$quarterFinals)
                            <form
                                action="{{ $isOrganizer ? route('tournament.setting.generate-quarterfinals', $tournament) : route('admin.tournaments.generate-quarterfinals', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-warning btn-sm step-button" {{
                                    !$currentPlayoffCompleted ? 'disabled' : '' }}><i class="bi bi-diagram-2-fill"></i>
                                    STEP 4: TẠO TỨ
                                    KẾT</button>
                            </form>
                            @endif

                            <!-- Generate Round of 32 (for 64+ team tournaments) -->
                            @if($roundOf64 && !$roundOf32)
                            <form
                                action="{{ $isOrganizer ? route('tournament.setting.generate-round-32', $tournament) : route('admin.tournaments.generate-round-32', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-primary btn-sm step-button" {{
                                    !$currentPlayoffCompleted ? 'disabled' : '' }}><i class="bi bi-diagram-2-fill"></i>
                                    TẠO VÒNG 1/32</button>
                            </form>
                            @endif

                            <!-- Generate Round of 16 (for 32+ team tournaments) -->
                            @if($roundOf32 && !$roundOf16)
                            <form
                                action="{{ $isOrganizer ? route('tournament.setting.generate-round-16', $tournament) : route('admin.tournaments.generate-round-16', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-primary btn-sm step-button" {{
                                    !$currentPlayoffCompleted ? 'disabled' : '' }}><i class="bi bi-diagram-2-fill"></i>
                                    TẠO VÒNG 1/16</button>
                            </form>
                            @endif

                            <!-- Step 5: Create Semi Finals -->
                            @if($quarterFinals && !$semiFinals)
                            <form
                                action="{{ $isOrganizer ? route('tournament.setting.generate-semifinals', $tournament) : route('admin.tournaments.generate-semifinals', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-info btn-sm step-button" {{
                                    !$currentPlayoffCompleted ? 'disabled' : '' }}><i class="bi bi-diagram-2-fill"></i>
                                    TẠO BÁN KẾT</button>
                            </form>
                            @endif

                            <!-- Step 6: Create Finals -->
                            @if($semiFinals && !$final)
                            <form
                                action="{{ $isOrganizer ? route('tournament.setting.generate-finals', $tournament) : route('admin.tournaments.generate-finals', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                <button type="submit" class="btn btn-dark btn-sm step-button" {{ !$stepFinalsCompleted
                                    ? 'disabled' : '' }}><i class="bi bi-trophy"></i> TẠO CHUNG KẾT & HẠNG 3</button>
                            </form>
                            @endif

                            <!-- Clear all playoffs -->
                            <form
                                action="{{ $isOrganizer ? route('tournament.setting.clear-playoffs', $tournament) : route('admin.tournaments.clear-playoffs', $tournament) }}"
                                method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-outline-danger btn-sm step-button"
                                    onclick="return confirm('Bạn có chắc muốn xóa TẤT CẢ các vòng đấu Play-off đã tạo? Hành động này không thể hoàn tác.')"><i
                                        class="bi bi-trash"></i> Xóa Play-off</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Groups & Pairs Tab -->
        @if(!$isReferee)
        <div class="tab-pane fade" id="groups-pairs" role="tabpanel" aria-labelledby="groups-pairs-tab">
            <!-- Group Management -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="bi bi-plus-circle"></i> Quản lý Bảng đấu thủ công</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex flex-wrap gap-3">
                        <!-- Form thêm bảng đấu -->
                        <div class="card bg-light" style="min-width:250px;">
                            <div class="card-body">
                                <h6 class="card-title text-primary fw-bold">Thêm Bảng Mới</h6>
                                <form
                                    action="{{ $isOrganizer ? route('tournament.setting.groups.add', $tournament) : route('admin.groups.store', $tournament) }}"
                                    method="POST">
                                    @csrf
                                    <div class="mb-2">
                                        <input type="text" name="name" class="form-control form-control-sm"
                                            placeholder="Tên bảng (A, B, C...)" required>
                                    </div>
                                    <button type="submit" class="btn btn-primary btn-sm w-100">Thêm Bảng</button>
                                </form>
                            </div>
                        </div>
                        @foreach($tournament->groups as $group)
                        <div class="card border-secondary" style="min-width:250px;">
                            <div class="card-body">
                                <h5 class="card-title fw-bold">Bảng {{ $group->name }}</h5>
                                <div class="d-flex gap-2">
                                    @if($isOrganizer)
                                    <a href="{{ route('tournament.setting.groups.pairs.create', ['tournament' => $tournament->id, 'group' => $group->id]) }}"
                                        class="btn btn-success btn-sm flex-grow-1">Thêm Cặp</a>
                                    @else
                                    <a href="{{ route('admin.groups.pairs.create', $group) }}"
                                        class="btn btn-success btn-sm flex-grow-1">Thêm Cặp</a>
                                    @endif
                                    <form
                                        action="{{ $isOrganizer ? route('tournament.setting.groups.delete', ['group' => $group->id]) : route('admin.groups.destroy', [$tournament, $group]) }}"
                                        method="POST"
                                        onsubmit="return confirm('Bạn có chắc muốn xóa bảng này và tất cả các cặp đấu trong đó?');">
                                        @csrf @if(!$isOrganizer) @method('DELETE') @endif
                                        <button type="submit" class="btn btn-outline-danger btn-sm"><i
                                                class="bi bi-trash"></i></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>

            <!-- Pairs List -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="bi bi-person-lines-fill"></i> Danh sách Cặp đấu theo Bảng</h5>
                    @php
                    $pairsExportRoute = $isOrganizer
                    ? route('tournament.setting.export-pairs', ['tournament' => $tournament->id])
                    : route('admin.tournaments.export-pairs', $tournament);
                    @endphp
                    <div class="d-flex gap-2">
                        <button id="print-pairs-btn" type="button" class="btn btn-secondary btn-sm">
                            <i class="bi bi-printer"></i> In Danh sách
                        </button>
                        <a href="{{ $pairsExportRoute }}" class="btn btn-primary btn-sm">
                            <i class="bi bi-file-earmark-excel"></i> Xuất Danh sách
                        </a>
                    </div>
                </div>
                <div class="card-body" id="printable-pairs">
                    <div class="row">
                        @forelse($tournament->groups as $group)
                        <div class="col-md-6 col-lg-4 mb-3">
                            <div class="card h-100">
                                <div class="card-header bg-dark text-white">Bảng {{ $group->name }}</div>
                                <div class="list-group list-group-flush">
                                    @forelse($group->pairs as $pair)
                                    <div class="list-group-item d-flex justify-content-between align-items-center">
                                        <span class="small">{{ $pair->player1->name ?? 'N/A' }} & {{
                                            $pair->player2->name ?? 'N/A' }}</span>
                                        <div class="btn-group btn-group-sm">
                                            @if($isOrganizer)
                                            <!-- Organizer should be routed to tournament setting edit route -->
                                            <a href="{{ route('tournament.setting.groups.pairs.edit', ['tournament' => $tournament->id, 'group' => $group->id, 'pair' => $pair->id]) }}"
                                                class="btn btn-outline-primary"><i class="bi bi-pencil"></i></a>
                                            @else
                                            <a href="{{ route('admin.groups.pairs.edit', [$group, $pair]) }}"
                                                class="btn btn-outline-primary"><i class="bi bi-pencil"></i></a>
                                            @endif
                                            <form
                                                action="{{ $isOrganizer ? route('tournament.setting.pairs.delete', ['pair' => $pair->id]) : route('admin.groups.pairs.destroy', [$group, $pair]) }}"
                                                method="POST"
                                                onsubmit="return confirm('Bạn có chắc muốn xóa cặp đấu này?');">
                                                @csrf @if(!$isOrganizer) @method('DELETE') @endif
                                                <button type="submit" class="btn btn-outline-danger"><i
                                                        class="bi bi-trash"></i></button>
                                            </form>
                                        </div>
                                    </div>
                                    @empty
                                    <div class="list-group-item text-muted text-center small">Chưa có cặp đấu</div>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                        @empty
                        <div class="col-12">
                            <p class="text-muted text-center">Chưa có bảng đấu nào được tạo.</p>
                        </div>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
        @endif

        <!-- Schedule Tab -->
        <div class="tab-pane fade {{ $isReferee ? 'show active' : '' }}" id="schedule" role="tabpanel"
            aria-labelledby="schedule-tab">
            <!-- Hiển thị các trận đấu của vòng bảng -->
            @php
            $groupRounds = $tournament->rounds->where('type', 'round_robin');
            @endphp
            @php
            // Di chuyển định nghĩa hàm ra ngoài vòng lặp để tránh lỗi redeclare
            if (!function_exists('generateAvatar')) {
            function generateAvatar($player) {
            if (isset($player->avatar) && !empty($player->avatar)) {
            return '<img src="'.asset($player->avatar).'" alt="Avatar" class="avatar">';
            }
            $name = $player->name ?? '?';
            $initial = mb_strtoupper(mb_substr($name, 0, 1, 'UTF-8'));
            $bgColor = 'hsl('. (crc32($player->id ?? rand()) % 360) .', 50%, 50%)';
            return '<div class="avatar-placeholder" style="background-color: '.$bgColor.';">'.$initial.'</div>';
            }
            }
            @endphp
            @php
            $exportRoute = $isOrganizer
            ? route('tournament.setting.export-schedule', ['tournament' => $tournament->id])
            : route('admin.tournaments.export-schedule', $tournament->id);
            @endphp
            @php
            // Round-robin ordering using the circle method (Berger tables)
            if (!function_exists('computeRoundRobinOrder')) {
            /**
            * Return an array of rounds; each round is an array of [teamAId, teamBId]
            * Works for even or odd team counts (adds a BYE when odd).
            */
            function computeRoundRobinOrder(array $teamIds): array {
            $teams = array_values($teamIds);
            $rounds = [];
            // Add BYE placeholder (null) if odd
            if (count($teams) % 2 === 1) {
            $teams[] = null;
            }
            $n = count($teams);
            if ($n < 2) { return $rounds; } $half=intval($n / 2); $rotation=$teams; for ($r=0; $r < $n - 1; $r++) {
                $pairs=[]; for ($i=0; $i < $half; $i++) { $t1=$rotation[$i]; $t2=$rotation[$n - 1 - $i]; if ($t1 !==null
                && $t2 !==null) { $pairs[]=[$t1, $t2]; } } $rounds[]=$pairs;$last=array_pop($rotation);
                array_splice($rotation, 1, 0, [$last]); } return $rounds; } } @endphp <div
                class="d-flex justify-content-end mb-3 gap-2">
                <button id="print-schedule-btn" class="btn btn-secondary">
                    <i class="bi bi-printer"></i> In Lịch thi đấu
                </button>
                <a href="{{ $exportRoute }}" class="btn btn-primary">
                    <i class="bi bi-file-earmark-excel"></i> Xuất Lịch thi đấu
                </a>
        </div>

        <div id="printable-schedule">
            @if($tournament->groups->count() > 0)
            <h2 class="text-primary fw-bold mb-3 mt-5">Lịch thi đấu Vòng Bảng</h2>
            @foreach($tournament->groups as $group)
            @php
            // Lấy các trận đấu vòng bảng của bảng này
            $groupPairIds = $group->pairs->pluck('id');
            $groupMatches = collect();
            if($groupRounds->count() > 0) {
            $groupMatches = $groupRounds->flatMap(function($round) use ($groupPairIds) {
            return $round->matches->filter(function($match) use ($groupPairIds) {
            return $groupPairIds->contains($match->pair1_id) && $groupPairIds->contains($match->pair2_id);
            });
            });
            }
            // Tạo thứ tự hiển thị theo vòng (lượt) sử dụng thuật toán vòng tròn
            $pairIds = $group->pairs->pluck('id')->values()->all();
            $rounds = computeRoundRobinOrder($pairIds);
            // Map thực tế: key "min-max" -> match
            $matchIndex = [];
            foreach ($groupMatches as $m) {
            if ($m->pair1_id && $m->pair2_id) {
            $a = min($m->pair1_id, $m->pair2_id);
            $b = max($m->pair1_id, $m->pair2_id);
            $matchIndex[$a.'-'.$b] = $m;
            }
            }
            // Tạo danh sách trận theo thứ tự các lượt
            $orderedEntries = [];
            $seenMatchIds = [];
            foreach ($rounds as $roundIdx => $pairs) {
            foreach ($pairs as $p) {
            [$a, $b] = $p;
            $key = min($a, $b).'-'.max($a, $b);
            if (isset($matchIndex[$key])) {
            $match = $matchIndex[$key];
            $orderedEntries[] = ['round' => $roundIdx + 1, 'match' => $match];
            $seenMatchIds[$match->id] = true;
            }
            }
            }
            // Thêm các trận chưa có trong thứ tự (phòng trường hợp dữ liệu cũ)
            foreach ($groupMatches->sortBy('id') as $m) {
            if (!isset($seenMatchIds[$m->id])) {
            $orderedEntries[] = ['round' => null, 'match' => $m];
            }
            }
            @endphp
            @if($groupMatches->isNotEmpty())
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-primary text-white">
                    <h5><i class="bi bi-grid-3x3"></i> Bảng {{ $group->name }} - Vòng Bảng</h5>
                    <small class="text-light">{{ $groupMatches->count() }} trận đấu</small>
                </div>
                <div class="card-body">
                    @php $__prevRound = null; @endphp
                    @foreach($orderedEntries as $__entry)
                    @php $match = $__entry['match']; $__roundNo = $__entry['round']; @endphp
                    @if($__roundNo !== null && $__roundNo !== $__prevRound)
                    <div class="mt-2 mb-2">
                        <span class="badge bg-secondary">Lượt {{ $__roundNo }}</span>
                    </div>
                    @php $__prevRound = $__roundNo; @endphp
                    @endif
                    @php
                    // Check if this is a Bye match
                    $isByeMatch = $match->pair2_id === null && $match->status === 'Bye';
                    @endphp
                    <div class="match-card {{ $isByeMatch ? 'bye-match' : '' }}" data-round-type="round_robin">
                        <form class="score-update-form" data-match-id="{{ $match->id }}"
                            data-action-url="{{ $isOrganizer ? route('tournament.setting.matches.updateScore', ['match' => $match->id]) : route('admin.matches.updateScore', $match->id) }}"
                            id="form-match-{{$match->id}}">
                            <!-- Status dropdown: only one per match, responsive -->
                            <div class="match-status-selector">
                                @if($isByeMatch)
                                <select name="status" class="form-select form-select-sm score-input" disabled>
                                    <option value="Bye" selected>Bye - Hoàn thành</option>
                                </select>
                                <input type="hidden" name="status" value="Bye">
                                @else
                                <select name="status" class="form-select form-select-sm score-input">
                                    <option value="Chưa bắt đầu" {{ $match->status == 'Chưa bắt đầu' ? 'selected' :
                                        '' }}>Chưa bắt đầu</option>
                                    <option value="Đang diễn ra" {{ $match->status == 'Đang diễn ra' ? 'selected' :
                                        '' }}>Đang diễn ra</option>
                                    <option value="Hoàn thành" {{ $match->status == 'Hoàn thành' ? 'selected' : ''
                                        }}>Hoàn thành</option>
                                    <option value="Tạm hoãn" {{ $match->status == 'Tạm hoãn' ? 'selected' : ''
                                        }}>Tạm hoãn</option>
                                    <option value="Bị hủy" {{ $match->status == 'Bị hủy' ? 'selected' : '' }}>Bị hủy
                                    </option>
                                </select>
                                @endif
                            </div>
                            @csrf
                            @php
                            if ($isByeMatch) {
                            $scores = ['BYE', '-'];
                            } else {
                            if ($match->score && str_contains($match->score, '-')) {
                            $scoreParts = explode('-', $match->score);
                            $scores = count($scoreParts) === 2 ? $scoreParts : [0, 0];
                            } else {
                            $scores = [0, 0];
                            }
                            }
                            @endphp
                            <div class="row align-items-center g-2">
                                <!-- Team 1 Info -->
                                <div class="col-5">
                                    <div class="match-team-info">
                                        <div class="team-avatars">
                                            @if($match->pair1 && $match->pair1->player1) {!!
                                            generateAvatar($match->pair1->player1) !!} @endif
                                            @if($match->pair1 && $match->pair1->player2) {!!
                                            generateAvatar($match->pair1->player2) !!} @endif
                                        </div>
                                        <div class="team-name" data-pair-id="{{ $match->pair1_id }}">
                                            <span class="player-name"
                                                data-player-id="{{ $match->pair1->player1_id ?? '' }}">{{
                                                $match->pair1->player1->name ?? 'N/A' }}</span>
                                            <span class="player-number-tag p1">1</span>
                                            @if($match->pair1_id)
                                            <i class="bi bi-arrow-left-right swap-players-btn" title="Đổi vị trí VĐV"
                                                data-pair-id="{{ $match->pair1_id }}"
                                                data-url="{{ route('admin.pairs.swap', $match->pair1_id) }}"
                                                data-is-organizer="{{ $isOrganizer ? 'true' : 'false' }}"
                                                data-organizer-url="{{ route('tournament.setting.pairs.swap', $match->pair1_id) }}">
                                            </i>
                                            @endif
                                            <span class="player-name"
                                                data-player-id="{{ $match->pair1->player2_id ?? '' }}">{{
                                                $match->pair1->player2->name ?? 'N/A' }}</span>
                                            <span class="player-number-tag p2">2</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Score Control & Status -->
                                <div class="col-2">
                                    <!-- Desktop status dropdown now handled above, removed duplicate -->

                                    @if($isByeMatch)
                                    <!-- Bye Match Display -->
                                    <div class="d-flex justify-content-center align-items-center">
                                        <div class="badge bg-success fs-6 px-3 py-2">
                                            <i class="bi bi-fast-forward"></i> BYE
                                        </div>
                                    </div>
                                    @else
                                    <!-- Normal Match Score Controls -->
                                    <div class="d-flex justify-content-center align-items-center">
                                        <!-- Score 1 -->
                                        <div class="score-control-wrapper">
                                            <div class="score-control-buttons">
                                                <button type="button" class="btn btn-sm btn-outline-secondary score-btn"
                                                    data-action="increment"
                                                    data-target="score1-{{$match->id}}">+</button>
                                            </div>
                                            <input type="number" name="score1" id="score1-{{$match->id}}"
                                                class="form-control d-none score-input" value="{{ $scores[0] }}"
                                                required min="0">
                                            <div id="score1-{{$match->id}}-display" class="score-input-display">{{
                                                $scores[0] }}</div>
                                            <div class="score-control-buttons">
                                                <button type="button" class="btn btn-sm btn-outline-secondary score-btn"
                                                    data-action="decrement"
                                                    data-target="score1-{{$match->id}}">-</button>
                                            </div>
                                        </div>
                                        <span class="px-2 fs-4">-</span>
                                        <!-- Score 2 -->
                                        <div class="score-control-wrapper">
                                            <div class="score-control-buttons">
                                                <button type="button" class="btn btn-sm btn-outline-secondary score-btn"
                                                    data-action="increment"
                                                    data-target="score2-{{$match->id}}">+</button>
                                            </div>
                                            <input type="number" name="score2" id="score2-{{$match->id}}"
                                                class="form-control d-none score-input" value="{{ $scores[1] }}"
                                                required min="0">
                                            <div id="score2-{{$match->id}}-display" class="score-input-display">{{
                                                $scores[1] }}</div>
                                            <div class="score-control-buttons">
                                                <button type="button" class="btn btn-sm btn-outline-secondary score-btn"
                                                    data-action="decrement"
                                                    data-target="score2-{{$match->id}}">-</button>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                </div>

                                <!-- Team 2 Info -->
                                <div class="col-5">
                                    <div class="match-team-info">
                                        <div class="team-avatars">
                                            @if($match->pair2 && $match->pair2->player1) {!!
                                            generateAvatar($match->pair2->player1) !!} @endif
                                            @if($match->pair2 && $match->pair2->player2) {!!
                                            generateAvatar($match->pair2->player2) !!} @endif
                                        </div>
                                        <div class="team-name" data-pair-id="{{ $match->pair2_id }}">
                                            <span class="player-name"
                                                data-player-id="{{ $match->pair2->player1_id ?? '' }}">{{
                                                $match->pair2->player1->name ?? 'N/A' }}</span>
                                            <span class="player-number-tag p1">1</span>
                                            @if($match->pair2_id)
                                            <i class="bi bi-arrow-left-right swap-players-btn" title="Đổi vị trí VĐV"
                                                data-pair-id="{{ $match->pair2_id }}"
                                                data-url="{{ route('admin.pairs.swap', $match->pair2_id) }}"
                                                data-is-organizer="{{ $isOrganizer ? 'true' : 'false' }}"
                                                data-organizer-url="{{ route('tournament.setting.pairs.swap', $match->pair2_id) }}">
                                            </i>
                                            @endif
                                            <span class="player-name"
                                                data-player-id="{{ $match->pair2->player2_id ?? '' }}">{{
                                                $match->pair2->player2->name ?? 'N/A' }}</span>
                                            <span class="player-number-tag p2">2</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
            @endforeach
            @else
            <div class="alert alert-info text-center">
                <i class="bi bi-info-circle"></i> Chưa có bảng đấu nào được tạo. Vui lòng tạo bảng đấu và vòng đấu
                bảng trước.
            </div>
            @endif
        </div>

        <!-- Bảng xếp hạng -->
        @if(!empty($standingsByGroup) && $tournament->groups->count() > 0 && $tournament->rounds->where('type',
        'round_robin')->count() > 0)
        <h2 class="text-primary fw-bold mb-3 mt-5">Bảng xếp hạng Vòng Bảng</h2>
        <div class="d-flex justify-content-end mb-3 gap-2">
            <button id="print-standings-btn" class="btn btn-secondary">
                <i class="bi bi-printer"></i> In Bảng xếp hạng
            </button>
            <a href="{{ $isOrganizer ? route('tournament.setting.export-standings', ['tournament' => $tournament->id]) : route('admin.tournaments.export-standings', $tournament) }}"
                class="btn btn-primary">
                <i class="bi bi-file-earmark-excel"></i> Xuất Bảng xếp hạng
            </a>
        </div>
        <div id="printable-standings">
            <div class="row">
                @foreach($standingsByGroup as $groupName => $standings)
                <div class="col-lg-6 mb-4" wire:key="standings-group-{{ $groupName }}">
                    <div class="card">
                        <div class="card-header bg-dark text-white">
                            <h5>Bảng {{ $groupName }}</h5>
                        </div>
                        <div class="table-responsive standings-table-wrapper">
                            <table class="table table-hover standings-table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">Cặp đấu</th>
                                        <th scope="col" class="text-center">ST</th>
                                        <th scope="col" class="text-center">T</th>
                                        <th scope="col" class="text-center">B</th>
                                        <th scope="col" class="text-center">HS</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($standings as $index => $standing)
                                    @php
                                    $rowClass = '';
                                    $badge = null;
                                    if ($index === 0) { $rowClass = 'standing-top-1'; $badge = 'Nhất'; }
                                    elseif ($index === 1) { $rowClass = 'standing-top-2'; $badge = 'Nhì'; }
                                    elseif ($index === 2) { $rowClass = 'standing-top-3'; $badge = 'Ba'; }
                                    @endphp
                                    <tr class="{{ $rowClass }}">
                                        <th scope="row">{{ $index + 1 }}</th>
                                        <td>
                                            @if($tournament->type == 'doubles')
                                            {{ $standing['pair']->player1->name ?? 'N/A' }} & {{
                                            $standing['pair']->player2->name ?? 'N/A' }}
                                            @else
                                            {{ $standing['pair']->player1->name ?? 'N/A' }}
                                            @endif
                                            @if($badge === 'Nhất')
                                            <span class="standing-badge badge bg-success text-dark">{{
                                                $badge
                                                }}</span>
                                            @elseif($badge === 'Nhì')
                                            <span class="standing-badge badge bg-warning text-dark">{{
                                                $badge
                                                }}</span>
                                            @elseif($badge === 'Ba')
                                            <span class="standing-badge badge bg-danger text-dark">{{ $badge
                                                }}</span>
                                            @endif
                                        </td>
                                        <td class="text-center">{{ $standing['played'] }}</td>
                                        <td class="text-center fw-bold text-success">{{ $standing['wins'] }}
                                        </td>
                                        <td class="text-center">{{ $standing['losses'] }}</td>
                                        <td class="text-center fw-bold">{{ ($standing['points_for'] ?? 0) -
                                            ($standing['points_against'] ?? 0) }}</td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="6" class="text-center text-muted">Chưa có dữ liệu xếp
                                            hạng
                                            cho bảng này.</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>

    <!-- Play-offs Tab -->
    @if($tournament->rounds->where('type', 'playoff')->isNotEmpty())
    <div class="tab-pane fade" id="playoffs" role="tabpanel" aria-labelledby="playoffs-tab">
        @php
        $playoffRounds = $tournament->rounds->where('type', 'playoff')->sortBy('created_at');
        @endphp

        <div class="d-flex justify-content-end mb-3 gap-2">
            <button id="print-playoffs-btn" class="btn btn-secondary">
                <i class="bi bi-printer"></i> In Lịch thi đấu
            </button>
            <a href="{{ $exportRoute }}" class="btn btn-primary">
                <i class="bi bi-file-earmark-excel"></i> Xuất Lịch thi đấu
            </a>
        </div>

        <div id="printable-playoffs">
            @if($playoffRounds->count() > 0)
            <h2 class="text-primary fw-bold mb-3 mt-4">Lịch thi đấu Vòng Play-off</h2>
            @foreach($playoffRounds as $round)
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0">{{ $round->name }}</h5>
                </div>
                <div class="card-body">
                    @if($round->matches->isNotEmpty())
                    @foreach($round->matches->sortBy('id') as $match)
                    @php
                    // Check if this is a Bye match
                    $isByeMatch = $match->pair2_id === null && $match->status === 'Bye';
                    @endphp
                    <div class="match-card {{ $isByeMatch ? 'bye-match' : '' }}" data-round-type="{{ $round->type }}">
                        <form class="score-update-form" data-match-id="{{ $match->id }}"
                            data-action-url="{{ $isOrganizer ? route('tournament.setting.matches.updateScore', ['match' => $match->id]) : route('admin.matches.updateScore', $match->id) }}"
                            id="form-match-{{$match->id}}">
                            <div class="match-status-selector">
                                @if($isByeMatch)
                                <select name="status" class="form-select form-select-sm score-input" disabled>
                                    <option value="Bye" selected>Bye - Hoàn thành</option>
                                </select>
                                <input type="hidden" name="status" value="Bye">
                                @else
                                <select name="status" class="form-select form-select-sm score-input">
                                    <option value="Chưa bắt đầu" {{ $match->status == 'Chưa bắt đầu' ? 'selected' :
                                        '' }}>Chưa bắt đầu</option>
                                    <option value="Đang diễn ra" {{ $match->status == 'Đang diễn ra' ? 'selected' :
                                        '' }}>Đang diễn ra</option>
                                    <option value="Hoàn thành" {{ $match->status == 'Hoàn thành' ? 'selected' : ''
                                        }}>Hoàn thành</option>
                                    <option value="Tạm hoãn" {{ $match->status == 'Tạm hoãn' ? 'selected' : ''
                                        }}>Tạm hoãn</option>
                                    <option value="Bị hủy" {{ $match->status == 'Bị hủy' ? 'selected' : '' }}>Bị hủy
                                    </option>
                                </select>
                                @endif
                            </div>
                            @csrf
                            @php
                            if ($isByeMatch) {
                            $scores = ['BYE', '-'];
                            } else {
                            if ($match->score && str_contains($match->score, '-')) {
                            $scoreParts = explode('-', $match->score);
                            $scores = count($scoreParts) === 2 ? $scoreParts : [0, 0];
                            } else {
                            $scores = [0, 0];
                            }
                            }
                            @endphp
                            <div class="row align-items-center g-2">
                                <!-- Team 1 Info -->
                                <div class="col-5">
                                    <div class="match-team-info">
                                        <div class="team-avatars">
                                            @if($match->pair1 && $match->pair1->player1) {!!
                                            generateAvatar($match->pair1->player1) !!} @endif
                                            @if($match->pair1 && $match->pair1->player2) {!!
                                            generateAvatar($match->pair1->player2) !!} @endif
                                        </div>
                                        <div class="team-name" data-pair-id="{{ $match->pair1_id }}">
                                            <span class="player-name"
                                                data-player-id="{{ $match->pair1->player1_id ?? '' }}">{{
                                                $match->pair1->player1->name ?? 'N/A' }}</span>
                                            <span class="player-number-tag p1">1</span>
                                            @if($match->pair1_id)
                                            <i class="bi bi-arrow-left-right swap-players-btn" title="Đổi vị trí VĐV"
                                                data-pair-id="{{ $match->pair1_id }}"
                                                data-url="{{ route('admin.pairs.swap', $match->pair1_id) }}"
                                                data-is-organizer="{{ $isOrganizer ? 'true' : 'false' }}"
                                                data-organizer-url="{{ route('tournament.setting.pairs.swap', $match->pair1_id) }}">
                                            </i>
                                            @endif
                                            <span class="player-name"
                                                data-player-id="{{ $match->pair1->player2_id ?? '' }}">{{
                                                $match->pair1->player2->name ?? 'N/A' }}</span>
                                            <span class="player-number-tag p2">2</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Score Control & Status -->
                                <div class="col-2">
                                    @if($isByeMatch)
                                    <!-- Bye Match Display -->
                                    <div class="d-flex justify-content-center align-items-center">
                                        <div class="badge bg-success fs-6 px-3 py-2">
                                            <i class="bi bi-fast-forward"></i> BYE
                                        </div>
                                    </div>
                                    @else
                                    <!-- Normal Match Score Controls -->
                                    <div class="d-flex justify-content-center align-items-center">
                                        <!-- Score 1 -->
                                        <div class="score-control-wrapper">
                                            <div class="score-control-buttons">
                                                <button type="button" class="btn btn-sm btn-outline-secondary score-btn"
                                                    data-action="increment"
                                                    data-target="score1-{{$match->id}}">+</button>
                                            </div>
                                            <input type="number" name="score1" id="score1-{{$match->id}}"
                                                class="form-control d-none score-input" value="{{ $scores[0] }}"
                                                required min="0">
                                            <div id="score1-{{$match->id}}-display" class="score-input-display">{{
                                                $scores[0] }}</div>
                                            <div class="score-control-buttons">
                                                <button type="button" class="btn btn-sm btn-outline-secondary score-btn"
                                                    data-action="decrement"
                                                    data-target="score1-{{$match->id}}">-</button>
                                            </div>
                                        </div>
                                        <span class="px-2 fs-4">-</span>
                                        <!-- Score 2 -->
                                        <div class="score-control-wrapper">
                                            <div class="score-control-buttons">
                                                <button type="button" class="btn btn-sm btn-outline-secondary score-btn"
                                                    data-action="increment"
                                                    data-target="score2-{{$match->id}}">+</button>
                                            </div>
                                            <input type="number" name="score2" id="score2-{{$match->id}}"
                                                class="form-control d-none score-input" value="{{ $scores[1] }}"
                                                required min="0">
                                            <div id="score2-{{$match->id}}-display" class="score-input-display">{{
                                                $scores[1] }}</div>
                                            <div class="score-control-buttons">
                                                <button type="button" class="btn btn-sm btn-outline-secondary score-btn"
                                                    data-action="decrement"
                                                    data-target="score2-{{$match->id}}">-</button>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                </div>

                                <!-- Team 2 Info -->
                                <div class="col-5">
                                    @if($isByeMatch)
                                    <!-- Bye Team Display -->
                                    <div class="match-team-info bye-team">
                                        <div class="team-avatars">
                                            <div class="avatar bg-light border rounded-circle d-flex align-items-center justify-content-center"
                                                style="width: 40px; height: 40px;">
                                                <i class="bi bi-fast-forward text-success"></i>
                                            </div>
                                        </div>
                                        <div class="team-name">
                                            <span class="text-success fw-bold">Bye - Vòng tiếp theo</span>
                                        </div>
                                    </div>
                                    @else
                                    <!-- Normal Team 2 Display -->
                                    <div class="match-team-info">
                                        <div class="team-avatars">
                                            @if($match->pair2 && $match->pair2->player1) {!!
                                            generateAvatar($match->pair2->player1) !!} @endif
                                            @if($match->pair2 && $match->pair2->player2) {!!
                                            generateAvatar($match->pair2->player2) !!} @endif
                                        </div>
                                        <div class="team-name" data-pair-id="{{ $match->pair2_id }}">
                                            <span class="player-name"
                                                data-player-id="{{ $match->pair2->player1_id ?? '' }}">{{
                                                $match->pair2->player1->name ?? 'N/A' }}</span>
                                            <span class="player-number-tag p1">1</span>
                                            @if($match->pair2_id)
                                            <i class="bi bi-arrow-left-right swap-players-btn" title="Đổi vị trí VĐV"
                                                data-pair-id="{{ $match->pair2_id }}"
                                                data-url="{{ route('admin.pairs.swap', $match->pair2_id) }}"
                                                data-is-organizer="{{ $isOrganizer ? 'true' : 'false' }}"
                                                data-organizer-url="{{ route('tournament.setting.pairs.swap', $match->pair2_id) }}">
                                            </i>
                                            @endif
                                            <span class="player-name"
                                                data-player-id="{{ $match->pair2->player2_id ?? '' }}">{{
                                                $match->pair2->player2->name ?? 'N/A' }}</span>
                                            <span class="player-number-tag p2">2</span>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </form>
                    </div>
                    @endforeach
                    @else
                    <p class="text-center text-muted">Chưa có trận đấu nào trong vòng này.</p>
                    @endif
                </div>
            </div>
            @endforeach
            @endif
        </div>
    </div>
    @endif

    <!-- Bracket Tab -->
    @if(!empty($roundOf16) || !empty($quarterFinals) || !empty($semiFinals) || !empty($final))
    <div class="tab-pane fade" id="bracket" role="tabpanel" aria-labelledby="bracket-tab">
        <button id="print-bracket-btn" class="btn btn-secondary mb-3"><i class="bi bi-printer-fill"></i> In
            Nhánh
            Đấu</button>
        <style>
            /* Bracket Styles */
            .bracket {
                display: flex;
                /* Changed to grid for better alignment on larger screens */
                justify-content: center;
                background: var(--secondary-bg);
                /* Darker background */
                padding: 20px;
                border-radius: 8px;
                border: 1px solid var(--border-color);
            }

            .bracket-round {
                display: flex;
                flex-direction: column;
                justify-content: space-around;
                flex: 1;
                flex-grow: 1;
            }

            .bracket-match {
                display: flex;
                flex-direction: column;
                justify-content: center;
                margin: 20px 10px;
                position: relative;
            }

            .bracket-pair {
                background: var(--card-bg);
                color: var(--text-primary);
                padding: 10px;
                margin: 5px 0;
                border-radius: 5px;
                display: flex;
                justify-content: space-between;
                align-items: center;
                border: 1px solid var(--border-color);
                border-left: 5px solid var(--text-muted);
                /* Default border */
                transition: all 0.3s ease;
                box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);
                min-width: 220px;
            }

            .bracket-pair:hover {
                transform: scale(1.02);
                box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            }

            .bracket-pair.winner {
                border-left-color: var(--success);
                /* Green for winner */
                font-weight: bold;
                background: rgba(34, 197, 94, 0.1);
                /* Light green background for winner */
            }

            .bracket-pair .score {
                font-weight: bold;
                color: var(--warning);
            }

            .bracket-connector {
                width: 20px;
                position: absolute;
                right: -21px;
                top: 50%;
                height: 2px;
                background-color: var(--border-color);
            }

            .bracket-line {
                width: 2px;
                background-color: var(--border-color);
                position: absolute;
                left: 50%;
                transform: translateX(-50%);
            }

            .bracket-match-group {
                position: relative;
                display: flex;
                flex-direction: column;
                justify-content: space-around;
                flex-grow: 1;
            }

            .bracket-match-group .bracket-line {
                height: calc(100% - 60px);
                /* Adjust based on pair height */
                top: 30px;
            }

            .final-rounds-container {
                display: flex;
                flex-wrap: wrap;
                justify-content: center;
                gap: 2rem;
                margin-top: 2rem;
            }

            .final-match {
                background: var(--card-bg);
                border: 1px solid var(--border-color);
                padding: 20px;
                border-radius: 8px;
                min-width: 300px;
                display: flex;
                flex-direction: column;
                align-items: center;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
                color: var(--text-primary);
            }

            .final-match .bracket-pair {
                width: 100%;
            }

            /* Table styling for dark theme */
            .table {
                background: var(--card-bg) !important;
                color: var(--text-primary) !important;
            }

            .table th,
            .table td {
                background: transparent !important;
                border-color: var(--border-color) !important;
                color: var(--text-primary) !important;
            }

            .table-striped>tbody>tr:nth-of-type(odd)>td {
                background: rgba(255, 255, 255, 0.02) !important;
            }

            .table-hover>tbody>tr:hover>td {
                background: rgba(255, 255, 255, 0.05) !important;
            }

            .table-light {
                background: var(--secondary-bg) !important;
                color: var(--text-primary) !important;
            }

            /* Alert styling */
            .alert {
                background: var(--card-bg) !important;
                border-color: var(--border-color) !important;
                color: var(--text-primary) !important;
            }

            .alert-info {
                background: rgba(59, 130, 246, 0.1) !important;
                border-color: var(--accent-primary) !important;
                color: var(--text-primary) !important;
            }

            /* List group styling */
            .list-group-item {
                background: var(--card-bg) !important;
                border-color: var(--border-color) !important;
                color: var(--text-primary) !important;
            }

            .list-group-item a {
                color: var(--accent-primary) !important;
                text-decoration: none;
            }

            .list-group-item a:hover {
                color: var(--accent-secondary) !important;
            }

            /* Nav tabs styling */
            .nav-tabs {
                border-bottom-color: var(--border-color) !important;
            }

            .nav-tabs .nav-link {
                background: var(--card-bg) !important;
                border-color: var(--border-color) !important;
                color: var(--text-muted) !important;
            }

            .nav-tabs .nav-link.active {
                background: var(--secondary-bg) !important;
                border-color: var(--border-color) var(--border-color) var(--secondary-bg) !important;
                color: var(--text-primary) !important;
            }

            .nav-tabs .nav-link:hover {
                color: var(--accent-primary) !important;
            }

            /* Button styling */
            .btn-primary {
                background: linear-gradient(135deg, var(--accent-primary), var(--accent-secondary)) !important;
                border-color: var(--accent-primary) !important;
                color: var(--text-primary) !important;
            }

            .btn-outline-primary {
                border-color: var(--accent-primary) !important;
                color: var(--accent-primary) !important;
            }

            .btn-outline-primary:hover {
                background: var(--accent-primary) !important;
                border-color: var(--accent-primary) !important;
                color: var(--text-primary) !important;
            }

            .btn-secondary {
                background: var(--secondary-bg) !important;
                border-color: var(--border-color) !important;
                color: var(--text-primary) !important;
            }

            .btn-info {
                background: linear-gradient(135deg, #0ea5e9, #0284c7) !important;
                border-color: #0ea5e9 !important;
                color: var(--text-primary) !important;
            }

            /* --- Mobile Responsive Bracket --- */
            @media (max-width: 767.98px) {
                .bracket {
                    flex-direction: column;
                    align-items: stretch;
                }

                .bracket-round {
                    flex-direction: column;
                    width: 100%;
                }

                .bracket-match {
                    margin: 0;
                    padding: 15px 0;
                    border-bottom: 2px dashed #e1e5eb;
                }

                .bracket-match:last-child {
                    border-bottom: none;
                    padding-bottom: 0;
                    margin-bottom: 0;
                }

                .bracket-connector,
                .bracket-line {
                    display: none;
                    /* Hide connectors on mobile */
                }

                .bracket-round+.bracket-round {
                    margin-top: 2rem;
                    padding-top: 2rem;
                    border-top: 2px solid #0d6efd;
                }
            }

            @media print {
                body * {
                    visibility: hidden;
                }

                #printable-bracket,
                #printable-bracket * {
                    visibility: visible;
                }

                #printable-bracket {
                    position: absolute;
                    left: 0;
                    top: 0;
                    width: 100%;
                }

                .bracket {
                    background-color: #ffffff !important;
                }

                .bracket-pair {
                    background: #fff !important;
                    color: #000 !important;
                    border: 1px solid #ccc !important;
                }

                .bracket-pair.winner {
                    border-left-color: #000 !important;
                    /* Make winner border more prominent */
                    font-weight: bold;
                    background-color: #e0e0e0 !important;
                }

                .bracket-pair .score {
                    color: #000 !important;
                }

                .bracket-line {
                    border-color: #666 !important;
                }

                h4 {
                    color: #000 !important;
                    /* Black for printing */
                }

                .bracket-connector,
                .bracket-line {
                    visibility: hidden;
                    /* Hide connectors for cleaner print */
                }
            }
        </style>
        @include('tournaments.partials.bracket_view', [
        'roundOf16' => $roundOf16,
        'quarterFinals' => $quarterFinals,
        'semiFinals' => $semiFinals,
        'final' => $final,
        'thirdPlace' => $thirdPlace
        ])
    </div>
    @endif
</div> <!-- End Tab Content -->
</div>
@endsection

@push('layout_script')
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Tự động chuyển tab sau khi thực hiện STEP 3 (Tạo Play-off)
        const playoffsForm = document.getElementById('generate-playoffs-form');
        if (playoffsForm) {
            playoffsForm.addEventListener('submit', function(e) {
                sessionStorage.setItem('showPlayoffsTab', 'true');
            });
        }


        const approvedRegistrationsCount = {{ $tournament->approved_registrations_count }};
        const step1Form = document.getElementById('step1-form');
        if (step1Form) {
            step1Form.addEventListener('submit', function(e) {
                const numberOfGroups = parseInt(document.getElementById('number_of_groups').value, 10);
                if (approvedRegistrationsCount < numberOfGroups) {
                    e.preventDefault(); // Ngăn form gửi đi
                    Swal.fire({
                        icon: 'error',
                        title: 'Không thể thực hiện!',
                        text: `Số lượng cặp đấu đã duyệt (${approvedRegistrationsCount}) phải lớn hơn hoặc bằng số bảng muốn chia (${numberOfGroups}).`,
                    });
                }
            });
        }

        // Tự động chuyển tab sau khi thực hiện STEP 3
        const step2Form = document.getElementById('step2-form');
        if (step2Form) {
            step2Form.addEventListener('submit', function(e) {
                // Chỉ lưu nếu nút không bị vô hiệu hóa
                if (!document.getElementById('step2-button').disabled) {
                    sessionStorage.setItem('showScheduleTab', 'true');
                }
            });
        }

        const printBtn = document.getElementById('print-bracket-btn');
        if (printBtn) {
            printBtn.addEventListener('click', function () {
                const bracketContainer = document.getElementById('printable-bracket');
                const originalContents = document.body.innerHTML;
                const printContents = bracketContainer.innerHTML;

                // Tạo một div tạm thời để in
                let printableDiv = document.createElement('div');
                printableDiv.id = 'temp-printable-div';
                printableDiv.innerHTML = printContents;
                document.body.appendChild(printableDiv);
                
                window.print();

                document.body.removeChild(printableDiv);
            });
        }

        // Print Schedule/Playoffs
        function handlePrint(buttonId, contentId) {
            const printBtn = document.getElementById(buttonId);
            if (printBtn) {
                printBtn.addEventListener('click', function () {
                    const contentToPrint = document.getElementById(contentId);
                    if (contentToPrint) {
                        const originalContents = document.body.innerHTML;
                        const printContents = contentToPrint.innerHTML;

                        // Extra CSS for specific sections
                        let extraCss = '';
                        if (contentId === 'printable-pairs') {
                            // Hide action buttons and icons within pairs list
                            extraCss = `
                                #temp-printable-div .btn-group,
                                #temp-printable-div .btn,
                                #temp-printable-div i.bi { display: none !important; }
                            `;
                        }

                        // Create a temporary div to hold the printable content
                        let printableDiv = document.createElement('div');
                        printableDiv.id = 'temp-printable-div';
                        printableDiv.innerHTML = `
                            <style>
                                @media print {
                                    body * { visibility: hidden; }
                                    #temp-printable-div, #temp-printable-div * { visibility: visible; }
                                    #temp-printable-div { position: absolute; left: 0; top: 0; width: 100%; }
                                    .match-status-selector, .score-control-buttons, .swap-players-btn { display: none !important; }
                                    ${extraCss}
                                }
                            </style>
                            ${printContents}`;
                        document.body.appendChild(printableDiv);
                        window.print();
                        document.body.removeChild(printableDiv);
                    }
                });
            }
        }

        // Xử lý nút tăng/giảm điểm
        document.querySelectorAll('.score-btn').forEach(button => {
            button.addEventListener('click', function() {
                const action = this.dataset.action;
                const targetId = this.dataset.target;
                const targetInput = document.getElementById(targetId);
                const targetDisplay = document.getElementById(targetId + '-display');
                let currentValue = parseInt(targetInput.value, 10) || 0;

                if (action === 'increment') {
                    currentValue++;
                } else if (action === 'decrement' && currentValue > 0) {
                    currentValue--;
                }

                targetInput.value = currentValue;
                targetDisplay.textContent = currentValue;
                
                // Kích hoạt sự kiện change để lưu tự động
                targetInput.dispatchEvent(new Event('change', { bubbles: true }));
            });
        });

        // --- Auto-save score logic ---
        let saveTimeout;

        function scheduleSave(formElement) {
            // Defensive: if we don't have a form element, nothing to save
            if (!formElement) return;

            clearTimeout(saveTimeout); // Hủy bỏ lưu tự động trước đó nếu có

            saveTimeout = setTimeout(() => {
                // Prefer dataset.actionUrl, fall back to data-action-url attribute
                const url = formElement.dataset && formElement.dataset.actionUrl ? formElement.dataset.actionUrl : formElement.getAttribute('data-action-url');
                if (!url) {
                    console.error('No action URL found on form to save score.');
                    return;
                }

                const formData = new FormData(formElement);
                const data = Object.fromEntries(formData.entries());

                fetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                        'Accept': 'application/json',
                    },
                    body: JSON.stringify(data)
                })
                .then(response => response.json())
                .then(result => {
                    if (!result.success) {
                        console.error('Lỗi khi lưu điểm:', result.message);
                        Swal.fire({ icon: 'error', title: 'Lỗi', text: result.message || 'Không thể cập nhật điểm số.' });
                        return;
                    }

                    // Nếu server trả về success, chỉ reload bảng xếp hạng khi trận được đánh dấu 'Hoàn thành'
                    // Kiểm tra data gửi đi có field 'status' và giá trị là 'Hoàn thành'
                    const submittedStatus = data.status || null;
                    const roundType = formElement.closest('.match-card').dataset.roundType;

                    if (submittedStatus === 'Hoàn thành') {
                        if (roundType === 'playoff') {
                            sessionStorage.setItem('showPlayoffsTab', 'true');
                        } else {
                            sessionStorage.setItem('showScheduleTab', 'true');
                        }
                        location.reload();
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    Swal.fire({ icon: 'error', title: 'Lỗi Mạng', text: 'Có lỗi xảy ra khi kết nối đến máy chủ.' });
                });
            }, 800); // Đợi 800ms sau lần thay đổi cuối cùng rồi mới lưu
        }

        // Hàm kiểm tra và enable các button playoff theo thứ tự: Quarter Finals → Semi Finals → Finals
        function checkAndEnablePlayoffButtons() {
            // Check for Quarter Finals button (Step 4: TẠO TỨ KẾT)
            const quarterButton = Array.from(document.querySelectorAll('button')).find(btn => 
                btn.textContent.includes('STEP 4: TẠO TỨ KẾT')
            );
            
            if (quarterButton) {
                // Check if Round of 16 is completed
                const roundOf16Cards = Array.from(document.querySelectorAll('#playoffs .card-header')).filter(header => 
                    header.textContent.includes('Vòng 1/16') && !header.textContent.includes('Tứ kết')
                );
                
                if (roundOf16Cards.length > 0) {
                    let allRoundOf16Completed = true;
                    roundOf16Cards.forEach(header => {
                        const card = header.closest('.card');
                        const statusSelects = card.querySelectorAll('.match-status-selector .form-select');
                        statusSelects.forEach(select => {
                            if (select.value !== 'Hoàn thành') {
                                allRoundOf16Completed = false;
                            }
                        });
                    });
                    
                    quarterButton.disabled = !allRoundOf16Completed;
                }
            }

            // Check for Semi Finals button (Step 4 or 5: TẠO BÁN KẾT)
            const semiButton = Array.from(document.querySelectorAll('button')).find(btn => 
                btn.textContent.includes('TẠO BÁN KẾT')
            );
            
            if (semiButton) {
                // Check if Quarter Finals exist and are completed
                const quarterFinalsCards = Array.from(document.querySelectorAll('#playoffs .card-header')).filter(header => 
                    header.textContent.includes('Tứ kết')
                );
                
                if (quarterFinalsCards.length > 0) {
                    let allQuarterFinalsCompleted = true;
                    quarterFinalsCards.forEach(header => {
                        const card = header.closest('.card');
                        const statusSelects = card.querySelectorAll('.match-status-selector .form-select');
                        statusSelects.forEach(select => {
                            if (select.value !== 'Hoàn thành') {
                                allQuarterFinalsCompleted = false;
                            }
                        });
                    });
                    
                    semiButton.disabled = !allQuarterFinalsCompleted;
                } else {
                    // No quarter finals exist, check if there are any other prior playoff rounds completed
                    const roundOf16Cards = Array.from(document.querySelectorAll('#playoffs .card-header')).filter(header => 
                        header.textContent.includes('Vòng 1/16')
                    );
                    
                    if (roundOf16Cards.length > 0) {
                        let allRoundOf16Completed = true;
                        roundOf16Cards.forEach(header => {
                            const card = header.closest('.card');
                            const statusSelects = card.querySelectorAll('.match-status-selector .form-select');
                            statusSelects.forEach(select => {
                                if (select.value !== 'Hoàn thành') {
                                    allRoundOf16Completed = false;
                                }
                            });
                        });
                        
                        semiButton.disabled = !allRoundOf16Completed;
                    }
                }
            }
            
            // Check for Finals button (Step 5 or 6: TẠO CHUNG KẾT)
            const finalsButton = Array.from(document.querySelectorAll('button')).find(btn => 
                btn.textContent.includes('TẠO CHUNG KẾT')
            );
            
            if (finalsButton) {
                const semifinalsCards = Array.from(document.querySelectorAll('#playoffs .card-header')).filter(header => 
                    header.textContent.includes('Bán kết')
                );
                
                if (semifinalsCards.length > 0) {
                    let allSemifinalsCompleted = true;
                    semifinalsCards.forEach(header => {
                        const card = header.closest('.card');
                        const statusSelects = card.querySelectorAll('.match-status-selector .form-select');
                        statusSelects.forEach(select => {
                            if (select.value !== 'Hoàn thành') {
                                allSemifinalsCompleted = false;
                            }
                        });
                    });
                    
                    finalsButton.disabled = !allSemifinalsCompleted;
                }
            }
        }

        // Hàm kiểm tra và bật nút Step 3 nếu tất cả các trận vòng bảng đã hoàn thành
        function checkAndEnableStep3() {
            const step3Button = document.getElementById('step3-button');
            if (!step3Button) return;

            // Lấy tất cả các dropdown trạng thái của các trận đấu vòng bảng
            const groupMatchStatusSelects = document.querySelectorAll('#schedule .match-card .match-status-selector .form-select');
            
            if (groupMatchStatusSelects.length === 0) return; // Không có trận vòng bảng

            let allCompleted = true;
            groupMatchStatusSelects.forEach(select => {
                if (select.value !== 'Hoàn thành') {
                    allCompleted = false;
                }
            });
            step3Button.disabled = !allCompleted;
        }

        // Helper to find the related form for an element.
        const getAssociatedForm = (el) => el.closest('form');

        // Autosave for all score inputs and status dropdowns (mobile & desktop)
        document.querySelectorAll('.score-input').forEach(element => {
            element.addEventListener('change', (e) => {
                const form = getAssociatedForm(e.target);
                if (form) {
                    scheduleSave(form);
                }
                checkAndEnableStep3();
                checkAndEnablePlayoffButtons();
                // Nếu chọn Hoàn thành thì chuyển sang tab Lịch Thi Đấu
                if (e.target.name === 'status' && e.target.value === 'Hoàn thành') {
                    const scheduleTab = document.getElementById('schedule-tab');
                    if (scheduleTab) {
                        new bootstrap.Tab(scheduleTab).show();
                    }
                }
            });
        });

        checkAndEnableStep3(); // Kiểm tra lần đầu khi tải trang
        checkAndEnablePlayoffButtons(); // Kiểm tra playoff buttons lần đầu

        // Check if user is referee
        const isReferee = {{ $isReferee ? 'true' : 'false' }};

        // First prefer server-side open_tab flash (set by controller on success)
        const serverOpenTab = {!! json_encode(session('open_tab')) !!};
        if (serverOpenTab) {
            const tabBtn = document.getElementById(serverOpenTab + '-tab');
            if (tabBtn) {
                new bootstrap.Tab(tabBtn).show();
            }
        } else {
            // Check sessionStorage flags first (for both referee and organizer)
            if (sessionStorage.getItem('showScheduleTab') === 'true') {
                const scheduleTab = document.getElementById('schedule-tab');
                if (scheduleTab) {
                    new bootstrap.Tab(scheduleTab).show();
                    sessionStorage.removeItem('showScheduleTab');
                }
            } else if (sessionStorage.getItem('showPlayoffsTab') === 'true') {
                const playoffsTab = document.getElementById('playoffs-tab');
                if (playoffsTab) {
                    new bootstrap.Tab(playoffsTab).show();
                    sessionStorage.removeItem('showPlayoffsTab');
                }
            } else if (isReferee) {
                // For referee, default to schedule tab only if no specific tab is requested
                const scheduleTab = document.getElementById('schedule-tab');
                if (scheduleTab) {
                    new bootstrap.Tab(scheduleTab).show();
                }
            }
        }

        // Swap players logic
        document.querySelectorAll('.swap-players-btn').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const pairId = this.dataset.pairId;
                const isOrganizer = this.dataset.isOrganizer === 'true';
                const url = isOrganizer ? this.dataset.organizerUrl : this.dataset.url;

                Swal.fire({
                    title: 'Bạn có chắc muốn đổi vị trí 2 VĐV?',
                    text: "Hành động này sẽ hoán đổi VĐV 1 và VĐV 2 trong cặp đấu này.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Đồng ý!',
                    cancelButtonText: 'Hủy'
                }).then((result) => {
                    if (result.isConfirmed) {
                        fetch(url, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                                'Accept': 'application/json',
                            },
                            body: JSON.stringify({ pair_id: pairId })
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                // Swal.fire('Thành công!', 'Đã hoán đổi vị trí VĐV.', 'success');
                                // Update UI without reloading
                                const teamNameDivs = document.querySelectorAll(`.team-name[data-pair-id="${pairId}"]`);
                                teamNameDivs.forEach(div => {
                                    const playerSpans = div.querySelectorAll('.player-name');
                                    if (playerSpans.length === 2) {
                                        // Swap the text content of the two player name spans
                                        const temp = playerSpans[0].textContent;
                                        playerSpans[0].textContent = playerSpans[1].textContent;
                                        playerSpans[1].textContent = temp;

                                        // Also swap player-id data attributes
                                        const tempId = playerSpans[0].getAttribute('data-player-id');
                                        playerSpans[0].setAttribute('data-player-id', playerSpans[1].getAttribute('data-player-id'));
                                        playerSpans[1].setAttribute('data-player-id', tempId);
                                    }
                                });

                                // Update avatars if pair data is available
                                if (data.pair && data.pair.player1 && data.pair.player2) {
                                    const teamAvatarDivs = document.querySelectorAll(`.team-avatars`);
                                    teamAvatarDivs.forEach(avatarDiv => {
                                        // Check if this avatar div is for the swapped pair by looking at nearby team-name div
                                        const teamNameDiv = avatarDiv.parentElement.querySelector(`.team-name[data-pair-id="${pairId}"]`);
                                        if (teamNameDiv) {
                                            const avatarElements = avatarDiv.children;
                                            if (avatarElements.length >= 2) {
                                                // Update avatar for player 1
                                                if (data.pair.player1.avatar) {
                                                    avatarElements[0].outerHTML = `<img src="${window.location.origin}/${data.pair.player1.avatar}" alt="Avatar" class="avatar">`;
                                                } else {
                                                    const initial = data.pair.player1.name.charAt(0).toUpperCase();
                                                    const colors = ['#3498db', '#e74c3c', '#2ecc71', '#f39c12', '#9b59b6', '#1abc9c', '#e67e22', '#34495e'];
                                                    const bgColor = colors[data.pair.player1.id % colors.length];
                                                    avatarElements[0].outerHTML = `<div class="avatar-placeholder" style="background-color: ${bgColor};">${initial}</div>`;
                                                }

                                                // Update avatar for player 2
                                                if (data.pair.player2.avatar) {
                                                    avatarElements[1].outerHTML = `<img src="${window.location.origin}/${data.pair.player2.avatar}" alt="Avatar" class="avatar">`;
                                                } else {
                                                    const initial = data.pair.player2.name.charAt(0).toUpperCase();
                                                    const colors = ['#3498db', '#e74c3c', '#2ecc71', '#f39c12', '#9b59b6', '#1abc9c', '#e67e22', '#34495e'];
                                                    const bgColor = colors[data.pair.player2.id % colors.length];
                                                    avatarElements[1].outerHTML = `<div class="avatar-placeholder" style="background-color: ${bgColor};">${initial}</div>`;
                                                }
                                            }
                                        }
                                    });
                                }
                            } else {
                                Swal.fire('Lỗi!', data.message || 'Không thể hoán đổi.', 'error');
                            }
                        }).catch(() => Swal.fire('Lỗi!', 'Có lỗi xảy ra, vui lòng thử lại.', 'error'));
                    }
                });
            });
        });

        handlePrint('print-schedule-btn', 'printable-schedule');
        handlePrint('print-playoffs-btn', 'printable-playoffs');
        handlePrint('print-standings-btn', 'printable-standings');
        handlePrint('print-bracket-btn', 'printable-bracket');
        handlePrint('print-pairs-btn', 'printable-pairs');
    });
</script>
{{-- <script>
    // Show server-side flash messages (success, error, info) using Swal if available
        (function() {
            var flashSuccess = {!! json_encode(session('success')) !!};
            var flashError = {!! json_encode(session('error')) !!};
            var flashInfo = {!! json_encode(session('info')) !!};

            function showMsg(type, msg) {
                if (!msg) return;
                if (typeof Swal !== 'undefined') {
                    Swal.fire({ icon: type, title: msg, toast: true, position: 'top-end', showConfirmButton: false, timer: 3500 });
                } else {
                    alert(msg);
                }
            }

            if (flashSuccess) showMsg('success', flashSuccess);
            if (flashError) showMsg('error', flashError);
            if (flashInfo) showMsg('info', flashInfo);
        })();
</script> --}}
@endpush