@extends('layouts.app')

@section('title', 'Activity Log - ' . $tournament->name)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.tournaments.index') }}">Tournaments</a>
                        </li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.tournaments.show', $tournament) }}">{{
                                $tournament->name }}</a></li>
                    </ol>
                </div>
                <h4 class="page-title">Activity Log</h4>
            </div>
        </div>
    </div>

    <!-- Filter Card -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Bộ lọc</h4>
                </div>
                <div class="card-body">
                    @php
                    // Determine the correct route for this context (admin or organizer)
                    $activityLogRoute = request()->routeIs('admin.*')
                    ? route('admin.tournaments.activity-log', $tournament)
                    : route('tournament.setting.activity-log', $tournament->id);
                    @endphp
                    <form method="GET" action="{{ $activityLogRoute }}">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="event" class="form-label">Sự kiện</label>
                                    <select class="form-control" id="event" name="event">
                                        <option value="">Tất cả</option>
                                        <option value="Tạo bảng đấu" {{ request('event')==='Tạo bảng đấu' ? 'selected'
                                            : '' }}>Tạo bảng đấu</option>
                                        <option value="Tạo vòng bảng" {{ request('event')==='Tạo vòng bảng' ? 'selected'
                                            : '' }}>Tạo vòng bảng</option>
                                        <option value="Tạo playoffs" {{ request('event')==='Tạo playoffs' ? 'selected'
                                            : '' }}>Tạo playoffs</option>
                                        <option value="Cập nhật kết quả" {{ request('event')==='Cập nhật kết quả'
                                            ? 'selected' : '' }}>Cập nhật kết quả</option>
                                        <option value="Duyệt đăng ký" {{ request('event')==='Duyệt đăng ký' ? 'selected'
                                            : '' }}>Duyệt đăng ký</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="causer" class="form-label">Người thực hiện</label>
                                    <input type="text" class="form-control" id="causer" name="causer"
                                        value="{{ request('causer') }}" placeholder="Tên người dùng...">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="date_from" class="form-label">Từ ngày</label>
                                    <input type="date" class="form-control" id="date_from" name="date_from"
                                        value="{{ request('date_from') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label for="date_to" class="form-label">Đến ngày</label>
                                    <input type="date" class="form-control" id="date_to" name="date_to"
                                        value="{{ request('date_to') }}">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label class="form-label">&nbsp;</label>
                                    <div class="d-grid">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-search"></i> Lọc
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Activity List -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Lịch sử hoạt động</h4>
                </div>
                <div class="card-body">
                    @if($activities->count() > 0)
                    <div class="activity-timeline">
                        @foreach($activities as $activity)
                        <div class="activity-item mb-4">
                            <div class="row">
                                <div class="col-auto">
                                    <div class="activity-icon">
                                        @php
                                        $label = $activity->properties['event_label'] ?? $activity->description;
                                        $desc = strtolower($label);
                                        $iconClass = match(true) {
                                        str_contains($desc, 'bảng') => 'fas fa-th-list text-info',
                                        str_contains($desc, 'vòng bảng') => 'fas fa-play-circle text-primary',
                                        str_contains($desc, 'playoff') || str_contains($desc, 'chung kết') ||
                                        str_contains($desc, 'tứ kết') || str_contains($desc, 'bán kết') => 'fas
                                        fa-trophy text-warning',
                                        str_contains($desc, 'kết quả') || str_contains($desc, 'tỷ số') => 'fas fa-edit
                                        text-success',
                                        str_contains($desc, 'đăng ký') => 'fas fa-user-plus text-secondary',
                                        default => 'fas fa-circle text-muted'
                                        };
                                        @endphp
                                        <i class="{{ $iconClass }}" title="{{ $label }}"></i>
                                    </div>
                                </div>
                                <div class="col">
                                    <div class="activity-content">
                                        <div class="activity-header d-flex justify-content-between align-items-start">
                                            <div>
                                                <h6 class="mb-1">{{ $activity->properties['event_label'] ??
                                                    $activity->description }}</h6>
                                                <div class="activity-meta">
                                                    <span class="text-muted">
                                                        <i class="fas fa-user fa-sm"></i>
                                                        {{ $activity->causer?->name ?? 'Hệ thống' }}
                                                    </span>
                                                    <span class="text-muted ms-3">
                                                        <i class="fas fa-clock fa-sm"></i>
                                                        {{ $activity->created_at->format('d/m/Y H:i:s') }}
                                                    </span>
                                                </div>
                                            </div>
                                            <small class="text-muted">
                                                {{ $activity->created_at->diffForHumans() }}
                                            </small>
                                        </div>

                                        @if($activity->properties && count($activity->properties) > 0)
                                        <div class="activity-properties mt-2">
                                            <details class="small">
                                                <summary class="text-primary" style="cursor: pointer;">Chi tiết
                                                </summary>
                                                <div class="mt-2 p-2 rounded">
                                                    @foreach($activity->properties as $key => $value)
                                                    <div class="row">
                                                        <div class="col-4"><strong>{{ ucfirst(str_replace('_', ' ',
                                                                $key)) }}:</strong></div>
                                                        <div class="col-8">
                                                            @if(is_array($value) || is_object($value))
                                                            <pre
                                                                class="small">{{ json_encode($value, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) }}</pre>
                                                            @else
                                                            {{ (string) $value }}
                                                            @endif
                                                        </div>
                                                    </div>
                                                    @endforeach
                                                </div>
                                            </details>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if(!$loop->last)
                        <div class="activity-separator"></div>
                        @endif
                        @endforeach
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $activities->appends(request()->query())->links() }}
                    </div>
                    @else
                    <div class="text-center py-5">
                        <div class="empty-state">
                            <i class="fas fa-history fa-3x text-muted mb-3"></i>
                            <h5>Chưa có hoạt động nào</h5>
                            <p class="text-muted">Chưa có hoạt động nào được ghi lại cho giải đấu này với bộ lọc hiện
                                tại.</p>
                            @if(request()->hasAny(['event', 'causer', 'date_from', 'date_to']))
                            <a href="{{ $activityLogRoute }}" class="btn btn-primary">
                                <i class="fas fa-refresh"></i> Xóa bộ lọc
                            </a>
                            @endif
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .activity-timeline {
        position: relative;
    }

    .activity-item {
        position: relative;
        padding-left: 0;
    }

    .activity-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: var(--bs-card-bg, #121212);
        border: 2px solid var(--bs-border-color, #2b2b2b);
        display: flex;
        align-items: center;
        justify-content: center;
        position: relative;
        z-index: 1;
    }

    .activity-content {
        background: var(--bs-card-bg, #121212);
        border: 1px solid var(--bs-border-color, #2b2b2b);
        border-radius: 8px;
        padding: 15px;
        margin-left: 15px;
        position: relative;
        color: var(--bs-body-color, #e2e2e2);
    }

    .activity-content::before {
        content: '';
        position: absolute;
        left: -8px;
        top: 15px;
        width: 0;
        height: 0;
        border-top: 8px solid transparent;
        border-bottom: 8px solid transparent;
        border-right: 8px solid var(--bs-border-color, #2b2b2b);
    }

    .activity-content::after {
        content: '';
        position: absolute;
        left: -7px;
        top: 15px;
        width: 0;
        height: 0;
        border-top: 8px solid transparent;
        border-bottom: 8px solid transparent;
        border-right: 8px solid var(--bs-card-bg, #121212);
    }

    .activity-separator {
        height: 20px;
        border-left: 2px dashed var(--bs-border-color, #2b2b2b);
        margin-left: 19px;
    }

    .activity-meta {
        font-size: 0.85em;
    }

    .activity-properties pre {
        max-height: 200px;
        overflow-y: auto;
        font-size: 0.8em;
        background: var(--bs-body-bg, #0f0f0f);
        color: var(--bs-body-color, #e2e2e2);
        border: 1px solid var(--bs-border-color, #2b2b2b);
    }
</style>
@endpush