@extends('layouts.app')
@section('content')
<div class="container">
    <h2>Danh sách vòng đấu - {{ $tournament->name }}</h2>
    <a href="{{ route('admin.rounds.create', $tournament) }}" class="btn btn-success mb-3">Thêm vòng đấu</a>
    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Tên vòng</th>
                <th>Loại</th>
                <th>Hành động</th>
            </tr>
        </thead>
        <tbody>
            @foreach($rounds as $round)
            <tr>
                <td>{{ $round->id }}</td>
                <td>{{ $round->name }}</td>
                <td>{{ $round->type }}</td>
                <td>
                    <a href="{{ route('admin.rounds.edit', [$tournament, $round]) }}"
                        class="btn btn-sm btn-primary">Sửa</a>
                    <form action="{{ route('admin.rounds.destroy', [$tournament, $round]) }}" method="POST"
                        style="display:inline-block;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger"
                            onclick="return confirm('Bạn có chắc muốn xóa?')">Xóa</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection