@extends('layouts.app')
@section('content')
<div class="container">
    <h2>Sửa vòng đấu cho {{ $tournament->name }}</h2>
    <form method="POST" action="{{ route('admin.rounds.update', [$tournament, $round]) }}">
        @csrf @method('PUT')
        <div class="mb-3">
            <label>Tên vòng</label>
            <input type="text" name="name" class="form-control" value="{{ $round->name }}" required>
        </div>
        <div class="mb-3">
            <label>Loại vòng</label>
            <select name="type" class="form-control" required>
                <option value="normal" @if($round->type=='normal') selected @endif>Thường</option>
                <option value="round_tree" @if($round->type=='round_tree') selected @endif>Loại trực tiếp</option>
            </select>
        </div>
        <button type="submit" class="btn btn-success">Cập nhật</button>
        <a href="{{ route('admin.rounds.index', $tournament) }}" class="btn btn-secondary">Quay lại</a>
    </form>
</div>
@endsection