@extends('layouts.app')
@section('content')
<div class="container">
    <h2>Thêm vòng đấu cho {{ $tournament->name }}</h2>
    <form method="POST" action="{{ route('admin.rounds.store', $tournament) }}">
        @csrf
        <div class="mb-3">
            <label>Tên vòng</label>
            <input type="text" name="name" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Loại vòng</label>
            <select name="type" class="form-control" required>
                <option value="normal">Thường</option>
                <option value="round_tree">Loại trực tiếp</option>
            </select>
        </div>
        <button type="submit" class="btn btn-success">Thêm</button>
        <a href="{{ route('admin.rounds.index', $tournament) }}" class="btn btn-secondary">Quay lại</a>
    </form>
</div>
@endsection