@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">
                        <i class="bi bi-pencil me-2"></i>Chỉnh sửa Player: {{ $player->name }}
                    </h3>
                    <a href="{{ route('admin.players.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left me-1"></i>Quay lại
                    </a>
                </div>

                <div class="card-body">
                    <!-- Success Message -->
                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <!-- Error Message -->
                    @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-circle me-2"></i>{{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <!-- Validation Errors -->
                    @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <h6><i class="bi bi-exclamation-triangle me-2"></i>Vui lòng kiểm tra lại thông tin:</h6>
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <form method="POST" action="{{ route('admin.players.update', $player) }}"
                        enctype="multipart/form-data" id="editPlayerForm">
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="player_id" value="{{ $player->player_id }}">

                        <div class="row">
                            <!-- Basic Information -->
                            <div class="col-md-6">
                                <h5 class="mb-3 text-primary">
                                    <i class="bi bi-person me-2"></i>Thông tin cơ bản
                                </h5>

                                <div class="mb-3">
                                    <label class="form-label">Mã Player</label>
                                    <input type="text" value="{{ $player->player_id }}" class="form-control" disabled>
                                    <div class="form-text">
                                        <i class="bi bi-info-circle me-1"></i>Mã player không thể thay đổi
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">
                                        Tên <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="name" value="{{ old('name', $player->name) }}"
                                        class="form-control @error('name') is-invalid @enderror" required>
                                    @error('name')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="email" class="form-label">
                                        Email <span class="text-danger">*</span>
                                    </label>
                                    <input type="email" name="email" id="email"
                                        value="{{ old('email', $player->user->email ?? '') }}"
                                        class="form-control @error('email') is-invalid @enderror" required
                                        maxlength="255">
                                    @error('email')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">
                                        Số điện thoại <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="phone" value="{{ old('phone', $player->phone) }}"
                                        class="form-control @error('phone') is-invalid @enderror" required>
                                    @error('phone')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="gender" class="form-label">
                                        Giới tính <span class="text-danger">*</span>
                                    </label>
                                    <select name="gender" id="gender"
                                        class="form-select @error('gender') is-invalid @enderror" required>
                                        <option value="Nam" @if(old('gender', $player->gender)=='Nam') selected
                                            @endif>Nam</option>
                                        <option value="Nữ" @if(old('gender', $player->gender)=='Nữ') selected @endif>Nữ
                                        </option>
                                        <option value="Khác" @if(old('gender', $player->gender)=='Khác') selected
                                            @endif>Khác</option>
                                    </select>
                                    @error('gender')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Game Information -->
                            <div class="col-md-6">
                                <h5 class="mb-3 text-success">
                                    <i class="bi bi-trophy me-2"></i>Thông tin game
                                </h5>

                                <div class="mb-3">
                                    <label class="form-label">Score đôi</label>
                                    <input type="number" step="0.01" name="doubles_score"
                                        value="{{ old('doubles_score', $player->doubles_score) }}"
                                        class="form-control @error('doubles_score') is-invalid @enderror">
                                    @error('doubles_score')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Số trận đôi</label>
                                    <input type="number" name="doubles_matches"
                                        value="{{ old('doubles_matches', $player->doubles_matches) }}"
                                        class="form-control @error('doubles_matches') is-invalid @enderror">
                                    @error('doubles_matches')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="row">
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label">Thắng đôi</label>
                                            <input type="number" name="doubles_wins"
                                                value="{{ old('doubles_wins', $player->doubles_wins) }}"
                                                class="form-control @error('doubles_wins') is-invalid @enderror">
                                            @error('doubles_wins')
                                            <div class="invalid-feedback">
                                                <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                            </div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="mb-3">
                                            <label class="form-label">Thua đôi</label>
                                            <input type="number" name="doubles_losses"
                                                value="{{ old('doubles_losses', $player->doubles_losses) }}"
                                                class="form-control @error('doubles_losses') is-invalid @enderror">
                                            @error('doubles_losses')
                                            <div class="invalid-feedback">
                                                <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                            </div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="initial_level" class="form-label">
                                        Trình độ ban đầu <span class="text-danger">*</span>
                                    </label>
                                    <select name="initial_level" id="initial_level"
                                        class="form-select @error('initial_level') is-invalid @enderror" required>
                                        <option value="2.0" @if(old('initial_level', $player->doubles_score)==2.0)
                                            selected @endif>2.0</option>
                                        @for($i = 2.1; $i <= 6.0; $i +=0.1) <option value="{{ number_format($i,1) }}"
                                            @if(number_format(old('initial_level', $player->
                                            doubles_score),1)==number_format($i,1)) selected @endif>
                                            {{ number_format($i,1) }}
                                            </option>
                                            @endfor
                                    </select>
                                    @error('initial_level')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                    <div class="form-text">
                                        <i class="bi bi-info-circle me-1"></i>Các trường điểm sẽ được cập nhật tự động
                                        từ trình độ này khi lưu
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="location" class="form-label">Khu vực</label>
                                    <select name="location" id="location"
                                        class="form-select @error('location') is-invalid @enderror">
                                        <option value="Hà Nội" @if(old('location', $player->location)=='Hà Nội')
                                            selected @endif>Hà Nội</option>
                                        <option value="TP Hồ Chí Minh" @if(old('location', $player->location)=='TP Hồ
                                            Chí Minh') selected @endif>TP Hồ Chí Minh</option>
                                        <option value="Đà Nẵng" @if(old('location', $player->location)=='Đà Nẵng')
                                            selected @endif>Đà Nẵng</option>
                                        <option value="Cần Thơ" @if(old('location', $player->location)=='Cần Thơ')
                                            selected @endif>Cần Thơ</option>
                                        <option value="Hội An" @if(old('location', $player->location)=='Hội An')
                                            selected @endif>Hội An</option>
                                        <option value="An Giang" @if(old('location', $player->location)=='An Giang')
                                            selected @endif>An Giang</option>
                                        <option value="Bà Rịa - Vũng Tàu" @if(old('location', $player->location)=='Bà
                                            Rịa - Vũng Tàu') selected @endif>Bà Rịa - Vũng Tàu</option>
                                        <option value="Bắc Giang" @if(old('location', $player->location)=='Bắc Giang')
                                            selected @endif>Bắc Giang</option>
                                        <option value="Bắc Kạn" @if(old('location', $player->location)=='Bắc Kạn')
                                            selected @endif>Bắc Kạn</option>
                                        <option value="Bạc Liêu" @if(old('location', $player->location)=='Bạc Liêu')
                                            selected @endif>Bạc Liêu</option>
                                        <option value="Bắc Ninh" @if(old('location', $player->location)=='Bắc Ninh')
                                            selected @endif>Bắc Ninh</option>
                                        <option value="Bến Tre" @if(old('location', $player->location)=='Bến Tre')
                                            selected @endif>Bến Tre</option>
                                        <option value="Bình Định" @if(old('location', $player->location)=='Bình Định')
                                            selected @endif>Bình Định</option>
                                        <option value="Bình Dương" @if(old('location', $player->location)=='Bình Dương')
                                            selected @endif>Bình Dương</option>
                                        <option value="Bình Phước" @if(old('location', $player->location)=='Bình Phước')
                                            selected @endif>Bình Phước</option>
                                        <option value="Bình Thuận" @if(old('location', $player->location)=='Bình Thuận')
                                            selected @endif>Bình Thuận</option>
                                        <option value="Cà Mau" @if(old('location', $player->location)=='Cà Mau')
                                            selected @endif>Cà Mau</option>
                                        <option value="Cao Bằng" @if(old('location', $player->location)=='Cao Bằng')
                                            selected @endif>Cao Bằng</option>
                                        <option value="Đắk Lắk" @if(old('location', $player->location)=='Đắk Lắk')
                                            selected @endif>Đắk Lắk</option>
                                        <option value="Đắk Nông" @if(old('location', $player->location)=='Đắk Nông')
                                            selected @endif>Đắk Nông</option>
                                        <option value="Điện Biên" @if(old('location', $player->location)=='Điện Biên')
                                            selected @endif>Điện Biên</option>
                                        <option value="Đồng Nai" @if(old('location', $player->location)=='Đồng Nai')
                                            selected @endif>Đồng Nai</option>
                                        <option value="Đồng Tháp" @if(old('location', $player->location)=='Đồng Tháp')
                                            selected @endif>Đồng Tháp</option>
                                        <!-- Thêm các tỉnh thành khác... -->
                                        <option value="Khác" @if(old('location', $player->location)=='Khác') selected
                                            @endif>Khác</option>
                                    </select>
                                    @error('location')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Trạng thái</label>
                                    <select name="status" class="form-select @error('status') is-invalid @enderror">
                                        <option value="0" @if(old('status', $player->status)==0) selected @endif>Chưa
                                            duyệt</option>
                                        <option value="1" @if(old('status', $player->status)==1) selected @endif>Đã
                                            duyệt</option>
                                        <option value="2" @if(old('status', $player->status)==2) selected @endif>Được
                                            bảo lãnh</option>
                                    </select>
                                    @error('status')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="avatar" class="form-label">Avatar</label>
                                    @if($player->avatar)
                                    <div class="mb-2">
                                        <img src="{{ asset($player->avatar) }}" alt="Avatar" width="60" height="60"
                                            class="rounded-circle border" style="object-fit:cover;">
                                        <small class="d-block text-muted">Avatar hiện tại</small>
                                    </div>
                                    @endif
                                    <input type="file" name="avatar" id="avatar"
                                        class="form-control @error('avatar') is-invalid @enderror" accept="image/*">
                                    @error('avatar')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                    <div class="form-text">
                                        <i class="bi bi-info-circle me-1"></i>Để trống nếu không muốn thay đổi avatar
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.players.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-1"></i>Hủy bỏ
                            </a>
                            <button type="submit" class="btn btn-success" id="submitBtn">
                                <i class="bi bi-check me-1"></i>Lưu thay đổi
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .card {
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }

    .form-label {
        font-weight: 500;
    }

    .is-invalid {
        border-color: #dc3545;
        box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
    }

    .invalid-feedback {
        display: block;
    }

    .alert {
        border: none;
        border-radius: 0.5rem;
    }

    #submitBtn:hover {
        transform: translateY(-1px);
        transition: all 0.2s;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('editPlayerForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Đang lưu...';
        submitBtn.disabled = true;
    });

    // Auto-hide alerts after 5 seconds
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => {
            if (alert.classList.contains('show')) {
                alert.classList.remove('show');
                setTimeout(() => alert.remove(), 150);
            }
        }, 5000);
    });
});
</script>
@endsection