@extends('layouts.app')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title mb-0">
                        <i class="bi bi-person-plus me-2"></i>Thêm Player Mới
                    </h3>
                    <a href="{{ route('admin.players.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left me-1"></i>Quay lại
                    </a>
                </div>

                <div class="card-body">
                    <!-- Success Message -->
                    @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle me-2"></i>{{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <!-- Error Message -->
                    @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-circle me-2"></i>{{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <!-- Validation Errors -->
                    @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <h6><i class="bi bi-exclamation-triangle me-2"></i>Vui lòng kiểm tra lại thông tin:</h6>
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif

                    <form method="POST" action="{{ route('admin.players.store') }}" enctype="multipart/form-data"
                        id="createPlayerForm">
                        @csrf

                        <div class="row">
                            <!-- Basic Information -->
                            <div class="col-md-6">
                                <h5 class="mb-3 text-primary">
                                    <i class="bi bi-person me-2"></i>Thông tin cơ bản
                                </h5>

                                <div class="mb-3">
                                    <label for="name" class="form-label">
                                        Tên <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="name" id="name" value="{{ old('name') }}"
                                        class="form-control @error('name') is-invalid @enderror" required
                                        placeholder="Nhập họ tên đầy đủ">
                                    @error('name')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="email" class="form-label">
                                        Email <span class="text-danger">*</span>
                                    </label>
                                    <input type="email" name="email" id="email" value="{{ old('email') }}"
                                        class="form-control @error('email') is-invalid @enderror" required
                                        maxlength="255" placeholder="example@gmail.com">
                                    @error('email')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="phone" class="form-label">
                                        Số điện thoại <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" name="phone" id="phone" value="{{ old('phone') }}"
                                        class="form-control @error('phone') is-invalid @enderror" required
                                        placeholder="0901234567">
                                    @error('phone')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="gender" class="form-label">
                                        Giới tính <span class="text-danger">*</span>
                                    </label>
                                    <select name="gender" id="gender"
                                        class="form-select @error('gender') is-invalid @enderror" required>
                                        <option value="">-- Chọn giới tính --</option>
                                        <option value="Nam" @if(old('gender')=='Nam' ) selected @endif>
                                            <i class="bi bi-gender-male"></i>Nam
                                        </option>
                                        <option value="Nữ" @if(old('gender')=='Nữ' ) selected @endif>
                                            <i class="bi bi-gender-female"></i>Nữ
                                        </option>
                                        <option value="Khác" @if(old('gender')=='Khác' ) selected @endif>Khác</option>
                                    </select>
                                    @error('gender')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Game Information -->
                            <div class="col-md-6">
                                <h5 class="mb-3 text-success">
                                    <i class="bi bi-trophy me-2"></i>Thông tin game
                                </h5>

                                <div class="mb-3">
                                    <label for="initial_level" class="form-label">
                                        Trình độ ban đầu <span class="text-danger">*</span>
                                    </label>
                                    <select name="initial_level" id="initial_level"
                                        class="form-select @error('initial_level') is-invalid @enderror" required>
                                        <option value="">-- Chọn trình độ --</option>
                                        <option value="2.0" @if(old('initial_level')=='2.0' ) selected @endif>2.0 - Mới
                                            bắt đầu</option>
                                        @for($i = 2.1; $i <= 6.0; $i +=0.1) <option value="{{ number_format($i,1) }}"
                                            @if(old('initial_level')==number_format($i,1)) selected @endif>
                                            {{ number_format($i,1) }}
                                            @if($i <= 2.5) - Người mới @elseif($i <=3.5) - Trung bình @elseif($i <=4.5)
                                                - Khá @else - Giỏi @endif </option>
                                                @endfor
                                    </select>
                                    @error('initial_level')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                    <div class="form-text">
                                        <i class="bi bi-info-circle me-1"></i>Điểm đôi và đơn sẽ được tự động thiết lập
                                        theo trình độ này
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="location" class="form-label">
                                        Khu vực <span class="text-danger">*</span>
                                    </label>
                                    <select name="location" id="location"
                                        class="form-select @error('location') is-invalid @enderror" required>
                                        <option value="">-- Chọn khu vực --</option>
                                        <option value="Hà Nội" @if(old('location')=='Hà Nội' ) selected @endif>Hà Nội
                                        </option>
                                        <option value="TP Hồ Chí Minh" @if(old('location')=='TP Hồ Chí Minh' ) selected
                                            @endif>TP Hồ Chí Minh</option>
                                        <option value="Đà Nẵng" @if(old('location')=='Đà Nẵng' ) selected @endif>Đà Nẵng
                                        </option>
                                        <option value="Cần Thơ" @if(old('location')=='Cần Thơ' ) selected @endif>Cần Thơ
                                        </option>
                                        <option value="Hải Phòng" @if(old('location')=='Hải Phòng' ) selected @endif>Hải
                                            Phòng</option>
                                        <option value="An Giang" @if(old('location')=='An Giang' ) selected @endif>An
                                            Giang</option>
                                        <option value="Bà Rịa - Vũng Tàu" @if(old('location')=='Bà Rịa - Vũng Tàu' )
                                            selected @endif>Bà Rịa - Vũng Tàu</option>
                                        <option value="Bắc Giang" @if(old('location')=='Bắc Giang' ) selected @endif>Bắc
                                            Giang</option>
                                        <option value="Bắc Kạn" @if(old('location')=='Bắc Kạn' ) selected @endif>Bắc Kạn
                                        </option>
                                        <option value="Bạc Liêu" @if(old('location')=='Bạc Liêu' ) selected @endif>Bạc
                                            Liêu</option>
                                        <option value="Bắc Ninh" @if(old('location')=='Bắc Ninh' ) selected @endif>Bắc
                                            Ninh</option>
                                        <option value="Bến Tre" @if(old('location')=='Bến Tre' ) selected @endif>Bến Tre
                                        </option>
                                        <option value="Bình Định" @if(old('location')=='Bình Định' ) selected @endif>
                                            Bình Định</option>
                                        <option value="Bình Dương" @if(old('location')=='Bình Dương' ) selected @endif>
                                            Bình Dương</option>
                                        <option value="Bình Phước" @if(old('location')=='Bình Phước' ) selected @endif>
                                            Bình Phước</option>
                                        <option value="Bình Thuận" @if(old('location')=='Bình Thuận' ) selected @endif>
                                            Bình Thuận</option>
                                        <option value="Cà Mau" @if(old('location')=='Cà Mau' ) selected @endif>Cà Mau
                                        </option>
                                        <option value="Cao Bằng" @if(old('location')=='Cao Bằng' ) selected @endif>Cao
                                            Bằng</option>
                                        <option value="Đắk Lắk" @if(old('location')=='Đắk Lắk' ) selected @endif>Đắk Lắk
                                        </option>
                                        <option value="Đắk Nông" @if(old('location')=='Đắk Nông' ) selected @endif>Đắk
                                            Nông</option>
                                        <option value="Điện Biên" @if(old('location')=='Điện Biên' ) selected @endif>
                                            Điện Biên</option>
                                        <option value="Đồng Nai" @if(old('location')=='Đồng Nai' ) selected @endif>Đồng
                                            Nai</option>
                                        <option value="Đồng Tháp" @if(old('location')=='Đồng Tháp' ) selected @endif>
                                            Đồng Tháp</option>
                                        <option value="Gia Lai" @if(old('location')=='Gia Lai' ) selected @endif>Gia Lai
                                        </option>
                                        <option value="Hà Giang" @if(old('location')=='Hà Giang' ) selected @endif>Hà
                                            Giang</option>
                                        <option value="Hà Nam" @if(old('location')=='Hà Nam' ) selected @endif>Hà Nam
                                        </option>
                                        <option value="Hà Tĩnh" @if(old('location')=='Hà Tĩnh' ) selected @endif>Hà Tĩnh
                                        </option>
                                        <option value="Hải Dương" @if(old('location')=='Hải Dương' ) selected @endif>Hải
                                            Dương</option>
                                        <option value="Hậu Giang" @if(old('location')=='Hậu Giang' ) selected @endif>Hậu
                                            Giang</option>
                                        <option value="Hòa Bình" @if(old('location')=='Hòa Bình' ) selected @endif>Hòa
                                            Bình</option>
                                        <option value="Hội An" @if(old('location')=='Hội An' ) selected @endif>Hội An
                                        </option>
                                        <option value="Hưng Yên" @if(old('location')=='Hưng Yên' ) selected @endif>Hưng
                                            Yên</option>
                                        <option value="Khánh Hòa" @if(old('location')=='Khánh Hòa' ) selected @endif>
                                            Khánh Hòa</option>
                                        <option value="Kiên Giang" @if(old('location')=='Kiên Giang' ) selected @endif>
                                            Kiên Giang</option>
                                        <option value="Kon Tum" @if(old('location')=='Kon Tum' ) selected @endif>Kon Tum
                                        </option>
                                        <option value="Lai Châu" @if(old('location')=='Lai Châu' ) selected @endif>Lai
                                            Châu</option>
                                        <option value="Lâm Đồng" @if(old('location')=='Lâm Đồng' ) selected @endif>Lâm
                                            Đồng</option>
                                        <option value="Lạng Sơn" @if(old('location')=='Lạng Sơn' ) selected @endif>Lạng
                                            Sơn</option>
                                        <option value="Lào Cai" @if(old('location')=='Lào Cai' ) selected @endif>Lào Cai
                                        </option>
                                        <option value="Long An" @if(old('location')=='Long An' ) selected @endif>Long An
                                        </option>
                                        <option value="Nam Định" @if(old('location')=='Nam Định' ) selected @endif>Nam
                                            Định</option>
                                        <option value="Nghệ An" @if(old('location')=='Nghệ An' ) selected @endif>Nghệ An
                                        </option>
                                        <option value="Ninh Bình" @if(old('location')=='Ninh Bình' ) selected @endif>
                                            Ninh Bình</option>
                                        <option value="Ninh Thuận" @if(old('location')=='Ninh Thuận' ) selected @endif>
                                            Ninh Thuận</option>
                                        <option value="Phú Thọ" @if(old('location')=='Phú Thọ' ) selected @endif>Phú Thọ
                                        </option>
                                        <option value="Phú Yên" @if(old('location')=='Phú Yên' ) selected @endif>Phú Yên
                                        </option>
                                        <option value="Quảng Bình" @if(old('location')=='Quảng Bình' ) selected @endif>
                                            Quảng Bình</option>
                                        <option value="Quảng Nam" @if(old('location')=='Quảng Nam' ) selected @endif>
                                            Quảng Nam</option>
                                        <option value="Quảng Ngãi" @if(old('location')=='Quảng Ngãi' ) selected @endif>
                                            Quảng Ngãi</option>
                                        <option value="Quảng Ninh" @if(old('location')=='Quảng Ninh' ) selected @endif>
                                            Quảng Ninh</option>
                                        <option value="Quảng Trị" @if(old('location')=='Quảng Trị' ) selected @endif>
                                            Quảng Trị</option>
                                        <option value="Sóc Trăng" @if(old('location')=='Sóc Trăng' ) selected @endif>Sóc
                                            Trăng</option>
                                        <option value="Sơn La" @if(old('location')=='Sơn La' ) selected @endif>Sơn La
                                        </option>
                                        <option value="Tây Ninh" @if(old('location')=='Tây Ninh' ) selected @endif>Tây
                                            Ninh</option>
                                        <option value="Thái Bình" @if(old('location')=='Thái Bình' ) selected @endif>
                                            Thái Bình</option>
                                        <option value="Thái Nguyên" @if(old('location')=='Thái Nguyên' ) selected
                                            @endif>Thái Nguyên</option>
                                        <option value="Thanh Hóa" @if(old('location')=='Thanh Hóa' ) selected @endif>
                                            Thanh Hóa</option>
                                        <option value="Thừa Thiên Huế" @if(old('location')=='Thừa Thiên Huế' ) selected
                                            @endif>Thừa Thiên Huế</option>
                                        <option value="Tiền Giang" @if(old('location')=='Tiền Giang' ) selected @endif>
                                            Tiền Giang</option>
                                        <option value="Trà Vinh" @if(old('location')=='Trà Vinh' ) selected @endif>Trà
                                            Vinh</option>
                                        <option value="Tuyên Quang" @if(old('location')=='Tuyên Quang' ) selected
                                            @endif>Tuyên Quang</option>
                                        <option value="Vĩnh Long" @if(old('location')=='Vĩnh Long' ) selected @endif>
                                            Vĩnh Long</option>
                                        <option value="Vĩnh Phúc" @if(old('location')=='Vĩnh Phúc' ) selected @endif>
                                            Vĩnh Phúc</option>
                                        <option value="Yên Bái" @if(old('location')=='Yên Bái' ) selected @endif>Yên Bái
                                        </option>
                                        <option value="Khác" @if(old('location')=='Khác' ) selected @endif>Khác</option>
                                    </select>
                                    @error('location')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="status" class="form-label">
                                        Trạng thái
                                    </label>
                                    <select name="status" id="status"
                                        class="form-select @error('status') is-invalid @enderror">
                                        <option value="0" @if(old('status', 0)==0) selected @endif>
                                            <i class="bi bi-clock"></i>Chưa duyệt
                                        </option>
                                        <option value="1" @if(old('status')==1) selected @endif>
                                            <i class="bi bi-check-circle"></i>Đã duyệt
                                        </option>
                                        <option value="2" @if(old('status')==2) selected @endif>
                                            <i class="bi bi-shield-check"></i>Được bảo lãnh
                                        </option>
                                    </select>
                                    @error('status')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="avatar" class="form-label">
                                        Avatar
                                    </label>
                                    <input type="file" name="avatar" id="avatar"
                                        class="form-control @error('avatar') is-invalid @enderror" accept="image/*">
                                    @error('avatar')
                                    <div class="invalid-feedback">
                                        <i class="bi bi-exclamation-circle me-1"></i>{{ $message }}
                                    </div>
                                    @enderror
                                    <div class="form-text">
                                        <i class="bi bi-info-circle me-1"></i>Chọn file ảnh (JPG, PNG, GIF). Tối đa 2MB.
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr class="my-4">

                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.players.index') }}" class="btn btn-outline-secondary">
                                <i class="bi bi-arrow-left me-1"></i>Hủy bỏ
                            </a>
                            <button type="submit" class="btn btn-success" id="submitBtn">
                                <i class="bi bi-person-plus me-1"></i>Thêm Player
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .card {
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    }

    .form-label {
        font-weight: 500;
    }

    .is-invalid {
        border-color: #dc3545;
        box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
    }

    .invalid-feedback {
        display: block;
    }

    .alert {
        border: none;
        border-radius: 0.5rem;
    }

    #submitBtn:hover {
        transform: translateY(-1px);
        transition: all 0.2s;
    }
</style>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    // Form validation feedback
    const form = document.getElementById('createPlayerForm');
    const submitBtn = document.getElementById('submitBtn');
    
    form.addEventListener('submit', function(e) {
        submitBtn.innerHTML = '<i class="bi bi-hourglass-split me-1"></i>Đang xử lý...';
        submitBtn.disabled = true;
    });

    // Auto-hide alerts after 5 seconds
    const alerts = document.querySelectorAll('.alert');
    alerts.forEach(alert => {
        setTimeout(() => {
            if (alert.classList.contains('show')) {
                alert.classList.remove('show');
                setTimeout(() => alert.remove(), 150);
            }
        }, 5000);
    });

    // Phone number formatting
    const phoneInput = document.getElementById('phone');
    phoneInput.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '');
        if (value.length > 10) value = value.slice(0, 10);
        e.target.value = value;
    });
});
</script>
@endsection