@extends('layouts.app')
@section('content')
<div class="container">
    <h2>Sửa cặp đấu cho bảng {{ $group->name }}</h2>
    <form method="POST"
        action="{{ isset($formAction) ? $formAction : route('admin.groups.pairs.update', ['group' => $group->id, 'pair' => $pair->id]) }}">
        @csrf
        @if(isset($formMethod) && strtoupper($formMethod) !== 'POST')
        @method($formMethod)
        @else
        {{-- default admin expects PUT --}}
        @unless(isset($formMethod))
        @method('PUT')
        @endunless
        @endif
        <div class="mb-3">
            <label>Player 1</label>
            <select name="player1_id" class="form-control" required>
                @foreach($players as $player)
                <option value="{{ $player->id }}" @if($pair->player1_id==$player->id) selected @endif>{{ $player->name
                    }}</option>
                @endforeach
            </select>
        </div>
        <div class="mb-3">
            <label>Player 2</label>
            <select name="player2_id" class="form-control" required>
                @foreach($players as $player)
                <option value="{{ $player->id }}" @if($pair->player2_id==$player->id) selected @endif>{{ $player->name
                    }}</option>
                @endforeach
            </select>
        </div>
        <button type="submit" class="btn btn-success">Cập nhật</button>
        <a href="{{ isset($cancelUrl) ? $cancelUrl : route('admin.tournaments.show', $group->tournament_id) }}"
            class="btn btn-secondary">Quay lại</a>
    </form>
</div>
@endsection

@push('layout_script')
<script>
    $(document).ready(function() {
        $('.form-control').select2({
            theme: 'bootstrap-5'
        });
    });
</script>
@endpush