@extends('layouts.app')

@section('title', 'Matches for ' . $tournament->name)

@section('content')
<div class="container mx-auto py-6">
    <h1 class="text-2xl font-bold mb-4">Matches: {{ $tournament->name }}</h1>
    <a href="{{ route('admin.matches.create', $tournament) }}"
        class="bg-blue-600 text-white px-4 py-2 mb-4 inline-block">Create Match</a>
    <div class="overflow-x-auto">
        <table class="table table-bordered table-hover align-middle">
            <thead class="bg-light">
                <tr>
                    <th class="text-center">Ngày</th>
                    <th class="text-center">Cặp đấu</th>
                    <th class="text-center">Tỷ số</th>
                    <th class="text-center">Trạng thái</th>
                    <th class="text-center">Điểm Elo</th>
                    <th class="text-center">Ảnh</th>
                    <th class="text-center">Hành động</th>
                </tr>
            </thead>
            <tbody>
                @foreach($matches as $match)
                <tr>
                    <td class="text-center">{{ $match->date->format('d/m/Y') }}</td>
                    <td class="text-center">
                        @if($tournament->type == 'singles')
                        <span class="fw-bold text-primary">{{ $match->player1->name }}</span>
                        <span class="mx-1">vs</span>
                        <span class="fw-bold text-danger">{{ $match->opponent1->name }}</span>
                        @else
                        <span class="fw-bold text-primary">{{ $match->player1->name }} & {{ $match->player2->name
                            }}</span>
                        <span class="mx-1">vs</span>
                        <span class="fw-bold text-danger">{{ $match->opponent1->name }} & {{ $match->opponent2->name
                            }}</span>
                        @endif
                    </td>
                    <td class="text-center">{{ $match->score }}</td>
                    <td class="text-center">
                        <span
                            class="badge {{ $match->status == 'Hoàn thành' ? 'bg-success' : ($match->status == 'Đang diễn ra' ? 'bg-warning text-dark' : 'bg-secondary') }}">{{
                            $match->status }}</span>
                    </td>
                    <td class="text-center">
                        <span class="badge bg-info">Đơn: {{ number_format($match->singles_score,2) }}</span>
                        <span class="badge bg-warning text-dark ms-1">Đôi: {{ number_format($match->doubles_score,2)
                            }}</span>
                    </td>
                    <td class="text-center">
                        @if($match->images && is_array($match->images) && count($match->images))
                        <img src="{{ asset($match->images[0]) }}" alt="Match image" class="w-24 h-auto rounded shadow">
                        @endif
                    </td>
                    <td class="text-center">
                        <a href="{{ route('admin.matches.edit', [$tournament, $match]) }}"
                            class="btn btn-sm btn-primary">Sửa</a>
                        <form action="{{ route('admin.matches.destroy', [$tournament, $match]) }}" method="POST"
                            style="display:inline-block" onsubmit="return confirm('Bạn chắc chắn muốn xóa trận này?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger">Xóa</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <div class="mt-3">
        {{ $matches->links() }}
    </div>
</div>
@endsection