@extends('layouts.app')

@section('title', 'Edit Match for ' . $tournament->name)

@section('content')
<div class="container mx-auto py-6">
    <h1 class="text-2xl font-bold mb-4">Edit Match: {{ $tournament->name }}</h1>
    <form action="{{ route('admin.matches.update', [$tournament, $match]) }}" method="POST"
        enctype="multipart/form-data" class="max-w-lg">
        @csrf @method('PUT')
        <div class="mb-4">
            <label for="date" class="block text-sm font-medium">Date</label>
            <input type="datetime-local" name="date" id="date"
                class="w-full border rounded px-3 py-2 @error('date') border-red-500 @enderror"
                value="{{ old('date', $match->date->format('Y-m-d\TH:i')) }}">
            @error('date') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label for="type" class="block text-sm font-medium">Type</label>
            <select name="type" id="type"
                class="w-full border rounded px-3 py-2 @error('type') border-red-500 @enderror">
                <option value="tournament" {{ old('type', $match->type) === 'tournament' ? 'selected' : '' }}>Tournament
                </option>
            </select>
            @error('type') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label for="result" class="block text-sm font-medium">Result</label>
            <select name="result" id="result"
                class="w-full border rounded px-3 py-2 @error('result') border-red-500 @enderror">
                <option value="win" {{ old('result', $match->result) === 'win' ? 'selected' : '' }}>Win</option>
                <option value="loss" {{ old('result', $match->result) === 'loss' ? 'selected' : '' }}>Loss</option>
            </select>
            @error('result') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label for="score" class="block text-sm font-medium">Score (e.g., 1-0 15-8)</label>
            <input type="text" name="score" id="score"
                class="w-full border rounded px-3 py-2 @error('score') border-red-500 @enderror"
                value="{{ old('score', $match->score) }}">
            @error('score') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label for="status" class="block text-sm font-medium">Status</label>
            <select name="status" id="status"
                class="w-full border rounded px-3 py-2 @error('status') border-red-500 @enderror">
                <option value="Sắp diễn ra" {{ old('status', $match->status) == 'Sắp diễn ra' ? 'selected' : '' }}>Sắp
                    diễn ra</option>
                <option value="Đang diễn ra" {{ old('status', $match->status) == 'Đang diễn ra' ? 'selected' : ''
                    }}>Đang diễn ra</option>
                <option value="Hoàn thành" {{ old('status', $match->status) == 'Hoàn thành' ? 'selected' : '' }}>Hoàn
                    thành</option>
            </select>
            @error('status') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label class="block text-sm font-medium">Điểm Elo</label>
            <div class="flex gap-2">
                <span class="badge bg-info">Đơn: {{ number_format($match->singles_score,2) }}</span>
                <span class="badge bg-warning text-dark">Đôi: {{ number_format($match->doubles_score,2) }}</span>
            </div>
        </div>
        <div class="mb-4">
            <label for="player1_id" class="block text-sm font-medium">Player 1</label>
            <select name="player1_id" id="player1_id"
                class="w-full border rounded px-3 py-2 @error('player1_id') border-red-500 @enderror">
                @foreach($players as $player)
                <option value="{{ $player->id }}" {{ old('player1_id', $match->player1_id) == $player->id ? 'selected' :
                    '' }}>{{ $player->name }} ({{ $player->player_id }})</option>
                @endforeach
            </select>
            @error('player1_id') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label for="player2_id" class="block text-sm font-medium">Player 2</label>
            <select name="player2_id" id="player2_id"
                class="w-full border rounded px-3 py-2 @error('player2_id') border-red-500 @enderror">
                @foreach($players as $player)
                <option value="{{ $player->id }}" {{ old('player2_id', $match->player2_id) == $player->id ? 'selected' :
                    '' }}>{{ $player->name }} ({{ $player->player_id }})</option>
                @endforeach
            </select>
            @error('player2_id') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label for="opponent1_id" class="block text-sm font-medium">Opponent 1</label>
            <select name="opponent1_id" id="opponent1_id"
                class="w-full border rounded px-3 py-2 @error('opponent1_id') border-red-500 @enderror">
                @foreach($players as $player)
                <option value="{{ $player->id }}" {{ old('opponent1_id', $match->opponent1_id) == $player->id ?
                    'selected' : '' }}>{{ $player->name }} ({{ $player->player_id }})</option>
                @endforeach
            </select>
            @error('opponent1_id') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label for="opponent2_id" class="block text-sm font-medium">Opponent 2</label>
            <select name="opponent2_id" id="opponent2_id"
                class="w-full border rounded px-3 py-2 @error('opponent2_id') border-red-500 @enderror">
                @foreach($players as $player)
                <option value="{{ $player->id }}" {{ old('opponent2_id', $match->opponent2_id) == $player->id ?
                    'selected' : '' }}>{{ $player->name }} ({{ $player->player_id }})</option>
                @endforeach
            </select>
            @error('opponent2_id') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
        </div>
        <div class="mb-4">
            <label for="images" class="block text-sm font-medium">Images</label>
            <input type="file" name="images[]" id="images" multiple
                class="w-full border rounded px-3 py-2 @error('images') border-red-500 @enderror">
            @error('images') <span class="text-red-500 text-sm">{{ $message }}</span> @enderror
            @if($match->images)
            <div class="mt-2">
                <p>Current Images:</p>
                @foreach($match->images as $image)
                <img src="{{ $image }}" alt="Match image" class="w-24 h-auto inline-block mr-2">
                @endforeach
            </div>
            @endif
        </div>
        <button type="submit" class="bg-blue-600 text-white px-4 py-2">Update</button>
    </form>
</div>
@endsection